// Copyright © 2025 Mikhail Hogrefe
//
// This file is part of Malachite.
//
// Malachite is free software: you can redistribute it and/or modify it under the terms of the GNU
// Lesser General Public License (LGPL) as published by the Free Software Foundation; either version
// 3 of the License, or (at your option) any later version. See <https://www.gnu.org/licenses/>.

/// Functions for approximating the natural logarithm of 2.
pub mod log_2;
/// Functions for approximating the prime constant (the constant whose $n$th bit is 1 if and only if
/// $n$ is prime).
pub mod prime_constant;
/// Functions for approximating the Thue-Morse constant (the constant whose bits are the Thue-Morse
/// sequence).
pub mod thue_morse_constant;
