Utilities for styling the stroke of SVG elements.

<style>
#stroke-color-table > tr td:nth-child(3) svg {
  width: 100%;
  fill: transparent;
}
</style>

<svg style="display: none;" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
  <defs>
    <symbol viewBox="0 0 32 32" id="svg-logo"><path d="M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zM18 9l-2 13l-2-13h-2l2.52 14h2.96L20 9h-2zM8 23H2v-2h6v-4H4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H4v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"></path></symbol>
  </defs>
</svg>

<table style="display: table;">
  <thead>
    <tr>
      <th style="text-align: center;">Class</th>
      <th style="text-align: center;">Properties</th>
      <th style="text-align: center; width: 7.5rem;">Color</th>
    </tr>
  </thead>
  <tbody id="stroke-color-table">
    <tr><td>stroke-inherit</td><td>stroke: inherit;</td><td><svg style="stroke: inherit;"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-current</td><td>stroke: currentColor;</td><td><svg style="stroke: currentColor;"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-transparent</td><td>stroke: transparent;</td><td><svg style="stroke: transparent;"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-50</td><td>stroke: oklch(97.1% .013 17.38);</td><td><svg style="stroke: oklch(97.1% .013 17.38);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-100</td><td>stroke: oklch(93.6% .032 17.717);</td><td><svg style="stroke: oklch(93.6% .032 17.717);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-200</td><td>stroke: oklch(88.5% .062 18.334);</td><td><svg style="stroke: oklch(88.5% .062 18.334);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-300</td><td>stroke: oklch(80.8% .114 19.571);</td><td><svg style="stroke: oklch(80.8% .114 19.571);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-400</td><td>stroke: oklch(70.4% .191 22.216);</td><td><svg style="stroke: oklch(70.4% .191 22.216);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-500</td><td>stroke: oklch(63.7% .237 25.331);</td><td><svg style="stroke: oklch(63.7% .237 25.331);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-600</td><td>stroke: oklch(57.7% .245 27.325);</td><td><svg style="stroke: oklch(57.7% .245 27.325);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-700</td><td>stroke: oklch(50.5% .213 27.518);</td><td><svg style="stroke: oklch(50.5% .213 27.518);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-800</td><td>stroke: oklch(44.4% .177 26.899);</td><td><svg style="stroke: oklch(44.4% .177 26.899);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-900</td><td>stroke: oklch(39.6% .141 25.723);</td><td><svg style="stroke: oklch(39.6% .141 25.723);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-red-950</td><td>stroke: oklch(25.8% .092 26.042);</td><td><svg style="stroke: oklch(25.8% .092 26.042);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-50</td><td>stroke: oklch(98% .016 73.684);</td><td><svg style="stroke: oklch(98% .016 73.684);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-100</td><td>stroke: oklch(95.4% .038 75.164);</td><td><svg style="stroke: oklch(95.4% .038 75.164);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-200</td><td>stroke: oklch(90.1% .076 70.697);</td><td><svg style="stroke: oklch(90.1% .076 70.697);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-300</td><td>stroke: oklch(83.7% .128 66.29);</td><td><svg style="stroke: oklch(83.7% .128 66.29);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-400</td><td>stroke: oklch(75% .183 55.934);</td><td><svg style="stroke: oklch(75% .183 55.934);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-500</td><td>stroke: oklch(70.5% .213 47.604);</td><td><svg style="stroke: oklch(70.5% .213 47.604);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-600</td><td>stroke: oklch(64.6% .222 41.116);</td><td><svg style="stroke: oklch(64.6% .222 41.116);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-700</td><td>stroke: oklch(55.3% .195 38.402);</td><td><svg style="stroke: oklch(55.3% .195 38.402);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-800</td><td>stroke: oklch(47% .157 37.304);</td><td><svg style="stroke: oklch(47% .157 37.304);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-900</td><td>stroke: oklch(40.8% .123 38.172);</td><td><svg style="stroke: oklch(40.8% .123 38.172);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-orange-950</td><td>stroke: oklch(26.6% .079 36.259);</td><td><svg style="stroke: oklch(26.6% .079 36.259);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-50</td><td>stroke: oklch(98.7% .022 95.277);</td><td><svg style="stroke: oklch(98.7% .022 95.277);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-100</td><td>stroke: oklch(96.2% .059 95.617);</td><td><svg style="stroke: oklch(96.2% .059 95.617);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-200</td><td>stroke: oklch(92.4% .12 95.746);</td><td><svg style="stroke: oklch(92.4% .12 95.746);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-300</td><td>stroke: oklch(87.9% .169 91.605);</td><td><svg style="stroke: oklch(87.9% .169 91.605);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-400</td><td>stroke: oklch(82.8% .189 84.429);</td><td><svg style="stroke: oklch(82.8% .189 84.429);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-500</td><td>stroke: oklch(76.9% .188 70.08);</td><td><svg style="stroke: oklch(76.9% .188 70.08);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-600</td><td>stroke: oklch(66.6% .179 58.318);</td><td><svg style="stroke: oklch(66.6% .179 58.318);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-700</td><td>stroke: oklch(55.5% .163 48.998);</td><td><svg style="stroke: oklch(55.5% .163 48.998);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-800</td><td>stroke: oklch(47.3% .137 46.201);</td><td><svg style="stroke: oklch(47.3% .137 46.201);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-900</td><td>stroke: oklch(41.4% .112 45.904);</td><td><svg style="stroke: oklch(41.4% .112 45.904);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-amber-950</td><td>stroke: oklch(27.9% .077 45.635);</td><td><svg style="stroke: oklch(27.9% .077 45.635);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-50</td><td>stroke: oklch(98.7% .026 102.212);</td><td><svg style="stroke: oklch(98.7% .026 102.212);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-100</td><td>stroke: oklch(97.3% .071 103.193);</td><td><svg style="stroke: oklch(97.3% .071 103.193);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-200</td><td>stroke: oklch(94.5% .129 101.54);</td><td><svg style="stroke: oklch(94.5% .129 101.54);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-300</td><td>stroke: oklch(90.5% .182 98.111);</td><td><svg style="stroke: oklch(90.5% .182 98.111);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-400</td><td>stroke: oklch(85.2% .199 91.936);</td><td><svg style="stroke: oklch(85.2% .199 91.936);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-500</td><td>stroke: oklch(79.5% .184 86.047);</td><td><svg style="stroke: oklch(79.5% .184 86.047);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-600</td><td>stroke: oklch(68.1% .162 75.834);</td><td><svg style="stroke: oklch(68.1% .162 75.834);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-700</td><td>stroke: oklch(55.4% .135 66.442);</td><td><svg style="stroke: oklch(55.4% .135 66.442);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-800</td><td>stroke: oklch(47.6% .114 61.907);</td><td><svg style="stroke: oklch(47.6% .114 61.907);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-900</td><td>stroke: oklch(42.1% .095 57.708);</td><td><svg style="stroke: oklch(42.1% .095 57.708);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-yellow-950</td><td>stroke: oklch(28.6% .066 53.813);</td><td><svg style="stroke: oklch(28.6% .066 53.813);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-50</td><td>stroke: oklch(98.6% .031 120.757);</td><td><svg style="stroke: oklch(98.6% .031 120.757);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-100</td><td>stroke: oklch(96.7% .067 122.328);</td><td><svg style="stroke: oklch(96.7% .067 122.328);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-200</td><td>stroke: oklch(93.8% .127 124.321);</td><td><svg style="stroke: oklch(93.8% .127 124.321);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-300</td><td>stroke: oklch(89.7% .196 126.665);</td><td><svg style="stroke: oklch(89.7% .196 126.665);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-400</td><td>stroke: oklch(84.1% .238 128.85);</td><td><svg style="stroke: oklch(84.1% .238 128.85);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-500</td><td>stroke: oklch(76.8% .233 130.85);</td><td><svg style="stroke: oklch(76.8% .233 130.85);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-600</td><td>stroke: oklch(64.8% .2 131.684);</td><td><svg style="stroke: oklch(64.8% .2 131.684);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-700</td><td>stroke: oklch(53.2% .157 131.589);</td><td><svg style="stroke: oklch(53.2% .157 131.589);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-800</td><td>stroke: oklch(45.3% .124 130.933);</td><td><svg style="stroke: oklch(45.3% .124 130.933);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-900</td><td>stroke: oklch(40.5% .101 131.063);</td><td><svg style="stroke: oklch(40.5% .101 131.063);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-lime-950</td><td>stroke: oklch(27.4% .072 132.109);</td><td><svg style="stroke: oklch(27.4% .072 132.109);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-50</td><td>stroke: oklch(98.2% .018 155.826);</td><td><svg style="stroke: oklch(98.2% .018 155.826);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-100</td><td>stroke: oklch(96.2% .044 156.743);</td><td><svg style="stroke: oklch(96.2% .044 156.743);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-200</td><td>stroke: oklch(92.5% .084 155.995);</td><td><svg style="stroke: oklch(92.5% .084 155.995);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-300</td><td>stroke: oklch(87.1% .15 154.449);</td><td><svg style="stroke: oklch(87.1% .15 154.449);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-400</td><td>stroke: oklch(79.2% .209 151.711);</td><td><svg style="stroke: oklch(79.2% .209 151.711);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-500</td><td>stroke: oklch(72.3% .219 149.579);</td><td><svg style="stroke: oklch(72.3% .219 149.579);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-600</td><td>stroke: oklch(62.7% .194 149.214);</td><td><svg style="stroke: oklch(62.7% .194 149.214);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-700</td><td>stroke: oklch(52.7% .154 150.069);</td><td><svg style="stroke: oklch(52.7% .154 150.069);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-800</td><td>stroke: oklch(44.8% .119 151.328);</td><td><svg style="stroke: oklch(44.8% .119 151.328);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-900</td><td>stroke: oklch(39.3% .095 152.535);</td><td><svg style="stroke: oklch(39.3% .095 152.535);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-green-950</td><td>stroke: oklch(26.6% .065 152.934);</td><td><svg style="stroke: oklch(26.6% .065 152.934);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-50</td><td>stroke: oklch(97.9% .021 166.113);</td><td><svg style="stroke: oklch(97.9% .021 166.113);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-100</td><td>stroke: oklch(95% .052 163.051);</td><td><svg style="stroke: oklch(95% .052 163.051);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-200</td><td>stroke: oklch(90.5% .093 164.15);</td><td><svg style="stroke: oklch(90.5% .093 164.15);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-300</td><td>stroke: oklch(84.5% .143 164.978);</td><td><svg style="stroke: oklch(84.5% .143 164.978);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-400</td><td>stroke: oklch(76.5% .177 163.223);</td><td><svg style="stroke: oklch(76.5% .177 163.223);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-500</td><td>stroke: oklch(69.6% .17 162.48);</td><td><svg style="stroke: oklch(69.6% .17 162.48);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-600</td><td>stroke: oklch(59.6% .145 163.225);</td><td><svg style="stroke: oklch(59.6% .145 163.225);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-700</td><td>stroke: oklch(50.8% .118 165.612);</td><td><svg style="stroke: oklch(50.8% .118 165.612);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-800</td><td>stroke: oklch(43.2% .095 166.913);</td><td><svg style="stroke: oklch(43.2% .095 166.913);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-900</td><td>stroke: oklch(37.8% .077 168.94);</td><td><svg style="stroke: oklch(37.8% .077 168.94);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-emerald-950</td><td>stroke: oklch(26.2% .051 172.552);</td><td><svg style="stroke: oklch(26.2% .051 172.552);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-50</td><td>stroke: oklch(98.4% .014 180.72);</td><td><svg style="stroke: oklch(98.4% .014 180.72);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-100</td><td>stroke: oklch(95.3% .051 180.801);</td><td><svg style="stroke: oklch(95.3% .051 180.801);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-200</td><td>stroke: oklch(91% .096 180.426);</td><td><svg style="stroke: oklch(91% .096 180.426);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-300</td><td>stroke: oklch(85.5% .138 181.071);</td><td><svg style="stroke: oklch(85.5% .138 181.071);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-400</td><td>stroke: oklch(77.7% .152 181.912);</td><td><svg style="stroke: oklch(77.7% .152 181.912);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-500</td><td>stroke: oklch(70.4% .14 182.503);</td><td><svg style="stroke: oklch(70.4% .14 182.503);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-600</td><td>stroke: oklch(60% .118 184.704);</td><td><svg style="stroke: oklch(60% .118 184.704);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-700</td><td>stroke: oklch(51.1% .096 186.391);</td><td><svg style="stroke: oklch(51.1% .096 186.391);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-800</td><td>stroke: oklch(43.7% .078 188.216);</td><td><svg style="stroke: oklch(43.7% .078 188.216);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-900</td><td>stroke: oklch(38.6% .063 188.416);</td><td><svg style="stroke: oklch(38.6% .063 188.416);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-teal-950</td><td>stroke: oklch(27.7% .046 192.524);</td><td><svg style="stroke: oklch(27.7% .046 192.524);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-50</td><td>stroke: oklch(98.4% .019 200.873);</td><td><svg style="stroke: oklch(98.4% .019 200.873);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-100</td><td>stroke: oklch(95.6% .045 203.388);</td><td><svg style="stroke: oklch(95.6% .045 203.388);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-200</td><td>stroke: oklch(91.7% .08 205.041);</td><td><svg style="stroke: oklch(91.7% .08 205.041);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-300</td><td>stroke: oklch(86.5% .127 207.078);</td><td><svg style="stroke: oklch(86.5% .127 207.078);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-400</td><td>stroke: oklch(78.9% .154 211.53);</td><td><svg style="stroke: oklch(78.9% .154 211.53);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-500</td><td>stroke: oklch(71.5% .143 215.221);</td><td><svg style="stroke: oklch(71.5% .143 215.221);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-600</td><td>stroke: oklch(60.9% .126 221.723);</td><td><svg style="stroke: oklch(60.9% .126 221.723);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-700</td><td>stroke: oklch(52% .105 223.128);</td><td><svg style="stroke: oklch(52% .105 223.128);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-800</td><td>stroke: oklch(45% .085 224.283);</td><td><svg style="stroke: oklch(45% .085 224.283);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-900</td><td>stroke: oklch(39.8% .07 227.392);</td><td><svg style="stroke: oklch(39.8% .07 227.392);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-cyan-950</td><td>stroke: oklch(30.2% .056 229.695);</td><td><svg style="stroke: oklch(30.2% .056 229.695);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-50</td><td>stroke: oklch(97.7% .013 236.62);</td><td><svg style="stroke: oklch(97.7% .013 236.62);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-100</td><td>stroke: oklch(95.1% .026 236.824);</td><td><svg style="stroke: oklch(95.1% .026 236.824);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-200</td><td>stroke: oklch(90.1% .058 230.902);</td><td><svg style="stroke: oklch(90.1% .058 230.902);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-300</td><td>stroke: oklch(82.8% .111 230.318);</td><td><svg style="stroke: oklch(82.8% .111 230.318);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-400</td><td>stroke: oklch(74.6% .16 232.661);</td><td><svg style="stroke: oklch(74.6% .16 232.661);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-500</td><td>stroke: oklch(68.5% .169 237.323);</td><td><svg style="stroke: oklch(68.5% .169 237.323);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-600</td><td>stroke: oklch(58.8% .158 241.966);</td><td><svg style="stroke: oklch(58.8% .158 241.966);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-700</td><td>stroke: oklch(50% .134 242.749);</td><td><svg style="stroke: oklch(50% .134 242.749);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-800</td><td>stroke: oklch(44.3% .11 240.79);</td><td><svg style="stroke: oklch(44.3% .11 240.79);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-900</td><td>stroke: oklch(39.1% .09 240.876);</td><td><svg style="stroke: oklch(39.1% .09 240.876);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-sky-950</td><td>stroke: oklch(29.3% .066 243.157);</td><td><svg style="stroke: oklch(29.3% .066 243.157);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-50</td><td>stroke: oklch(97% .014 254.604);</td><td><svg style="stroke: oklch(97% .014 254.604);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-100</td><td>stroke: oklch(93.2% .032 255.585);</td><td><svg style="stroke: oklch(93.2% .032 255.585);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-200</td><td>stroke: oklch(88.2% .059 254.128);</td><td><svg style="stroke: oklch(88.2% .059 254.128);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-300</td><td>stroke: oklch(80.9% .105 251.813);</td><td><svg style="stroke: oklch(80.9% .105 251.813);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-400</td><td>stroke: oklch(70.7% .165 254.624);</td><td><svg style="stroke: oklch(70.7% .165 254.624);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-500</td><td>stroke: oklch(62.3% .214 259.815);</td><td><svg style="stroke: oklch(62.3% .214 259.815);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-600</td><td>stroke: oklch(54.6% .245 262.881);</td><td><svg style="stroke: oklch(54.6% .245 262.881);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-700</td><td>stroke: oklch(48.8% .243 264.376);</td><td><svg style="stroke: oklch(48.8% .243 264.376);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-800</td><td>stroke: oklch(42.4% .199 265.638);</td><td><svg style="stroke: oklch(42.4% .199 265.638);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-900</td><td>stroke: oklch(37.9% .146 265.522);</td><td><svg style="stroke: oklch(37.9% .146 265.522);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-blue-950</td><td>stroke: oklch(28.2% .091 267.935);</td><td><svg style="stroke: oklch(28.2% .091 267.935);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-50</td><td>stroke: oklch(96.2% .018 272.314);</td><td><svg style="stroke: oklch(96.2% .018 272.314);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-100</td><td>stroke: oklch(93% .034 272.788);</td><td><svg style="stroke: oklch(93% .034 272.788);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-200</td><td>stroke: oklch(87% .065 274.039);</td><td><svg style="stroke: oklch(87% .065 274.039);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-300</td><td>stroke: oklch(78.5% .115 274.713);</td><td><svg style="stroke: oklch(78.5% .115 274.713);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-400</td><td>stroke: oklch(67.3% .182 276.935);</td><td><svg style="stroke: oklch(67.3% .182 276.935);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-500</td><td>stroke: oklch(58.5% .233 277.117);</td><td><svg style="stroke: oklch(58.5% .233 277.117);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-600</td><td>stroke: oklch(51.1% .262 276.966);</td><td><svg style="stroke: oklch(51.1% .262 276.966);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-700</td><td>stroke: oklch(45.7% .24 277.023);</td><td><svg style="stroke: oklch(45.7% .24 277.023);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-800</td><td>stroke: oklch(39.8% .195 277.366);</td><td><svg style="stroke: oklch(39.8% .195 277.366);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-900</td><td>stroke: oklch(35.9% .144 278.697);</td><td><svg style="stroke: oklch(35.9% .144 278.697);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-indigo-950</td><td>stroke: oklch(25.7% .09 281.288);</td><td><svg style="stroke: oklch(25.7% .09 281.288);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-50</td><td>stroke: oklch(96.9% .016 293.756);</td><td><svg style="stroke: oklch(96.9% .016 293.756);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-100</td><td>stroke: oklch(94.3% .029 294.588);</td><td><svg style="stroke: oklch(94.3% .029 294.588);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-200</td><td>stroke: oklch(89.4% .057 293.283);</td><td><svg style="stroke: oklch(89.4% .057 293.283);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-300</td><td>stroke: oklch(81.1% .111 293.571);</td><td><svg style="stroke: oklch(81.1% .111 293.571);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-400</td><td>stroke: oklch(70.2% .183 293.541);</td><td><svg style="stroke: oklch(70.2% .183 293.541);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-500</td><td>stroke: oklch(60.6% .25 292.717);</td><td><svg style="stroke: oklch(60.6% .25 292.717);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-600</td><td>stroke: oklch(54.1% .281 293.009);</td><td><svg style="stroke: oklch(54.1% .281 293.009);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-700</td><td>stroke: oklch(49.1% .27 292.581);</td><td><svg style="stroke: oklch(49.1% .27 292.581);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-800</td><td>stroke: oklch(43.2% .232 292.759);</td><td><svg style="stroke: oklch(43.2% .232 292.759);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-900</td><td>stroke: oklch(38% .189 293.745);</td><td><svg style="stroke: oklch(38% .189 293.745);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-violet-950</td><td>stroke: oklch(28.3% .141 291.089);</td><td><svg style="stroke: oklch(28.3% .141 291.089);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-50</td><td>stroke: oklch(97.7% .014 308.299);</td><td><svg style="stroke: oklch(97.7% .014 308.299);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-100</td><td>stroke: oklch(94.6% .033 307.174);</td><td><svg style="stroke: oklch(94.6% .033 307.174);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-200</td><td>stroke: oklch(90.2% .063 306.703);</td><td><svg style="stroke: oklch(90.2% .063 306.703);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-300</td><td>stroke: oklch(82.7% .119 306.383);</td><td><svg style="stroke: oklch(82.7% .119 306.383);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-400</td><td>stroke: oklch(71.4% .203 305.504);</td><td><svg style="stroke: oklch(71.4% .203 305.504);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-500</td><td>stroke: oklch(62.7% .265 303.9);</td><td><svg style="stroke: oklch(62.7% .265 303.9);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-600</td><td>stroke: oklch(55.8% .288 302.321);</td><td><svg style="stroke: oklch(55.8% .288 302.321);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-700</td><td>stroke: oklch(49.6% .265 301.924);</td><td><svg style="stroke: oklch(49.6% .265 301.924);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-800</td><td>stroke: oklch(43.8% .218 303.724);</td><td><svg style="stroke: oklch(43.8% .218 303.724);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-900</td><td>stroke: oklch(38.1% .176 304.987);</td><td><svg style="stroke: oklch(38.1% .176 304.987);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-purple-950</td><td>stroke: oklch(29.1% .149 302.717);</td><td><svg style="stroke: oklch(29.1% .149 302.717);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-50</td><td>stroke: oklch(97.7% .017 320.058);</td><td><svg style="stroke: oklch(97.7% .017 320.058);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-100</td><td>stroke: oklch(95.2% .037 318.852);</td><td><svg style="stroke: oklch(95.2% .037 318.852);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-200</td><td>stroke: oklch(90.3% .076 319.62);</td><td><svg style="stroke: oklch(90.3% .076 319.62);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-300</td><td>stroke: oklch(83.3% .145 321.434);</td><td><svg style="stroke: oklch(83.3% .145 321.434);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-400</td><td>stroke: oklch(74% .238 322.16);</td><td><svg style="stroke: oklch(74% .238 322.16);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-500</td><td>stroke: oklch(66.7% .295 322.15);</td><td><svg style="stroke: oklch(66.7% .295 322.15);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-600</td><td>stroke: oklch(59.1% .293 322.896);</td><td><svg style="stroke: oklch(59.1% .293 322.896);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-700</td><td>stroke: oklch(51.8% .253 323.949);</td><td><svg style="stroke: oklch(51.8% .253 323.949);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-800</td><td>stroke: oklch(45.2% .211 324.591);</td><td><svg style="stroke: oklch(45.2% .211 324.591);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-900</td><td>stroke: oklch(40.1% .17 325.612);</td><td><svg style="stroke: oklch(40.1% .17 325.612);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-fuchsia-950</td><td>stroke: oklch(29.3% .136 325.661);</td><td><svg style="stroke: oklch(29.3% .136 325.661);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-50</td><td>stroke: oklch(97.1% .014 343.198);</td><td><svg style="stroke: oklch(97.1% .014 343.198);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-100</td><td>stroke: oklch(94.8% .028 342.258);</td><td><svg style="stroke: oklch(94.8% .028 342.258);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-200</td><td>stroke: oklch(89.9% .061 343.231);</td><td><svg style="stroke: oklch(89.9% .061 343.231);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-300</td><td>stroke: oklch(82.3% .12 346.018);</td><td><svg style="stroke: oklch(82.3% .12 346.018);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-400</td><td>stroke: oklch(71.8% .202 349.761);</td><td><svg style="stroke: oklch(71.8% .202 349.761);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-500</td><td>stroke: oklch(65.6% .241 354.308);</td><td><svg style="stroke: oklch(65.6% .241 354.308);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-600</td><td>stroke: oklch(59.2% .249 .584);</td><td><svg style="stroke: oklch(59.2% .249 .584);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-700</td><td>stroke: oklch(52.5% .223 3.958);</td><td><svg style="stroke: oklch(52.5% .223 3.958);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-800</td><td>stroke: oklch(45.9% .187 3.815);</td><td><svg style="stroke: oklch(45.9% .187 3.815);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-900</td><td>stroke: oklch(40.8% .153 2.432);</td><td><svg style="stroke: oklch(40.8% .153 2.432);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-pink-950</td><td>stroke: oklch(28.4% .109 3.907);</td><td><svg style="stroke: oklch(28.4% .109 3.907);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-50</td><td>stroke: oklch(96.9% .015 12.422);</td><td><svg style="stroke: oklch(96.9% .015 12.422);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-100</td><td>stroke: oklch(94.1% .03 12.58);</td><td><svg style="stroke: oklch(94.1% .03 12.58);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-200</td><td>stroke: oklch(89.2% .058 10.001);</td><td><svg style="stroke: oklch(89.2% .058 10.001);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-300</td><td>stroke: oklch(81% .117 11.638);</td><td><svg style="stroke: oklch(81% .117 11.638);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-400</td><td>stroke: oklch(71.2% .194 13.428);</td><td><svg style="stroke: oklch(71.2% .194 13.428);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-500</td><td>stroke: oklch(64.5% .246 16.439);</td><td><svg style="stroke: oklch(64.5% .246 16.439);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-600</td><td>stroke: oklch(58.6% .253 17.585);</td><td><svg style="stroke: oklch(58.6% .253 17.585);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-700</td><td>stroke: oklch(51.4% .222 16.935);</td><td><svg style="stroke: oklch(51.4% .222 16.935);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-800</td><td>stroke: oklch(45.5% .188 13.697);</td><td><svg style="stroke: oklch(45.5% .188 13.697);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-900</td><td>stroke: oklch(41% .159 10.272);</td><td><svg style="stroke: oklch(41% .159 10.272);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-rose-950</td><td>stroke: oklch(27.1% .105 12.094);</td><td><svg style="stroke: oklch(27.1% .105 12.094);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-50</td><td>stroke: oklch(98.4% .003 247.858);</td><td><svg style="stroke: oklch(98.4% .003 247.858);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-100</td><td>stroke: oklch(96.8% .007 247.896);</td><td><svg style="stroke: oklch(96.8% .007 247.896);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-200</td><td>stroke: oklch(92.9% .013 255.508);</td><td><svg style="stroke: oklch(92.9% .013 255.508);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-300</td><td>stroke: oklch(86.9% .022 252.894);</td><td><svg style="stroke: oklch(86.9% .022 252.894);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-400</td><td>stroke: oklch(70.4% .04 256.788);</td><td><svg style="stroke: oklch(70.4% .04 256.788);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-500</td><td>stroke: oklch(55.4% .046 257.417);</td><td><svg style="stroke: oklch(55.4% .046 257.417);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-600</td><td>stroke: oklch(44.6% .043 257.281);</td><td><svg style="stroke: oklch(44.6% .043 257.281);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-700</td><td>stroke: oklch(37.2% .044 257.287);</td><td><svg style="stroke: oklch(37.2% .044 257.287);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-800</td><td>stroke: oklch(27.9% .041 260.031);</td><td><svg style="stroke: oklch(27.9% .041 260.031);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-900</td><td>stroke: oklch(20.8% .042 265.755);</td><td><svg style="stroke: oklch(20.8% .042 265.755);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-slate-950</td><td>stroke: oklch(12.9% .042 264.695);</td><td><svg style="stroke: oklch(12.9% .042 264.695);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-50</td><td>stroke: oklch(98.5% .002 247.839);</td><td><svg style="stroke: oklch(98.5% .002 247.839);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-100</td><td>stroke: oklch(96.7% .003 264.542);</td><td><svg style="stroke: oklch(96.7% .003 264.542);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-200</td><td>stroke: oklch(92.8% .006 264.531);</td><td><svg style="stroke: oklch(92.8% .006 264.531);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-300</td><td>stroke: oklch(87.2% .01 258.338);</td><td><svg style="stroke: oklch(87.2% .01 258.338);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-400</td><td>stroke: oklch(70.7% .022 261.325);</td><td><svg style="stroke: oklch(70.7% .022 261.325);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-500</td><td>stroke: oklch(55.1% .027 264.364);</td><td><svg style="stroke: oklch(55.1% .027 264.364);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-600</td><td>stroke: oklch(44.6% .03 256.802);</td><td><svg style="stroke: oklch(44.6% .03 256.802);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-700</td><td>stroke: oklch(37.3% .034 259.733);</td><td><svg style="stroke: oklch(37.3% .034 259.733);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-800</td><td>stroke: oklch(27.8% .033 256.848);</td><td><svg style="stroke: oklch(27.8% .033 256.848);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-900</td><td>stroke: oklch(21% .034 264.665);</td><td><svg style="stroke: oklch(21% .034 264.665);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-gray-950</td><td>stroke: oklch(13% .028 261.692);</td><td><svg style="stroke: oklch(13% .028 261.692);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-50</td><td>stroke: oklch(98.5% 0 0);</td><td><svg style="stroke: oklch(98.5% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-100</td><td>stroke: oklch(96.7% .001 286.375);</td><td><svg style="stroke: oklch(96.7% .001 286.375);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-200</td><td>stroke: oklch(92% .004 286.32);</td><td><svg style="stroke: oklch(92% .004 286.32);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-300</td><td>stroke: oklch(87.1% .006 286.286);</td><td><svg style="stroke: oklch(87.1% .006 286.286);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-400</td><td>stroke: oklch(70.5% .015 286.067);</td><td><svg style="stroke: oklch(70.5% .015 286.067);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-500</td><td>stroke: oklch(55.2% .016 285.938);</td><td><svg style="stroke: oklch(55.2% .016 285.938);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-600</td><td>stroke: oklch(44.2% .017 285.786);</td><td><svg style="stroke: oklch(44.2% .017 285.786);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-700</td><td>stroke: oklch(37% .013 285.805);</td><td><svg style="stroke: oklch(37% .013 285.805);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-800</td><td>stroke: oklch(27.4% .006 286.033);</td><td><svg style="stroke: oklch(27.4% .006 286.033);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-900</td><td>stroke: oklch(21% .006 285.885);</td><td><svg style="stroke: oklch(21% .006 285.885);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-zinc-950</td><td>stroke: oklch(14.1% .005 285.823);</td><td><svg style="stroke: oklch(14.1% .005 285.823);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-50</td><td>stroke: oklch(98.5% 0 0);</td><td><svg style="stroke: oklch(98.5% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-100</td><td>stroke: oklch(97% 0 0);</td><td><svg style="stroke: oklch(97% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-200</td><td>stroke: oklch(92.2% 0 0);</td><td><svg style="stroke: oklch(92.2% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-300</td><td>stroke: oklch(87% 0 0);</td><td><svg style="stroke: oklch(87% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-400</td><td>stroke: oklch(70.8% 0 0);</td><td><svg style="stroke: oklch(70.8% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-500</td><td>stroke: oklch(55.6% 0 0);</td><td><svg style="stroke: oklch(55.6% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-600</td><td>stroke: oklch(43.9% 0 0);</td><td><svg style="stroke: oklch(43.9% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-700</td><td>stroke: oklch(37.1% 0 0);</td><td><svg style="stroke: oklch(37.1% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-800</td><td>stroke: oklch(26.9% 0 0);</td><td><svg style="stroke: oklch(26.9% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-900</td><td>stroke: oklch(20.5% 0 0);</td><td><svg style="stroke: oklch(20.5% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-neutral-950</td><td>stroke: oklch(14.5% 0 0);</td><td><svg style="stroke: oklch(14.5% 0 0);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-50</td><td>stroke: oklch(98.5% .001 106.423);</td><td><svg style="stroke: oklch(98.5% .001 106.423);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-100</td><td>stroke: oklch(97% .001 106.424);</td><td><svg style="stroke: oklch(97% .001 106.424);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-200</td><td>stroke: oklch(92.3% .003 48.717);</td><td><svg style="stroke: oklch(92.3% .003 48.717);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-300</td><td>stroke: oklch(86.9% .005 56.366);</td><td><svg style="stroke: oklch(86.9% .005 56.366);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-400</td><td>stroke: oklch(70.9% .01 56.259);</td><td><svg style="stroke: oklch(70.9% .01 56.259);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-500</td><td>stroke: oklch(55.3% .013 58.071);</td><td><svg style="stroke: oklch(55.3% .013 58.071);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-600</td><td>stroke: oklch(44.4% .011 73.639);</td><td><svg style="stroke: oklch(44.4% .011 73.639);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-700</td><td>stroke: oklch(37.4% .01 67.558);</td><td><svg style="stroke: oklch(37.4% .01 67.558);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-800</td><td>stroke: oklch(26.8% .007 34.298);</td><td><svg style="stroke: oklch(26.8% .007 34.298);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-900</td><td>stroke: oklch(21.6% .006 56.043);</td><td><svg style="stroke: oklch(21.6% .006 56.043);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-stone-950</td><td>stroke: oklch(14.7% .004 49.25);</td><td><svg style="stroke: oklch(14.7% .004 49.25);"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-black</td><td>stroke: #000;</td><td><svg style="stroke: #000;"><use href="#svg-logo" /></svg></td></tr>
    <tr><td>stroke-white</td><td>stroke: #fff;</td><td><svg style="stroke: #fff;"><use href="#svg-logo" /></svg></td></tr>
  </tbody>
</table>

### Arbitrary values

Any [`<color>`](crate::utils::value_matchers::is_matching_color) property is allowed as arbitrary value.
For example, `stroke-[rgb(33,45,42)]`.

[Tailwind reference](https://tailwindcss.com/docs/stroke)
