Utilities for controlling the color of an element's borders.

<style>
#border-color-table > tr td:nth-child(3) {
  position: relative;
}

#border-color-table > tr {
  height: 4rem;
}

#border-color-table tr td:nth-child(3) div {
  position: absolute;
  top: 0;
  bottom: 0;
  left: 0;
  right: 0;
  border-style: solid;
  border-width: 4px;
  margin: 1rem;
  border-color: transparent;
}
</style>

<table style="display: table;">
  <thead>
    <tr>
      <th style="text-align: center;">Class</th>
      <th style="text-align: center;">Properties</th>
      <th style="text-align: center; width: 10rem;">Color</th>
    </tr>
  </thead>
  <tbody id="border-color-table">
    <tr><td>border-inherit</td><td>border-color: inherit;</td><td><div style="border-color: inherit;"></div></td></tr>
    <tr><td>border-current</td><td>border-color: currentColor;</td><td><div style="border-color: currentColor;"></div></td></tr>
    <tr><td>border-transparent</td><td>border-color: transparent;</td><td><div style="border-color: transparent;"></div></td></tr>
    <tr><td>border-red-50</td><td>border-color: oklch(97.1% .013 17.38);</td><td><div style="border-color: oklch(97.1% .013 17.38);"></div></td></tr>
    <tr><td>border-red-100</td><td>border-color: oklch(93.6% .032 17.717);</td><td><div style="border-color: oklch(93.6% .032 17.717);"></div></td></tr>
    <tr><td>border-red-200</td><td>border-color: oklch(88.5% .062 18.334);</td><td><div style="border-color: oklch(88.5% .062 18.334);"></div></td></tr>
    <tr><td>border-red-300</td><td>border-color: oklch(80.8% .114 19.571);</td><td><div style="border-color: oklch(80.8% .114 19.571);"></div></td></tr>
    <tr><td>border-red-400</td><td>border-color: oklch(70.4% .191 22.216);</td><td><div style="border-color: oklch(70.4% .191 22.216);"></div></td></tr>
    <tr><td>border-red-500</td><td>border-color: oklch(63.7% .237 25.331);</td><td><div style="border-color: oklch(63.7% .237 25.331);"></div></td></tr>
    <tr><td>border-red-600</td><td>border-color: oklch(57.7% .245 27.325);</td><td><div style="border-color: oklch(57.7% .245 27.325);"></div></td></tr>
    <tr><td>border-red-700</td><td>border-color: oklch(50.5% .213 27.518);</td><td><div style="border-color: oklch(50.5% .213 27.518);"></div></td></tr>
    <tr><td>border-red-800</td><td>border-color: oklch(44.4% .177 26.899);</td><td><div style="border-color: oklch(44.4% .177 26.899);"></div></td></tr>
    <tr><td>border-red-900</td><td>border-color: oklch(39.6% .141 25.723);</td><td><div style="border-color: oklch(39.6% .141 25.723);"></div></td></tr>
    <tr><td>border-red-950</td><td>border-color: oklch(25.8% .092 26.042);</td><td><div style="border-color: oklch(25.8% .092 26.042);"></div></td></tr>
    <tr><td>border-orange-50</td><td>border-color: oklch(98% .016 73.684);</td><td><div style="border-color: oklch(98% .016 73.684);"></div></td></tr>
    <tr><td>border-orange-100</td><td>border-color: oklch(95.4% .038 75.164);</td><td><div style="border-color: oklch(95.4% .038 75.164);"></div></td></tr>
    <tr><td>border-orange-200</td><td>border-color: oklch(90.1% .076 70.697);</td><td><div style="border-color: oklch(90.1% .076 70.697);"></div></td></tr>
    <tr><td>border-orange-300</td><td>border-color: oklch(83.7% .128 66.29);</td><td><div style="border-color: oklch(83.7% .128 66.29);"></div></td></tr>
    <tr><td>border-orange-400</td><td>border-color: oklch(75% .183 55.934);</td><td><div style="border-color: oklch(75% .183 55.934);"></div></td></tr>
    <tr><td>border-orange-500</td><td>border-color: oklch(70.5% .213 47.604);</td><td><div style="border-color: oklch(70.5% .213 47.604);"></div></td></tr>
    <tr><td>border-orange-600</td><td>border-color: oklch(64.6% .222 41.116);</td><td><div style="border-color: oklch(64.6% .222 41.116);"></div></td></tr>
    <tr><td>border-orange-700</td><td>border-color: oklch(55.3% .195 38.402);</td><td><div style="border-color: oklch(55.3% .195 38.402);"></div></td></tr>
    <tr><td>border-orange-800</td><td>border-color: oklch(47% .157 37.304);</td><td><div style="border-color: oklch(47% .157 37.304);"></div></td></tr>
    <tr><td>border-orange-900</td><td>border-color: oklch(40.8% .123 38.172);</td><td><div style="border-color: oklch(40.8% .123 38.172);"></div></td></tr>
    <tr><td>border-orange-950</td><td>border-color: oklch(26.6% .079 36.259);</td><td><div style="border-color: oklch(26.6% .079 36.259);"></div></td></tr>
    <tr><td>border-amber-50</td><td>border-color: oklch(98.7% .022 95.277);</td><td><div style="border-color: oklch(98.7% .022 95.277);"></div></td></tr>
    <tr><td>border-amber-100</td><td>border-color: oklch(96.2% .059 95.617);</td><td><div style="border-color: oklch(96.2% .059 95.617);"></div></td></tr>
    <tr><td>border-amber-200</td><td>border-color: oklch(92.4% .12 95.746);</td><td><div style="border-color: oklch(92.4% .12 95.746);"></div></td></tr>
    <tr><td>border-amber-300</td><td>border-color: oklch(87.9% .169 91.605);</td><td><div style="border-color: oklch(87.9% .169 91.605);"></div></td></tr>
    <tr><td>border-amber-400</td><td>border-color: oklch(82.8% .189 84.429);</td><td><div style="border-color: oklch(82.8% .189 84.429);"></div></td></tr>
    <tr><td>border-amber-500</td><td>border-color: oklch(76.9% .188 70.08);</td><td><div style="border-color: oklch(76.9% .188 70.08);"></div></td></tr>
    <tr><td>border-amber-600</td><td>border-color: oklch(66.6% .179 58.318);</td><td><div style="border-color: oklch(66.6% .179 58.318);"></div></td></tr>
    <tr><td>border-amber-700</td><td>border-color: oklch(55.5% .163 48.998);</td><td><div style="border-color: oklch(55.5% .163 48.998);"></div></td></tr>
    <tr><td>border-amber-800</td><td>border-color: oklch(47.3% .137 46.201);</td><td><div style="border-color: oklch(47.3% .137 46.201);"></div></td></tr>
    <tr><td>border-amber-900</td><td>border-color: oklch(41.4% .112 45.904);</td><td><div style="border-color: oklch(41.4% .112 45.904);"></div></td></tr>
    <tr><td>border-amber-950</td><td>border-color: oklch(27.9% .077 45.635);</td><td><div style="border-color: oklch(27.9% .077 45.635);"></div></td></tr>
    <tr><td>border-yellow-50</td><td>border-color: oklch(98.7% .026 102.212);</td><td><div style="border-color: oklch(98.7% .026 102.212);"></div></td></tr>
    <tr><td>border-yellow-100</td><td>border-color: oklch(97.3% .071 103.193);</td><td><div style="border-color: oklch(97.3% .071 103.193);"></div></td></tr>
    <tr><td>border-yellow-200</td><td>border-color: oklch(94.5% .129 101.54);</td><td><div style="border-color: oklch(94.5% .129 101.54);"></div></td></tr>
    <tr><td>border-yellow-300</td><td>border-color: oklch(90.5% .182 98.111);</td><td><div style="border-color: oklch(90.5% .182 98.111);"></div></td></tr>
    <tr><td>border-yellow-400</td><td>border-color: oklch(85.2% .199 91.936);</td><td><div style="border-color: oklch(85.2% .199 91.936);"></div></td></tr>
    <tr><td>border-yellow-500</td><td>border-color: oklch(79.5% .184 86.047);</td><td><div style="border-color: oklch(79.5% .184 86.047);"></div></td></tr>
    <tr><td>border-yellow-600</td><td>border-color: oklch(68.1% .162 75.834);</td><td><div style="border-color: oklch(68.1% .162 75.834);"></div></td></tr>
    <tr><td>border-yellow-700</td><td>border-color: oklch(55.4% .135 66.442);</td><td><div style="border-color: oklch(55.4% .135 66.442);"></div></td></tr>
    <tr><td>border-yellow-800</td><td>border-color: oklch(47.6% .114 61.907);</td><td><div style="border-color: oklch(47.6% .114 61.907);"></div></td></tr>
    <tr><td>border-yellow-900</td><td>border-color: oklch(42.1% .095 57.708);</td><td><div style="border-color: oklch(42.1% .095 57.708);"></div></td></tr>
    <tr><td>border-yellow-950</td><td>border-color: oklch(28.6% .066 53.813);</td><td><div style="border-color: oklch(28.6% .066 53.813);"></div></td></tr>
    <tr><td>border-lime-50</td><td>border-color: oklch(98.6% .031 120.757);</td><td><div style="border-color: oklch(98.6% .031 120.757);"></div></td></tr>
    <tr><td>border-lime-100</td><td>border-color: oklch(96.7% .067 122.328);</td><td><div style="border-color: oklch(96.7% .067 122.328);"></div></td></tr>
    <tr><td>border-lime-200</td><td>border-color: oklch(93.8% .127 124.321);</td><td><div style="border-color: oklch(93.8% .127 124.321);"></div></td></tr>
    <tr><td>border-lime-300</td><td>border-color: oklch(89.7% .196 126.665);</td><td><div style="border-color: oklch(89.7% .196 126.665);"></div></td></tr>
    <tr><td>border-lime-400</td><td>border-color: oklch(84.1% .238 128.85);</td><td><div style="border-color: oklch(84.1% .238 128.85);"></div></td></tr>
    <tr><td>border-lime-500</td><td>border-color: oklch(76.8% .233 130.85);</td><td><div style="border-color: oklch(76.8% .233 130.85);"></div></td></tr>
    <tr><td>border-lime-600</td><td>border-color: oklch(64.8% .2 131.684);</td><td><div style="border-color: oklch(64.8% .2 131.684);"></div></td></tr>
    <tr><td>border-lime-700</td><td>border-color: oklch(53.2% .157 131.589);</td><td><div style="border-color: oklch(53.2% .157 131.589);"></div></td></tr>
    <tr><td>border-lime-800</td><td>border-color: oklch(45.3% .124 130.933);</td><td><div style="border-color: oklch(45.3% .124 130.933);"></div></td></tr>
    <tr><td>border-lime-900</td><td>border-color: oklch(40.5% .101 131.063);</td><td><div style="border-color: oklch(40.5% .101 131.063);"></div></td></tr>
    <tr><td>border-lime-950</td><td>border-color: oklch(27.4% .072 132.109);</td><td><div style="border-color: oklch(27.4% .072 132.109);"></div></td></tr>
    <tr><td>border-green-50</td><td>border-color: oklch(98.2% .018 155.826);</td><td><div style="border-color: oklch(98.2% .018 155.826);"></div></td></tr>
    <tr><td>border-green-100</td><td>border-color: oklch(96.2% .044 156.743);</td><td><div style="border-color: oklch(96.2% .044 156.743);"></div></td></tr>
    <tr><td>border-green-200</td><td>border-color: oklch(92.5% .084 155.995);</td><td><div style="border-color: oklch(92.5% .084 155.995);"></div></td></tr>
    <tr><td>border-green-300</td><td>border-color: oklch(87.1% .15 154.449);</td><td><div style="border-color: oklch(87.1% .15 154.449);"></div></td></tr>
    <tr><td>border-green-400</td><td>border-color: oklch(79.2% .209 151.711);</td><td><div style="border-color: oklch(79.2% .209 151.711);"></div></td></tr>
    <tr><td>border-green-500</td><td>border-color: oklch(72.3% .219 149.579);</td><td><div style="border-color: oklch(72.3% .219 149.579);"></div></td></tr>
    <tr><td>border-green-600</td><td>border-color: oklch(62.7% .194 149.214);</td><td><div style="border-color: oklch(62.7% .194 149.214);"></div></td></tr>
    <tr><td>border-green-700</td><td>border-color: oklch(52.7% .154 150.069);</td><td><div style="border-color: oklch(52.7% .154 150.069);"></div></td></tr>
    <tr><td>border-green-800</td><td>border-color: oklch(44.8% .119 151.328);</td><td><div style="border-color: oklch(44.8% .119 151.328);"></div></td></tr>
    <tr><td>border-green-900</td><td>border-color: oklch(39.3% .095 152.535);</td><td><div style="border-color: oklch(39.3% .095 152.535);"></div></td></tr>
    <tr><td>border-green-950</td><td>border-color: oklch(26.6% .065 152.934);</td><td><div style="border-color: oklch(26.6% .065 152.934);"></div></td></tr>
    <tr><td>border-emerald-50</td><td>border-color: oklch(97.9% .021 166.113);</td><td><div style="border-color: oklch(97.9% .021 166.113);"></div></td></tr>
    <tr><td>border-emerald-100</td><td>border-color: oklch(95% .052 163.051);</td><td><div style="border-color: oklch(95% .052 163.051);"></div></td></tr>
    <tr><td>border-emerald-200</td><td>border-color: oklch(90.5% .093 164.15);</td><td><div style="border-color: oklch(90.5% .093 164.15);"></div></td></tr>
    <tr><td>border-emerald-300</td><td>border-color: oklch(84.5% .143 164.978);</td><td><div style="border-color: oklch(84.5% .143 164.978);"></div></td></tr>
    <tr><td>border-emerald-400</td><td>border-color: oklch(76.5% .177 163.223);</td><td><div style="border-color: oklch(76.5% .177 163.223);"></div></td></tr>
    <tr><td>border-emerald-500</td><td>border-color: oklch(69.6% .17 162.48);</td><td><div style="border-color: oklch(69.6% .17 162.48);"></div></td></tr>
    <tr><td>border-emerald-600</td><td>border-color: oklch(59.6% .145 163.225);</td><td><div style="border-color: oklch(59.6% .145 163.225);"></div></td></tr>
    <tr><td>border-emerald-700</td><td>border-color: oklch(50.8% .118 165.612);</td><td><div style="border-color: oklch(50.8% .118 165.612);"></div></td></tr>
    <tr><td>border-emerald-800</td><td>border-color: oklch(43.2% .095 166.913);</td><td><div style="border-color: oklch(43.2% .095 166.913);"></div></td></tr>
    <tr><td>border-emerald-900</td><td>border-color: oklch(37.8% .077 168.94);</td><td><div style="border-color: oklch(37.8% .077 168.94);"></div></td></tr>
    <tr><td>border-emerald-950</td><td>border-color: oklch(26.2% .051 172.552);</td><td><div style="border-color: oklch(26.2% .051 172.552);"></div></td></tr>
    <tr><td>border-teal-50</td><td>border-color: oklch(98.4% .014 180.72);</td><td><div style="border-color: oklch(98.4% .014 180.72);"></div></td></tr>
    <tr><td>border-teal-100</td><td>border-color: oklch(95.3% .051 180.801);</td><td><div style="border-color: oklch(95.3% .051 180.801);"></div></td></tr>
    <tr><td>border-teal-200</td><td>border-color: oklch(91% .096 180.426);</td><td><div style="border-color: oklch(91% .096 180.426);"></div></td></tr>
    <tr><td>border-teal-300</td><td>border-color: oklch(85.5% .138 181.071);</td><td><div style="border-color: oklch(85.5% .138 181.071);"></div></td></tr>
    <tr><td>border-teal-400</td><td>border-color: oklch(77.7% .152 181.912);</td><td><div style="border-color: oklch(77.7% .152 181.912);"></div></td></tr>
    <tr><td>border-teal-500</td><td>border-color: oklch(70.4% .14 182.503);</td><td><div style="border-color: oklch(70.4% .14 182.503);"></div></td></tr>
    <tr><td>border-teal-600</td><td>border-color: oklch(60% .118 184.704);</td><td><div style="border-color: oklch(60% .118 184.704);"></div></td></tr>
    <tr><td>border-teal-700</td><td>border-color: oklch(51.1% .096 186.391);</td><td><div style="border-color: oklch(51.1% .096 186.391);"></div></td></tr>
    <tr><td>border-teal-800</td><td>border-color: oklch(43.7% .078 188.216);</td><td><div style="border-color: oklch(43.7% .078 188.216);"></div></td></tr>
    <tr><td>border-teal-900</td><td>border-color: oklch(38.6% .063 188.416);</td><td><div style="border-color: oklch(38.6% .063 188.416);"></div></td></tr>
    <tr><td>border-teal-950</td><td>border-color: oklch(27.7% .046 192.524);</td><td><div style="border-color: oklch(27.7% .046 192.524);"></div></td></tr>
    <tr><td>border-cyan-50</td><td>border-color: oklch(98.4% .019 200.873);</td><td><div style="border-color: oklch(98.4% .019 200.873);"></div></td></tr>
    <tr><td>border-cyan-100</td><td>border-color: oklch(95.6% .045 203.388);</td><td><div style="border-color: oklch(95.6% .045 203.388);"></div></td></tr>
    <tr><td>border-cyan-200</td><td>border-color: oklch(91.7% .08 205.041);</td><td><div style="border-color: oklch(91.7% .08 205.041);"></div></td></tr>
    <tr><td>border-cyan-300</td><td>border-color: oklch(86.5% .127 207.078);</td><td><div style="border-color: oklch(86.5% .127 207.078);"></div></td></tr>
    <tr><td>border-cyan-400</td><td>border-color: oklch(78.9% .154 211.53);</td><td><div style="border-color: oklch(78.9% .154 211.53);"></div></td></tr>
    <tr><td>border-cyan-500</td><td>border-color: oklch(71.5% .143 215.221);</td><td><div style="border-color: oklch(71.5% .143 215.221);"></div></td></tr>
    <tr><td>border-cyan-600</td><td>border-color: oklch(60.9% .126 221.723);</td><td><div style="border-color: oklch(60.9% .126 221.723);"></div></td></tr>
    <tr><td>border-cyan-700</td><td>border-color: oklch(52% .105 223.128);</td><td><div style="border-color: oklch(52% .105 223.128);"></div></td></tr>
    <tr><td>border-cyan-800</td><td>border-color: oklch(45% .085 224.283);</td><td><div style="border-color: oklch(45% .085 224.283);"></div></td></tr>
    <tr><td>border-cyan-900</td><td>border-color: oklch(39.8% .07 227.392);</td><td><div style="border-color: oklch(39.8% .07 227.392);"></div></td></tr>
    <tr><td>border-cyan-950</td><td>border-color: oklch(30.2% .056 229.695);</td><td><div style="border-color: oklch(30.2% .056 229.695);"></div></td></tr>
    <tr><td>border-sky-50</td><td>border-color: oklch(97.7% .013 236.62);</td><td><div style="border-color: oklch(97.7% .013 236.62);"></div></td></tr>
    <tr><td>border-sky-100</td><td>border-color: oklch(95.1% .026 236.824);</td><td><div style="border-color: oklch(95.1% .026 236.824);"></div></td></tr>
    <tr><td>border-sky-200</td><td>border-color: oklch(90.1% .058 230.902);</td><td><div style="border-color: oklch(90.1% .058 230.902);"></div></td></tr>
    <tr><td>border-sky-300</td><td>border-color: oklch(82.8% .111 230.318);</td><td><div style="border-color: oklch(82.8% .111 230.318);"></div></td></tr>
    <tr><td>border-sky-400</td><td>border-color: oklch(74.6% .16 232.661);</td><td><div style="border-color: oklch(74.6% .16 232.661);"></div></td></tr>
    <tr><td>border-sky-500</td><td>border-color: oklch(68.5% .169 237.323);</td><td><div style="border-color: oklch(68.5% .169 237.323);"></div></td></tr>
    <tr><td>border-sky-600</td><td>border-color: oklch(58.8% .158 241.966);</td><td><div style="border-color: oklch(58.8% .158 241.966);"></div></td></tr>
    <tr><td>border-sky-700</td><td>border-color: oklch(50% .134 242.749);</td><td><div style="border-color: oklch(50% .134 242.749);"></div></td></tr>
    <tr><td>border-sky-800</td><td>border-color: oklch(44.3% .11 240.79);</td><td><div style="border-color: oklch(44.3% .11 240.79);"></div></td></tr>
    <tr><td>border-sky-900</td><td>border-color: oklch(39.1% .09 240.876);</td><td><div style="border-color: oklch(39.1% .09 240.876);"></div></td></tr>
    <tr><td>border-sky-950</td><td>border-color: oklch(29.3% .066 243.157);</td><td><div style="border-color: oklch(29.3% .066 243.157);"></div></td></tr>
    <tr><td>border-blue-50</td><td>border-color: oklch(97% .014 254.604);</td><td><div style="border-color: oklch(97% .014 254.604);"></div></td></tr>
    <tr><td>border-blue-100</td><td>border-color: oklch(93.2% .032 255.585);</td><td><div style="border-color: oklch(93.2% .032 255.585);"></div></td></tr>
    <tr><td>border-blue-200</td><td>border-color: oklch(88.2% .059 254.128);</td><td><div style="border-color: oklch(88.2% .059 254.128);"></div></td></tr>
    <tr><td>border-blue-300</td><td>border-color: oklch(80.9% .105 251.813);</td><td><div style="border-color: oklch(80.9% .105 251.813);"></div></td></tr>
    <tr><td>border-blue-400</td><td>border-color: oklch(70.7% .165 254.624);</td><td><div style="border-color: oklch(70.7% .165 254.624);"></div></td></tr>
    <tr><td>border-blue-500</td><td>border-color: oklch(62.3% .214 259.815);</td><td><div style="border-color: oklch(62.3% .214 259.815);"></div></td></tr>
    <tr><td>border-blue-600</td><td>border-color: oklch(54.6% .245 262.881);</td><td><div style="border-color: oklch(54.6% .245 262.881);"></div></td></tr>
    <tr><td>border-blue-700</td><td>border-color: oklch(48.8% .243 264.376);</td><td><div style="border-color: oklch(48.8% .243 264.376);"></div></td></tr>
    <tr><td>border-blue-800</td><td>border-color: oklch(42.4% .199 265.638);</td><td><div style="border-color: oklch(42.4% .199 265.638);"></div></td></tr>
    <tr><td>border-blue-900</td><td>border-color: oklch(37.9% .146 265.522);</td><td><div style="border-color: oklch(37.9% .146 265.522);"></div></td></tr>
    <tr><td>border-blue-950</td><td>border-color: oklch(28.2% .091 267.935);</td><td><div style="border-color: oklch(28.2% .091 267.935);"></div></td></tr>
    <tr><td>border-indigo-50</td><td>border-color: oklch(96.2% .018 272.314);</td><td><div style="border-color: oklch(96.2% .018 272.314);"></div></td></tr>
    <tr><td>border-indigo-100</td><td>border-color: oklch(93% .034 272.788);</td><td><div style="border-color: oklch(93% .034 272.788);"></div></td></tr>
    <tr><td>border-indigo-200</td><td>border-color: oklch(87% .065 274.039);</td><td><div style="border-color: oklch(87% .065 274.039);"></div></td></tr>
    <tr><td>border-indigo-300</td><td>border-color: oklch(78.5% .115 274.713);</td><td><div style="border-color: oklch(78.5% .115 274.713);"></div></td></tr>
    <tr><td>border-indigo-400</td><td>border-color: oklch(67.3% .182 276.935);</td><td><div style="border-color: oklch(67.3% .182 276.935);"></div></td></tr>
    <tr><td>border-indigo-500</td><td>border-color: oklch(58.5% .233 277.117);</td><td><div style="border-color: oklch(58.5% .233 277.117);"></div></td></tr>
    <tr><td>border-indigo-600</td><td>border-color: oklch(51.1% .262 276.966);</td><td><div style="border-color: oklch(51.1% .262 276.966);"></div></td></tr>
    <tr><td>border-indigo-700</td><td>border-color: oklch(45.7% .24 277.023);</td><td><div style="border-color: oklch(45.7% .24 277.023);"></div></td></tr>
    <tr><td>border-indigo-800</td><td>border-color: oklch(39.8% .195 277.366);</td><td><div style="border-color: oklch(39.8% .195 277.366);"></div></td></tr>
    <tr><td>border-indigo-900</td><td>border-color: oklch(35.9% .144 278.697);</td><td><div style="border-color: oklch(35.9% .144 278.697);"></div></td></tr>
    <tr><td>border-indigo-950</td><td>border-color: oklch(25.7% .09 281.288);</td><td><div style="border-color: oklch(25.7% .09 281.288);"></div></td></tr>
    <tr><td>border-violet-50</td><td>border-color: oklch(96.9% .016 293.756);</td><td><div style="border-color: oklch(96.9% .016 293.756);"></div></td></tr>
    <tr><td>border-violet-100</td><td>border-color: oklch(94.3% .029 294.588);</td><td><div style="border-color: oklch(94.3% .029 294.588);"></div></td></tr>
    <tr><td>border-violet-200</td><td>border-color: oklch(89.4% .057 293.283);</td><td><div style="border-color: oklch(89.4% .057 293.283);"></div></td></tr>
    <tr><td>border-violet-300</td><td>border-color: oklch(81.1% .111 293.571);</td><td><div style="border-color: oklch(81.1% .111 293.571);"></div></td></tr>
    <tr><td>border-violet-400</td><td>border-color: oklch(70.2% .183 293.541);</td><td><div style="border-color: oklch(70.2% .183 293.541);"></div></td></tr>
    <tr><td>border-violet-500</td><td>border-color: oklch(60.6% .25 292.717);</td><td><div style="border-color: oklch(60.6% .25 292.717);"></div></td></tr>
    <tr><td>border-violet-600</td><td>border-color: oklch(54.1% .281 293.009);</td><td><div style="border-color: oklch(54.1% .281 293.009);"></div></td></tr>
    <tr><td>border-violet-700</td><td>border-color: oklch(49.1% .27 292.581);</td><td><div style="border-color: oklch(49.1% .27 292.581);"></div></td></tr>
    <tr><td>border-violet-800</td><td>border-color: oklch(43.2% .232 292.759);</td><td><div style="border-color: oklch(43.2% .232 292.759);"></div></td></tr>
    <tr><td>border-violet-900</td><td>border-color: oklch(38% .189 293.745);</td><td><div style="border-color: oklch(38% .189 293.745);"></div></td></tr>
    <tr><td>border-violet-950</td><td>border-color: oklch(28.3% .141 291.089);</td><td><div style="border-color: oklch(28.3% .141 291.089);"></div></td></tr>
    <tr><td>border-purple-50</td><td>border-color: oklch(97.7% .014 308.299);</td><td><div style="border-color: oklch(97.7% .014 308.299);"></div></td></tr>
    <tr><td>border-purple-100</td><td>border-color: oklch(94.6% .033 307.174);</td><td><div style="border-color: oklch(94.6% .033 307.174);"></div></td></tr>
    <tr><td>border-purple-200</td><td>border-color: oklch(90.2% .063 306.703);</td><td><div style="border-color: oklch(90.2% .063 306.703);"></div></td></tr>
    <tr><td>border-purple-300</td><td>border-color: oklch(82.7% .119 306.383);</td><td><div style="border-color: oklch(82.7% .119 306.383);"></div></td></tr>
    <tr><td>border-purple-400</td><td>border-color: oklch(71.4% .203 305.504);</td><td><div style="border-color: oklch(71.4% .203 305.504);"></div></td></tr>
    <tr><td>border-purple-500</td><td>border-color: oklch(62.7% .265 303.9);</td><td><div style="border-color: oklch(62.7% .265 303.9);"></div></td></tr>
    <tr><td>border-purple-600</td><td>border-color: oklch(55.8% .288 302.321);</td><td><div style="border-color: oklch(55.8% .288 302.321);"></div></td></tr>
    <tr><td>border-purple-700</td><td>border-color: oklch(49.6% .265 301.924);</td><td><div style="border-color: oklch(49.6% .265 301.924);"></div></td></tr>
    <tr><td>border-purple-800</td><td>border-color: oklch(43.8% .218 303.724);</td><td><div style="border-color: oklch(43.8% .218 303.724);"></div></td></tr>
    <tr><td>border-purple-900</td><td>border-color: oklch(38.1% .176 304.987);</td><td><div style="border-color: oklch(38.1% .176 304.987);"></div></td></tr>
    <tr><td>border-purple-950</td><td>border-color: oklch(29.1% .149 302.717);</td><td><div style="border-color: oklch(29.1% .149 302.717);"></div></td></tr>
    <tr><td>border-fuchsia-50</td><td>border-color: oklch(97.7% .017 320.058);</td><td><div style="border-color: oklch(97.7% .017 320.058);"></div></td></tr>
    <tr><td>border-fuchsia-100</td><td>border-color: oklch(95.2% .037 318.852);</td><td><div style="border-color: oklch(95.2% .037 318.852);"></div></td></tr>
    <tr><td>border-fuchsia-200</td><td>border-color: oklch(90.3% .076 319.62);</td><td><div style="border-color: oklch(90.3% .076 319.62);"></div></td></tr>
    <tr><td>border-fuchsia-300</td><td>border-color: oklch(83.3% .145 321.434);</td><td><div style="border-color: oklch(83.3% .145 321.434);"></div></td></tr>
    <tr><td>border-fuchsia-400</td><td>border-color: oklch(74% .238 322.16);</td><td><div style="border-color: oklch(74% .238 322.16);"></div></td></tr>
    <tr><td>border-fuchsia-500</td><td>border-color: oklch(66.7% .295 322.15);</td><td><div style="border-color: oklch(66.7% .295 322.15);"></div></td></tr>
    <tr><td>border-fuchsia-600</td><td>border-color: oklch(59.1% .293 322.896);</td><td><div style="border-color: oklch(59.1% .293 322.896);"></div></td></tr>
    <tr><td>border-fuchsia-700</td><td>border-color: oklch(51.8% .253 323.949);</td><td><div style="border-color: oklch(51.8% .253 323.949);"></div></td></tr>
    <tr><td>border-fuchsia-800</td><td>border-color: oklch(45.2% .211 324.591);</td><td><div style="border-color: oklch(45.2% .211 324.591);"></div></td></tr>
    <tr><td>border-fuchsia-900</td><td>border-color: oklch(40.1% .17 325.612);</td><td><div style="border-color: oklch(40.1% .17 325.612);"></div></td></tr>
    <tr><td>border-fuchsia-950</td><td>border-color: oklch(29.3% .136 325.661);</td><td><div style="border-color: oklch(29.3% .136 325.661);"></div></td></tr>
    <tr><td>border-pink-50</td><td>border-color: oklch(97.1% .014 343.198);</td><td><div style="border-color: oklch(97.1% .014 343.198);"></div></td></tr>
    <tr><td>border-pink-100</td><td>border-color: oklch(94.8% .028 342.258);</td><td><div style="border-color: oklch(94.8% .028 342.258);"></div></td></tr>
    <tr><td>border-pink-200</td><td>border-color: oklch(89.9% .061 343.231);</td><td><div style="border-color: oklch(89.9% .061 343.231);"></div></td></tr>
    <tr><td>border-pink-300</td><td>border-color: oklch(82.3% .12 346.018);</td><td><div style="border-color: oklch(82.3% .12 346.018);"></div></td></tr>
    <tr><td>border-pink-400</td><td>border-color: oklch(71.8% .202 349.761);</td><td><div style="border-color: oklch(71.8% .202 349.761);"></div></td></tr>
    <tr><td>border-pink-500</td><td>border-color: oklch(65.6% .241 354.308);</td><td><div style="border-color: oklch(65.6% .241 354.308);"></div></td></tr>
    <tr><td>border-pink-600</td><td>border-color: oklch(59.2% .249 .584);</td><td><div style="border-color: oklch(59.2% .249 .584);"></div></td></tr>
    <tr><td>border-pink-700</td><td>border-color: oklch(52.5% .223 3.958);</td><td><div style="border-color: oklch(52.5% .223 3.958);"></div></td></tr>
    <tr><td>border-pink-800</td><td>border-color: oklch(45.9% .187 3.815);</td><td><div style="border-color: oklch(45.9% .187 3.815);"></div></td></tr>
    <tr><td>border-pink-900</td><td>border-color: oklch(40.8% .153 2.432);</td><td><div style="border-color: oklch(40.8% .153 2.432);"></div></td></tr>
    <tr><td>border-pink-950</td><td>border-color: oklch(28.4% .109 3.907);</td><td><div style="border-color: oklch(28.4% .109 3.907);"></div></td></tr>
    <tr><td>border-rose-50</td><td>border-color: oklch(96.9% .015 12.422);</td><td><div style="border-color: oklch(96.9% .015 12.422);"></div></td></tr>
    <tr><td>border-rose-100</td><td>border-color: oklch(94.1% .03 12.58);</td><td><div style="border-color: oklch(94.1% .03 12.58);"></div></td></tr>
    <tr><td>border-rose-200</td><td>border-color: oklch(89.2% .058 10.001);</td><td><div style="border-color: oklch(89.2% .058 10.001);"></div></td></tr>
    <tr><td>border-rose-300</td><td>border-color: oklch(81% .117 11.638);</td><td><div style="border-color: oklch(81% .117 11.638);"></div></td></tr>
    <tr><td>border-rose-400</td><td>border-color: oklch(71.2% .194 13.428);</td><td><div style="border-color: oklch(71.2% .194 13.428);"></div></td></tr>
    <tr><td>border-rose-500</td><td>border-color: oklch(64.5% .246 16.439);</td><td><div style="border-color: oklch(64.5% .246 16.439);"></div></td></tr>
    <tr><td>border-rose-600</td><td>border-color: oklch(58.6% .253 17.585);</td><td><div style="border-color: oklch(58.6% .253 17.585);"></div></td></tr>
    <tr><td>border-rose-700</td><td>border-color: oklch(51.4% .222 16.935);</td><td><div style="border-color: oklch(51.4% .222 16.935);"></div></td></tr>
    <tr><td>border-rose-800</td><td>border-color: oklch(45.5% .188 13.697);</td><td><div style="border-color: oklch(45.5% .188 13.697);"></div></td></tr>
    <tr><td>border-rose-900</td><td>border-color: oklch(41% .159 10.272);</td><td><div style="border-color: oklch(41% .159 10.272);"></div></td></tr>
    <tr><td>border-rose-950</td><td>border-color: oklch(27.1% .105 12.094);</td><td><div style="border-color: oklch(27.1% .105 12.094);"></div></td></tr>
    <tr><td>border-slate-50</td><td>border-color: oklch(98.4% .003 247.858);</td><td><div style="border-color: oklch(98.4% .003 247.858);"></div></td></tr>
    <tr><td>border-slate-100</td><td>border-color: oklch(96.8% .007 247.896);</td><td><div style="border-color: oklch(96.8% .007 247.896);"></div></td></tr>
    <tr><td>border-slate-200</td><td>border-color: oklch(92.9% .013 255.508);</td><td><div style="border-color: oklch(92.9% .013 255.508);"></div></td></tr>
    <tr><td>border-slate-300</td><td>border-color: oklch(86.9% .022 252.894);</td><td><div style="border-color: oklch(86.9% .022 252.894);"></div></td></tr>
    <tr><td>border-slate-400</td><td>border-color: oklch(70.4% .04 256.788);</td><td><div style="border-color: oklch(70.4% .04 256.788);"></div></td></tr>
    <tr><td>border-slate-500</td><td>border-color: oklch(55.4% .046 257.417);</td><td><div style="border-color: oklch(55.4% .046 257.417);"></div></td></tr>
    <tr><td>border-slate-600</td><td>border-color: oklch(44.6% .043 257.281);</td><td><div style="border-color: oklch(44.6% .043 257.281);"></div></td></tr>
    <tr><td>border-slate-700</td><td>border-color: oklch(37.2% .044 257.287);</td><td><div style="border-color: oklch(37.2% .044 257.287);"></div></td></tr>
    <tr><td>border-slate-800</td><td>border-color: oklch(27.9% .041 260.031);</td><td><div style="border-color: oklch(27.9% .041 260.031);"></div></td></tr>
    <tr><td>border-slate-900</td><td>border-color: oklch(20.8% .042 265.755);</td><td><div style="border-color: oklch(20.8% .042 265.755);"></div></td></tr>
    <tr><td>border-slate-950</td><td>border-color: oklch(12.9% .042 264.695);</td><td><div style="border-color: oklch(12.9% .042 264.695);"></div></td></tr>
    <tr><td>border-gray-50</td><td>border-color: oklch(98.5% .002 247.839);</td><td><div style="border-color: oklch(98.5% .002 247.839);"></div></td></tr>
    <tr><td>border-gray-100</td><td>border-color: oklch(96.7% .003 264.542);</td><td><div style="border-color: oklch(96.7% .003 264.542);"></div></td></tr>
    <tr><td>border-gray-200</td><td>border-color: oklch(92.8% .006 264.531);</td><td><div style="border-color: oklch(92.8% .006 264.531);"></div></td></tr>
    <tr><td>border-gray-300</td><td>border-color: oklch(87.2% .01 258.338);</td><td><div style="border-color: oklch(87.2% .01 258.338);"></div></td></tr>
    <tr><td>border-gray-400</td><td>border-color: oklch(70.7% .022 261.325);</td><td><div style="border-color: oklch(70.7% .022 261.325);"></div></td></tr>
    <tr><td>border-gray-500</td><td>border-color: oklch(55.1% .027 264.364);</td><td><div style="border-color: oklch(55.1% .027 264.364);"></div></td></tr>
    <tr><td>border-gray-600</td><td>border-color: oklch(44.6% .03 256.802);</td><td><div style="border-color: oklch(44.6% .03 256.802);"></div></td></tr>
    <tr><td>border-gray-700</td><td>border-color: oklch(37.3% .034 259.733);</td><td><div style="border-color: oklch(37.3% .034 259.733);"></div></td></tr>
    <tr><td>border-gray-800</td><td>border-color: oklch(27.8% .033 256.848);</td><td><div style="border-color: oklch(27.8% .033 256.848);"></div></td></tr>
    <tr><td>border-gray-900</td><td>border-color: oklch(21% .034 264.665);</td><td><div style="border-color: oklch(21% .034 264.665);"></div></td></tr>
    <tr><td>border-gray-950</td><td>border-color: oklch(13% .028 261.692);</td><td><div style="border-color: oklch(13% .028 261.692);"></div></td></tr>
    <tr><td>border-zinc-50</td><td>border-color: oklch(98.5% 0 0);</td><td><div style="border-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-zinc-100</td><td>border-color: oklch(96.7% .001 286.375);</td><td><div style="border-color: oklch(96.7% .001 286.375);"></div></td></tr>
    <tr><td>border-zinc-200</td><td>border-color: oklch(92% .004 286.32);</td><td><div style="border-color: oklch(92% .004 286.32);"></div></td></tr>
    <tr><td>border-zinc-300</td><td>border-color: oklch(87.1% .006 286.286);</td><td><div style="border-color: oklch(87.1% .006 286.286);"></div></td></tr>
    <tr><td>border-zinc-400</td><td>border-color: oklch(70.5% .015 286.067);</td><td><div style="border-color: oklch(70.5% .015 286.067);"></div></td></tr>
    <tr><td>border-zinc-500</td><td>border-color: oklch(55.2% .016 285.938);</td><td><div style="border-color: oklch(55.2% .016 285.938);"></div></td></tr>
    <tr><td>border-zinc-600</td><td>border-color: oklch(44.2% .017 285.786);</td><td><div style="border-color: oklch(44.2% .017 285.786);"></div></td></tr>
    <tr><td>border-zinc-700</td><td>border-color: oklch(37% .013 285.805);</td><td><div style="border-color: oklch(37% .013 285.805);"></div></td></tr>
    <tr><td>border-zinc-800</td><td>border-color: oklch(27.4% .006 286.033);</td><td><div style="border-color: oklch(27.4% .006 286.033);"></div></td></tr>
    <tr><td>border-zinc-900</td><td>border-color: oklch(21% .006 285.885);</td><td><div style="border-color: oklch(21% .006 285.885);"></div></td></tr>
    <tr><td>border-zinc-950</td><td>border-color: oklch(14.1% .005 285.823);</td><td><div style="border-color: oklch(14.1% .005 285.823);"></div></td></tr>
    <tr><td>border-neutral-50</td><td>border-color: oklch(98.5% 0 0);</td><td><div style="border-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-neutral-100</td><td>border-color: oklch(97% 0 0);</td><td><div style="border-color: oklch(97% 0 0);"></div></td></tr>
    <tr><td>border-neutral-200</td><td>border-color: oklch(92.2% 0 0);</td><td><div style="border-color: oklch(92.2% 0 0);"></div></td></tr>
    <tr><td>border-neutral-300</td><td>border-color: oklch(87% 0 0);</td><td><div style="border-color: oklch(87% 0 0);"></div></td></tr>
    <tr><td>border-neutral-400</td><td>border-color: oklch(70.8% 0 0);</td><td><div style="border-color: oklch(70.8% 0 0);"></div></td></tr>
    <tr><td>border-neutral-500</td><td>border-color: oklch(55.6% 0 0);</td><td><div style="border-color: oklch(55.6% 0 0);"></div></td></tr>
    <tr><td>border-neutral-600</td><td>border-color: oklch(43.9% 0 0);</td><td><div style="border-color: oklch(43.9% 0 0);"></div></td></tr>
    <tr><td>border-neutral-700</td><td>border-color: oklch(37.1% 0 0);</td><td><div style="border-color: oklch(37.1% 0 0);"></div></td></tr>
    <tr><td>border-neutral-800</td><td>border-color: oklch(26.9% 0 0);</td><td><div style="border-color: oklch(26.9% 0 0);"></div></td></tr>
    <tr><td>border-neutral-900</td><td>border-color: oklch(20.5% 0 0);</td><td><div style="border-color: oklch(20.5% 0 0);"></div></td></tr>
    <tr><td>border-neutral-950</td><td>border-color: oklch(14.5% 0 0);</td><td><div style="border-color: oklch(14.5% 0 0);"></div></td></tr>
    <tr><td>border-stone-50</td><td>border-color: oklch(98.5% .001 106.423);</td><td><div style="border-color: oklch(98.5% .001 106.423);"></div></td></tr>
    <tr><td>border-stone-100</td><td>border-color: oklch(97% .001 106.424);</td><td><div style="border-color: oklch(97% .001 106.424);"></div></td></tr>
    <tr><td>border-stone-200</td><td>border-color: oklch(92.3% .003 48.717);</td><td><div style="border-color: oklch(92.3% .003 48.717);"></div></td></tr>
    <tr><td>border-stone-300</td><td>border-color: oklch(86.9% .005 56.366);</td><td><div style="border-color: oklch(86.9% .005 56.366);"></div></td></tr>
    <tr><td>border-stone-400</td><td>border-color: oklch(70.9% .01 56.259);</td><td><div style="border-color: oklch(70.9% .01 56.259);"></div></td></tr>
    <tr><td>border-stone-500</td><td>border-color: oklch(55.3% .013 58.071);</td><td><div style="border-color: oklch(55.3% .013 58.071);"></div></td></tr>
    <tr><td>border-stone-600</td><td>border-color: oklch(44.4% .011 73.639);</td><td><div style="border-color: oklch(44.4% .011 73.639);"></div></td></tr>
    <tr><td>border-stone-700</td><td>border-color: oklch(37.4% .01 67.558);</td><td><div style="border-color: oklch(37.4% .01 67.558);"></div></td></tr>
    <tr><td>border-stone-800</td><td>border-color: oklch(26.8% .007 34.298);</td><td><div style="border-color: oklch(26.8% .007 34.298);"></div></td></tr>
    <tr><td>border-stone-900</td><td>border-color: oklch(21.6% .006 56.043);</td><td><div style="border-color: oklch(21.6% .006 56.043);"></div></td></tr>
    <tr><td>border-stone-950</td><td>border-color: oklch(14.7% .004 49.25);</td><td><div style="border-color: oklch(14.7% .004 49.25);"></div></td></tr>
    <tr><td>border-black</td><td>border-color: #000;</td><td><div style="border-color: #000;"></div></td></tr>
    <tr><td>border-white</td><td>border-color: #fff;</td><td><div style="border-color: #fff;"></div></td></tr>
    <tr><td>border-x-inherit</td><td>border-inline-color: inherit;</td><td><div style="border-inline-color: inherit;"></div></td></tr>
    <tr><td>border-x-current</td><td>border-inline-color: currentColor;</td><td><div style="border-inline-color: currentColor;"></div></td></tr>
    <tr><td>border-x-transparent</td><td>border-inline-color: transparent;</td><td><div style="border-inline-color: transparent;"></div></td></tr>
    <tr><td>border-x-red-50</td><td>border-inline-color: oklch(97.1% .013 17.38);</td><td><div style="border-inline-color: oklch(97.1% .013 17.38);"></div></td></tr>
    <tr><td>border-x-red-100</td><td>border-inline-color: oklch(93.6% .032 17.717);</td><td><div style="border-inline-color: oklch(93.6% .032 17.717);"></div></td></tr>
    <tr><td>border-x-red-200</td><td>border-inline-color: oklch(88.5% .062 18.334);</td><td><div style="border-inline-color: oklch(88.5% .062 18.334);"></div></td></tr>
    <tr><td>border-x-red-300</td><td>border-inline-color: oklch(80.8% .114 19.571);</td><td><div style="border-inline-color: oklch(80.8% .114 19.571);"></div></td></tr>
    <tr><td>border-x-red-400</td><td>border-inline-color: oklch(70.4% .191 22.216);</td><td><div style="border-inline-color: oklch(70.4% .191 22.216);"></div></td></tr>
    <tr><td>border-x-red-500</td><td>border-inline-color: oklch(63.7% .237 25.331);</td><td><div style="border-inline-color: oklch(63.7% .237 25.331);"></div></td></tr>
    <tr><td>border-x-red-600</td><td>border-inline-color: oklch(57.7% .245 27.325);</td><td><div style="border-inline-color: oklch(57.7% .245 27.325);"></div></td></tr>
    <tr><td>border-x-red-700</td><td>border-inline-color: oklch(50.5% .213 27.518);</td><td><div style="border-inline-color: oklch(50.5% .213 27.518);"></div></td></tr>
    <tr><td>border-x-red-800</td><td>border-inline-color: oklch(44.4% .177 26.899);</td><td><div style="border-inline-color: oklch(44.4% .177 26.899);"></div></td></tr>
    <tr><td>border-x-red-900</td><td>border-inline-color: oklch(39.6% .141 25.723);</td><td><div style="border-inline-color: oklch(39.6% .141 25.723);"></div></td></tr>
    <tr><td>border-x-red-950</td><td>border-inline-color: oklch(25.8% .092 26.042);</td><td><div style="border-inline-color: oklch(25.8% .092 26.042);"></div></td></tr>
    <tr><td>border-x-orange-50</td><td>border-inline-color: oklch(98% .016 73.684);</td><td><div style="border-inline-color: oklch(98% .016 73.684);"></div></td></tr>
    <tr><td>border-x-orange-100</td><td>border-inline-color: oklch(95.4% .038 75.164);</td><td><div style="border-inline-color: oklch(95.4% .038 75.164);"></div></td></tr>
    <tr><td>border-x-orange-200</td><td>border-inline-color: oklch(90.1% .076 70.697);</td><td><div style="border-inline-color: oklch(90.1% .076 70.697);"></div></td></tr>
    <tr><td>border-x-orange-300</td><td>border-inline-color: oklch(83.7% .128 66.29);</td><td><div style="border-inline-color: oklch(83.7% .128 66.29);"></div></td></tr>
    <tr><td>border-x-orange-400</td><td>border-inline-color: oklch(75% .183 55.934);</td><td><div style="border-inline-color: oklch(75% .183 55.934);"></div></td></tr>
    <tr><td>border-x-orange-500</td><td>border-inline-color: oklch(70.5% .213 47.604);</td><td><div style="border-inline-color: oklch(70.5% .213 47.604);"></div></td></tr>
    <tr><td>border-x-orange-600</td><td>border-inline-color: oklch(64.6% .222 41.116);</td><td><div style="border-inline-color: oklch(64.6% .222 41.116);"></div></td></tr>
    <tr><td>border-x-orange-700</td><td>border-inline-color: oklch(55.3% .195 38.402);</td><td><div style="border-inline-color: oklch(55.3% .195 38.402);"></div></td></tr>
    <tr><td>border-x-orange-800</td><td>border-inline-color: oklch(47% .157 37.304);</td><td><div style="border-inline-color: oklch(47% .157 37.304);"></div></td></tr>
    <tr><td>border-x-orange-900</td><td>border-inline-color: oklch(40.8% .123 38.172);</td><td><div style="border-inline-color: oklch(40.8% .123 38.172);"></div></td></tr>
    <tr><td>border-x-orange-950</td><td>border-inline-color: oklch(26.6% .079 36.259);</td><td><div style="border-inline-color: oklch(26.6% .079 36.259);"></div></td></tr>
    <tr><td>border-x-amber-50</td><td>border-inline-color: oklch(98.7% .022 95.277);</td><td><div style="border-inline-color: oklch(98.7% .022 95.277);"></div></td></tr>
    <tr><td>border-x-amber-100</td><td>border-inline-color: oklch(96.2% .059 95.617);</td><td><div style="border-inline-color: oklch(96.2% .059 95.617);"></div></td></tr>
    <tr><td>border-x-amber-200</td><td>border-inline-color: oklch(92.4% .12 95.746);</td><td><div style="border-inline-color: oklch(92.4% .12 95.746);"></div></td></tr>
    <tr><td>border-x-amber-300</td><td>border-inline-color: oklch(87.9% .169 91.605);</td><td><div style="border-inline-color: oklch(87.9% .169 91.605);"></div></td></tr>
    <tr><td>border-x-amber-400</td><td>border-inline-color: oklch(82.8% .189 84.429);</td><td><div style="border-inline-color: oklch(82.8% .189 84.429);"></div></td></tr>
    <tr><td>border-x-amber-500</td><td>border-inline-color: oklch(76.9% .188 70.08);</td><td><div style="border-inline-color: oklch(76.9% .188 70.08);"></div></td></tr>
    <tr><td>border-x-amber-600</td><td>border-inline-color: oklch(66.6% .179 58.318);</td><td><div style="border-inline-color: oklch(66.6% .179 58.318);"></div></td></tr>
    <tr><td>border-x-amber-700</td><td>border-inline-color: oklch(55.5% .163 48.998);</td><td><div style="border-inline-color: oklch(55.5% .163 48.998);"></div></td></tr>
    <tr><td>border-x-amber-800</td><td>border-inline-color: oklch(47.3% .137 46.201);</td><td><div style="border-inline-color: oklch(47.3% .137 46.201);"></div></td></tr>
    <tr><td>border-x-amber-900</td><td>border-inline-color: oklch(41.4% .112 45.904);</td><td><div style="border-inline-color: oklch(41.4% .112 45.904);"></div></td></tr>
    <tr><td>border-x-amber-950</td><td>border-inline-color: oklch(27.9% .077 45.635);</td><td><div style="border-inline-color: oklch(27.9% .077 45.635);"></div></td></tr>
    <tr><td>border-x-yellow-50</td><td>border-inline-color: oklch(98.7% .026 102.212);</td><td><div style="border-inline-color: oklch(98.7% .026 102.212);"></div></td></tr>
    <tr><td>border-x-yellow-100</td><td>border-inline-color: oklch(97.3% .071 103.193);</td><td><div style="border-inline-color: oklch(97.3% .071 103.193);"></div></td></tr>
    <tr><td>border-x-yellow-200</td><td>border-inline-color: oklch(94.5% .129 101.54);</td><td><div style="border-inline-color: oklch(94.5% .129 101.54);"></div></td></tr>
    <tr><td>border-x-yellow-300</td><td>border-inline-color: oklch(90.5% .182 98.111);</td><td><div style="border-inline-color: oklch(90.5% .182 98.111);"></div></td></tr>
    <tr><td>border-x-yellow-400</td><td>border-inline-color: oklch(85.2% .199 91.936);</td><td><div style="border-inline-color: oklch(85.2% .199 91.936);"></div></td></tr>
    <tr><td>border-x-yellow-500</td><td>border-inline-color: oklch(79.5% .184 86.047);</td><td><div style="border-inline-color: oklch(79.5% .184 86.047);"></div></td></tr>
    <tr><td>border-x-yellow-600</td><td>border-inline-color: oklch(68.1% .162 75.834);</td><td><div style="border-inline-color: oklch(68.1% .162 75.834);"></div></td></tr>
    <tr><td>border-x-yellow-700</td><td>border-inline-color: oklch(55.4% .135 66.442);</td><td><div style="border-inline-color: oklch(55.4% .135 66.442);"></div></td></tr>
    <tr><td>border-x-yellow-800</td><td>border-inline-color: oklch(47.6% .114 61.907);</td><td><div style="border-inline-color: oklch(47.6% .114 61.907);"></div></td></tr>
    <tr><td>border-x-yellow-900</td><td>border-inline-color: oklch(42.1% .095 57.708);</td><td><div style="border-inline-color: oklch(42.1% .095 57.708);"></div></td></tr>
    <tr><td>border-x-yellow-950</td><td>border-inline-color: oklch(28.6% .066 53.813);</td><td><div style="border-inline-color: oklch(28.6% .066 53.813);"></div></td></tr>
    <tr><td>border-x-lime-50</td><td>border-inline-color: oklch(98.6% .031 120.757);</td><td><div style="border-inline-color: oklch(98.6% .031 120.757);"></div></td></tr>
    <tr><td>border-x-lime-100</td><td>border-inline-color: oklch(96.7% .067 122.328);</td><td><div style="border-inline-color: oklch(96.7% .067 122.328);"></div></td></tr>
    <tr><td>border-x-lime-200</td><td>border-inline-color: oklch(93.8% .127 124.321);</td><td><div style="border-inline-color: oklch(93.8% .127 124.321);"></div></td></tr>
    <tr><td>border-x-lime-300</td><td>border-inline-color: oklch(89.7% .196 126.665);</td><td><div style="border-inline-color: oklch(89.7% .196 126.665);"></div></td></tr>
    <tr><td>border-x-lime-400</td><td>border-inline-color: oklch(84.1% .238 128.85);</td><td><div style="border-inline-color: oklch(84.1% .238 128.85);"></div></td></tr>
    <tr><td>border-x-lime-500</td><td>border-inline-color: oklch(76.8% .233 130.85);</td><td><div style="border-inline-color: oklch(76.8% .233 130.85);"></div></td></tr>
    <tr><td>border-x-lime-600</td><td>border-inline-color: oklch(64.8% .2 131.684);</td><td><div style="border-inline-color: oklch(64.8% .2 131.684);"></div></td></tr>
    <tr><td>border-x-lime-700</td><td>border-inline-color: oklch(53.2% .157 131.589);</td><td><div style="border-inline-color: oklch(53.2% .157 131.589);"></div></td></tr>
    <tr><td>border-x-lime-800</td><td>border-inline-color: oklch(45.3% .124 130.933);</td><td><div style="border-inline-color: oklch(45.3% .124 130.933);"></div></td></tr>
    <tr><td>border-x-lime-900</td><td>border-inline-color: oklch(40.5% .101 131.063);</td><td><div style="border-inline-color: oklch(40.5% .101 131.063);"></div></td></tr>
    <tr><td>border-x-lime-950</td><td>border-inline-color: oklch(27.4% .072 132.109);</td><td><div style="border-inline-color: oklch(27.4% .072 132.109);"></div></td></tr>
    <tr><td>border-x-green-50</td><td>border-inline-color: oklch(98.2% .018 155.826);</td><td><div style="border-inline-color: oklch(98.2% .018 155.826);"></div></td></tr>
    <tr><td>border-x-green-100</td><td>border-inline-color: oklch(96.2% .044 156.743);</td><td><div style="border-inline-color: oklch(96.2% .044 156.743);"></div></td></tr>
    <tr><td>border-x-green-200</td><td>border-inline-color: oklch(92.5% .084 155.995);</td><td><div style="border-inline-color: oklch(92.5% .084 155.995);"></div></td></tr>
    <tr><td>border-x-green-300</td><td>border-inline-color: oklch(87.1% .15 154.449);</td><td><div style="border-inline-color: oklch(87.1% .15 154.449);"></div></td></tr>
    <tr><td>border-x-green-400</td><td>border-inline-color: oklch(79.2% .209 151.711);</td><td><div style="border-inline-color: oklch(79.2% .209 151.711);"></div></td></tr>
    <tr><td>border-x-green-500</td><td>border-inline-color: oklch(72.3% .219 149.579);</td><td><div style="border-inline-color: oklch(72.3% .219 149.579);"></div></td></tr>
    <tr><td>border-x-green-600</td><td>border-inline-color: oklch(62.7% .194 149.214);</td><td><div style="border-inline-color: oklch(62.7% .194 149.214);"></div></td></tr>
    <tr><td>border-x-green-700</td><td>border-inline-color: oklch(52.7% .154 150.069);</td><td><div style="border-inline-color: oklch(52.7% .154 150.069);"></div></td></tr>
    <tr><td>border-x-green-800</td><td>border-inline-color: oklch(44.8% .119 151.328);</td><td><div style="border-inline-color: oklch(44.8% .119 151.328);"></div></td></tr>
    <tr><td>border-x-green-900</td><td>border-inline-color: oklch(39.3% .095 152.535);</td><td><div style="border-inline-color: oklch(39.3% .095 152.535);"></div></td></tr>
    <tr><td>border-x-green-950</td><td>border-inline-color: oklch(26.6% .065 152.934);</td><td><div style="border-inline-color: oklch(26.6% .065 152.934);"></div></td></tr>
    <tr><td>border-x-emerald-50</td><td>border-inline-color: oklch(97.9% .021 166.113);</td><td><div style="border-inline-color: oklch(97.9% .021 166.113);"></div></td></tr>
    <tr><td>border-x-emerald-100</td><td>border-inline-color: oklch(95% .052 163.051);</td><td><div style="border-inline-color: oklch(95% .052 163.051);"></div></td></tr>
    <tr><td>border-x-emerald-200</td><td>border-inline-color: oklch(90.5% .093 164.15);</td><td><div style="border-inline-color: oklch(90.5% .093 164.15);"></div></td></tr>
    <tr><td>border-x-emerald-300</td><td>border-inline-color: oklch(84.5% .143 164.978);</td><td><div style="border-inline-color: oklch(84.5% .143 164.978);"></div></td></tr>
    <tr><td>border-x-emerald-400</td><td>border-inline-color: oklch(76.5% .177 163.223);</td><td><div style="border-inline-color: oklch(76.5% .177 163.223);"></div></td></tr>
    <tr><td>border-x-emerald-500</td><td>border-inline-color: oklch(69.6% .17 162.48);</td><td><div style="border-inline-color: oklch(69.6% .17 162.48);"></div></td></tr>
    <tr><td>border-x-emerald-600</td><td>border-inline-color: oklch(59.6% .145 163.225);</td><td><div style="border-inline-color: oklch(59.6% .145 163.225);"></div></td></tr>
    <tr><td>border-x-emerald-700</td><td>border-inline-color: oklch(50.8% .118 165.612);</td><td><div style="border-inline-color: oklch(50.8% .118 165.612);"></div></td></tr>
    <tr><td>border-x-emerald-800</td><td>border-inline-color: oklch(43.2% .095 166.913);</td><td><div style="border-inline-color: oklch(43.2% .095 166.913);"></div></td></tr>
    <tr><td>border-x-emerald-900</td><td>border-inline-color: oklch(37.8% .077 168.94);</td><td><div style="border-inline-color: oklch(37.8% .077 168.94);"></div></td></tr>
    <tr><td>border-x-emerald-950</td><td>border-inline-color: oklch(26.2% .051 172.552);</td><td><div style="border-inline-color: oklch(26.2% .051 172.552);"></div></td></tr>
    <tr><td>border-x-teal-50</td><td>border-inline-color: oklch(98.4% .014 180.72);</td><td><div style="border-inline-color: oklch(98.4% .014 180.72);"></div></td></tr>
    <tr><td>border-x-teal-100</td><td>border-inline-color: oklch(95.3% .051 180.801);</td><td><div style="border-inline-color: oklch(95.3% .051 180.801);"></div></td></tr>
    <tr><td>border-x-teal-200</td><td>border-inline-color: oklch(91% .096 180.426);</td><td><div style="border-inline-color: oklch(91% .096 180.426);"></div></td></tr>
    <tr><td>border-x-teal-300</td><td>border-inline-color: oklch(85.5% .138 181.071);</td><td><div style="border-inline-color: oklch(85.5% .138 181.071);"></div></td></tr>
    <tr><td>border-x-teal-400</td><td>border-inline-color: oklch(77.7% .152 181.912);</td><td><div style="border-inline-color: oklch(77.7% .152 181.912);"></div></td></tr>
    <tr><td>border-x-teal-500</td><td>border-inline-color: oklch(70.4% .14 182.503);</td><td><div style="border-inline-color: oklch(70.4% .14 182.503);"></div></td></tr>
    <tr><td>border-x-teal-600</td><td>border-inline-color: oklch(60% .118 184.704);</td><td><div style="border-inline-color: oklch(60% .118 184.704);"></div></td></tr>
    <tr><td>border-x-teal-700</td><td>border-inline-color: oklch(51.1% .096 186.391);</td><td><div style="border-inline-color: oklch(51.1% .096 186.391);"></div></td></tr>
    <tr><td>border-x-teal-800</td><td>border-inline-color: oklch(43.7% .078 188.216);</td><td><div style="border-inline-color: oklch(43.7% .078 188.216);"></div></td></tr>
    <tr><td>border-x-teal-900</td><td>border-inline-color: oklch(38.6% .063 188.416);</td><td><div style="border-inline-color: oklch(38.6% .063 188.416);"></div></td></tr>
    <tr><td>border-x-teal-950</td><td>border-inline-color: oklch(27.7% .046 192.524);</td><td><div style="border-inline-color: oklch(27.7% .046 192.524);"></div></td></tr>
    <tr><td>border-x-cyan-50</td><td>border-inline-color: oklch(98.4% .019 200.873);</td><td><div style="border-inline-color: oklch(98.4% .019 200.873);"></div></td></tr>
    <tr><td>border-x-cyan-100</td><td>border-inline-color: oklch(95.6% .045 203.388);</td><td><div style="border-inline-color: oklch(95.6% .045 203.388);"></div></td></tr>
    <tr><td>border-x-cyan-200</td><td>border-inline-color: oklch(91.7% .08 205.041);</td><td><div style="border-inline-color: oklch(91.7% .08 205.041);"></div></td></tr>
    <tr><td>border-x-cyan-300</td><td>border-inline-color: oklch(86.5% .127 207.078);</td><td><div style="border-inline-color: oklch(86.5% .127 207.078);"></div></td></tr>
    <tr><td>border-x-cyan-400</td><td>border-inline-color: oklch(78.9% .154 211.53);</td><td><div style="border-inline-color: oklch(78.9% .154 211.53);"></div></td></tr>
    <tr><td>border-x-cyan-500</td><td>border-inline-color: oklch(71.5% .143 215.221);</td><td><div style="border-inline-color: oklch(71.5% .143 215.221);"></div></td></tr>
    <tr><td>border-x-cyan-600</td><td>border-inline-color: oklch(60.9% .126 221.723);</td><td><div style="border-inline-color: oklch(60.9% .126 221.723);"></div></td></tr>
    <tr><td>border-x-cyan-700</td><td>border-inline-color: oklch(52% .105 223.128);</td><td><div style="border-inline-color: oklch(52% .105 223.128);"></div></td></tr>
    <tr><td>border-x-cyan-800</td><td>border-inline-color: oklch(45% .085 224.283);</td><td><div style="border-inline-color: oklch(45% .085 224.283);"></div></td></tr>
    <tr><td>border-x-cyan-900</td><td>border-inline-color: oklch(39.8% .07 227.392);</td><td><div style="border-inline-color: oklch(39.8% .07 227.392);"></div></td></tr>
    <tr><td>border-x-cyan-950</td><td>border-inline-color: oklch(30.2% .056 229.695);</td><td><div style="border-inline-color: oklch(30.2% .056 229.695);"></div></td></tr>
    <tr><td>border-x-sky-50</td><td>border-inline-color: oklch(97.7% .013 236.62);</td><td><div style="border-inline-color: oklch(97.7% .013 236.62);"></div></td></tr>
    <tr><td>border-x-sky-100</td><td>border-inline-color: oklch(95.1% .026 236.824);</td><td><div style="border-inline-color: oklch(95.1% .026 236.824);"></div></td></tr>
    <tr><td>border-x-sky-200</td><td>border-inline-color: oklch(90.1% .058 230.902);</td><td><div style="border-inline-color: oklch(90.1% .058 230.902);"></div></td></tr>
    <tr><td>border-x-sky-300</td><td>border-inline-color: oklch(82.8% .111 230.318);</td><td><div style="border-inline-color: oklch(82.8% .111 230.318);"></div></td></tr>
    <tr><td>border-x-sky-400</td><td>border-inline-color: oklch(74.6% .16 232.661);</td><td><div style="border-inline-color: oklch(74.6% .16 232.661);"></div></td></tr>
    <tr><td>border-x-sky-500</td><td>border-inline-color: oklch(68.5% .169 237.323);</td><td><div style="border-inline-color: oklch(68.5% .169 237.323);"></div></td></tr>
    <tr><td>border-x-sky-600</td><td>border-inline-color: oklch(58.8% .158 241.966);</td><td><div style="border-inline-color: oklch(58.8% .158 241.966);"></div></td></tr>
    <tr><td>border-x-sky-700</td><td>border-inline-color: oklch(50% .134 242.749);</td><td><div style="border-inline-color: oklch(50% .134 242.749);"></div></td></tr>
    <tr><td>border-x-sky-800</td><td>border-inline-color: oklch(44.3% .11 240.79);</td><td><div style="border-inline-color: oklch(44.3% .11 240.79);"></div></td></tr>
    <tr><td>border-x-sky-900</td><td>border-inline-color: oklch(39.1% .09 240.876);</td><td><div style="border-inline-color: oklch(39.1% .09 240.876);"></div></td></tr>
    <tr><td>border-x-sky-950</td><td>border-inline-color: oklch(29.3% .066 243.157);</td><td><div style="border-inline-color: oklch(29.3% .066 243.157);"></div></td></tr>
    <tr><td>border-x-blue-50</td><td>border-inline-color: oklch(97% .014 254.604);</td><td><div style="border-inline-color: oklch(97% .014 254.604);"></div></td></tr>
    <tr><td>border-x-blue-100</td><td>border-inline-color: oklch(93.2% .032 255.585);</td><td><div style="border-inline-color: oklch(93.2% .032 255.585);"></div></td></tr>
    <tr><td>border-x-blue-200</td><td>border-inline-color: oklch(88.2% .059 254.128);</td><td><div style="border-inline-color: oklch(88.2% .059 254.128);"></div></td></tr>
    <tr><td>border-x-blue-300</td><td>border-inline-color: oklch(80.9% .105 251.813);</td><td><div style="border-inline-color: oklch(80.9% .105 251.813);"></div></td></tr>
    <tr><td>border-x-blue-400</td><td>border-inline-color: oklch(70.7% .165 254.624);</td><td><div style="border-inline-color: oklch(70.7% .165 254.624);"></div></td></tr>
    <tr><td>border-x-blue-500</td><td>border-inline-color: oklch(62.3% .214 259.815);</td><td><div style="border-inline-color: oklch(62.3% .214 259.815);"></div></td></tr>
    <tr><td>border-x-blue-600</td><td>border-inline-color: oklch(54.6% .245 262.881);</td><td><div style="border-inline-color: oklch(54.6% .245 262.881);"></div></td></tr>
    <tr><td>border-x-blue-700</td><td>border-inline-color: oklch(48.8% .243 264.376);</td><td><div style="border-inline-color: oklch(48.8% .243 264.376);"></div></td></tr>
    <tr><td>border-x-blue-800</td><td>border-inline-color: oklch(42.4% .199 265.638);</td><td><div style="border-inline-color: oklch(42.4% .199 265.638);"></div></td></tr>
    <tr><td>border-x-blue-900</td><td>border-inline-color: oklch(37.9% .146 265.522);</td><td><div style="border-inline-color: oklch(37.9% .146 265.522);"></div></td></tr>
    <tr><td>border-x-blue-950</td><td>border-inline-color: oklch(28.2% .091 267.935);</td><td><div style="border-inline-color: oklch(28.2% .091 267.935);"></div></td></tr>
    <tr><td>border-x-indigo-50</td><td>border-inline-color: oklch(96.2% .018 272.314);</td><td><div style="border-inline-color: oklch(96.2% .018 272.314);"></div></td></tr>
    <tr><td>border-x-indigo-100</td><td>border-inline-color: oklch(93% .034 272.788);</td><td><div style="border-inline-color: oklch(93% .034 272.788);"></div></td></tr>
    <tr><td>border-x-indigo-200</td><td>border-inline-color: oklch(87% .065 274.039);</td><td><div style="border-inline-color: oklch(87% .065 274.039);"></div></td></tr>
    <tr><td>border-x-indigo-300</td><td>border-inline-color: oklch(78.5% .115 274.713);</td><td><div style="border-inline-color: oklch(78.5% .115 274.713);"></div></td></tr>
    <tr><td>border-x-indigo-400</td><td>border-inline-color: oklch(67.3% .182 276.935);</td><td><div style="border-inline-color: oklch(67.3% .182 276.935);"></div></td></tr>
    <tr><td>border-x-indigo-500</td><td>border-inline-color: oklch(58.5% .233 277.117);</td><td><div style="border-inline-color: oklch(58.5% .233 277.117);"></div></td></tr>
    <tr><td>border-x-indigo-600</td><td>border-inline-color: oklch(51.1% .262 276.966);</td><td><div style="border-inline-color: oklch(51.1% .262 276.966);"></div></td></tr>
    <tr><td>border-x-indigo-700</td><td>border-inline-color: oklch(45.7% .24 277.023);</td><td><div style="border-inline-color: oklch(45.7% .24 277.023);"></div></td></tr>
    <tr><td>border-x-indigo-800</td><td>border-inline-color: oklch(39.8% .195 277.366);</td><td><div style="border-inline-color: oklch(39.8% .195 277.366);"></div></td></tr>
    <tr><td>border-x-indigo-900</td><td>border-inline-color: oklch(35.9% .144 278.697);</td><td><div style="border-inline-color: oklch(35.9% .144 278.697);"></div></td></tr>
    <tr><td>border-x-indigo-950</td><td>border-inline-color: oklch(25.7% .09 281.288);</td><td><div style="border-inline-color: oklch(25.7% .09 281.288);"></div></td></tr>
    <tr><td>border-x-violet-50</td><td>border-inline-color: oklch(96.9% .016 293.756);</td><td><div style="border-inline-color: oklch(96.9% .016 293.756);"></div></td></tr>
    <tr><td>border-x-violet-100</td><td>border-inline-color: oklch(94.3% .029 294.588);</td><td><div style="border-inline-color: oklch(94.3% .029 294.588);"></div></td></tr>
    <tr><td>border-x-violet-200</td><td>border-inline-color: oklch(89.4% .057 293.283);</td><td><div style="border-inline-color: oklch(89.4% .057 293.283);"></div></td></tr>
    <tr><td>border-x-violet-300</td><td>border-inline-color: oklch(81.1% .111 293.571);</td><td><div style="border-inline-color: oklch(81.1% .111 293.571);"></div></td></tr>
    <tr><td>border-x-violet-400</td><td>border-inline-color: oklch(70.2% .183 293.541);</td><td><div style="border-inline-color: oklch(70.2% .183 293.541);"></div></td></tr>
    <tr><td>border-x-violet-500</td><td>border-inline-color: oklch(60.6% .25 292.717);</td><td><div style="border-inline-color: oklch(60.6% .25 292.717);"></div></td></tr>
    <tr><td>border-x-violet-600</td><td>border-inline-color: oklch(54.1% .281 293.009);</td><td><div style="border-inline-color: oklch(54.1% .281 293.009);"></div></td></tr>
    <tr><td>border-x-violet-700</td><td>border-inline-color: oklch(49.1% .27 292.581);</td><td><div style="border-inline-color: oklch(49.1% .27 292.581);"></div></td></tr>
    <tr><td>border-x-violet-800</td><td>border-inline-color: oklch(43.2% .232 292.759);</td><td><div style="border-inline-color: oklch(43.2% .232 292.759);"></div></td></tr>
    <tr><td>border-x-violet-900</td><td>border-inline-color: oklch(38% .189 293.745);</td><td><div style="border-inline-color: oklch(38% .189 293.745);"></div></td></tr>
    <tr><td>border-x-violet-950</td><td>border-inline-color: oklch(28.3% .141 291.089);</td><td><div style="border-inline-color: oklch(28.3% .141 291.089);"></div></td></tr>
    <tr><td>border-x-purple-50</td><td>border-inline-color: oklch(97.7% .014 308.299);</td><td><div style="border-inline-color: oklch(97.7% .014 308.299);"></div></td></tr>
    <tr><td>border-x-purple-100</td><td>border-inline-color: oklch(94.6% .033 307.174);</td><td><div style="border-inline-color: oklch(94.6% .033 307.174);"></div></td></tr>
    <tr><td>border-x-purple-200</td><td>border-inline-color: oklch(90.2% .063 306.703);</td><td><div style="border-inline-color: oklch(90.2% .063 306.703);"></div></td></tr>
    <tr><td>border-x-purple-300</td><td>border-inline-color: oklch(82.7% .119 306.383);</td><td><div style="border-inline-color: oklch(82.7% .119 306.383);"></div></td></tr>
    <tr><td>border-x-purple-400</td><td>border-inline-color: oklch(71.4% .203 305.504);</td><td><div style="border-inline-color: oklch(71.4% .203 305.504);"></div></td></tr>
    <tr><td>border-x-purple-500</td><td>border-inline-color: oklch(62.7% .265 303.9);</td><td><div style="border-inline-color: oklch(62.7% .265 303.9);"></div></td></tr>
    <tr><td>border-x-purple-600</td><td>border-inline-color: oklch(55.8% .288 302.321);</td><td><div style="border-inline-color: oklch(55.8% .288 302.321);"></div></td></tr>
    <tr><td>border-x-purple-700</td><td>border-inline-color: oklch(49.6% .265 301.924);</td><td><div style="border-inline-color: oklch(49.6% .265 301.924);"></div></td></tr>
    <tr><td>border-x-purple-800</td><td>border-inline-color: oklch(43.8% .218 303.724);</td><td><div style="border-inline-color: oklch(43.8% .218 303.724);"></div></td></tr>
    <tr><td>border-x-purple-900</td><td>border-inline-color: oklch(38.1% .176 304.987);</td><td><div style="border-inline-color: oklch(38.1% .176 304.987);"></div></td></tr>
    <tr><td>border-x-purple-950</td><td>border-inline-color: oklch(29.1% .149 302.717);</td><td><div style="border-inline-color: oklch(29.1% .149 302.717);"></div></td></tr>
    <tr><td>border-x-fuchsia-50</td><td>border-inline-color: oklch(97.7% .017 320.058);</td><td><div style="border-inline-color: oklch(97.7% .017 320.058);"></div></td></tr>
    <tr><td>border-x-fuchsia-100</td><td>border-inline-color: oklch(95.2% .037 318.852);</td><td><div style="border-inline-color: oklch(95.2% .037 318.852);"></div></td></tr>
    <tr><td>border-x-fuchsia-200</td><td>border-inline-color: oklch(90.3% .076 319.62);</td><td><div style="border-inline-color: oklch(90.3% .076 319.62);"></div></td></tr>
    <tr><td>border-x-fuchsia-300</td><td>border-inline-color: oklch(83.3% .145 321.434);</td><td><div style="border-inline-color: oklch(83.3% .145 321.434);"></div></td></tr>
    <tr><td>border-x-fuchsia-400</td><td>border-inline-color: oklch(74% .238 322.16);</td><td><div style="border-inline-color: oklch(74% .238 322.16);"></div></td></tr>
    <tr><td>border-x-fuchsia-500</td><td>border-inline-color: oklch(66.7% .295 322.15);</td><td><div style="border-inline-color: oklch(66.7% .295 322.15);"></div></td></tr>
    <tr><td>border-x-fuchsia-600</td><td>border-inline-color: oklch(59.1% .293 322.896);</td><td><div style="border-inline-color: oklch(59.1% .293 322.896);"></div></td></tr>
    <tr><td>border-x-fuchsia-700</td><td>border-inline-color: oklch(51.8% .253 323.949);</td><td><div style="border-inline-color: oklch(51.8% .253 323.949);"></div></td></tr>
    <tr><td>border-x-fuchsia-800</td><td>border-inline-color: oklch(45.2% .211 324.591);</td><td><div style="border-inline-color: oklch(45.2% .211 324.591);"></div></td></tr>
    <tr><td>border-x-fuchsia-900</td><td>border-inline-color: oklch(40.1% .17 325.612);</td><td><div style="border-inline-color: oklch(40.1% .17 325.612);"></div></td></tr>
    <tr><td>border-x-fuchsia-950</td><td>border-inline-color: oklch(29.3% .136 325.661);</td><td><div style="border-inline-color: oklch(29.3% .136 325.661);"></div></td></tr>
    <tr><td>border-x-pink-50</td><td>border-inline-color: oklch(97.1% .014 343.198);</td><td><div style="border-inline-color: oklch(97.1% .014 343.198);"></div></td></tr>
    <tr><td>border-x-pink-100</td><td>border-inline-color: oklch(94.8% .028 342.258);</td><td><div style="border-inline-color: oklch(94.8% .028 342.258);"></div></td></tr>
    <tr><td>border-x-pink-200</td><td>border-inline-color: oklch(89.9% .061 343.231);</td><td><div style="border-inline-color: oklch(89.9% .061 343.231);"></div></td></tr>
    <tr><td>border-x-pink-300</td><td>border-inline-color: oklch(82.3% .12 346.018);</td><td><div style="border-inline-color: oklch(82.3% .12 346.018);"></div></td></tr>
    <tr><td>border-x-pink-400</td><td>border-inline-color: oklch(71.8% .202 349.761);</td><td><div style="border-inline-color: oklch(71.8% .202 349.761);"></div></td></tr>
    <tr><td>border-x-pink-500</td><td>border-inline-color: oklch(65.6% .241 354.308);</td><td><div style="border-inline-color: oklch(65.6% .241 354.308);"></div></td></tr>
    <tr><td>border-x-pink-600</td><td>border-inline-color: oklch(59.2% .249 .584);</td><td><div style="border-inline-color: oklch(59.2% .249 .584);"></div></td></tr>
    <tr><td>border-x-pink-700</td><td>border-inline-color: oklch(52.5% .223 3.958);</td><td><div style="border-inline-color: oklch(52.5% .223 3.958);"></div></td></tr>
    <tr><td>border-x-pink-800</td><td>border-inline-color: oklch(45.9% .187 3.815);</td><td><div style="border-inline-color: oklch(45.9% .187 3.815);"></div></td></tr>
    <tr><td>border-x-pink-900</td><td>border-inline-color: oklch(40.8% .153 2.432);</td><td><div style="border-inline-color: oklch(40.8% .153 2.432);"></div></td></tr>
    <tr><td>border-x-pink-950</td><td>border-inline-color: oklch(28.4% .109 3.907);</td><td><div style="border-inline-color: oklch(28.4% .109 3.907);"></div></td></tr>
    <tr><td>border-x-rose-50</td><td>border-inline-color: oklch(96.9% .015 12.422);</td><td><div style="border-inline-color: oklch(96.9% .015 12.422);"></div></td></tr>
    <tr><td>border-x-rose-100</td><td>border-inline-color: oklch(94.1% .03 12.58);</td><td><div style="border-inline-color: oklch(94.1% .03 12.58);"></div></td></tr>
    <tr><td>border-x-rose-200</td><td>border-inline-color: oklch(89.2% .058 10.001);</td><td><div style="border-inline-color: oklch(89.2% .058 10.001);"></div></td></tr>
    <tr><td>border-x-rose-300</td><td>border-inline-color: oklch(81% .117 11.638);</td><td><div style="border-inline-color: oklch(81% .117 11.638);"></div></td></tr>
    <tr><td>border-x-rose-400</td><td>border-inline-color: oklch(71.2% .194 13.428);</td><td><div style="border-inline-color: oklch(71.2% .194 13.428);"></div></td></tr>
    <tr><td>border-x-rose-500</td><td>border-inline-color: oklch(64.5% .246 16.439);</td><td><div style="border-inline-color: oklch(64.5% .246 16.439);"></div></td></tr>
    <tr><td>border-x-rose-600</td><td>border-inline-color: oklch(58.6% .253 17.585);</td><td><div style="border-inline-color: oklch(58.6% .253 17.585);"></div></td></tr>
    <tr><td>border-x-rose-700</td><td>border-inline-color: oklch(51.4% .222 16.935);</td><td><div style="border-inline-color: oklch(51.4% .222 16.935);"></div></td></tr>
    <tr><td>border-x-rose-800</td><td>border-inline-color: oklch(45.5% .188 13.697);</td><td><div style="border-inline-color: oklch(45.5% .188 13.697);"></div></td></tr>
    <tr><td>border-x-rose-900</td><td>border-inline-color: oklch(41% .159 10.272);</td><td><div style="border-inline-color: oklch(41% .159 10.272);"></div></td></tr>
    <tr><td>border-x-rose-950</td><td>border-inline-color: oklch(27.1% .105 12.094);</td><td><div style="border-inline-color: oklch(27.1% .105 12.094);"></div></td></tr>
    <tr><td>border-x-slate-50</td><td>border-inline-color: oklch(98.4% .003 247.858);</td><td><div style="border-inline-color: oklch(98.4% .003 247.858);"></div></td></tr>
    <tr><td>border-x-slate-100</td><td>border-inline-color: oklch(96.8% .007 247.896);</td><td><div style="border-inline-color: oklch(96.8% .007 247.896);"></div></td></tr>
    <tr><td>border-x-slate-200</td><td>border-inline-color: oklch(92.9% .013 255.508);</td><td><div style="border-inline-color: oklch(92.9% .013 255.508);"></div></td></tr>
    <tr><td>border-x-slate-300</td><td>border-inline-color: oklch(86.9% .022 252.894);</td><td><div style="border-inline-color: oklch(86.9% .022 252.894);"></div></td></tr>
    <tr><td>border-x-slate-400</td><td>border-inline-color: oklch(70.4% .04 256.788);</td><td><div style="border-inline-color: oklch(70.4% .04 256.788);"></div></td></tr>
    <tr><td>border-x-slate-500</td><td>border-inline-color: oklch(55.4% .046 257.417);</td><td><div style="border-inline-color: oklch(55.4% .046 257.417);"></div></td></tr>
    <tr><td>border-x-slate-600</td><td>border-inline-color: oklch(44.6% .043 257.281);</td><td><div style="border-inline-color: oklch(44.6% .043 257.281);"></div></td></tr>
    <tr><td>border-x-slate-700</td><td>border-inline-color: oklch(37.2% .044 257.287);</td><td><div style="border-inline-color: oklch(37.2% .044 257.287);"></div></td></tr>
    <tr><td>border-x-slate-800</td><td>border-inline-color: oklch(27.9% .041 260.031);</td><td><div style="border-inline-color: oklch(27.9% .041 260.031);"></div></td></tr>
    <tr><td>border-x-slate-900</td><td>border-inline-color: oklch(20.8% .042 265.755);</td><td><div style="border-inline-color: oklch(20.8% .042 265.755);"></div></td></tr>
    <tr><td>border-x-slate-950</td><td>border-inline-color: oklch(12.9% .042 264.695);</td><td><div style="border-inline-color: oklch(12.9% .042 264.695);"></div></td></tr>
    <tr><td>border-x-gray-50</td><td>border-inline-color: oklch(98.5% .002 247.839);</td><td><div style="border-inline-color: oklch(98.5% .002 247.839);"></div></td></tr>
    <tr><td>border-x-gray-100</td><td>border-inline-color: oklch(96.7% .003 264.542);</td><td><div style="border-inline-color: oklch(96.7% .003 264.542);"></div></td></tr>
    <tr><td>border-x-gray-200</td><td>border-inline-color: oklch(92.8% .006 264.531);</td><td><div style="border-inline-color: oklch(92.8% .006 264.531);"></div></td></tr>
    <tr><td>border-x-gray-300</td><td>border-inline-color: oklch(87.2% .01 258.338);</td><td><div style="border-inline-color: oklch(87.2% .01 258.338);"></div></td></tr>
    <tr><td>border-x-gray-400</td><td>border-inline-color: oklch(70.7% .022 261.325);</td><td><div style="border-inline-color: oklch(70.7% .022 261.325);"></div></td></tr>
    <tr><td>border-x-gray-500</td><td>border-inline-color: oklch(55.1% .027 264.364);</td><td><div style="border-inline-color: oklch(55.1% .027 264.364);"></div></td></tr>
    <tr><td>border-x-gray-600</td><td>border-inline-color: oklch(44.6% .03 256.802);</td><td><div style="border-inline-color: oklch(44.6% .03 256.802);"></div></td></tr>
    <tr><td>border-x-gray-700</td><td>border-inline-color: oklch(37.3% .034 259.733);</td><td><div style="border-inline-color: oklch(37.3% .034 259.733);"></div></td></tr>
    <tr><td>border-x-gray-800</td><td>border-inline-color: oklch(27.8% .033 256.848);</td><td><div style="border-inline-color: oklch(27.8% .033 256.848);"></div></td></tr>
    <tr><td>border-x-gray-900</td><td>border-inline-color: oklch(21% .034 264.665);</td><td><div style="border-inline-color: oklch(21% .034 264.665);"></div></td></tr>
    <tr><td>border-x-gray-950</td><td>border-inline-color: oklch(13% .028 261.692);</td><td><div style="border-inline-color: oklch(13% .028 261.692);"></div></td></tr>
    <tr><td>border-x-zinc-50</td><td>border-inline-color: oklch(98.5% 0 0);</td><td><div style="border-inline-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-x-zinc-100</td><td>border-inline-color: oklch(96.7% .001 286.375);</td><td><div style="border-inline-color: oklch(96.7% .001 286.375);"></div></td></tr>
    <tr><td>border-x-zinc-200</td><td>border-inline-color: oklch(92% .004 286.32);</td><td><div style="border-inline-color: oklch(92% .004 286.32);"></div></td></tr>
    <tr><td>border-x-zinc-300</td><td>border-inline-color: oklch(87.1% .006 286.286);</td><td><div style="border-inline-color: oklch(87.1% .006 286.286);"></div></td></tr>
    <tr><td>border-x-zinc-400</td><td>border-inline-color: oklch(70.5% .015 286.067);</td><td><div style="border-inline-color: oklch(70.5% .015 286.067);"></div></td></tr>
    <tr><td>border-x-zinc-500</td><td>border-inline-color: oklch(55.2% .016 285.938);</td><td><div style="border-inline-color: oklch(55.2% .016 285.938);"></div></td></tr>
    <tr><td>border-x-zinc-600</td><td>border-inline-color: oklch(44.2% .017 285.786);</td><td><div style="border-inline-color: oklch(44.2% .017 285.786);"></div></td></tr>
    <tr><td>border-x-zinc-700</td><td>border-inline-color: oklch(37% .013 285.805);</td><td><div style="border-inline-color: oklch(37% .013 285.805);"></div></td></tr>
    <tr><td>border-x-zinc-800</td><td>border-inline-color: oklch(27.4% .006 286.033);</td><td><div style="border-inline-color: oklch(27.4% .006 286.033);"></div></td></tr>
    <tr><td>border-x-zinc-900</td><td>border-inline-color: oklch(21% .006 285.885);</td><td><div style="border-inline-color: oklch(21% .006 285.885);"></div></td></tr>
    <tr><td>border-x-zinc-950</td><td>border-inline-color: oklch(14.1% .005 285.823);</td><td><div style="border-inline-color: oklch(14.1% .005 285.823);"></div></td></tr>
    <tr><td>border-x-neutral-50</td><td>border-inline-color: oklch(98.5% 0 0);</td><td><div style="border-inline-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-100</td><td>border-inline-color: oklch(97% 0 0);</td><td><div style="border-inline-color: oklch(97% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-200</td><td>border-inline-color: oklch(92.2% 0 0);</td><td><div style="border-inline-color: oklch(92.2% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-300</td><td>border-inline-color: oklch(87% 0 0);</td><td><div style="border-inline-color: oklch(87% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-400</td><td>border-inline-color: oklch(70.8% 0 0);</td><td><div style="border-inline-color: oklch(70.8% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-500</td><td>border-inline-color: oklch(55.6% 0 0);</td><td><div style="border-inline-color: oklch(55.6% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-600</td><td>border-inline-color: oklch(43.9% 0 0);</td><td><div style="border-inline-color: oklch(43.9% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-700</td><td>border-inline-color: oklch(37.1% 0 0);</td><td><div style="border-inline-color: oklch(37.1% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-800</td><td>border-inline-color: oklch(26.9% 0 0);</td><td><div style="border-inline-color: oklch(26.9% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-900</td><td>border-inline-color: oklch(20.5% 0 0);</td><td><div style="border-inline-color: oklch(20.5% 0 0);"></div></td></tr>
    <tr><td>border-x-neutral-950</td><td>border-inline-color: oklch(14.5% 0 0);</td><td><div style="border-inline-color: oklch(14.5% 0 0);"></div></td></tr>
    <tr><td>border-x-stone-50</td><td>border-inline-color: oklch(98.5% .001 106.423);</td><td><div style="border-inline-color: oklch(98.5% .001 106.423);"></div></td></tr>
    <tr><td>border-x-stone-100</td><td>border-inline-color: oklch(97% .001 106.424);</td><td><div style="border-inline-color: oklch(97% .001 106.424);"></div></td></tr>
    <tr><td>border-x-stone-200</td><td>border-inline-color: oklch(92.3% .003 48.717);</td><td><div style="border-inline-color: oklch(92.3% .003 48.717);"></div></td></tr>
    <tr><td>border-x-stone-300</td><td>border-inline-color: oklch(86.9% .005 56.366);</td><td><div style="border-inline-color: oklch(86.9% .005 56.366);"></div></td></tr>
    <tr><td>border-x-stone-400</td><td>border-inline-color: oklch(70.9% .01 56.259);</td><td><div style="border-inline-color: oklch(70.9% .01 56.259);"></div></td></tr>
    <tr><td>border-x-stone-500</td><td>border-inline-color: oklch(55.3% .013 58.071);</td><td><div style="border-inline-color: oklch(55.3% .013 58.071);"></div></td></tr>
    <tr><td>border-x-stone-600</td><td>border-inline-color: oklch(44.4% .011 73.639);</td><td><div style="border-inline-color: oklch(44.4% .011 73.639);"></div></td></tr>
    <tr><td>border-x-stone-700</td><td>border-inline-color: oklch(37.4% .01 67.558);</td><td><div style="border-inline-color: oklch(37.4% .01 67.558);"></div></td></tr>
    <tr><td>border-x-stone-800</td><td>border-inline-color: oklch(26.8% .007 34.298);</td><td><div style="border-inline-color: oklch(26.8% .007 34.298);"></div></td></tr>
    <tr><td>border-x-stone-900</td><td>border-inline-color: oklch(21.6% .006 56.043);</td><td><div style="border-inline-color: oklch(21.6% .006 56.043);"></div></td></tr>
    <tr><td>border-x-stone-950</td><td>border-inline-color: oklch(14.7% .004 49.25);</td><td><div style="border-inline-color: oklch(14.7% .004 49.25);"></div></td></tr>
    <tr><td>border-x-black</td><td>border-inline-color: #000;</td><td><div style="border-inline-color: #000;"></div></td></tr>
    <tr><td>border-x-white</td><td>border-inline-color: #fff;</td><td><div style="border-inline-color: #fff;"></div></td></tr>
    <tr><td>border-y-inherit</td><td>border-block-color: inherit;</td><td><div style="border-block-color: inherit;"></div></td></tr>
    <tr><td>border-y-current</td><td>border-block-color: currentColor;</td><td><div style="border-block-color: currentColor;"></div></td></tr>
    <tr><td>border-y-transparent</td><td>border-block-color: transparent;</td><td><div style="border-block-color: transparent;"></div></td></tr>
    <tr><td>border-y-red-50</td><td>border-block-color: oklch(97.1% .013 17.38);</td><td><div style="border-block-color: oklch(97.1% .013 17.38);"></div></td></tr>
    <tr><td>border-y-red-100</td><td>border-block-color: oklch(93.6% .032 17.717);</td><td><div style="border-block-color: oklch(93.6% .032 17.717);"></div></td></tr>
    <tr><td>border-y-red-200</td><td>border-block-color: oklch(88.5% .062 18.334);</td><td><div style="border-block-color: oklch(88.5% .062 18.334);"></div></td></tr>
    <tr><td>border-y-red-300</td><td>border-block-color: oklch(80.8% .114 19.571);</td><td><div style="border-block-color: oklch(80.8% .114 19.571);"></div></td></tr>
    <tr><td>border-y-red-400</td><td>border-block-color: oklch(70.4% .191 22.216);</td><td><div style="border-block-color: oklch(70.4% .191 22.216);"></div></td></tr>
    <tr><td>border-y-red-500</td><td>border-block-color: oklch(63.7% .237 25.331);</td><td><div style="border-block-color: oklch(63.7% .237 25.331);"></div></td></tr>
    <tr><td>border-y-red-600</td><td>border-block-color: oklch(57.7% .245 27.325);</td><td><div style="border-block-color: oklch(57.7% .245 27.325);"></div></td></tr>
    <tr><td>border-y-red-700</td><td>border-block-color: oklch(50.5% .213 27.518);</td><td><div style="border-block-color: oklch(50.5% .213 27.518);"></div></td></tr>
    <tr><td>border-y-red-800</td><td>border-block-color: oklch(44.4% .177 26.899);</td><td><div style="border-block-color: oklch(44.4% .177 26.899);"></div></td></tr>
    <tr><td>border-y-red-900</td><td>border-block-color: oklch(39.6% .141 25.723);</td><td><div style="border-block-color: oklch(39.6% .141 25.723);"></div></td></tr>
    <tr><td>border-y-red-950</td><td>border-block-color: oklch(25.8% .092 26.042);</td><td><div style="border-block-color: oklch(25.8% .092 26.042);"></div></td></tr>
    <tr><td>border-y-orange-50</td><td>border-block-color: oklch(98% .016 73.684);</td><td><div style="border-block-color: oklch(98% .016 73.684);"></div></td></tr>
    <tr><td>border-y-orange-100</td><td>border-block-color: oklch(95.4% .038 75.164);</td><td><div style="border-block-color: oklch(95.4% .038 75.164);"></div></td></tr>
    <tr><td>border-y-orange-200</td><td>border-block-color: oklch(90.1% .076 70.697);</td><td><div style="border-block-color: oklch(90.1% .076 70.697);"></div></td></tr>
    <tr><td>border-y-orange-300</td><td>border-block-color: oklch(83.7% .128 66.29);</td><td><div style="border-block-color: oklch(83.7% .128 66.29);"></div></td></tr>
    <tr><td>border-y-orange-400</td><td>border-block-color: oklch(75% .183 55.934);</td><td><div style="border-block-color: oklch(75% .183 55.934);"></div></td></tr>
    <tr><td>border-y-orange-500</td><td>border-block-color: oklch(70.5% .213 47.604);</td><td><div style="border-block-color: oklch(70.5% .213 47.604);"></div></td></tr>
    <tr><td>border-y-orange-600</td><td>border-block-color: oklch(64.6% .222 41.116);</td><td><div style="border-block-color: oklch(64.6% .222 41.116);"></div></td></tr>
    <tr><td>border-y-orange-700</td><td>border-block-color: oklch(55.3% .195 38.402);</td><td><div style="border-block-color: oklch(55.3% .195 38.402);"></div></td></tr>
    <tr><td>border-y-orange-800</td><td>border-block-color: oklch(47% .157 37.304);</td><td><div style="border-block-color: oklch(47% .157 37.304);"></div></td></tr>
    <tr><td>border-y-orange-900</td><td>border-block-color: oklch(40.8% .123 38.172);</td><td><div style="border-block-color: oklch(40.8% .123 38.172);"></div></td></tr>
    <tr><td>border-y-orange-950</td><td>border-block-color: oklch(26.6% .079 36.259);</td><td><div style="border-block-color: oklch(26.6% .079 36.259);"></div></td></tr>
    <tr><td>border-y-amber-50</td><td>border-block-color: oklch(98.7% .022 95.277);</td><td><div style="border-block-color: oklch(98.7% .022 95.277);"></div></td></tr>
    <tr><td>border-y-amber-100</td><td>border-block-color: oklch(96.2% .059 95.617);</td><td><div style="border-block-color: oklch(96.2% .059 95.617);"></div></td></tr>
    <tr><td>border-y-amber-200</td><td>border-block-color: oklch(92.4% .12 95.746);</td><td><div style="border-block-color: oklch(92.4% .12 95.746);"></div></td></tr>
    <tr><td>border-y-amber-300</td><td>border-block-color: oklch(87.9% .169 91.605);</td><td><div style="border-block-color: oklch(87.9% .169 91.605);"></div></td></tr>
    <tr><td>border-y-amber-400</td><td>border-block-color: oklch(82.8% .189 84.429);</td><td><div style="border-block-color: oklch(82.8% .189 84.429);"></div></td></tr>
    <tr><td>border-y-amber-500</td><td>border-block-color: oklch(76.9% .188 70.08);</td><td><div style="border-block-color: oklch(76.9% .188 70.08);"></div></td></tr>
    <tr><td>border-y-amber-600</td><td>border-block-color: oklch(66.6% .179 58.318);</td><td><div style="border-block-color: oklch(66.6% .179 58.318);"></div></td></tr>
    <tr><td>border-y-amber-700</td><td>border-block-color: oklch(55.5% .163 48.998);</td><td><div style="border-block-color: oklch(55.5% .163 48.998);"></div></td></tr>
    <tr><td>border-y-amber-800</td><td>border-block-color: oklch(47.3% .137 46.201);</td><td><div style="border-block-color: oklch(47.3% .137 46.201);"></div></td></tr>
    <tr><td>border-y-amber-900</td><td>border-block-color: oklch(41.4% .112 45.904);</td><td><div style="border-block-color: oklch(41.4% .112 45.904);"></div></td></tr>
    <tr><td>border-y-amber-950</td><td>border-block-color: oklch(27.9% .077 45.635);</td><td><div style="border-block-color: oklch(27.9% .077 45.635);"></div></td></tr>
    <tr><td>border-y-yellow-50</td><td>border-block-color: oklch(98.7% .026 102.212);</td><td><div style="border-block-color: oklch(98.7% .026 102.212);"></div></td></tr>
    <tr><td>border-y-yellow-100</td><td>border-block-color: oklch(97.3% .071 103.193);</td><td><div style="border-block-color: oklch(97.3% .071 103.193);"></div></td></tr>
    <tr><td>border-y-yellow-200</td><td>border-block-color: oklch(94.5% .129 101.54);</td><td><div style="border-block-color: oklch(94.5% .129 101.54);"></div></td></tr>
    <tr><td>border-y-yellow-300</td><td>border-block-color: oklch(90.5% .182 98.111);</td><td><div style="border-block-color: oklch(90.5% .182 98.111);"></div></td></tr>
    <tr><td>border-y-yellow-400</td><td>border-block-color: oklch(85.2% .199 91.936);</td><td><div style="border-block-color: oklch(85.2% .199 91.936);"></div></td></tr>
    <tr><td>border-y-yellow-500</td><td>border-block-color: oklch(79.5% .184 86.047);</td><td><div style="border-block-color: oklch(79.5% .184 86.047);"></div></td></tr>
    <tr><td>border-y-yellow-600</td><td>border-block-color: oklch(68.1% .162 75.834);</td><td><div style="border-block-color: oklch(68.1% .162 75.834);"></div></td></tr>
    <tr><td>border-y-yellow-700</td><td>border-block-color: oklch(55.4% .135 66.442);</td><td><div style="border-block-color: oklch(55.4% .135 66.442);"></div></td></tr>
    <tr><td>border-y-yellow-800</td><td>border-block-color: oklch(47.6% .114 61.907);</td><td><div style="border-block-color: oklch(47.6% .114 61.907);"></div></td></tr>
    <tr><td>border-y-yellow-900</td><td>border-block-color: oklch(42.1% .095 57.708);</td><td><div style="border-block-color: oklch(42.1% .095 57.708);"></div></td></tr>
    <tr><td>border-y-yellow-950</td><td>border-block-color: oklch(28.6% .066 53.813);</td><td><div style="border-block-color: oklch(28.6% .066 53.813);"></div></td></tr>
    <tr><td>border-y-lime-50</td><td>border-block-color: oklch(98.6% .031 120.757);</td><td><div style="border-block-color: oklch(98.6% .031 120.757);"></div></td></tr>
    <tr><td>border-y-lime-100</td><td>border-block-color: oklch(96.7% .067 122.328);</td><td><div style="border-block-color: oklch(96.7% .067 122.328);"></div></td></tr>
    <tr><td>border-y-lime-200</td><td>border-block-color: oklch(93.8% .127 124.321);</td><td><div style="border-block-color: oklch(93.8% .127 124.321);"></div></td></tr>
    <tr><td>border-y-lime-300</td><td>border-block-color: oklch(89.7% .196 126.665);</td><td><div style="border-block-color: oklch(89.7% .196 126.665);"></div></td></tr>
    <tr><td>border-y-lime-400</td><td>border-block-color: oklch(84.1% .238 128.85);</td><td><div style="border-block-color: oklch(84.1% .238 128.85);"></div></td></tr>
    <tr><td>border-y-lime-500</td><td>border-block-color: oklch(76.8% .233 130.85);</td><td><div style="border-block-color: oklch(76.8% .233 130.85);"></div></td></tr>
    <tr><td>border-y-lime-600</td><td>border-block-color: oklch(64.8% .2 131.684);</td><td><div style="border-block-color: oklch(64.8% .2 131.684);"></div></td></tr>
    <tr><td>border-y-lime-700</td><td>border-block-color: oklch(53.2% .157 131.589);</td><td><div style="border-block-color: oklch(53.2% .157 131.589);"></div></td></tr>
    <tr><td>border-y-lime-800</td><td>border-block-color: oklch(45.3% .124 130.933);</td><td><div style="border-block-color: oklch(45.3% .124 130.933);"></div></td></tr>
    <tr><td>border-y-lime-900</td><td>border-block-color: oklch(40.5% .101 131.063);</td><td><div style="border-block-color: oklch(40.5% .101 131.063);"></div></td></tr>
    <tr><td>border-y-lime-950</td><td>border-block-color: oklch(27.4% .072 132.109);</td><td><div style="border-block-color: oklch(27.4% .072 132.109);"></div></td></tr>
    <tr><td>border-y-green-50</td><td>border-block-color: oklch(98.2% .018 155.826);</td><td><div style="border-block-color: oklch(98.2% .018 155.826);"></div></td></tr>
    <tr><td>border-y-green-100</td><td>border-block-color: oklch(96.2% .044 156.743);</td><td><div style="border-block-color: oklch(96.2% .044 156.743);"></div></td></tr>
    <tr><td>border-y-green-200</td><td>border-block-color: oklch(92.5% .084 155.995);</td><td><div style="border-block-color: oklch(92.5% .084 155.995);"></div></td></tr>
    <tr><td>border-y-green-300</td><td>border-block-color: oklch(87.1% .15 154.449);</td><td><div style="border-block-color: oklch(87.1% .15 154.449);"></div></td></tr>
    <tr><td>border-y-green-400</td><td>border-block-color: oklch(79.2% .209 151.711);</td><td><div style="border-block-color: oklch(79.2% .209 151.711);"></div></td></tr>
    <tr><td>border-y-green-500</td><td>border-block-color: oklch(72.3% .219 149.579);</td><td><div style="border-block-color: oklch(72.3% .219 149.579);"></div></td></tr>
    <tr><td>border-y-green-600</td><td>border-block-color: oklch(62.7% .194 149.214);</td><td><div style="border-block-color: oklch(62.7% .194 149.214);"></div></td></tr>
    <tr><td>border-y-green-700</td><td>border-block-color: oklch(52.7% .154 150.069);</td><td><div style="border-block-color: oklch(52.7% .154 150.069);"></div></td></tr>
    <tr><td>border-y-green-800</td><td>border-block-color: oklch(44.8% .119 151.328);</td><td><div style="border-block-color: oklch(44.8% .119 151.328);"></div></td></tr>
    <tr><td>border-y-green-900</td><td>border-block-color: oklch(39.3% .095 152.535);</td><td><div style="border-block-color: oklch(39.3% .095 152.535);"></div></td></tr>
    <tr><td>border-y-green-950</td><td>border-block-color: oklch(26.6% .065 152.934);</td><td><div style="border-block-color: oklch(26.6% .065 152.934);"></div></td></tr>
    <tr><td>border-y-emerald-50</td><td>border-block-color: oklch(97.9% .021 166.113);</td><td><div style="border-block-color: oklch(97.9% .021 166.113);"></div></td></tr>
    <tr><td>border-y-emerald-100</td><td>border-block-color: oklch(95% .052 163.051);</td><td><div style="border-block-color: oklch(95% .052 163.051);"></div></td></tr>
    <tr><td>border-y-emerald-200</td><td>border-block-color: oklch(90.5% .093 164.15);</td><td><div style="border-block-color: oklch(90.5% .093 164.15);"></div></td></tr>
    <tr><td>border-y-emerald-300</td><td>border-block-color: oklch(84.5% .143 164.978);</td><td><div style="border-block-color: oklch(84.5% .143 164.978);"></div></td></tr>
    <tr><td>border-y-emerald-400</td><td>border-block-color: oklch(76.5% .177 163.223);</td><td><div style="border-block-color: oklch(76.5% .177 163.223);"></div></td></tr>
    <tr><td>border-y-emerald-500</td><td>border-block-color: oklch(69.6% .17 162.48);</td><td><div style="border-block-color: oklch(69.6% .17 162.48);"></div></td></tr>
    <tr><td>border-y-emerald-600</td><td>border-block-color: oklch(59.6% .145 163.225);</td><td><div style="border-block-color: oklch(59.6% .145 163.225);"></div></td></tr>
    <tr><td>border-y-emerald-700</td><td>border-block-color: oklch(50.8% .118 165.612);</td><td><div style="border-block-color: oklch(50.8% .118 165.612);"></div></td></tr>
    <tr><td>border-y-emerald-800</td><td>border-block-color: oklch(43.2% .095 166.913);</td><td><div style="border-block-color: oklch(43.2% .095 166.913);"></div></td></tr>
    <tr><td>border-y-emerald-900</td><td>border-block-color: oklch(37.8% .077 168.94);</td><td><div style="border-block-color: oklch(37.8% .077 168.94);"></div></td></tr>
    <tr><td>border-y-emerald-950</td><td>border-block-color: oklch(26.2% .051 172.552);</td><td><div style="border-block-color: oklch(26.2% .051 172.552);"></div></td></tr>
    <tr><td>border-y-teal-50</td><td>border-block-color: oklch(98.4% .014 180.72);</td><td><div style="border-block-color: oklch(98.4% .014 180.72);"></div></td></tr>
    <tr><td>border-y-teal-100</td><td>border-block-color: oklch(95.3% .051 180.801);</td><td><div style="border-block-color: oklch(95.3% .051 180.801);"></div></td></tr>
    <tr><td>border-y-teal-200</td><td>border-block-color: oklch(91% .096 180.426);</td><td><div style="border-block-color: oklch(91% .096 180.426);"></div></td></tr>
    <tr><td>border-y-teal-300</td><td>border-block-color: oklch(85.5% .138 181.071);</td><td><div style="border-block-color: oklch(85.5% .138 181.071);"></div></td></tr>
    <tr><td>border-y-teal-400</td><td>border-block-color: oklch(77.7% .152 181.912);</td><td><div style="border-block-color: oklch(77.7% .152 181.912);"></div></td></tr>
    <tr><td>border-y-teal-500</td><td>border-block-color: oklch(70.4% .14 182.503);</td><td><div style="border-block-color: oklch(70.4% .14 182.503);"></div></td></tr>
    <tr><td>border-y-teal-600</td><td>border-block-color: oklch(60% .118 184.704);</td><td><div style="border-block-color: oklch(60% .118 184.704);"></div></td></tr>
    <tr><td>border-y-teal-700</td><td>border-block-color: oklch(51.1% .096 186.391);</td><td><div style="border-block-color: oklch(51.1% .096 186.391);"></div></td></tr>
    <tr><td>border-y-teal-800</td><td>border-block-color: oklch(43.7% .078 188.216);</td><td><div style="border-block-color: oklch(43.7% .078 188.216);"></div></td></tr>
    <tr><td>border-y-teal-900</td><td>border-block-color: oklch(38.6% .063 188.416);</td><td><div style="border-block-color: oklch(38.6% .063 188.416);"></div></td></tr>
    <tr><td>border-y-teal-950</td><td>border-block-color: oklch(27.7% .046 192.524);</td><td><div style="border-block-color: oklch(27.7% .046 192.524);"></div></td></tr>
    <tr><td>border-y-cyan-50</td><td>border-block-color: oklch(98.4% .019 200.873);</td><td><div style="border-block-color: oklch(98.4% .019 200.873);"></div></td></tr>
    <tr><td>border-y-cyan-100</td><td>border-block-color: oklch(95.6% .045 203.388);</td><td><div style="border-block-color: oklch(95.6% .045 203.388);"></div></td></tr>
    <tr><td>border-y-cyan-200</td><td>border-block-color: oklch(91.7% .08 205.041);</td><td><div style="border-block-color: oklch(91.7% .08 205.041);"></div></td></tr>
    <tr><td>border-y-cyan-300</td><td>border-block-color: oklch(86.5% .127 207.078);</td><td><div style="border-block-color: oklch(86.5% .127 207.078);"></div></td></tr>
    <tr><td>border-y-cyan-400</td><td>border-block-color: oklch(78.9% .154 211.53);</td><td><div style="border-block-color: oklch(78.9% .154 211.53);"></div></td></tr>
    <tr><td>border-y-cyan-500</td><td>border-block-color: oklch(71.5% .143 215.221);</td><td><div style="border-block-color: oklch(71.5% .143 215.221);"></div></td></tr>
    <tr><td>border-y-cyan-600</td><td>border-block-color: oklch(60.9% .126 221.723);</td><td><div style="border-block-color: oklch(60.9% .126 221.723);"></div></td></tr>
    <tr><td>border-y-cyan-700</td><td>border-block-color: oklch(52% .105 223.128);</td><td><div style="border-block-color: oklch(52% .105 223.128);"></div></td></tr>
    <tr><td>border-y-cyan-800</td><td>border-block-color: oklch(45% .085 224.283);</td><td><div style="border-block-color: oklch(45% .085 224.283);"></div></td></tr>
    <tr><td>border-y-cyan-900</td><td>border-block-color: oklch(39.8% .07 227.392);</td><td><div style="border-block-color: oklch(39.8% .07 227.392);"></div></td></tr>
    <tr><td>border-y-cyan-950</td><td>border-block-color: oklch(30.2% .056 229.695);</td><td><div style="border-block-color: oklch(30.2% .056 229.695);"></div></td></tr>
    <tr><td>border-y-sky-50</td><td>border-block-color: oklch(97.7% .013 236.62);</td><td><div style="border-block-color: oklch(97.7% .013 236.62);"></div></td></tr>
    <tr><td>border-y-sky-100</td><td>border-block-color: oklch(95.1% .026 236.824);</td><td><div style="border-block-color: oklch(95.1% .026 236.824);"></div></td></tr>
    <tr><td>border-y-sky-200</td><td>border-block-color: oklch(90.1% .058 230.902);</td><td><div style="border-block-color: oklch(90.1% .058 230.902);"></div></td></tr>
    <tr><td>border-y-sky-300</td><td>border-block-color: oklch(82.8% .111 230.318);</td><td><div style="border-block-color: oklch(82.8% .111 230.318);"></div></td></tr>
    <tr><td>border-y-sky-400</td><td>border-block-color: oklch(74.6% .16 232.661);</td><td><div style="border-block-color: oklch(74.6% .16 232.661);"></div></td></tr>
    <tr><td>border-y-sky-500</td><td>border-block-color: oklch(68.5% .169 237.323);</td><td><div style="border-block-color: oklch(68.5% .169 237.323);"></div></td></tr>
    <tr><td>border-y-sky-600</td><td>border-block-color: oklch(58.8% .158 241.966);</td><td><div style="border-block-color: oklch(58.8% .158 241.966);"></div></td></tr>
    <tr><td>border-y-sky-700</td><td>border-block-color: oklch(50% .134 242.749);</td><td><div style="border-block-color: oklch(50% .134 242.749);"></div></td></tr>
    <tr><td>border-y-sky-800</td><td>border-block-color: oklch(44.3% .11 240.79);</td><td><div style="border-block-color: oklch(44.3% .11 240.79);"></div></td></tr>
    <tr><td>border-y-sky-900</td><td>border-block-color: oklch(39.1% .09 240.876);</td><td><div style="border-block-color: oklch(39.1% .09 240.876);"></div></td></tr>
    <tr><td>border-y-sky-950</td><td>border-block-color: oklch(29.3% .066 243.157);</td><td><div style="border-block-color: oklch(29.3% .066 243.157);"></div></td></tr>
    <tr><td>border-y-blue-50</td><td>border-block-color: oklch(97% .014 254.604);</td><td><div style="border-block-color: oklch(97% .014 254.604);"></div></td></tr>
    <tr><td>border-y-blue-100</td><td>border-block-color: oklch(93.2% .032 255.585);</td><td><div style="border-block-color: oklch(93.2% .032 255.585);"></div></td></tr>
    <tr><td>border-y-blue-200</td><td>border-block-color: oklch(88.2% .059 254.128);</td><td><div style="border-block-color: oklch(88.2% .059 254.128);"></div></td></tr>
    <tr><td>border-y-blue-300</td><td>border-block-color: oklch(80.9% .105 251.813);</td><td><div style="border-block-color: oklch(80.9% .105 251.813);"></div></td></tr>
    <tr><td>border-y-blue-400</td><td>border-block-color: oklch(70.7% .165 254.624);</td><td><div style="border-block-color: oklch(70.7% .165 254.624);"></div></td></tr>
    <tr><td>border-y-blue-500</td><td>border-block-color: oklch(62.3% .214 259.815);</td><td><div style="border-block-color: oklch(62.3% .214 259.815);"></div></td></tr>
    <tr><td>border-y-blue-600</td><td>border-block-color: oklch(54.6% .245 262.881);</td><td><div style="border-block-color: oklch(54.6% .245 262.881);"></div></td></tr>
    <tr><td>border-y-blue-700</td><td>border-block-color: oklch(48.8% .243 264.376);</td><td><div style="border-block-color: oklch(48.8% .243 264.376);"></div></td></tr>
    <tr><td>border-y-blue-800</td><td>border-block-color: oklch(42.4% .199 265.638);</td><td><div style="border-block-color: oklch(42.4% .199 265.638);"></div></td></tr>
    <tr><td>border-y-blue-900</td><td>border-block-color: oklch(37.9% .146 265.522);</td><td><div style="border-block-color: oklch(37.9% .146 265.522);"></div></td></tr>
    <tr><td>border-y-blue-950</td><td>border-block-color: oklch(28.2% .091 267.935);</td><td><div style="border-block-color: oklch(28.2% .091 267.935);"></div></td></tr>
    <tr><td>border-y-indigo-50</td><td>border-block-color: oklch(96.2% .018 272.314);</td><td><div style="border-block-color: oklch(96.2% .018 272.314);"></div></td></tr>
    <tr><td>border-y-indigo-100</td><td>border-block-color: oklch(93% .034 272.788);</td><td><div style="border-block-color: oklch(93% .034 272.788);"></div></td></tr>
    <tr><td>border-y-indigo-200</td><td>border-block-color: oklch(87% .065 274.039);</td><td><div style="border-block-color: oklch(87% .065 274.039);"></div></td></tr>
    <tr><td>border-y-indigo-300</td><td>border-block-color: oklch(78.5% .115 274.713);</td><td><div style="border-block-color: oklch(78.5% .115 274.713);"></div></td></tr>
    <tr><td>border-y-indigo-400</td><td>border-block-color: oklch(67.3% .182 276.935);</td><td><div style="border-block-color: oklch(67.3% .182 276.935);"></div></td></tr>
    <tr><td>border-y-indigo-500</td><td>border-block-color: oklch(58.5% .233 277.117);</td><td><div style="border-block-color: oklch(58.5% .233 277.117);"></div></td></tr>
    <tr><td>border-y-indigo-600</td><td>border-block-color: oklch(51.1% .262 276.966);</td><td><div style="border-block-color: oklch(51.1% .262 276.966);"></div></td></tr>
    <tr><td>border-y-indigo-700</td><td>border-block-color: oklch(45.7% .24 277.023);</td><td><div style="border-block-color: oklch(45.7% .24 277.023);"></div></td></tr>
    <tr><td>border-y-indigo-800</td><td>border-block-color: oklch(39.8% .195 277.366);</td><td><div style="border-block-color: oklch(39.8% .195 277.366);"></div></td></tr>
    <tr><td>border-y-indigo-900</td><td>border-block-color: oklch(35.9% .144 278.697);</td><td><div style="border-block-color: oklch(35.9% .144 278.697);"></div></td></tr>
    <tr><td>border-y-indigo-950</td><td>border-block-color: oklch(25.7% .09 281.288);</td><td><div style="border-block-color: oklch(25.7% .09 281.288);"></div></td></tr>
    <tr><td>border-y-violet-50</td><td>border-block-color: oklch(96.9% .016 293.756);</td><td><div style="border-block-color: oklch(96.9% .016 293.756);"></div></td></tr>
    <tr><td>border-y-violet-100</td><td>border-block-color: oklch(94.3% .029 294.588);</td><td><div style="border-block-color: oklch(94.3% .029 294.588);"></div></td></tr>
    <tr><td>border-y-violet-200</td><td>border-block-color: oklch(89.4% .057 293.283);</td><td><div style="border-block-color: oklch(89.4% .057 293.283);"></div></td></tr>
    <tr><td>border-y-violet-300</td><td>border-block-color: oklch(81.1% .111 293.571);</td><td><div style="border-block-color: oklch(81.1% .111 293.571);"></div></td></tr>
    <tr><td>border-y-violet-400</td><td>border-block-color: oklch(70.2% .183 293.541);</td><td><div style="border-block-color: oklch(70.2% .183 293.541);"></div></td></tr>
    <tr><td>border-y-violet-500</td><td>border-block-color: oklch(60.6% .25 292.717);</td><td><div style="border-block-color: oklch(60.6% .25 292.717);"></div></td></tr>
    <tr><td>border-y-violet-600</td><td>border-block-color: oklch(54.1% .281 293.009);</td><td><div style="border-block-color: oklch(54.1% .281 293.009);"></div></td></tr>
    <tr><td>border-y-violet-700</td><td>border-block-color: oklch(49.1% .27 292.581);</td><td><div style="border-block-color: oklch(49.1% .27 292.581);"></div></td></tr>
    <tr><td>border-y-violet-800</td><td>border-block-color: oklch(43.2% .232 292.759);</td><td><div style="border-block-color: oklch(43.2% .232 292.759);"></div></td></tr>
    <tr><td>border-y-violet-900</td><td>border-block-color: oklch(38% .189 293.745);</td><td><div style="border-block-color: oklch(38% .189 293.745);"></div></td></tr>
    <tr><td>border-y-violet-950</td><td>border-block-color: oklch(28.3% .141 291.089);</td><td><div style="border-block-color: oklch(28.3% .141 291.089);"></div></td></tr>
    <tr><td>border-y-purple-50</td><td>border-block-color: oklch(97.7% .014 308.299);</td><td><div style="border-block-color: oklch(97.7% .014 308.299);"></div></td></tr>
    <tr><td>border-y-purple-100</td><td>border-block-color: oklch(94.6% .033 307.174);</td><td><div style="border-block-color: oklch(94.6% .033 307.174);"></div></td></tr>
    <tr><td>border-y-purple-200</td><td>border-block-color: oklch(90.2% .063 306.703);</td><td><div style="border-block-color: oklch(90.2% .063 306.703);"></div></td></tr>
    <tr><td>border-y-purple-300</td><td>border-block-color: oklch(82.7% .119 306.383);</td><td><div style="border-block-color: oklch(82.7% .119 306.383);"></div></td></tr>
    <tr><td>border-y-purple-400</td><td>border-block-color: oklch(71.4% .203 305.504);</td><td><div style="border-block-color: oklch(71.4% .203 305.504);"></div></td></tr>
    <tr><td>border-y-purple-500</td><td>border-block-color: oklch(62.7% .265 303.9);</td><td><div style="border-block-color: oklch(62.7% .265 303.9);"></div></td></tr>
    <tr><td>border-y-purple-600</td><td>border-block-color: oklch(55.8% .288 302.321);</td><td><div style="border-block-color: oklch(55.8% .288 302.321);"></div></td></tr>
    <tr><td>border-y-purple-700</td><td>border-block-color: oklch(49.6% .265 301.924);</td><td><div style="border-block-color: oklch(49.6% .265 301.924);"></div></td></tr>
    <tr><td>border-y-purple-800</td><td>border-block-color: oklch(43.8% .218 303.724);</td><td><div style="border-block-color: oklch(43.8% .218 303.724);"></div></td></tr>
    <tr><td>border-y-purple-900</td><td>border-block-color: oklch(38.1% .176 304.987);</td><td><div style="border-block-color: oklch(38.1% .176 304.987);"></div></td></tr>
    <tr><td>border-y-purple-950</td><td>border-block-color: oklch(29.1% .149 302.717);</td><td><div style="border-block-color: oklch(29.1% .149 302.717);"></div></td></tr>
    <tr><td>border-y-fuchsia-50</td><td>border-block-color: oklch(97.7% .017 320.058);</td><td><div style="border-block-color: oklch(97.7% .017 320.058);"></div></td></tr>
    <tr><td>border-y-fuchsia-100</td><td>border-block-color: oklch(95.2% .037 318.852);</td><td><div style="border-block-color: oklch(95.2% .037 318.852);"></div></td></tr>
    <tr><td>border-y-fuchsia-200</td><td>border-block-color: oklch(90.3% .076 319.62);</td><td><div style="border-block-color: oklch(90.3% .076 319.62);"></div></td></tr>
    <tr><td>border-y-fuchsia-300</td><td>border-block-color: oklch(83.3% .145 321.434);</td><td><div style="border-block-color: oklch(83.3% .145 321.434);"></div></td></tr>
    <tr><td>border-y-fuchsia-400</td><td>border-block-color: oklch(74% .238 322.16);</td><td><div style="border-block-color: oklch(74% .238 322.16);"></div></td></tr>
    <tr><td>border-y-fuchsia-500</td><td>border-block-color: oklch(66.7% .295 322.15);</td><td><div style="border-block-color: oklch(66.7% .295 322.15);"></div></td></tr>
    <tr><td>border-y-fuchsia-600</td><td>border-block-color: oklch(59.1% .293 322.896);</td><td><div style="border-block-color: oklch(59.1% .293 322.896);"></div></td></tr>
    <tr><td>border-y-fuchsia-700</td><td>border-block-color: oklch(51.8% .253 323.949);</td><td><div style="border-block-color: oklch(51.8% .253 323.949);"></div></td></tr>
    <tr><td>border-y-fuchsia-800</td><td>border-block-color: oklch(45.2% .211 324.591);</td><td><div style="border-block-color: oklch(45.2% .211 324.591);"></div></td></tr>
    <tr><td>border-y-fuchsia-900</td><td>border-block-color: oklch(40.1% .17 325.612);</td><td><div style="border-block-color: oklch(40.1% .17 325.612);"></div></td></tr>
    <tr><td>border-y-fuchsia-950</td><td>border-block-color: oklch(29.3% .136 325.661);</td><td><div style="border-block-color: oklch(29.3% .136 325.661);"></div></td></tr>
    <tr><td>border-y-pink-50</td><td>border-block-color: oklch(97.1% .014 343.198);</td><td><div style="border-block-color: oklch(97.1% .014 343.198);"></div></td></tr>
    <tr><td>border-y-pink-100</td><td>border-block-color: oklch(94.8% .028 342.258);</td><td><div style="border-block-color: oklch(94.8% .028 342.258);"></div></td></tr>
    <tr><td>border-y-pink-200</td><td>border-block-color: oklch(89.9% .061 343.231);</td><td><div style="border-block-color: oklch(89.9% .061 343.231);"></div></td></tr>
    <tr><td>border-y-pink-300</td><td>border-block-color: oklch(82.3% .12 346.018);</td><td><div style="border-block-color: oklch(82.3% .12 346.018);"></div></td></tr>
    <tr><td>border-y-pink-400</td><td>border-block-color: oklch(71.8% .202 349.761);</td><td><div style="border-block-color: oklch(71.8% .202 349.761);"></div></td></tr>
    <tr><td>border-y-pink-500</td><td>border-block-color: oklch(65.6% .241 354.308);</td><td><div style="border-block-color: oklch(65.6% .241 354.308);"></div></td></tr>
    <tr><td>border-y-pink-600</td><td>border-block-color: oklch(59.2% .249 .584);</td><td><div style="border-block-color: oklch(59.2% .249 .584);"></div></td></tr>
    <tr><td>border-y-pink-700</td><td>border-block-color: oklch(52.5% .223 3.958);</td><td><div style="border-block-color: oklch(52.5% .223 3.958);"></div></td></tr>
    <tr><td>border-y-pink-800</td><td>border-block-color: oklch(45.9% .187 3.815);</td><td><div style="border-block-color: oklch(45.9% .187 3.815);"></div></td></tr>
    <tr><td>border-y-pink-900</td><td>border-block-color: oklch(40.8% .153 2.432);</td><td><div style="border-block-color: oklch(40.8% .153 2.432);"></div></td></tr>
    <tr><td>border-y-pink-950</td><td>border-block-color: oklch(28.4% .109 3.907);</td><td><div style="border-block-color: oklch(28.4% .109 3.907);"></div></td></tr>
    <tr><td>border-y-rose-50</td><td>border-block-color: oklch(96.9% .015 12.422);</td><td><div style="border-block-color: oklch(96.9% .015 12.422);"></div></td></tr>
    <tr><td>border-y-rose-100</td><td>border-block-color: oklch(94.1% .03 12.58);</td><td><div style="border-block-color: oklch(94.1% .03 12.58);"></div></td></tr>
    <tr><td>border-y-rose-200</td><td>border-block-color: oklch(89.2% .058 10.001);</td><td><div style="border-block-color: oklch(89.2% .058 10.001);"></div></td></tr>
    <tr><td>border-y-rose-300</td><td>border-block-color: oklch(81% .117 11.638);</td><td><div style="border-block-color: oklch(81% .117 11.638);"></div></td></tr>
    <tr><td>border-y-rose-400</td><td>border-block-color: oklch(71.2% .194 13.428);</td><td><div style="border-block-color: oklch(71.2% .194 13.428);"></div></td></tr>
    <tr><td>border-y-rose-500</td><td>border-block-color: oklch(64.5% .246 16.439);</td><td><div style="border-block-color: oklch(64.5% .246 16.439);"></div></td></tr>
    <tr><td>border-y-rose-600</td><td>border-block-color: oklch(58.6% .253 17.585);</td><td><div style="border-block-color: oklch(58.6% .253 17.585);"></div></td></tr>
    <tr><td>border-y-rose-700</td><td>border-block-color: oklch(51.4% .222 16.935);</td><td><div style="border-block-color: oklch(51.4% .222 16.935);"></div></td></tr>
    <tr><td>border-y-rose-800</td><td>border-block-color: oklch(45.5% .188 13.697);</td><td><div style="border-block-color: oklch(45.5% .188 13.697);"></div></td></tr>
    <tr><td>border-y-rose-900</td><td>border-block-color: oklch(41% .159 10.272);</td><td><div style="border-block-color: oklch(41% .159 10.272);"></div></td></tr>
    <tr><td>border-y-rose-950</td><td>border-block-color: oklch(27.1% .105 12.094);</td><td><div style="border-block-color: oklch(27.1% .105 12.094);"></div></td></tr>
    <tr><td>border-y-slate-50</td><td>border-block-color: oklch(98.4% .003 247.858);</td><td><div style="border-block-color: oklch(98.4% .003 247.858);"></div></td></tr>
    <tr><td>border-y-slate-100</td><td>border-block-color: oklch(96.8% .007 247.896);</td><td><div style="border-block-color: oklch(96.8% .007 247.896);"></div></td></tr>
    <tr><td>border-y-slate-200</td><td>border-block-color: oklch(92.9% .013 255.508);</td><td><div style="border-block-color: oklch(92.9% .013 255.508);"></div></td></tr>
    <tr><td>border-y-slate-300</td><td>border-block-color: oklch(86.9% .022 252.894);</td><td><div style="border-block-color: oklch(86.9% .022 252.894);"></div></td></tr>
    <tr><td>border-y-slate-400</td><td>border-block-color: oklch(70.4% .04 256.788);</td><td><div style="border-block-color: oklch(70.4% .04 256.788);"></div></td></tr>
    <tr><td>border-y-slate-500</td><td>border-block-color: oklch(55.4% .046 257.417);</td><td><div style="border-block-color: oklch(55.4% .046 257.417);"></div></td></tr>
    <tr><td>border-y-slate-600</td><td>border-block-color: oklch(44.6% .043 257.281);</td><td><div style="border-block-color: oklch(44.6% .043 257.281);"></div></td></tr>
    <tr><td>border-y-slate-700</td><td>border-block-color: oklch(37.2% .044 257.287);</td><td><div style="border-block-color: oklch(37.2% .044 257.287);"></div></td></tr>
    <tr><td>border-y-slate-800</td><td>border-block-color: oklch(27.9% .041 260.031);</td><td><div style="border-block-color: oklch(27.9% .041 260.031);"></div></td></tr>
    <tr><td>border-y-slate-900</td><td>border-block-color: oklch(20.8% .042 265.755);</td><td><div style="border-block-color: oklch(20.8% .042 265.755);"></div></td></tr>
    <tr><td>border-y-slate-950</td><td>border-block-color: oklch(12.9% .042 264.695);</td><td><div style="border-block-color: oklch(12.9% .042 264.695);"></div></td></tr>
    <tr><td>border-y-gray-50</td><td>border-block-color: oklch(98.5% .002 247.839);</td><td><div style="border-block-color: oklch(98.5% .002 247.839);"></div></td></tr>
    <tr><td>border-y-gray-100</td><td>border-block-color: oklch(96.7% .003 264.542);</td><td><div style="border-block-color: oklch(96.7% .003 264.542);"></div></td></tr>
    <tr><td>border-y-gray-200</td><td>border-block-color: oklch(92.8% .006 264.531);</td><td><div style="border-block-color: oklch(92.8% .006 264.531);"></div></td></tr>
    <tr><td>border-y-gray-300</td><td>border-block-color: oklch(87.2% .01 258.338);</td><td><div style="border-block-color: oklch(87.2% .01 258.338);"></div></td></tr>
    <tr><td>border-y-gray-400</td><td>border-block-color: oklch(70.7% .022 261.325);</td><td><div style="border-block-color: oklch(70.7% .022 261.325);"></div></td></tr>
    <tr><td>border-y-gray-500</td><td>border-block-color: oklch(55.1% .027 264.364);</td><td><div style="border-block-color: oklch(55.1% .027 264.364);"></div></td></tr>
    <tr><td>border-y-gray-600</td><td>border-block-color: oklch(44.6% .03 256.802);</td><td><div style="border-block-color: oklch(44.6% .03 256.802);"></div></td></tr>
    <tr><td>border-y-gray-700</td><td>border-block-color: oklch(37.3% .034 259.733);</td><td><div style="border-block-color: oklch(37.3% .034 259.733);"></div></td></tr>
    <tr><td>border-y-gray-800</td><td>border-block-color: oklch(27.8% .033 256.848);</td><td><div style="border-block-color: oklch(27.8% .033 256.848);"></div></td></tr>
    <tr><td>border-y-gray-900</td><td>border-block-color: oklch(21% .034 264.665);</td><td><div style="border-block-color: oklch(21% .034 264.665);"></div></td></tr>
    <tr><td>border-y-gray-950</td><td>border-block-color: oklch(13% .028 261.692);</td><td><div style="border-block-color: oklch(13% .028 261.692);"></div></td></tr>
    <tr><td>border-y-zinc-50</td><td>border-block-color: oklch(98.5% 0 0);</td><td><div style="border-block-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-y-zinc-100</td><td>border-block-color: oklch(96.7% .001 286.375);</td><td><div style="border-block-color: oklch(96.7% .001 286.375);"></div></td></tr>
    <tr><td>border-y-zinc-200</td><td>border-block-color: oklch(92% .004 286.32);</td><td><div style="border-block-color: oklch(92% .004 286.32);"></div></td></tr>
    <tr><td>border-y-zinc-300</td><td>border-block-color: oklch(87.1% .006 286.286);</td><td><div style="border-block-color: oklch(87.1% .006 286.286);"></div></td></tr>
    <tr><td>border-y-zinc-400</td><td>border-block-color: oklch(70.5% .015 286.067);</td><td><div style="border-block-color: oklch(70.5% .015 286.067);"></div></td></tr>
    <tr><td>border-y-zinc-500</td><td>border-block-color: oklch(55.2% .016 285.938);</td><td><div style="border-block-color: oklch(55.2% .016 285.938);"></div></td></tr>
    <tr><td>border-y-zinc-600</td><td>border-block-color: oklch(44.2% .017 285.786);</td><td><div style="border-block-color: oklch(44.2% .017 285.786);"></div></td></tr>
    <tr><td>border-y-zinc-700</td><td>border-block-color: oklch(37% .013 285.805);</td><td><div style="border-block-color: oklch(37% .013 285.805);"></div></td></tr>
    <tr><td>border-y-zinc-800</td><td>border-block-color: oklch(27.4% .006 286.033);</td><td><div style="border-block-color: oklch(27.4% .006 286.033);"></div></td></tr>
    <tr><td>border-y-zinc-900</td><td>border-block-color: oklch(21% .006 285.885);</td><td><div style="border-block-color: oklch(21% .006 285.885);"></div></td></tr>
    <tr><td>border-y-zinc-950</td><td>border-block-color: oklch(14.1% .005 285.823);</td><td><div style="border-block-color: oklch(14.1% .005 285.823);"></div></td></tr>
    <tr><td>border-y-neutral-50</td><td>border-block-color: oklch(98.5% 0 0);</td><td><div style="border-block-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-100</td><td>border-block-color: oklch(97% 0 0);</td><td><div style="border-block-color: oklch(97% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-200</td><td>border-block-color: oklch(92.2% 0 0);</td><td><div style="border-block-color: oklch(92.2% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-300</td><td>border-block-color: oklch(87% 0 0);</td><td><div style="border-block-color: oklch(87% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-400</td><td>border-block-color: oklch(70.8% 0 0);</td><td><div style="border-block-color: oklch(70.8% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-500</td><td>border-block-color: oklch(55.6% 0 0);</td><td><div style="border-block-color: oklch(55.6% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-600</td><td>border-block-color: oklch(43.9% 0 0);</td><td><div style="border-block-color: oklch(43.9% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-700</td><td>border-block-color: oklch(37.1% 0 0);</td><td><div style="border-block-color: oklch(37.1% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-800</td><td>border-block-color: oklch(26.9% 0 0);</td><td><div style="border-block-color: oklch(26.9% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-900</td><td>border-block-color: oklch(20.5% 0 0);</td><td><div style="border-block-color: oklch(20.5% 0 0);"></div></td></tr>
    <tr><td>border-y-neutral-950</td><td>border-block-color: oklch(14.5% 0 0);</td><td><div style="border-block-color: oklch(14.5% 0 0);"></div></td></tr>
    <tr><td>border-y-stone-50</td><td>border-block-color: oklch(98.5% .001 106.423);</td><td><div style="border-block-color: oklch(98.5% .001 106.423);"></div></td></tr>
    <tr><td>border-y-stone-100</td><td>border-block-color: oklch(97% .001 106.424);</td><td><div style="border-block-color: oklch(97% .001 106.424);"></div></td></tr>
    <tr><td>border-y-stone-200</td><td>border-block-color: oklch(92.3% .003 48.717);</td><td><div style="border-block-color: oklch(92.3% .003 48.717);"></div></td></tr>
    <tr><td>border-y-stone-300</td><td>border-block-color: oklch(86.9% .005 56.366);</td><td><div style="border-block-color: oklch(86.9% .005 56.366);"></div></td></tr>
    <tr><td>border-y-stone-400</td><td>border-block-color: oklch(70.9% .01 56.259);</td><td><div style="border-block-color: oklch(70.9% .01 56.259);"></div></td></tr>
    <tr><td>border-y-stone-500</td><td>border-block-color: oklch(55.3% .013 58.071);</td><td><div style="border-block-color: oklch(55.3% .013 58.071);"></div></td></tr>
    <tr><td>border-y-stone-600</td><td>border-block-color: oklch(44.4% .011 73.639);</td><td><div style="border-block-color: oklch(44.4% .011 73.639);"></div></td></tr>
    <tr><td>border-y-stone-700</td><td>border-block-color: oklch(37.4% .01 67.558);</td><td><div style="border-block-color: oklch(37.4% .01 67.558);"></div></td></tr>
    <tr><td>border-y-stone-800</td><td>border-block-color: oklch(26.8% .007 34.298);</td><td><div style="border-block-color: oklch(26.8% .007 34.298);"></div></td></tr>
    <tr><td>border-y-stone-900</td><td>border-block-color: oklch(21.6% .006 56.043);</td><td><div style="border-block-color: oklch(21.6% .006 56.043);"></div></td></tr>
    <tr><td>border-y-stone-950</td><td>border-block-color: oklch(14.7% .004 49.25);</td><td><div style="border-block-color: oklch(14.7% .004 49.25);"></div></td></tr>
    <tr><td>border-y-black</td><td>border-block-color: #000;</td><td><div style="border-block-color: #000;"></div></td></tr>
    <tr><td>border-y-white</td><td>border-block-color: #fff;</td><td><div style="border-block-color: #fff;"></div></td></tr>
    <tr><td>border-s-inherit</td><td>border-inline-start-color: inherit;</td><td><div style="border-inline-start-color: inherit;"></div></td></tr>
    <tr><td>border-s-current</td><td>border-inline-start-color: currentColor;</td><td><div style="border-inline-start-color: currentColor;"></div></td></tr>
    <tr><td>border-s-transparent</td><td>border-inline-start-color: transparent;</td><td><div style="border-inline-start-color: transparent;"></div></td></tr>
    <tr><td>border-s-red-50</td><td>border-inline-start-color: oklch(97.1% .013 17.38);</td><td><div style="border-inline-start-color: oklch(97.1% .013 17.38);"></div></td></tr>
    <tr><td>border-s-red-100</td><td>border-inline-start-color: oklch(93.6% .032 17.717);</td><td><div style="border-inline-start-color: oklch(93.6% .032 17.717);"></div></td></tr>
    <tr><td>border-s-red-200</td><td>border-inline-start-color: oklch(88.5% .062 18.334);</td><td><div style="border-inline-start-color: oklch(88.5% .062 18.334);"></div></td></tr>
    <tr><td>border-s-red-300</td><td>border-inline-start-color: oklch(80.8% .114 19.571);</td><td><div style="border-inline-start-color: oklch(80.8% .114 19.571);"></div></td></tr>
    <tr><td>border-s-red-400</td><td>border-inline-start-color: oklch(70.4% .191 22.216);</td><td><div style="border-inline-start-color: oklch(70.4% .191 22.216);"></div></td></tr>
    <tr><td>border-s-red-500</td><td>border-inline-start-color: oklch(63.7% .237 25.331);</td><td><div style="border-inline-start-color: oklch(63.7% .237 25.331);"></div></td></tr>
    <tr><td>border-s-red-600</td><td>border-inline-start-color: oklch(57.7% .245 27.325);</td><td><div style="border-inline-start-color: oklch(57.7% .245 27.325);"></div></td></tr>
    <tr><td>border-s-red-700</td><td>border-inline-start-color: oklch(50.5% .213 27.518);</td><td><div style="border-inline-start-color: oklch(50.5% .213 27.518);"></div></td></tr>
    <tr><td>border-s-red-800</td><td>border-inline-start-color: oklch(44.4% .177 26.899);</td><td><div style="border-inline-start-color: oklch(44.4% .177 26.899);"></div></td></tr>
    <tr><td>border-s-red-900</td><td>border-inline-start-color: oklch(39.6% .141 25.723);</td><td><div style="border-inline-start-color: oklch(39.6% .141 25.723);"></div></td></tr>
    <tr><td>border-s-red-950</td><td>border-inline-start-color: oklch(25.8% .092 26.042);</td><td><div style="border-inline-start-color: oklch(25.8% .092 26.042);"></div></td></tr>
    <tr><td>border-s-orange-50</td><td>border-inline-start-color: oklch(98% .016 73.684);</td><td><div style="border-inline-start-color: oklch(98% .016 73.684);"></div></td></tr>
    <tr><td>border-s-orange-100</td><td>border-inline-start-color: oklch(95.4% .038 75.164);</td><td><div style="border-inline-start-color: oklch(95.4% .038 75.164);"></div></td></tr>
    <tr><td>border-s-orange-200</td><td>border-inline-start-color: oklch(90.1% .076 70.697);</td><td><div style="border-inline-start-color: oklch(90.1% .076 70.697);"></div></td></tr>
    <tr><td>border-s-orange-300</td><td>border-inline-start-color: oklch(83.7% .128 66.29);</td><td><div style="border-inline-start-color: oklch(83.7% .128 66.29);"></div></td></tr>
    <tr><td>border-s-orange-400</td><td>border-inline-start-color: oklch(75% .183 55.934);</td><td><div style="border-inline-start-color: oklch(75% .183 55.934);"></div></td></tr>
    <tr><td>border-s-orange-500</td><td>border-inline-start-color: oklch(70.5% .213 47.604);</td><td><div style="border-inline-start-color: oklch(70.5% .213 47.604);"></div></td></tr>
    <tr><td>border-s-orange-600</td><td>border-inline-start-color: oklch(64.6% .222 41.116);</td><td><div style="border-inline-start-color: oklch(64.6% .222 41.116);"></div></td></tr>
    <tr><td>border-s-orange-700</td><td>border-inline-start-color: oklch(55.3% .195 38.402);</td><td><div style="border-inline-start-color: oklch(55.3% .195 38.402);"></div></td></tr>
    <tr><td>border-s-orange-800</td><td>border-inline-start-color: oklch(47% .157 37.304);</td><td><div style="border-inline-start-color: oklch(47% .157 37.304);"></div></td></tr>
    <tr><td>border-s-orange-900</td><td>border-inline-start-color: oklch(40.8% .123 38.172);</td><td><div style="border-inline-start-color: oklch(40.8% .123 38.172);"></div></td></tr>
    <tr><td>border-s-orange-950</td><td>border-inline-start-color: oklch(26.6% .079 36.259);</td><td><div style="border-inline-start-color: oklch(26.6% .079 36.259);"></div></td></tr>
    <tr><td>border-s-amber-50</td><td>border-inline-start-color: oklch(98.7% .022 95.277);</td><td><div style="border-inline-start-color: oklch(98.7% .022 95.277);"></div></td></tr>
    <tr><td>border-s-amber-100</td><td>border-inline-start-color: oklch(96.2% .059 95.617);</td><td><div style="border-inline-start-color: oklch(96.2% .059 95.617);"></div></td></tr>
    <tr><td>border-s-amber-200</td><td>border-inline-start-color: oklch(92.4% .12 95.746);</td><td><div style="border-inline-start-color: oklch(92.4% .12 95.746);"></div></td></tr>
    <tr><td>border-s-amber-300</td><td>border-inline-start-color: oklch(87.9% .169 91.605);</td><td><div style="border-inline-start-color: oklch(87.9% .169 91.605);"></div></td></tr>
    <tr><td>border-s-amber-400</td><td>border-inline-start-color: oklch(82.8% .189 84.429);</td><td><div style="border-inline-start-color: oklch(82.8% .189 84.429);"></div></td></tr>
    <tr><td>border-s-amber-500</td><td>border-inline-start-color: oklch(76.9% .188 70.08);</td><td><div style="border-inline-start-color: oklch(76.9% .188 70.08);"></div></td></tr>
    <tr><td>border-s-amber-600</td><td>border-inline-start-color: oklch(66.6% .179 58.318);</td><td><div style="border-inline-start-color: oklch(66.6% .179 58.318);"></div></td></tr>
    <tr><td>border-s-amber-700</td><td>border-inline-start-color: oklch(55.5% .163 48.998);</td><td><div style="border-inline-start-color: oklch(55.5% .163 48.998);"></div></td></tr>
    <tr><td>border-s-amber-800</td><td>border-inline-start-color: oklch(47.3% .137 46.201);</td><td><div style="border-inline-start-color: oklch(47.3% .137 46.201);"></div></td></tr>
    <tr><td>border-s-amber-900</td><td>border-inline-start-color: oklch(41.4% .112 45.904);</td><td><div style="border-inline-start-color: oklch(41.4% .112 45.904);"></div></td></tr>
    <tr><td>border-s-amber-950</td><td>border-inline-start-color: oklch(27.9% .077 45.635);</td><td><div style="border-inline-start-color: oklch(27.9% .077 45.635);"></div></td></tr>
    <tr><td>border-s-yellow-50</td><td>border-inline-start-color: oklch(98.7% .026 102.212);</td><td><div style="border-inline-start-color: oklch(98.7% .026 102.212);"></div></td></tr>
    <tr><td>border-s-yellow-100</td><td>border-inline-start-color: oklch(97.3% .071 103.193);</td><td><div style="border-inline-start-color: oklch(97.3% .071 103.193);"></div></td></tr>
    <tr><td>border-s-yellow-200</td><td>border-inline-start-color: oklch(94.5% .129 101.54);</td><td><div style="border-inline-start-color: oklch(94.5% .129 101.54);"></div></td></tr>
    <tr><td>border-s-yellow-300</td><td>border-inline-start-color: oklch(90.5% .182 98.111);</td><td><div style="border-inline-start-color: oklch(90.5% .182 98.111);"></div></td></tr>
    <tr><td>border-s-yellow-400</td><td>border-inline-start-color: oklch(85.2% .199 91.936);</td><td><div style="border-inline-start-color: oklch(85.2% .199 91.936);"></div></td></tr>
    <tr><td>border-s-yellow-500</td><td>border-inline-start-color: oklch(79.5% .184 86.047);</td><td><div style="border-inline-start-color: oklch(79.5% .184 86.047);"></div></td></tr>
    <tr><td>border-s-yellow-600</td><td>border-inline-start-color: oklch(68.1% .162 75.834);</td><td><div style="border-inline-start-color: oklch(68.1% .162 75.834);"></div></td></tr>
    <tr><td>border-s-yellow-700</td><td>border-inline-start-color: oklch(55.4% .135 66.442);</td><td><div style="border-inline-start-color: oklch(55.4% .135 66.442);"></div></td></tr>
    <tr><td>border-s-yellow-800</td><td>border-inline-start-color: oklch(47.6% .114 61.907);</td><td><div style="border-inline-start-color: oklch(47.6% .114 61.907);"></div></td></tr>
    <tr><td>border-s-yellow-900</td><td>border-inline-start-color: oklch(42.1% .095 57.708);</td><td><div style="border-inline-start-color: oklch(42.1% .095 57.708);"></div></td></tr>
    <tr><td>border-s-yellow-950</td><td>border-inline-start-color: oklch(28.6% .066 53.813);</td><td><div style="border-inline-start-color: oklch(28.6% .066 53.813);"></div></td></tr>
    <tr><td>border-s-lime-50</td><td>border-inline-start-color: oklch(98.6% .031 120.757);</td><td><div style="border-inline-start-color: oklch(98.6% .031 120.757);"></div></td></tr>
    <tr><td>border-s-lime-100</td><td>border-inline-start-color: oklch(96.7% .067 122.328);</td><td><div style="border-inline-start-color: oklch(96.7% .067 122.328);"></div></td></tr>
    <tr><td>border-s-lime-200</td><td>border-inline-start-color: oklch(93.8% .127 124.321);</td><td><div style="border-inline-start-color: oklch(93.8% .127 124.321);"></div></td></tr>
    <tr><td>border-s-lime-300</td><td>border-inline-start-color: oklch(89.7% .196 126.665);</td><td><div style="border-inline-start-color: oklch(89.7% .196 126.665);"></div></td></tr>
    <tr><td>border-s-lime-400</td><td>border-inline-start-color: oklch(84.1% .238 128.85);</td><td><div style="border-inline-start-color: oklch(84.1% .238 128.85);"></div></td></tr>
    <tr><td>border-s-lime-500</td><td>border-inline-start-color: oklch(76.8% .233 130.85);</td><td><div style="border-inline-start-color: oklch(76.8% .233 130.85);"></div></td></tr>
    <tr><td>border-s-lime-600</td><td>border-inline-start-color: oklch(64.8% .2 131.684);</td><td><div style="border-inline-start-color: oklch(64.8% .2 131.684);"></div></td></tr>
    <tr><td>border-s-lime-700</td><td>border-inline-start-color: oklch(53.2% .157 131.589);</td><td><div style="border-inline-start-color: oklch(53.2% .157 131.589);"></div></td></tr>
    <tr><td>border-s-lime-800</td><td>border-inline-start-color: oklch(45.3% .124 130.933);</td><td><div style="border-inline-start-color: oklch(45.3% .124 130.933);"></div></td></tr>
    <tr><td>border-s-lime-900</td><td>border-inline-start-color: oklch(40.5% .101 131.063);</td><td><div style="border-inline-start-color: oklch(40.5% .101 131.063);"></div></td></tr>
    <tr><td>border-s-lime-950</td><td>border-inline-start-color: oklch(27.4% .072 132.109);</td><td><div style="border-inline-start-color: oklch(27.4% .072 132.109);"></div></td></tr>
    <tr><td>border-s-green-50</td><td>border-inline-start-color: oklch(98.2% .018 155.826);</td><td><div style="border-inline-start-color: oklch(98.2% .018 155.826);"></div></td></tr>
    <tr><td>border-s-green-100</td><td>border-inline-start-color: oklch(96.2% .044 156.743);</td><td><div style="border-inline-start-color: oklch(96.2% .044 156.743);"></div></td></tr>
    <tr><td>border-s-green-200</td><td>border-inline-start-color: oklch(92.5% .084 155.995);</td><td><div style="border-inline-start-color: oklch(92.5% .084 155.995);"></div></td></tr>
    <tr><td>border-s-green-300</td><td>border-inline-start-color: oklch(87.1% .15 154.449);</td><td><div style="border-inline-start-color: oklch(87.1% .15 154.449);"></div></td></tr>
    <tr><td>border-s-green-400</td><td>border-inline-start-color: oklch(79.2% .209 151.711);</td><td><div style="border-inline-start-color: oklch(79.2% .209 151.711);"></div></td></tr>
    <tr><td>border-s-green-500</td><td>border-inline-start-color: oklch(72.3% .219 149.579);</td><td><div style="border-inline-start-color: oklch(72.3% .219 149.579);"></div></td></tr>
    <tr><td>border-s-green-600</td><td>border-inline-start-color: oklch(62.7% .194 149.214);</td><td><div style="border-inline-start-color: oklch(62.7% .194 149.214);"></div></td></tr>
    <tr><td>border-s-green-700</td><td>border-inline-start-color: oklch(52.7% .154 150.069);</td><td><div style="border-inline-start-color: oklch(52.7% .154 150.069);"></div></td></tr>
    <tr><td>border-s-green-800</td><td>border-inline-start-color: oklch(44.8% .119 151.328);</td><td><div style="border-inline-start-color: oklch(44.8% .119 151.328);"></div></td></tr>
    <tr><td>border-s-green-900</td><td>border-inline-start-color: oklch(39.3% .095 152.535);</td><td><div style="border-inline-start-color: oklch(39.3% .095 152.535);"></div></td></tr>
    <tr><td>border-s-green-950</td><td>border-inline-start-color: oklch(26.6% .065 152.934);</td><td><div style="border-inline-start-color: oklch(26.6% .065 152.934);"></div></td></tr>
    <tr><td>border-s-emerald-50</td><td>border-inline-start-color: oklch(97.9% .021 166.113);</td><td><div style="border-inline-start-color: oklch(97.9% .021 166.113);"></div></td></tr>
    <tr><td>border-s-emerald-100</td><td>border-inline-start-color: oklch(95% .052 163.051);</td><td><div style="border-inline-start-color: oklch(95% .052 163.051);"></div></td></tr>
    <tr><td>border-s-emerald-200</td><td>border-inline-start-color: oklch(90.5% .093 164.15);</td><td><div style="border-inline-start-color: oklch(90.5% .093 164.15);"></div></td></tr>
    <tr><td>border-s-emerald-300</td><td>border-inline-start-color: oklch(84.5% .143 164.978);</td><td><div style="border-inline-start-color: oklch(84.5% .143 164.978);"></div></td></tr>
    <tr><td>border-s-emerald-400</td><td>border-inline-start-color: oklch(76.5% .177 163.223);</td><td><div style="border-inline-start-color: oklch(76.5% .177 163.223);"></div></td></tr>
    <tr><td>border-s-emerald-500</td><td>border-inline-start-color: oklch(69.6% .17 162.48);</td><td><div style="border-inline-start-color: oklch(69.6% .17 162.48);"></div></td></tr>
    <tr><td>border-s-emerald-600</td><td>border-inline-start-color: oklch(59.6% .145 163.225);</td><td><div style="border-inline-start-color: oklch(59.6% .145 163.225);"></div></td></tr>
    <tr><td>border-s-emerald-700</td><td>border-inline-start-color: oklch(50.8% .118 165.612);</td><td><div style="border-inline-start-color: oklch(50.8% .118 165.612);"></div></td></tr>
    <tr><td>border-s-emerald-800</td><td>border-inline-start-color: oklch(43.2% .095 166.913);</td><td><div style="border-inline-start-color: oklch(43.2% .095 166.913);"></div></td></tr>
    <tr><td>border-s-emerald-900</td><td>border-inline-start-color: oklch(37.8% .077 168.94);</td><td><div style="border-inline-start-color: oklch(37.8% .077 168.94);"></div></td></tr>
    <tr><td>border-s-emerald-950</td><td>border-inline-start-color: oklch(26.2% .051 172.552);</td><td><div style="border-inline-start-color: oklch(26.2% .051 172.552);"></div></td></tr>
    <tr><td>border-s-teal-50</td><td>border-inline-start-color: oklch(98.4% .014 180.72);</td><td><div style="border-inline-start-color: oklch(98.4% .014 180.72);"></div></td></tr>
    <tr><td>border-s-teal-100</td><td>border-inline-start-color: oklch(95.3% .051 180.801);</td><td><div style="border-inline-start-color: oklch(95.3% .051 180.801);"></div></td></tr>
    <tr><td>border-s-teal-200</td><td>border-inline-start-color: oklch(91% .096 180.426);</td><td><div style="border-inline-start-color: oklch(91% .096 180.426);"></div></td></tr>
    <tr><td>border-s-teal-300</td><td>border-inline-start-color: oklch(85.5% .138 181.071);</td><td><div style="border-inline-start-color: oklch(85.5% .138 181.071);"></div></td></tr>
    <tr><td>border-s-teal-400</td><td>border-inline-start-color: oklch(77.7% .152 181.912);</td><td><div style="border-inline-start-color: oklch(77.7% .152 181.912);"></div></td></tr>
    <tr><td>border-s-teal-500</td><td>border-inline-start-color: oklch(70.4% .14 182.503);</td><td><div style="border-inline-start-color: oklch(70.4% .14 182.503);"></div></td></tr>
    <tr><td>border-s-teal-600</td><td>border-inline-start-color: oklch(60% .118 184.704);</td><td><div style="border-inline-start-color: oklch(60% .118 184.704);"></div></td></tr>
    <tr><td>border-s-teal-700</td><td>border-inline-start-color: oklch(51.1% .096 186.391);</td><td><div style="border-inline-start-color: oklch(51.1% .096 186.391);"></div></td></tr>
    <tr><td>border-s-teal-800</td><td>border-inline-start-color: oklch(43.7% .078 188.216);</td><td><div style="border-inline-start-color: oklch(43.7% .078 188.216);"></div></td></tr>
    <tr><td>border-s-teal-900</td><td>border-inline-start-color: oklch(38.6% .063 188.416);</td><td><div style="border-inline-start-color: oklch(38.6% .063 188.416);"></div></td></tr>
    <tr><td>border-s-teal-950</td><td>border-inline-start-color: oklch(27.7% .046 192.524);</td><td><div style="border-inline-start-color: oklch(27.7% .046 192.524);"></div></td></tr>
    <tr><td>border-s-cyan-50</td><td>border-inline-start-color: oklch(98.4% .019 200.873);</td><td><div style="border-inline-start-color: oklch(98.4% .019 200.873);"></div></td></tr>
    <tr><td>border-s-cyan-100</td><td>border-inline-start-color: oklch(95.6% .045 203.388);</td><td><div style="border-inline-start-color: oklch(95.6% .045 203.388);"></div></td></tr>
    <tr><td>border-s-cyan-200</td><td>border-inline-start-color: oklch(91.7% .08 205.041);</td><td><div style="border-inline-start-color: oklch(91.7% .08 205.041);"></div></td></tr>
    <tr><td>border-s-cyan-300</td><td>border-inline-start-color: oklch(86.5% .127 207.078);</td><td><div style="border-inline-start-color: oklch(86.5% .127 207.078);"></div></td></tr>
    <tr><td>border-s-cyan-400</td><td>border-inline-start-color: oklch(78.9% .154 211.53);</td><td><div style="border-inline-start-color: oklch(78.9% .154 211.53);"></div></td></tr>
    <tr><td>border-s-cyan-500</td><td>border-inline-start-color: oklch(71.5% .143 215.221);</td><td><div style="border-inline-start-color: oklch(71.5% .143 215.221);"></div></td></tr>
    <tr><td>border-s-cyan-600</td><td>border-inline-start-color: oklch(60.9% .126 221.723);</td><td><div style="border-inline-start-color: oklch(60.9% .126 221.723);"></div></td></tr>
    <tr><td>border-s-cyan-700</td><td>border-inline-start-color: oklch(52% .105 223.128);</td><td><div style="border-inline-start-color: oklch(52% .105 223.128);"></div></td></tr>
    <tr><td>border-s-cyan-800</td><td>border-inline-start-color: oklch(45% .085 224.283);</td><td><div style="border-inline-start-color: oklch(45% .085 224.283);"></div></td></tr>
    <tr><td>border-s-cyan-900</td><td>border-inline-start-color: oklch(39.8% .07 227.392);</td><td><div style="border-inline-start-color: oklch(39.8% .07 227.392);"></div></td></tr>
    <tr><td>border-s-cyan-950</td><td>border-inline-start-color: oklch(30.2% .056 229.695);</td><td><div style="border-inline-start-color: oklch(30.2% .056 229.695);"></div></td></tr>
    <tr><td>border-s-sky-50</td><td>border-inline-start-color: oklch(97.7% .013 236.62);</td><td><div style="border-inline-start-color: oklch(97.7% .013 236.62);"></div></td></tr>
    <tr><td>border-s-sky-100</td><td>border-inline-start-color: oklch(95.1% .026 236.824);</td><td><div style="border-inline-start-color: oklch(95.1% .026 236.824);"></div></td></tr>
    <tr><td>border-s-sky-200</td><td>border-inline-start-color: oklch(90.1% .058 230.902);</td><td><div style="border-inline-start-color: oklch(90.1% .058 230.902);"></div></td></tr>
    <tr><td>border-s-sky-300</td><td>border-inline-start-color: oklch(82.8% .111 230.318);</td><td><div style="border-inline-start-color: oklch(82.8% .111 230.318);"></div></td></tr>
    <tr><td>border-s-sky-400</td><td>border-inline-start-color: oklch(74.6% .16 232.661);</td><td><div style="border-inline-start-color: oklch(74.6% .16 232.661);"></div></td></tr>
    <tr><td>border-s-sky-500</td><td>border-inline-start-color: oklch(68.5% .169 237.323);</td><td><div style="border-inline-start-color: oklch(68.5% .169 237.323);"></div></td></tr>
    <tr><td>border-s-sky-600</td><td>border-inline-start-color: oklch(58.8% .158 241.966);</td><td><div style="border-inline-start-color: oklch(58.8% .158 241.966);"></div></td></tr>
    <tr><td>border-s-sky-700</td><td>border-inline-start-color: oklch(50% .134 242.749);</td><td><div style="border-inline-start-color: oklch(50% .134 242.749);"></div></td></tr>
    <tr><td>border-s-sky-800</td><td>border-inline-start-color: oklch(44.3% .11 240.79);</td><td><div style="border-inline-start-color: oklch(44.3% .11 240.79);"></div></td></tr>
    <tr><td>border-s-sky-900</td><td>border-inline-start-color: oklch(39.1% .09 240.876);</td><td><div style="border-inline-start-color: oklch(39.1% .09 240.876);"></div></td></tr>
    <tr><td>border-s-sky-950</td><td>border-inline-start-color: oklch(29.3% .066 243.157);</td><td><div style="border-inline-start-color: oklch(29.3% .066 243.157);"></div></td></tr>
    <tr><td>border-s-blue-50</td><td>border-inline-start-color: oklch(97% .014 254.604);</td><td><div style="border-inline-start-color: oklch(97% .014 254.604);"></div></td></tr>
    <tr><td>border-s-blue-100</td><td>border-inline-start-color: oklch(93.2% .032 255.585);</td><td><div style="border-inline-start-color: oklch(93.2% .032 255.585);"></div></td></tr>
    <tr><td>border-s-blue-200</td><td>border-inline-start-color: oklch(88.2% .059 254.128);</td><td><div style="border-inline-start-color: oklch(88.2% .059 254.128);"></div></td></tr>
    <tr><td>border-s-blue-300</td><td>border-inline-start-color: oklch(80.9% .105 251.813);</td><td><div style="border-inline-start-color: oklch(80.9% .105 251.813);"></div></td></tr>
    <tr><td>border-s-blue-400</td><td>border-inline-start-color: oklch(70.7% .165 254.624);</td><td><div style="border-inline-start-color: oklch(70.7% .165 254.624);"></div></td></tr>
    <tr><td>border-s-blue-500</td><td>border-inline-start-color: oklch(62.3% .214 259.815);</td><td><div style="border-inline-start-color: oklch(62.3% .214 259.815);"></div></td></tr>
    <tr><td>border-s-blue-600</td><td>border-inline-start-color: oklch(54.6% .245 262.881);</td><td><div style="border-inline-start-color: oklch(54.6% .245 262.881);"></div></td></tr>
    <tr><td>border-s-blue-700</td><td>border-inline-start-color: oklch(48.8% .243 264.376);</td><td><div style="border-inline-start-color: oklch(48.8% .243 264.376);"></div></td></tr>
    <tr><td>border-s-blue-800</td><td>border-inline-start-color: oklch(42.4% .199 265.638);</td><td><div style="border-inline-start-color: oklch(42.4% .199 265.638);"></div></td></tr>
    <tr><td>border-s-blue-900</td><td>border-inline-start-color: oklch(37.9% .146 265.522);</td><td><div style="border-inline-start-color: oklch(37.9% .146 265.522);"></div></td></tr>
    <tr><td>border-s-blue-950</td><td>border-inline-start-color: oklch(28.2% .091 267.935);</td><td><div style="border-inline-start-color: oklch(28.2% .091 267.935);"></div></td></tr>
    <tr><td>border-s-indigo-50</td><td>border-inline-start-color: oklch(96.2% .018 272.314);</td><td><div style="border-inline-start-color: oklch(96.2% .018 272.314);"></div></td></tr>
    <tr><td>border-s-indigo-100</td><td>border-inline-start-color: oklch(93% .034 272.788);</td><td><div style="border-inline-start-color: oklch(93% .034 272.788);"></div></td></tr>
    <tr><td>border-s-indigo-200</td><td>border-inline-start-color: oklch(87% .065 274.039);</td><td><div style="border-inline-start-color: oklch(87% .065 274.039);"></div></td></tr>
    <tr><td>border-s-indigo-300</td><td>border-inline-start-color: oklch(78.5% .115 274.713);</td><td><div style="border-inline-start-color: oklch(78.5% .115 274.713);"></div></td></tr>
    <tr><td>border-s-indigo-400</td><td>border-inline-start-color: oklch(67.3% .182 276.935);</td><td><div style="border-inline-start-color: oklch(67.3% .182 276.935);"></div></td></tr>
    <tr><td>border-s-indigo-500</td><td>border-inline-start-color: oklch(58.5% .233 277.117);</td><td><div style="border-inline-start-color: oklch(58.5% .233 277.117);"></div></td></tr>
    <tr><td>border-s-indigo-600</td><td>border-inline-start-color: oklch(51.1% .262 276.966);</td><td><div style="border-inline-start-color: oklch(51.1% .262 276.966);"></div></td></tr>
    <tr><td>border-s-indigo-700</td><td>border-inline-start-color: oklch(45.7% .24 277.023);</td><td><div style="border-inline-start-color: oklch(45.7% .24 277.023);"></div></td></tr>
    <tr><td>border-s-indigo-800</td><td>border-inline-start-color: oklch(39.8% .195 277.366);</td><td><div style="border-inline-start-color: oklch(39.8% .195 277.366);"></div></td></tr>
    <tr><td>border-s-indigo-900</td><td>border-inline-start-color: oklch(35.9% .144 278.697);</td><td><div style="border-inline-start-color: oklch(35.9% .144 278.697);"></div></td></tr>
    <tr><td>border-s-indigo-950</td><td>border-inline-start-color: oklch(25.7% .09 281.288);</td><td><div style="border-inline-start-color: oklch(25.7% .09 281.288);"></div></td></tr>
    <tr><td>border-s-violet-50</td><td>border-inline-start-color: oklch(96.9% .016 293.756);</td><td><div style="border-inline-start-color: oklch(96.9% .016 293.756);"></div></td></tr>
    <tr><td>border-s-violet-100</td><td>border-inline-start-color: oklch(94.3% .029 294.588);</td><td><div style="border-inline-start-color: oklch(94.3% .029 294.588);"></div></td></tr>
    <tr><td>border-s-violet-200</td><td>border-inline-start-color: oklch(89.4% .057 293.283);</td><td><div style="border-inline-start-color: oklch(89.4% .057 293.283);"></div></td></tr>
    <tr><td>border-s-violet-300</td><td>border-inline-start-color: oklch(81.1% .111 293.571);</td><td><div style="border-inline-start-color: oklch(81.1% .111 293.571);"></div></td></tr>
    <tr><td>border-s-violet-400</td><td>border-inline-start-color: oklch(70.2% .183 293.541);</td><td><div style="border-inline-start-color: oklch(70.2% .183 293.541);"></div></td></tr>
    <tr><td>border-s-violet-500</td><td>border-inline-start-color: oklch(60.6% .25 292.717);</td><td><div style="border-inline-start-color: oklch(60.6% .25 292.717);"></div></td></tr>
    <tr><td>border-s-violet-600</td><td>border-inline-start-color: oklch(54.1% .281 293.009);</td><td><div style="border-inline-start-color: oklch(54.1% .281 293.009);"></div></td></tr>
    <tr><td>border-s-violet-700</td><td>border-inline-start-color: oklch(49.1% .27 292.581);</td><td><div style="border-inline-start-color: oklch(49.1% .27 292.581);"></div></td></tr>
    <tr><td>border-s-violet-800</td><td>border-inline-start-color: oklch(43.2% .232 292.759);</td><td><div style="border-inline-start-color: oklch(43.2% .232 292.759);"></div></td></tr>
    <tr><td>border-s-violet-900</td><td>border-inline-start-color: oklch(38% .189 293.745);</td><td><div style="border-inline-start-color: oklch(38% .189 293.745);"></div></td></tr>
    <tr><td>border-s-violet-950</td><td>border-inline-start-color: oklch(28.3% .141 291.089);</td><td><div style="border-inline-start-color: oklch(28.3% .141 291.089);"></div></td></tr>
    <tr><td>border-s-purple-50</td><td>border-inline-start-color: oklch(97.7% .014 308.299);</td><td><div style="border-inline-start-color: oklch(97.7% .014 308.299);"></div></td></tr>
    <tr><td>border-s-purple-100</td><td>border-inline-start-color: oklch(94.6% .033 307.174);</td><td><div style="border-inline-start-color: oklch(94.6% .033 307.174);"></div></td></tr>
    <tr><td>border-s-purple-200</td><td>border-inline-start-color: oklch(90.2% .063 306.703);</td><td><div style="border-inline-start-color: oklch(90.2% .063 306.703);"></div></td></tr>
    <tr><td>border-s-purple-300</td><td>border-inline-start-color: oklch(82.7% .119 306.383);</td><td><div style="border-inline-start-color: oklch(82.7% .119 306.383);"></div></td></tr>
    <tr><td>border-s-purple-400</td><td>border-inline-start-color: oklch(71.4% .203 305.504);</td><td><div style="border-inline-start-color: oklch(71.4% .203 305.504);"></div></td></tr>
    <tr><td>border-s-purple-500</td><td>border-inline-start-color: oklch(62.7% .265 303.9);</td><td><div style="border-inline-start-color: oklch(62.7% .265 303.9);"></div></td></tr>
    <tr><td>border-s-purple-600</td><td>border-inline-start-color: oklch(55.8% .288 302.321);</td><td><div style="border-inline-start-color: oklch(55.8% .288 302.321);"></div></td></tr>
    <tr><td>border-s-purple-700</td><td>border-inline-start-color: oklch(49.6% .265 301.924);</td><td><div style="border-inline-start-color: oklch(49.6% .265 301.924);"></div></td></tr>
    <tr><td>border-s-purple-800</td><td>border-inline-start-color: oklch(43.8% .218 303.724);</td><td><div style="border-inline-start-color: oklch(43.8% .218 303.724);"></div></td></tr>
    <tr><td>border-s-purple-900</td><td>border-inline-start-color: oklch(38.1% .176 304.987);</td><td><div style="border-inline-start-color: oklch(38.1% .176 304.987);"></div></td></tr>
    <tr><td>border-s-purple-950</td><td>border-inline-start-color: oklch(29.1% .149 302.717);</td><td><div style="border-inline-start-color: oklch(29.1% .149 302.717);"></div></td></tr>
    <tr><td>border-s-fuchsia-50</td><td>border-inline-start-color: oklch(97.7% .017 320.058);</td><td><div style="border-inline-start-color: oklch(97.7% .017 320.058);"></div></td></tr>
    <tr><td>border-s-fuchsia-100</td><td>border-inline-start-color: oklch(95.2% .037 318.852);</td><td><div style="border-inline-start-color: oklch(95.2% .037 318.852);"></div></td></tr>
    <tr><td>border-s-fuchsia-200</td><td>border-inline-start-color: oklch(90.3% .076 319.62);</td><td><div style="border-inline-start-color: oklch(90.3% .076 319.62);"></div></td></tr>
    <tr><td>border-s-fuchsia-300</td><td>border-inline-start-color: oklch(83.3% .145 321.434);</td><td><div style="border-inline-start-color: oklch(83.3% .145 321.434);"></div></td></tr>
    <tr><td>border-s-fuchsia-400</td><td>border-inline-start-color: oklch(74% .238 322.16);</td><td><div style="border-inline-start-color: oklch(74% .238 322.16);"></div></td></tr>
    <tr><td>border-s-fuchsia-500</td><td>border-inline-start-color: oklch(66.7% .295 322.15);</td><td><div style="border-inline-start-color: oklch(66.7% .295 322.15);"></div></td></tr>
    <tr><td>border-s-fuchsia-600</td><td>border-inline-start-color: oklch(59.1% .293 322.896);</td><td><div style="border-inline-start-color: oklch(59.1% .293 322.896);"></div></td></tr>
    <tr><td>border-s-fuchsia-700</td><td>border-inline-start-color: oklch(51.8% .253 323.949);</td><td><div style="border-inline-start-color: oklch(51.8% .253 323.949);"></div></td></tr>
    <tr><td>border-s-fuchsia-800</td><td>border-inline-start-color: oklch(45.2% .211 324.591);</td><td><div style="border-inline-start-color: oklch(45.2% .211 324.591);"></div></td></tr>
    <tr><td>border-s-fuchsia-900</td><td>border-inline-start-color: oklch(40.1% .17 325.612);</td><td><div style="border-inline-start-color: oklch(40.1% .17 325.612);"></div></td></tr>
    <tr><td>border-s-fuchsia-950</td><td>border-inline-start-color: oklch(29.3% .136 325.661);</td><td><div style="border-inline-start-color: oklch(29.3% .136 325.661);"></div></td></tr>
    <tr><td>border-s-pink-50</td><td>border-inline-start-color: oklch(97.1% .014 343.198);</td><td><div style="border-inline-start-color: oklch(97.1% .014 343.198);"></div></td></tr>
    <tr><td>border-s-pink-100</td><td>border-inline-start-color: oklch(94.8% .028 342.258);</td><td><div style="border-inline-start-color: oklch(94.8% .028 342.258);"></div></td></tr>
    <tr><td>border-s-pink-200</td><td>border-inline-start-color: oklch(89.9% .061 343.231);</td><td><div style="border-inline-start-color: oklch(89.9% .061 343.231);"></div></td></tr>
    <tr><td>border-s-pink-300</td><td>border-inline-start-color: oklch(82.3% .12 346.018);</td><td><div style="border-inline-start-color: oklch(82.3% .12 346.018);"></div></td></tr>
    <tr><td>border-s-pink-400</td><td>border-inline-start-color: oklch(71.8% .202 349.761);</td><td><div style="border-inline-start-color: oklch(71.8% .202 349.761);"></div></td></tr>
    <tr><td>border-s-pink-500</td><td>border-inline-start-color: oklch(65.6% .241 354.308);</td><td><div style="border-inline-start-color: oklch(65.6% .241 354.308);"></div></td></tr>
    <tr><td>border-s-pink-600</td><td>border-inline-start-color: oklch(59.2% .249 .584);</td><td><div style="border-inline-start-color: oklch(59.2% .249 .584);"></div></td></tr>
    <tr><td>border-s-pink-700</td><td>border-inline-start-color: oklch(52.5% .223 3.958);</td><td><div style="border-inline-start-color: oklch(52.5% .223 3.958);"></div></td></tr>
    <tr><td>border-s-pink-800</td><td>border-inline-start-color: oklch(45.9% .187 3.815);</td><td><div style="border-inline-start-color: oklch(45.9% .187 3.815);"></div></td></tr>
    <tr><td>border-s-pink-900</td><td>border-inline-start-color: oklch(40.8% .153 2.432);</td><td><div style="border-inline-start-color: oklch(40.8% .153 2.432);"></div></td></tr>
    <tr><td>border-s-pink-950</td><td>border-inline-start-color: oklch(28.4% .109 3.907);</td><td><div style="border-inline-start-color: oklch(28.4% .109 3.907);"></div></td></tr>
    <tr><td>border-s-rose-50</td><td>border-inline-start-color: oklch(96.9% .015 12.422);</td><td><div style="border-inline-start-color: oklch(96.9% .015 12.422);"></div></td></tr>
    <tr><td>border-s-rose-100</td><td>border-inline-start-color: oklch(94.1% .03 12.58);</td><td><div style="border-inline-start-color: oklch(94.1% .03 12.58);"></div></td></tr>
    <tr><td>border-s-rose-200</td><td>border-inline-start-color: oklch(89.2% .058 10.001);</td><td><div style="border-inline-start-color: oklch(89.2% .058 10.001);"></div></td></tr>
    <tr><td>border-s-rose-300</td><td>border-inline-start-color: oklch(81% .117 11.638);</td><td><div style="border-inline-start-color: oklch(81% .117 11.638);"></div></td></tr>
    <tr><td>border-s-rose-400</td><td>border-inline-start-color: oklch(71.2% .194 13.428);</td><td><div style="border-inline-start-color: oklch(71.2% .194 13.428);"></div></td></tr>
    <tr><td>border-s-rose-500</td><td>border-inline-start-color: oklch(64.5% .246 16.439);</td><td><div style="border-inline-start-color: oklch(64.5% .246 16.439);"></div></td></tr>
    <tr><td>border-s-rose-600</td><td>border-inline-start-color: oklch(58.6% .253 17.585);</td><td><div style="border-inline-start-color: oklch(58.6% .253 17.585);"></div></td></tr>
    <tr><td>border-s-rose-700</td><td>border-inline-start-color: oklch(51.4% .222 16.935);</td><td><div style="border-inline-start-color: oklch(51.4% .222 16.935);"></div></td></tr>
    <tr><td>border-s-rose-800</td><td>border-inline-start-color: oklch(45.5% .188 13.697);</td><td><div style="border-inline-start-color: oklch(45.5% .188 13.697);"></div></td></tr>
    <tr><td>border-s-rose-900</td><td>border-inline-start-color: oklch(41% .159 10.272);</td><td><div style="border-inline-start-color: oklch(41% .159 10.272);"></div></td></tr>
    <tr><td>border-s-rose-950</td><td>border-inline-start-color: oklch(27.1% .105 12.094);</td><td><div style="border-inline-start-color: oklch(27.1% .105 12.094);"></div></td></tr>
    <tr><td>border-s-slate-50</td><td>border-inline-start-color: oklch(98.4% .003 247.858);</td><td><div style="border-inline-start-color: oklch(98.4% .003 247.858);"></div></td></tr>
    <tr><td>border-s-slate-100</td><td>border-inline-start-color: oklch(96.8% .007 247.896);</td><td><div style="border-inline-start-color: oklch(96.8% .007 247.896);"></div></td></tr>
    <tr><td>border-s-slate-200</td><td>border-inline-start-color: oklch(92.9% .013 255.508);</td><td><div style="border-inline-start-color: oklch(92.9% .013 255.508);"></div></td></tr>
    <tr><td>border-s-slate-300</td><td>border-inline-start-color: oklch(86.9% .022 252.894);</td><td><div style="border-inline-start-color: oklch(86.9% .022 252.894);"></div></td></tr>
    <tr><td>border-s-slate-400</td><td>border-inline-start-color: oklch(70.4% .04 256.788);</td><td><div style="border-inline-start-color: oklch(70.4% .04 256.788);"></div></td></tr>
    <tr><td>border-s-slate-500</td><td>border-inline-start-color: oklch(55.4% .046 257.417);</td><td><div style="border-inline-start-color: oklch(55.4% .046 257.417);"></div></td></tr>
    <tr><td>border-s-slate-600</td><td>border-inline-start-color: oklch(44.6% .043 257.281);</td><td><div style="border-inline-start-color: oklch(44.6% .043 257.281);"></div></td></tr>
    <tr><td>border-s-slate-700</td><td>border-inline-start-color: oklch(37.2% .044 257.287);</td><td><div style="border-inline-start-color: oklch(37.2% .044 257.287);"></div></td></tr>
    <tr><td>border-s-slate-800</td><td>border-inline-start-color: oklch(27.9% .041 260.031);</td><td><div style="border-inline-start-color: oklch(27.9% .041 260.031);"></div></td></tr>
    <tr><td>border-s-slate-900</td><td>border-inline-start-color: oklch(20.8% .042 265.755);</td><td><div style="border-inline-start-color: oklch(20.8% .042 265.755);"></div></td></tr>
    <tr><td>border-s-slate-950</td><td>border-inline-start-color: oklch(12.9% .042 264.695);</td><td><div style="border-inline-start-color: oklch(12.9% .042 264.695);"></div></td></tr>
    <tr><td>border-s-gray-50</td><td>border-inline-start-color: oklch(98.5% .002 247.839);</td><td><div style="border-inline-start-color: oklch(98.5% .002 247.839);"></div></td></tr>
    <tr><td>border-s-gray-100</td><td>border-inline-start-color: oklch(96.7% .003 264.542);</td><td><div style="border-inline-start-color: oklch(96.7% .003 264.542);"></div></td></tr>
    <tr><td>border-s-gray-200</td><td>border-inline-start-color: oklch(92.8% .006 264.531);</td><td><div style="border-inline-start-color: oklch(92.8% .006 264.531);"></div></td></tr>
    <tr><td>border-s-gray-300</td><td>border-inline-start-color: oklch(87.2% .01 258.338);</td><td><div style="border-inline-start-color: oklch(87.2% .01 258.338);"></div></td></tr>
    <tr><td>border-s-gray-400</td><td>border-inline-start-color: oklch(70.7% .022 261.325);</td><td><div style="border-inline-start-color: oklch(70.7% .022 261.325);"></div></td></tr>
    <tr><td>border-s-gray-500</td><td>border-inline-start-color: oklch(55.1% .027 264.364);</td><td><div style="border-inline-start-color: oklch(55.1% .027 264.364);"></div></td></tr>
    <tr><td>border-s-gray-600</td><td>border-inline-start-color: oklch(44.6% .03 256.802);</td><td><div style="border-inline-start-color: oklch(44.6% .03 256.802);"></div></td></tr>
    <tr><td>border-s-gray-700</td><td>border-inline-start-color: oklch(37.3% .034 259.733);</td><td><div style="border-inline-start-color: oklch(37.3% .034 259.733);"></div></td></tr>
    <tr><td>border-s-gray-800</td><td>border-inline-start-color: oklch(27.8% .033 256.848);</td><td><div style="border-inline-start-color: oklch(27.8% .033 256.848);"></div></td></tr>
    <tr><td>border-s-gray-900</td><td>border-inline-start-color: oklch(21% .034 264.665);</td><td><div style="border-inline-start-color: oklch(21% .034 264.665);"></div></td></tr>
    <tr><td>border-s-gray-950</td><td>border-inline-start-color: oklch(13% .028 261.692);</td><td><div style="border-inline-start-color: oklch(13% .028 261.692);"></div></td></tr>
    <tr><td>border-s-zinc-50</td><td>border-inline-start-color: oklch(98.5% 0 0);</td><td><div style="border-inline-start-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-s-zinc-100</td><td>border-inline-start-color: oklch(96.7% .001 286.375);</td><td><div style="border-inline-start-color: oklch(96.7% .001 286.375);"></div></td></tr>
    <tr><td>border-s-zinc-200</td><td>border-inline-start-color: oklch(92% .004 286.32);</td><td><div style="border-inline-start-color: oklch(92% .004 286.32);"></div></td></tr>
    <tr><td>border-s-zinc-300</td><td>border-inline-start-color: oklch(87.1% .006 286.286);</td><td><div style="border-inline-start-color: oklch(87.1% .006 286.286);"></div></td></tr>
    <tr><td>border-s-zinc-400</td><td>border-inline-start-color: oklch(70.5% .015 286.067);</td><td><div style="border-inline-start-color: oklch(70.5% .015 286.067);"></div></td></tr>
    <tr><td>border-s-zinc-500</td><td>border-inline-start-color: oklch(55.2% .016 285.938);</td><td><div style="border-inline-start-color: oklch(55.2% .016 285.938);"></div></td></tr>
    <tr><td>border-s-zinc-600</td><td>border-inline-start-color: oklch(44.2% .017 285.786);</td><td><div style="border-inline-start-color: oklch(44.2% .017 285.786);"></div></td></tr>
    <tr><td>border-s-zinc-700</td><td>border-inline-start-color: oklch(37% .013 285.805);</td><td><div style="border-inline-start-color: oklch(37% .013 285.805);"></div></td></tr>
    <tr><td>border-s-zinc-800</td><td>border-inline-start-color: oklch(27.4% .006 286.033);</td><td><div style="border-inline-start-color: oklch(27.4% .006 286.033);"></div></td></tr>
    <tr><td>border-s-zinc-900</td><td>border-inline-start-color: oklch(21% .006 285.885);</td><td><div style="border-inline-start-color: oklch(21% .006 285.885);"></div></td></tr>
    <tr><td>border-s-zinc-950</td><td>border-inline-start-color: oklch(14.1% .005 285.823);</td><td><div style="border-inline-start-color: oklch(14.1% .005 285.823);"></div></td></tr>
    <tr><td>border-s-neutral-50</td><td>border-inline-start-color: oklch(98.5% 0 0);</td><td><div style="border-inline-start-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-100</td><td>border-inline-start-color: oklch(97% 0 0);</td><td><div style="border-inline-start-color: oklch(97% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-200</td><td>border-inline-start-color: oklch(92.2% 0 0);</td><td><div style="border-inline-start-color: oklch(92.2% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-300</td><td>border-inline-start-color: oklch(87% 0 0);</td><td><div style="border-inline-start-color: oklch(87% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-400</td><td>border-inline-start-color: oklch(70.8% 0 0);</td><td><div style="border-inline-start-color: oklch(70.8% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-500</td><td>border-inline-start-color: oklch(55.6% 0 0);</td><td><div style="border-inline-start-color: oklch(55.6% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-600</td><td>border-inline-start-color: oklch(43.9% 0 0);</td><td><div style="border-inline-start-color: oklch(43.9% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-700</td><td>border-inline-start-color: oklch(37.1% 0 0);</td><td><div style="border-inline-start-color: oklch(37.1% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-800</td><td>border-inline-start-color: oklch(26.9% 0 0);</td><td><div style="border-inline-start-color: oklch(26.9% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-900</td><td>border-inline-start-color: oklch(20.5% 0 0);</td><td><div style="border-inline-start-color: oklch(20.5% 0 0);"></div></td></tr>
    <tr><td>border-s-neutral-950</td><td>border-inline-start-color: oklch(14.5% 0 0);</td><td><div style="border-inline-start-color: oklch(14.5% 0 0);"></div></td></tr>
    <tr><td>border-s-stone-50</td><td>border-inline-start-color: oklch(98.5% .001 106.423);</td><td><div style="border-inline-start-color: oklch(98.5% .001 106.423);"></div></td></tr>
    <tr><td>border-s-stone-100</td><td>border-inline-start-color: oklch(97% .001 106.424);</td><td><div style="border-inline-start-color: oklch(97% .001 106.424);"></div></td></tr>
    <tr><td>border-s-stone-200</td><td>border-inline-start-color: oklch(92.3% .003 48.717);</td><td><div style="border-inline-start-color: oklch(92.3% .003 48.717);"></div></td></tr>
    <tr><td>border-s-stone-300</td><td>border-inline-start-color: oklch(86.9% .005 56.366);</td><td><div style="border-inline-start-color: oklch(86.9% .005 56.366);"></div></td></tr>
    <tr><td>border-s-stone-400</td><td>border-inline-start-color: oklch(70.9% .01 56.259);</td><td><div style="border-inline-start-color: oklch(70.9% .01 56.259);"></div></td></tr>
    <tr><td>border-s-stone-500</td><td>border-inline-start-color: oklch(55.3% .013 58.071);</td><td><div style="border-inline-start-color: oklch(55.3% .013 58.071);"></div></td></tr>
    <tr><td>border-s-stone-600</td><td>border-inline-start-color: oklch(44.4% .011 73.639);</td><td><div style="border-inline-start-color: oklch(44.4% .011 73.639);"></div></td></tr>
    <tr><td>border-s-stone-700</td><td>border-inline-start-color: oklch(37.4% .01 67.558);</td><td><div style="border-inline-start-color: oklch(37.4% .01 67.558);"></div></td></tr>
    <tr><td>border-s-stone-800</td><td>border-inline-start-color: oklch(26.8% .007 34.298);</td><td><div style="border-inline-start-color: oklch(26.8% .007 34.298);"></div></td></tr>
    <tr><td>border-s-stone-900</td><td>border-inline-start-color: oklch(21.6% .006 56.043);</td><td><div style="border-inline-start-color: oklch(21.6% .006 56.043);"></div></td></tr>
    <tr><td>border-s-stone-950</td><td>border-inline-start-color: oklch(14.7% .004 49.25);</td><td><div style="border-inline-start-color: oklch(14.7% .004 49.25);"></div></td></tr>
    <tr><td>border-s-black</td><td>border-inline-start-color: #000;</td><td><div style="border-inline-start-color: #000;"></div></td></tr>
    <tr><td>border-s-white</td><td>border-inline-start-color: #fff;</td><td><div style="border-inline-start-color: #fff;"></div></td></tr>
    <tr><td>border-e-inherit</td><td>border-inline-end-color: inherit;</td><td><div style="border-inline-end-color: inherit;"></div></td></tr>
    <tr><td>border-e-current</td><td>border-inline-end-color: currentColor;</td><td><div style="border-inline-end-color: currentColor;"></div></td></tr>
    <tr><td>border-e-transparent</td><td>border-inline-end-color: transparent;</td><td><div style="border-inline-end-color: transparent;"></div></td></tr>
    <tr><td>border-e-red-50</td><td>border-inline-end-color: oklch(97.1% .013 17.38);</td><td><div style="border-inline-end-color: oklch(97.1% .013 17.38);"></div></td></tr>
    <tr><td>border-e-red-100</td><td>border-inline-end-color: oklch(93.6% .032 17.717);</td><td><div style="border-inline-end-color: oklch(93.6% .032 17.717);"></div></td></tr>
    <tr><td>border-e-red-200</td><td>border-inline-end-color: oklch(88.5% .062 18.334);</td><td><div style="border-inline-end-color: oklch(88.5% .062 18.334);"></div></td></tr>
    <tr><td>border-e-red-300</td><td>border-inline-end-color: oklch(80.8% .114 19.571);</td><td><div style="border-inline-end-color: oklch(80.8% .114 19.571);"></div></td></tr>
    <tr><td>border-e-red-400</td><td>border-inline-end-color: oklch(70.4% .191 22.216);</td><td><div style="border-inline-end-color: oklch(70.4% .191 22.216);"></div></td></tr>
    <tr><td>border-e-red-500</td><td>border-inline-end-color: oklch(63.7% .237 25.331);</td><td><div style="border-inline-end-color: oklch(63.7% .237 25.331);"></div></td></tr>
    <tr><td>border-e-red-600</td><td>border-inline-end-color: oklch(57.7% .245 27.325);</td><td><div style="border-inline-end-color: oklch(57.7% .245 27.325);"></div></td></tr>
    <tr><td>border-e-red-700</td><td>border-inline-end-color: oklch(50.5% .213 27.518);</td><td><div style="border-inline-end-color: oklch(50.5% .213 27.518);"></div></td></tr>
    <tr><td>border-e-red-800</td><td>border-inline-end-color: oklch(44.4% .177 26.899);</td><td><div style="border-inline-end-color: oklch(44.4% .177 26.899);"></div></td></tr>
    <tr><td>border-e-red-900</td><td>border-inline-end-color: oklch(39.6% .141 25.723);</td><td><div style="border-inline-end-color: oklch(39.6% .141 25.723);"></div></td></tr>
    <tr><td>border-e-red-950</td><td>border-inline-end-color: oklch(25.8% .092 26.042);</td><td><div style="border-inline-end-color: oklch(25.8% .092 26.042);"></div></td></tr>
    <tr><td>border-e-orange-50</td><td>border-inline-end-color: oklch(98% .016 73.684);</td><td><div style="border-inline-end-color: oklch(98% .016 73.684);"></div></td></tr>
    <tr><td>border-e-orange-100</td><td>border-inline-end-color: oklch(95.4% .038 75.164);</td><td><div style="border-inline-end-color: oklch(95.4% .038 75.164);"></div></td></tr>
    <tr><td>border-e-orange-200</td><td>border-inline-end-color: oklch(90.1% .076 70.697);</td><td><div style="border-inline-end-color: oklch(90.1% .076 70.697);"></div></td></tr>
    <tr><td>border-e-orange-300</td><td>border-inline-end-color: oklch(83.7% .128 66.29);</td><td><div style="border-inline-end-color: oklch(83.7% .128 66.29);"></div></td></tr>
    <tr><td>border-e-orange-400</td><td>border-inline-end-color: oklch(75% .183 55.934);</td><td><div style="border-inline-end-color: oklch(75% .183 55.934);"></div></td></tr>
    <tr><td>border-e-orange-500</td><td>border-inline-end-color: oklch(70.5% .213 47.604);</td><td><div style="border-inline-end-color: oklch(70.5% .213 47.604);"></div></td></tr>
    <tr><td>border-e-orange-600</td><td>border-inline-end-color: oklch(64.6% .222 41.116);</td><td><div style="border-inline-end-color: oklch(64.6% .222 41.116);"></div></td></tr>
    <tr><td>border-e-orange-700</td><td>border-inline-end-color: oklch(55.3% .195 38.402);</td><td><div style="border-inline-end-color: oklch(55.3% .195 38.402);"></div></td></tr>
    <tr><td>border-e-orange-800</td><td>border-inline-end-color: oklch(47% .157 37.304);</td><td><div style="border-inline-end-color: oklch(47% .157 37.304);"></div></td></tr>
    <tr><td>border-e-orange-900</td><td>border-inline-end-color: oklch(40.8% .123 38.172);</td><td><div style="border-inline-end-color: oklch(40.8% .123 38.172);"></div></td></tr>
    <tr><td>border-e-orange-950</td><td>border-inline-end-color: oklch(26.6% .079 36.259);</td><td><div style="border-inline-end-color: oklch(26.6% .079 36.259);"></div></td></tr>
    <tr><td>border-e-amber-50</td><td>border-inline-end-color: oklch(98.7% .022 95.277);</td><td><div style="border-inline-end-color: oklch(98.7% .022 95.277);"></div></td></tr>
    <tr><td>border-e-amber-100</td><td>border-inline-end-color: oklch(96.2% .059 95.617);</td><td><div style="border-inline-end-color: oklch(96.2% .059 95.617);"></div></td></tr>
    <tr><td>border-e-amber-200</td><td>border-inline-end-color: oklch(92.4% .12 95.746);</td><td><div style="border-inline-end-color: oklch(92.4% .12 95.746);"></div></td></tr>
    <tr><td>border-e-amber-300</td><td>border-inline-end-color: oklch(87.9% .169 91.605);</td><td><div style="border-inline-end-color: oklch(87.9% .169 91.605);"></div></td></tr>
    <tr><td>border-e-amber-400</td><td>border-inline-end-color: oklch(82.8% .189 84.429);</td><td><div style="border-inline-end-color: oklch(82.8% .189 84.429);"></div></td></tr>
    <tr><td>border-e-amber-500</td><td>border-inline-end-color: oklch(76.9% .188 70.08);</td><td><div style="border-inline-end-color: oklch(76.9% .188 70.08);"></div></td></tr>
    <tr><td>border-e-amber-600</td><td>border-inline-end-color: oklch(66.6% .179 58.318);</td><td><div style="border-inline-end-color: oklch(66.6% .179 58.318);"></div></td></tr>
    <tr><td>border-e-amber-700</td><td>border-inline-end-color: oklch(55.5% .163 48.998);</td><td><div style="border-inline-end-color: oklch(55.5% .163 48.998);"></div></td></tr>
    <tr><td>border-e-amber-800</td><td>border-inline-end-color: oklch(47.3% .137 46.201);</td><td><div style="border-inline-end-color: oklch(47.3% .137 46.201);"></div></td></tr>
    <tr><td>border-e-amber-900</td><td>border-inline-end-color: oklch(41.4% .112 45.904);</td><td><div style="border-inline-end-color: oklch(41.4% .112 45.904);"></div></td></tr>
    <tr><td>border-e-amber-950</td><td>border-inline-end-color: oklch(27.9% .077 45.635);</td><td><div style="border-inline-end-color: oklch(27.9% .077 45.635);"></div></td></tr>
    <tr><td>border-e-yellow-50</td><td>border-inline-end-color: oklch(98.7% .026 102.212);</td><td><div style="border-inline-end-color: oklch(98.7% .026 102.212);"></div></td></tr>
    <tr><td>border-e-yellow-100</td><td>border-inline-end-color: oklch(97.3% .071 103.193);</td><td><div style="border-inline-end-color: oklch(97.3% .071 103.193);"></div></td></tr>
    <tr><td>border-e-yellow-200</td><td>border-inline-end-color: oklch(94.5% .129 101.54);</td><td><div style="border-inline-end-color: oklch(94.5% .129 101.54);"></div></td></tr>
    <tr><td>border-e-yellow-300</td><td>border-inline-end-color: oklch(90.5% .182 98.111);</td><td><div style="border-inline-end-color: oklch(90.5% .182 98.111);"></div></td></tr>
    <tr><td>border-e-yellow-400</td><td>border-inline-end-color: oklch(85.2% .199 91.936);</td><td><div style="border-inline-end-color: oklch(85.2% .199 91.936);"></div></td></tr>
    <tr><td>border-e-yellow-500</td><td>border-inline-end-color: oklch(79.5% .184 86.047);</td><td><div style="border-inline-end-color: oklch(79.5% .184 86.047);"></div></td></tr>
    <tr><td>border-e-yellow-600</td><td>border-inline-end-color: oklch(68.1% .162 75.834);</td><td><div style="border-inline-end-color: oklch(68.1% .162 75.834);"></div></td></tr>
    <tr><td>border-e-yellow-700</td><td>border-inline-end-color: oklch(55.4% .135 66.442);</td><td><div style="border-inline-end-color: oklch(55.4% .135 66.442);"></div></td></tr>
    <tr><td>border-e-yellow-800</td><td>border-inline-end-color: oklch(47.6% .114 61.907);</td><td><div style="border-inline-end-color: oklch(47.6% .114 61.907);"></div></td></tr>
    <tr><td>border-e-yellow-900</td><td>border-inline-end-color: oklch(42.1% .095 57.708);</td><td><div style="border-inline-end-color: oklch(42.1% .095 57.708);"></div></td></tr>
    <tr><td>border-e-yellow-950</td><td>border-inline-end-color: oklch(28.6% .066 53.813);</td><td><div style="border-inline-end-color: oklch(28.6% .066 53.813);"></div></td></tr>
    <tr><td>border-e-lime-50</td><td>border-inline-end-color: oklch(98.6% .031 120.757);</td><td><div style="border-inline-end-color: oklch(98.6% .031 120.757);"></div></td></tr>
    <tr><td>border-e-lime-100</td><td>border-inline-end-color: oklch(96.7% .067 122.328);</td><td><div style="border-inline-end-color: oklch(96.7% .067 122.328);"></div></td></tr>
    <tr><td>border-e-lime-200</td><td>border-inline-end-color: oklch(93.8% .127 124.321);</td><td><div style="border-inline-end-color: oklch(93.8% .127 124.321);"></div></td></tr>
    <tr><td>border-e-lime-300</td><td>border-inline-end-color: oklch(89.7% .196 126.665);</td><td><div style="border-inline-end-color: oklch(89.7% .196 126.665);"></div></td></tr>
    <tr><td>border-e-lime-400</td><td>border-inline-end-color: oklch(84.1% .238 128.85);</td><td><div style="border-inline-end-color: oklch(84.1% .238 128.85);"></div></td></tr>
    <tr><td>border-e-lime-500</td><td>border-inline-end-color: oklch(76.8% .233 130.85);</td><td><div style="border-inline-end-color: oklch(76.8% .233 130.85);"></div></td></tr>
    <tr><td>border-e-lime-600</td><td>border-inline-end-color: oklch(64.8% .2 131.684);</td><td><div style="border-inline-end-color: oklch(64.8% .2 131.684);"></div></td></tr>
    <tr><td>border-e-lime-700</td><td>border-inline-end-color: oklch(53.2% .157 131.589);</td><td><div style="border-inline-end-color: oklch(53.2% .157 131.589);"></div></td></tr>
    <tr><td>border-e-lime-800</td><td>border-inline-end-color: oklch(45.3% .124 130.933);</td><td><div style="border-inline-end-color: oklch(45.3% .124 130.933);"></div></td></tr>
    <tr><td>border-e-lime-900</td><td>border-inline-end-color: oklch(40.5% .101 131.063);</td><td><div style="border-inline-end-color: oklch(40.5% .101 131.063);"></div></td></tr>
    <tr><td>border-e-lime-950</td><td>border-inline-end-color: oklch(27.4% .072 132.109);</td><td><div style="border-inline-end-color: oklch(27.4% .072 132.109);"></div></td></tr>
    <tr><td>border-e-green-50</td><td>border-inline-end-color: oklch(98.2% .018 155.826);</td><td><div style="border-inline-end-color: oklch(98.2% .018 155.826);"></div></td></tr>
    <tr><td>border-e-green-100</td><td>border-inline-end-color: oklch(96.2% .044 156.743);</td><td><div style="border-inline-end-color: oklch(96.2% .044 156.743);"></div></td></tr>
    <tr><td>border-e-green-200</td><td>border-inline-end-color: oklch(92.5% .084 155.995);</td><td><div style="border-inline-end-color: oklch(92.5% .084 155.995);"></div></td></tr>
    <tr><td>border-e-green-300</td><td>border-inline-end-color: oklch(87.1% .15 154.449);</td><td><div style="border-inline-end-color: oklch(87.1% .15 154.449);"></div></td></tr>
    <tr><td>border-e-green-400</td><td>border-inline-end-color: oklch(79.2% .209 151.711);</td><td><div style="border-inline-end-color: oklch(79.2% .209 151.711);"></div></td></tr>
    <tr><td>border-e-green-500</td><td>border-inline-end-color: oklch(72.3% .219 149.579);</td><td><div style="border-inline-end-color: oklch(72.3% .219 149.579);"></div></td></tr>
    <tr><td>border-e-green-600</td><td>border-inline-end-color: oklch(62.7% .194 149.214);</td><td><div style="border-inline-end-color: oklch(62.7% .194 149.214);"></div></td></tr>
    <tr><td>border-e-green-700</td><td>border-inline-end-color: oklch(52.7% .154 150.069);</td><td><div style="border-inline-end-color: oklch(52.7% .154 150.069);"></div></td></tr>
    <tr><td>border-e-green-800</td><td>border-inline-end-color: oklch(44.8% .119 151.328);</td><td><div style="border-inline-end-color: oklch(44.8% .119 151.328);"></div></td></tr>
    <tr><td>border-e-green-900</td><td>border-inline-end-color: oklch(39.3% .095 152.535);</td><td><div style="border-inline-end-color: oklch(39.3% .095 152.535);"></div></td></tr>
    <tr><td>border-e-green-950</td><td>border-inline-end-color: oklch(26.6% .065 152.934);</td><td><div style="border-inline-end-color: oklch(26.6% .065 152.934);"></div></td></tr>
    <tr><td>border-e-emerald-50</td><td>border-inline-end-color: oklch(97.9% .021 166.113);</td><td><div style="border-inline-end-color: oklch(97.9% .021 166.113);"></div></td></tr>
    <tr><td>border-e-emerald-100</td><td>border-inline-end-color: oklch(95% .052 163.051);</td><td><div style="border-inline-end-color: oklch(95% .052 163.051);"></div></td></tr>
    <tr><td>border-e-emerald-200</td><td>border-inline-end-color: oklch(90.5% .093 164.15);</td><td><div style="border-inline-end-color: oklch(90.5% .093 164.15);"></div></td></tr>
    <tr><td>border-e-emerald-300</td><td>border-inline-end-color: oklch(84.5% .143 164.978);</td><td><div style="border-inline-end-color: oklch(84.5% .143 164.978);"></div></td></tr>
    <tr><td>border-e-emerald-400</td><td>border-inline-end-color: oklch(76.5% .177 163.223);</td><td><div style="border-inline-end-color: oklch(76.5% .177 163.223);"></div></td></tr>
    <tr><td>border-e-emerald-500</td><td>border-inline-end-color: oklch(69.6% .17 162.48);</td><td><div style="border-inline-end-color: oklch(69.6% .17 162.48);"></div></td></tr>
    <tr><td>border-e-emerald-600</td><td>border-inline-end-color: oklch(59.6% .145 163.225);</td><td><div style="border-inline-end-color: oklch(59.6% .145 163.225);"></div></td></tr>
    <tr><td>border-e-emerald-700</td><td>border-inline-end-color: oklch(50.8% .118 165.612);</td><td><div style="border-inline-end-color: oklch(50.8% .118 165.612);"></div></td></tr>
    <tr><td>border-e-emerald-800</td><td>border-inline-end-color: oklch(43.2% .095 166.913);</td><td><div style="border-inline-end-color: oklch(43.2% .095 166.913);"></div></td></tr>
    <tr><td>border-e-emerald-900</td><td>border-inline-end-color: oklch(37.8% .077 168.94);</td><td><div style="border-inline-end-color: oklch(37.8% .077 168.94);"></div></td></tr>
    <tr><td>border-e-emerald-950</td><td>border-inline-end-color: oklch(26.2% .051 172.552);</td><td><div style="border-inline-end-color: oklch(26.2% .051 172.552);"></div></td></tr>
    <tr><td>border-e-teal-50</td><td>border-inline-end-color: oklch(98.4% .014 180.72);</td><td><div style="border-inline-end-color: oklch(98.4% .014 180.72);"></div></td></tr>
    <tr><td>border-e-teal-100</td><td>border-inline-end-color: oklch(95.3% .051 180.801);</td><td><div style="border-inline-end-color: oklch(95.3% .051 180.801);"></div></td></tr>
    <tr><td>border-e-teal-200</td><td>border-inline-end-color: oklch(91% .096 180.426);</td><td><div style="border-inline-end-color: oklch(91% .096 180.426);"></div></td></tr>
    <tr><td>border-e-teal-300</td><td>border-inline-end-color: oklch(85.5% .138 181.071);</td><td><div style="border-inline-end-color: oklch(85.5% .138 181.071);"></div></td></tr>
    <tr><td>border-e-teal-400</td><td>border-inline-end-color: oklch(77.7% .152 181.912);</td><td><div style="border-inline-end-color: oklch(77.7% .152 181.912);"></div></td></tr>
    <tr><td>border-e-teal-500</td><td>border-inline-end-color: oklch(70.4% .14 182.503);</td><td><div style="border-inline-end-color: oklch(70.4% .14 182.503);"></div></td></tr>
    <tr><td>border-e-teal-600</td><td>border-inline-end-color: oklch(60% .118 184.704);</td><td><div style="border-inline-end-color: oklch(60% .118 184.704);"></div></td></tr>
    <tr><td>border-e-teal-700</td><td>border-inline-end-color: oklch(51.1% .096 186.391);</td><td><div style="border-inline-end-color: oklch(51.1% .096 186.391);"></div></td></tr>
    <tr><td>border-e-teal-800</td><td>border-inline-end-color: oklch(43.7% .078 188.216);</td><td><div style="border-inline-end-color: oklch(43.7% .078 188.216);"></div></td></tr>
    <tr><td>border-e-teal-900</td><td>border-inline-end-color: oklch(38.6% .063 188.416);</td><td><div style="border-inline-end-color: oklch(38.6% .063 188.416);"></div></td></tr>
    <tr><td>border-e-teal-950</td><td>border-inline-end-color: oklch(27.7% .046 192.524);</td><td><div style="border-inline-end-color: oklch(27.7% .046 192.524);"></div></td></tr>
    <tr><td>border-e-cyan-50</td><td>border-inline-end-color: oklch(98.4% .019 200.873);</td><td><div style="border-inline-end-color: oklch(98.4% .019 200.873);"></div></td></tr>
    <tr><td>border-e-cyan-100</td><td>border-inline-end-color: oklch(95.6% .045 203.388);</td><td><div style="border-inline-end-color: oklch(95.6% .045 203.388);"></div></td></tr>
    <tr><td>border-e-cyan-200</td><td>border-inline-end-color: oklch(91.7% .08 205.041);</td><td><div style="border-inline-end-color: oklch(91.7% .08 205.041);"></div></td></tr>
    <tr><td>border-e-cyan-300</td><td>border-inline-end-color: oklch(86.5% .127 207.078);</td><td><div style="border-inline-end-color: oklch(86.5% .127 207.078);"></div></td></tr>
    <tr><td>border-e-cyan-400</td><td>border-inline-end-color: oklch(78.9% .154 211.53);</td><td><div style="border-inline-end-color: oklch(78.9% .154 211.53);"></div></td></tr>
    <tr><td>border-e-cyan-500</td><td>border-inline-end-color: oklch(71.5% .143 215.221);</td><td><div style="border-inline-end-color: oklch(71.5% .143 215.221);"></div></td></tr>
    <tr><td>border-e-cyan-600</td><td>border-inline-end-color: oklch(60.9% .126 221.723);</td><td><div style="border-inline-end-color: oklch(60.9% .126 221.723);"></div></td></tr>
    <tr><td>border-e-cyan-700</td><td>border-inline-end-color: oklch(52% .105 223.128);</td><td><div style="border-inline-end-color: oklch(52% .105 223.128);"></div></td></tr>
    <tr><td>border-e-cyan-800</td><td>border-inline-end-color: oklch(45% .085 224.283);</td><td><div style="border-inline-end-color: oklch(45% .085 224.283);"></div></td></tr>
    <tr><td>border-e-cyan-900</td><td>border-inline-end-color: oklch(39.8% .07 227.392);</td><td><div style="border-inline-end-color: oklch(39.8% .07 227.392);"></div></td></tr>
    <tr><td>border-e-cyan-950</td><td>border-inline-end-color: oklch(30.2% .056 229.695);</td><td><div style="border-inline-end-color: oklch(30.2% .056 229.695);"></div></td></tr>
    <tr><td>border-e-sky-50</td><td>border-inline-end-color: oklch(97.7% .013 236.62);</td><td><div style="border-inline-end-color: oklch(97.7% .013 236.62);"></div></td></tr>
    <tr><td>border-e-sky-100</td><td>border-inline-end-color: oklch(95.1% .026 236.824);</td><td><div style="border-inline-end-color: oklch(95.1% .026 236.824);"></div></td></tr>
    <tr><td>border-e-sky-200</td><td>border-inline-end-color: oklch(90.1% .058 230.902);</td><td><div style="border-inline-end-color: oklch(90.1% .058 230.902);"></div></td></tr>
    <tr><td>border-e-sky-300</td><td>border-inline-end-color: oklch(82.8% .111 230.318);</td><td><div style="border-inline-end-color: oklch(82.8% .111 230.318);"></div></td></tr>
    <tr><td>border-e-sky-400</td><td>border-inline-end-color: oklch(74.6% .16 232.661);</td><td><div style="border-inline-end-color: oklch(74.6% .16 232.661);"></div></td></tr>
    <tr><td>border-e-sky-500</td><td>border-inline-end-color: oklch(68.5% .169 237.323);</td><td><div style="border-inline-end-color: oklch(68.5% .169 237.323);"></div></td></tr>
    <tr><td>border-e-sky-600</td><td>border-inline-end-color: oklch(58.8% .158 241.966);</td><td><div style="border-inline-end-color: oklch(58.8% .158 241.966);"></div></td></tr>
    <tr><td>border-e-sky-700</td><td>border-inline-end-color: oklch(50% .134 242.749);</td><td><div style="border-inline-end-color: oklch(50% .134 242.749);"></div></td></tr>
    <tr><td>border-e-sky-800</td><td>border-inline-end-color: oklch(44.3% .11 240.79);</td><td><div style="border-inline-end-color: oklch(44.3% .11 240.79);"></div></td></tr>
    <tr><td>border-e-sky-900</td><td>border-inline-end-color: oklch(39.1% .09 240.876);</td><td><div style="border-inline-end-color: oklch(39.1% .09 240.876);"></div></td></tr>
    <tr><td>border-e-sky-950</td><td>border-inline-end-color: oklch(29.3% .066 243.157);</td><td><div style="border-inline-end-color: oklch(29.3% .066 243.157);"></div></td></tr>
    <tr><td>border-e-blue-50</td><td>border-inline-end-color: oklch(97% .014 254.604);</td><td><div style="border-inline-end-color: oklch(97% .014 254.604);"></div></td></tr>
    <tr><td>border-e-blue-100</td><td>border-inline-end-color: oklch(93.2% .032 255.585);</td><td><div style="border-inline-end-color: oklch(93.2% .032 255.585);"></div></td></tr>
    <tr><td>border-e-blue-200</td><td>border-inline-end-color: oklch(88.2% .059 254.128);</td><td><div style="border-inline-end-color: oklch(88.2% .059 254.128);"></div></td></tr>
    <tr><td>border-e-blue-300</td><td>border-inline-end-color: oklch(80.9% .105 251.813);</td><td><div style="border-inline-end-color: oklch(80.9% .105 251.813);"></div></td></tr>
    <tr><td>border-e-blue-400</td><td>border-inline-end-color: oklch(70.7% .165 254.624);</td><td><div style="border-inline-end-color: oklch(70.7% .165 254.624);"></div></td></tr>
    <tr><td>border-e-blue-500</td><td>border-inline-end-color: oklch(62.3% .214 259.815);</td><td><div style="border-inline-end-color: oklch(62.3% .214 259.815);"></div></td></tr>
    <tr><td>border-e-blue-600</td><td>border-inline-end-color: oklch(54.6% .245 262.881);</td><td><div style="border-inline-end-color: oklch(54.6% .245 262.881);"></div></td></tr>
    <tr><td>border-e-blue-700</td><td>border-inline-end-color: oklch(48.8% .243 264.376);</td><td><div style="border-inline-end-color: oklch(48.8% .243 264.376);"></div></td></tr>
    <tr><td>border-e-blue-800</td><td>border-inline-end-color: oklch(42.4% .199 265.638);</td><td><div style="border-inline-end-color: oklch(42.4% .199 265.638);"></div></td></tr>
    <tr><td>border-e-blue-900</td><td>border-inline-end-color: oklch(37.9% .146 265.522);</td><td><div style="border-inline-end-color: oklch(37.9% .146 265.522);"></div></td></tr>
    <tr><td>border-e-blue-950</td><td>border-inline-end-color: oklch(28.2% .091 267.935);</td><td><div style="border-inline-end-color: oklch(28.2% .091 267.935);"></div></td></tr>
    <tr><td>border-e-indigo-50</td><td>border-inline-end-color: oklch(96.2% .018 272.314);</td><td><div style="border-inline-end-color: oklch(96.2% .018 272.314);"></div></td></tr>
    <tr><td>border-e-indigo-100</td><td>border-inline-end-color: oklch(93% .034 272.788);</td><td><div style="border-inline-end-color: oklch(93% .034 272.788);"></div></td></tr>
    <tr><td>border-e-indigo-200</td><td>border-inline-end-color: oklch(87% .065 274.039);</td><td><div style="border-inline-end-color: oklch(87% .065 274.039);"></div></td></tr>
    <tr><td>border-e-indigo-300</td><td>border-inline-end-color: oklch(78.5% .115 274.713);</td><td><div style="border-inline-end-color: oklch(78.5% .115 274.713);"></div></td></tr>
    <tr><td>border-e-indigo-400</td><td>border-inline-end-color: oklch(67.3% .182 276.935);</td><td><div style="border-inline-end-color: oklch(67.3% .182 276.935);"></div></td></tr>
    <tr><td>border-e-indigo-500</td><td>border-inline-end-color: oklch(58.5% .233 277.117);</td><td><div style="border-inline-end-color: oklch(58.5% .233 277.117);"></div></td></tr>
    <tr><td>border-e-indigo-600</td><td>border-inline-end-color: oklch(51.1% .262 276.966);</td><td><div style="border-inline-end-color: oklch(51.1% .262 276.966);"></div></td></tr>
    <tr><td>border-e-indigo-700</td><td>border-inline-end-color: oklch(45.7% .24 277.023);</td><td><div style="border-inline-end-color: oklch(45.7% .24 277.023);"></div></td></tr>
    <tr><td>border-e-indigo-800</td><td>border-inline-end-color: oklch(39.8% .195 277.366);</td><td><div style="border-inline-end-color: oklch(39.8% .195 277.366);"></div></td></tr>
    <tr><td>border-e-indigo-900</td><td>border-inline-end-color: oklch(35.9% .144 278.697);</td><td><div style="border-inline-end-color: oklch(35.9% .144 278.697);"></div></td></tr>
    <tr><td>border-e-indigo-950</td><td>border-inline-end-color: oklch(25.7% .09 281.288);</td><td><div style="border-inline-end-color: oklch(25.7% .09 281.288);"></div></td></tr>
    <tr><td>border-e-violet-50</td><td>border-inline-end-color: oklch(96.9% .016 293.756);</td><td><div style="border-inline-end-color: oklch(96.9% .016 293.756);"></div></td></tr>
    <tr><td>border-e-violet-100</td><td>border-inline-end-color: oklch(94.3% .029 294.588);</td><td><div style="border-inline-end-color: oklch(94.3% .029 294.588);"></div></td></tr>
    <tr><td>border-e-violet-200</td><td>border-inline-end-color: oklch(89.4% .057 293.283);</td><td><div style="border-inline-end-color: oklch(89.4% .057 293.283);"></div></td></tr>
    <tr><td>border-e-violet-300</td><td>border-inline-end-color: oklch(81.1% .111 293.571);</td><td><div style="border-inline-end-color: oklch(81.1% .111 293.571);"></div></td></tr>
    <tr><td>border-e-violet-400</td><td>border-inline-end-color: oklch(70.2% .183 293.541);</td><td><div style="border-inline-end-color: oklch(70.2% .183 293.541);"></div></td></tr>
    <tr><td>border-e-violet-500</td><td>border-inline-end-color: oklch(60.6% .25 292.717);</td><td><div style="border-inline-end-color: oklch(60.6% .25 292.717);"></div></td></tr>
    <tr><td>border-e-violet-600</td><td>border-inline-end-color: oklch(54.1% .281 293.009);</td><td><div style="border-inline-end-color: oklch(54.1% .281 293.009);"></div></td></tr>
    <tr><td>border-e-violet-700</td><td>border-inline-end-color: oklch(49.1% .27 292.581);</td><td><div style="border-inline-end-color: oklch(49.1% .27 292.581);"></div></td></tr>
    <tr><td>border-e-violet-800</td><td>border-inline-end-color: oklch(43.2% .232 292.759);</td><td><div style="border-inline-end-color: oklch(43.2% .232 292.759);"></div></td></tr>
    <tr><td>border-e-violet-900</td><td>border-inline-end-color: oklch(38% .189 293.745);</td><td><div style="border-inline-end-color: oklch(38% .189 293.745);"></div></td></tr>
    <tr><td>border-e-violet-950</td><td>border-inline-end-color: oklch(28.3% .141 291.089);</td><td><div style="border-inline-end-color: oklch(28.3% .141 291.089);"></div></td></tr>
    <tr><td>border-e-purple-50</td><td>border-inline-end-color: oklch(97.7% .014 308.299);</td><td><div style="border-inline-end-color: oklch(97.7% .014 308.299);"></div></td></tr>
    <tr><td>border-e-purple-100</td><td>border-inline-end-color: oklch(94.6% .033 307.174);</td><td><div style="border-inline-end-color: oklch(94.6% .033 307.174);"></div></td></tr>
    <tr><td>border-e-purple-200</td><td>border-inline-end-color: oklch(90.2% .063 306.703);</td><td><div style="border-inline-end-color: oklch(90.2% .063 306.703);"></div></td></tr>
    <tr><td>border-e-purple-300</td><td>border-inline-end-color: oklch(82.7% .119 306.383);</td><td><div style="border-inline-end-color: oklch(82.7% .119 306.383);"></div></td></tr>
    <tr><td>border-e-purple-400</td><td>border-inline-end-color: oklch(71.4% .203 305.504);</td><td><div style="border-inline-end-color: oklch(71.4% .203 305.504);"></div></td></tr>
    <tr><td>border-e-purple-500</td><td>border-inline-end-color: oklch(62.7% .265 303.9);</td><td><div style="border-inline-end-color: oklch(62.7% .265 303.9);"></div></td></tr>
    <tr><td>border-e-purple-600</td><td>border-inline-end-color: oklch(55.8% .288 302.321);</td><td><div style="border-inline-end-color: oklch(55.8% .288 302.321);"></div></td></tr>
    <tr><td>border-e-purple-700</td><td>border-inline-end-color: oklch(49.6% .265 301.924);</td><td><div style="border-inline-end-color: oklch(49.6% .265 301.924);"></div></td></tr>
    <tr><td>border-e-purple-800</td><td>border-inline-end-color: oklch(43.8% .218 303.724);</td><td><div style="border-inline-end-color: oklch(43.8% .218 303.724);"></div></td></tr>
    <tr><td>border-e-purple-900</td><td>border-inline-end-color: oklch(38.1% .176 304.987);</td><td><div style="border-inline-end-color: oklch(38.1% .176 304.987);"></div></td></tr>
    <tr><td>border-e-purple-950</td><td>border-inline-end-color: oklch(29.1% .149 302.717);</td><td><div style="border-inline-end-color: oklch(29.1% .149 302.717);"></div></td></tr>
    <tr><td>border-e-fuchsia-50</td><td>border-inline-end-color: oklch(97.7% .017 320.058);</td><td><div style="border-inline-end-color: oklch(97.7% .017 320.058);"></div></td></tr>
    <tr><td>border-e-fuchsia-100</td><td>border-inline-end-color: oklch(95.2% .037 318.852);</td><td><div style="border-inline-end-color: oklch(95.2% .037 318.852);"></div></td></tr>
    <tr><td>border-e-fuchsia-200</td><td>border-inline-end-color: oklch(90.3% .076 319.62);</td><td><div style="border-inline-end-color: oklch(90.3% .076 319.62);"></div></td></tr>
    <tr><td>border-e-fuchsia-300</td><td>border-inline-end-color: oklch(83.3% .145 321.434);</td><td><div style="border-inline-end-color: oklch(83.3% .145 321.434);"></div></td></tr>
    <tr><td>border-e-fuchsia-400</td><td>border-inline-end-color: oklch(74% .238 322.16);</td><td><div style="border-inline-end-color: oklch(74% .238 322.16);"></div></td></tr>
    <tr><td>border-e-fuchsia-500</td><td>border-inline-end-color: oklch(66.7% .295 322.15);</td><td><div style="border-inline-end-color: oklch(66.7% .295 322.15);"></div></td></tr>
    <tr><td>border-e-fuchsia-600</td><td>border-inline-end-color: oklch(59.1% .293 322.896);</td><td><div style="border-inline-end-color: oklch(59.1% .293 322.896);"></div></td></tr>
    <tr><td>border-e-fuchsia-700</td><td>border-inline-end-color: oklch(51.8% .253 323.949);</td><td><div style="border-inline-end-color: oklch(51.8% .253 323.949);"></div></td></tr>
    <tr><td>border-e-fuchsia-800</td><td>border-inline-end-color: oklch(45.2% .211 324.591);</td><td><div style="border-inline-end-color: oklch(45.2% .211 324.591);"></div></td></tr>
    <tr><td>border-e-fuchsia-900</td><td>border-inline-end-color: oklch(40.1% .17 325.612);</td><td><div style="border-inline-end-color: oklch(40.1% .17 325.612);"></div></td></tr>
    <tr><td>border-e-fuchsia-950</td><td>border-inline-end-color: oklch(29.3% .136 325.661);</td><td><div style="border-inline-end-color: oklch(29.3% .136 325.661);"></div></td></tr>
    <tr><td>border-e-pink-50</td><td>border-inline-end-color: oklch(97.1% .014 343.198);</td><td><div style="border-inline-end-color: oklch(97.1% .014 343.198);"></div></td></tr>
    <tr><td>border-e-pink-100</td><td>border-inline-end-color: oklch(94.8% .028 342.258);</td><td><div style="border-inline-end-color: oklch(94.8% .028 342.258);"></div></td></tr>
    <tr><td>border-e-pink-200</td><td>border-inline-end-color: oklch(89.9% .061 343.231);</td><td><div style="border-inline-end-color: oklch(89.9% .061 343.231);"></div></td></tr>
    <tr><td>border-e-pink-300</td><td>border-inline-end-color: oklch(82.3% .12 346.018);</td><td><div style="border-inline-end-color: oklch(82.3% .12 346.018);"></div></td></tr>
    <tr><td>border-e-pink-400</td><td>border-inline-end-color: oklch(71.8% .202 349.761);</td><td><div style="border-inline-end-color: oklch(71.8% .202 349.761);"></div></td></tr>
    <tr><td>border-e-pink-500</td><td>border-inline-end-color: oklch(65.6% .241 354.308);</td><td><div style="border-inline-end-color: oklch(65.6% .241 354.308);"></div></td></tr>
    <tr><td>border-e-pink-600</td><td>border-inline-end-color: oklch(59.2% .249 .584);</td><td><div style="border-inline-end-color: oklch(59.2% .249 .584);"></div></td></tr>
    <tr><td>border-e-pink-700</td><td>border-inline-end-color: oklch(52.5% .223 3.958);</td><td><div style="border-inline-end-color: oklch(52.5% .223 3.958);"></div></td></tr>
    <tr><td>border-e-pink-800</td><td>border-inline-end-color: oklch(45.9% .187 3.815);</td><td><div style="border-inline-end-color: oklch(45.9% .187 3.815);"></div></td></tr>
    <tr><td>border-e-pink-900</td><td>border-inline-end-color: oklch(40.8% .153 2.432);</td><td><div style="border-inline-end-color: oklch(40.8% .153 2.432);"></div></td></tr>
    <tr><td>border-e-pink-950</td><td>border-inline-end-color: oklch(28.4% .109 3.907);</td><td><div style="border-inline-end-color: oklch(28.4% .109 3.907);"></div></td></tr>
    <tr><td>border-e-rose-50</td><td>border-inline-end-color: oklch(96.9% .015 12.422);</td><td><div style="border-inline-end-color: oklch(96.9% .015 12.422);"></div></td></tr>
    <tr><td>border-e-rose-100</td><td>border-inline-end-color: oklch(94.1% .03 12.58);</td><td><div style="border-inline-end-color: oklch(94.1% .03 12.58);"></div></td></tr>
    <tr><td>border-e-rose-200</td><td>border-inline-end-color: oklch(89.2% .058 10.001);</td><td><div style="border-inline-end-color: oklch(89.2% .058 10.001);"></div></td></tr>
    <tr><td>border-e-rose-300</td><td>border-inline-end-color: oklch(81% .117 11.638);</td><td><div style="border-inline-end-color: oklch(81% .117 11.638);"></div></td></tr>
    <tr><td>border-e-rose-400</td><td>border-inline-end-color: oklch(71.2% .194 13.428);</td><td><div style="border-inline-end-color: oklch(71.2% .194 13.428);"></div></td></tr>
    <tr><td>border-e-rose-500</td><td>border-inline-end-color: oklch(64.5% .246 16.439);</td><td><div style="border-inline-end-color: oklch(64.5% .246 16.439);"></div></td></tr>
    <tr><td>border-e-rose-600</td><td>border-inline-end-color: oklch(58.6% .253 17.585);</td><td><div style="border-inline-end-color: oklch(58.6% .253 17.585);"></div></td></tr>
    <tr><td>border-e-rose-700</td><td>border-inline-end-color: oklch(51.4% .222 16.935);</td><td><div style="border-inline-end-color: oklch(51.4% .222 16.935);"></div></td></tr>
    <tr><td>border-e-rose-800</td><td>border-inline-end-color: oklch(45.5% .188 13.697);</td><td><div style="border-inline-end-color: oklch(45.5% .188 13.697);"></div></td></tr>
    <tr><td>border-e-rose-900</td><td>border-inline-end-color: oklch(41% .159 10.272);</td><td><div style="border-inline-end-color: oklch(41% .159 10.272);"></div></td></tr>
    <tr><td>border-e-rose-950</td><td>border-inline-end-color: oklch(27.1% .105 12.094);</td><td><div style="border-inline-end-color: oklch(27.1% .105 12.094);"></div></td></tr>
    <tr><td>border-e-slate-50</td><td>border-inline-end-color: oklch(98.4% .003 247.858);</td><td><div style="border-inline-end-color: oklch(98.4% .003 247.858);"></div></td></tr>
    <tr><td>border-e-slate-100</td><td>border-inline-end-color: oklch(96.8% .007 247.896);</td><td><div style="border-inline-end-color: oklch(96.8% .007 247.896);"></div></td></tr>
    <tr><td>border-e-slate-200</td><td>border-inline-end-color: oklch(92.9% .013 255.508);</td><td><div style="border-inline-end-color: oklch(92.9% .013 255.508);"></div></td></tr>
    <tr><td>border-e-slate-300</td><td>border-inline-end-color: oklch(86.9% .022 252.894);</td><td><div style="border-inline-end-color: oklch(86.9% .022 252.894);"></div></td></tr>
    <tr><td>border-e-slate-400</td><td>border-inline-end-color: oklch(70.4% .04 256.788);</td><td><div style="border-inline-end-color: oklch(70.4% .04 256.788);"></div></td></tr>
    <tr><td>border-e-slate-500</td><td>border-inline-end-color: oklch(55.4% .046 257.417);</td><td><div style="border-inline-end-color: oklch(55.4% .046 257.417);"></div></td></tr>
    <tr><td>border-e-slate-600</td><td>border-inline-end-color: oklch(44.6% .043 257.281);</td><td><div style="border-inline-end-color: oklch(44.6% .043 257.281);"></div></td></tr>
    <tr><td>border-e-slate-700</td><td>border-inline-end-color: oklch(37.2% .044 257.287);</td><td><div style="border-inline-end-color: oklch(37.2% .044 257.287);"></div></td></tr>
    <tr><td>border-e-slate-800</td><td>border-inline-end-color: oklch(27.9% .041 260.031);</td><td><div style="border-inline-end-color: oklch(27.9% .041 260.031);"></div></td></tr>
    <tr><td>border-e-slate-900</td><td>border-inline-end-color: oklch(20.8% .042 265.755);</td><td><div style="border-inline-end-color: oklch(20.8% .042 265.755);"></div></td></tr>
    <tr><td>border-e-slate-950</td><td>border-inline-end-color: oklch(12.9% .042 264.695);</td><td><div style="border-inline-end-color: oklch(12.9% .042 264.695);"></div></td></tr>
    <tr><td>border-e-gray-50</td><td>border-inline-end-color: oklch(98.5% .002 247.839);</td><td><div style="border-inline-end-color: oklch(98.5% .002 247.839);"></div></td></tr>
    <tr><td>border-e-gray-100</td><td>border-inline-end-color: oklch(96.7% .003 264.542);</td><td><div style="border-inline-end-color: oklch(96.7% .003 264.542);"></div></td></tr>
    <tr><td>border-e-gray-200</td><td>border-inline-end-color: oklch(92.8% .006 264.531);</td><td><div style="border-inline-end-color: oklch(92.8% .006 264.531);"></div></td></tr>
    <tr><td>border-e-gray-300</td><td>border-inline-end-color: oklch(87.2% .01 258.338);</td><td><div style="border-inline-end-color: oklch(87.2% .01 258.338);"></div></td></tr>
    <tr><td>border-e-gray-400</td><td>border-inline-end-color: oklch(70.7% .022 261.325);</td><td><div style="border-inline-end-color: oklch(70.7% .022 261.325);"></div></td></tr>
    <tr><td>border-e-gray-500</td><td>border-inline-end-color: oklch(55.1% .027 264.364);</td><td><div style="border-inline-end-color: oklch(55.1% .027 264.364);"></div></td></tr>
    <tr><td>border-e-gray-600</td><td>border-inline-end-color: oklch(44.6% .03 256.802);</td><td><div style="border-inline-end-color: oklch(44.6% .03 256.802);"></div></td></tr>
    <tr><td>border-e-gray-700</td><td>border-inline-end-color: oklch(37.3% .034 259.733);</td><td><div style="border-inline-end-color: oklch(37.3% .034 259.733);"></div></td></tr>
    <tr><td>border-e-gray-800</td><td>border-inline-end-color: oklch(27.8% .033 256.848);</td><td><div style="border-inline-end-color: oklch(27.8% .033 256.848);"></div></td></tr>
    <tr><td>border-e-gray-900</td><td>border-inline-end-color: oklch(21% .034 264.665);</td><td><div style="border-inline-end-color: oklch(21% .034 264.665);"></div></td></tr>
    <tr><td>border-e-gray-950</td><td>border-inline-end-color: oklch(13% .028 261.692);</td><td><div style="border-inline-end-color: oklch(13% .028 261.692);"></div></td></tr>
    <tr><td>border-e-zinc-50</td><td>border-inline-end-color: oklch(98.5% 0 0);</td><td><div style="border-inline-end-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-e-zinc-100</td><td>border-inline-end-color: oklch(96.7% .001 286.375);</td><td><div style="border-inline-end-color: oklch(96.7% .001 286.375);"></div></td></tr>
    <tr><td>border-e-zinc-200</td><td>border-inline-end-color: oklch(92% .004 286.32);</td><td><div style="border-inline-end-color: oklch(92% .004 286.32);"></div></td></tr>
    <tr><td>border-e-zinc-300</td><td>border-inline-end-color: oklch(87.1% .006 286.286);</td><td><div style="border-inline-end-color: oklch(87.1% .006 286.286);"></div></td></tr>
    <tr><td>border-e-zinc-400</td><td>border-inline-end-color: oklch(70.5% .015 286.067);</td><td><div style="border-inline-end-color: oklch(70.5% .015 286.067);"></div></td></tr>
    <tr><td>border-e-zinc-500</td><td>border-inline-end-color: oklch(55.2% .016 285.938);</td><td><div style="border-inline-end-color: oklch(55.2% .016 285.938);"></div></td></tr>
    <tr><td>border-e-zinc-600</td><td>border-inline-end-color: oklch(44.2% .017 285.786);</td><td><div style="border-inline-end-color: oklch(44.2% .017 285.786);"></div></td></tr>
    <tr><td>border-e-zinc-700</td><td>border-inline-end-color: oklch(37% .013 285.805);</td><td><div style="border-inline-end-color: oklch(37% .013 285.805);"></div></td></tr>
    <tr><td>border-e-zinc-800</td><td>border-inline-end-color: oklch(27.4% .006 286.033);</td><td><div style="border-inline-end-color: oklch(27.4% .006 286.033);"></div></td></tr>
    <tr><td>border-e-zinc-900</td><td>border-inline-end-color: oklch(21% .006 285.885);</td><td><div style="border-inline-end-color: oklch(21% .006 285.885);"></div></td></tr>
    <tr><td>border-e-zinc-950</td><td>border-inline-end-color: oklch(14.1% .005 285.823);</td><td><div style="border-inline-end-color: oklch(14.1% .005 285.823);"></div></td></tr>
    <tr><td>border-e-neutral-50</td><td>border-inline-end-color: oklch(98.5% 0 0);</td><td><div style="border-inline-end-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-100</td><td>border-inline-end-color: oklch(97% 0 0);</td><td><div style="border-inline-end-color: oklch(97% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-200</td><td>border-inline-end-color: oklch(92.2% 0 0);</td><td><div style="border-inline-end-color: oklch(92.2% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-300</td><td>border-inline-end-color: oklch(87% 0 0);</td><td><div style="border-inline-end-color: oklch(87% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-400</td><td>border-inline-end-color: oklch(70.8% 0 0);</td><td><div style="border-inline-end-color: oklch(70.8% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-500</td><td>border-inline-end-color: oklch(55.6% 0 0);</td><td><div style="border-inline-end-color: oklch(55.6% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-600</td><td>border-inline-end-color: oklch(43.9% 0 0);</td><td><div style="border-inline-end-color: oklch(43.9% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-700</td><td>border-inline-end-color: oklch(37.1% 0 0);</td><td><div style="border-inline-end-color: oklch(37.1% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-800</td><td>border-inline-end-color: oklch(26.9% 0 0);</td><td><div style="border-inline-end-color: oklch(26.9% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-900</td><td>border-inline-end-color: oklch(20.5% 0 0);</td><td><div style="border-inline-end-color: oklch(20.5% 0 0);"></div></td></tr>
    <tr><td>border-e-neutral-950</td><td>border-inline-end-color: oklch(14.5% 0 0);</td><td><div style="border-inline-end-color: oklch(14.5% 0 0);"></div></td></tr>
    <tr><td>border-e-stone-50</td><td>border-inline-end-color: oklch(98.5% .001 106.423);</td><td><div style="border-inline-end-color: oklch(98.5% .001 106.423);"></div></td></tr>
    <tr><td>border-e-stone-100</td><td>border-inline-end-color: oklch(97% .001 106.424);</td><td><div style="border-inline-end-color: oklch(97% .001 106.424);"></div></td></tr>
    <tr><td>border-e-stone-200</td><td>border-inline-end-color: oklch(92.3% .003 48.717);</td><td><div style="border-inline-end-color: oklch(92.3% .003 48.717);"></div></td></tr>
    <tr><td>border-e-stone-300</td><td>border-inline-end-color: oklch(86.9% .005 56.366);</td><td><div style="border-inline-end-color: oklch(86.9% .005 56.366);"></div></td></tr>
    <tr><td>border-e-stone-400</td><td>border-inline-end-color: oklch(70.9% .01 56.259);</td><td><div style="border-inline-end-color: oklch(70.9% .01 56.259);"></div></td></tr>
    <tr><td>border-e-stone-500</td><td>border-inline-end-color: oklch(55.3% .013 58.071);</td><td><div style="border-inline-end-color: oklch(55.3% .013 58.071);"></div></td></tr>
    <tr><td>border-e-stone-600</td><td>border-inline-end-color: oklch(44.4% .011 73.639);</td><td><div style="border-inline-end-color: oklch(44.4% .011 73.639);"></div></td></tr>
    <tr><td>border-e-stone-700</td><td>border-inline-end-color: oklch(37.4% .01 67.558);</td><td><div style="border-inline-end-color: oklch(37.4% .01 67.558);"></div></td></tr>
    <tr><td>border-e-stone-800</td><td>border-inline-end-color: oklch(26.8% .007 34.298);</td><td><div style="border-inline-end-color: oklch(26.8% .007 34.298);"></div></td></tr>
    <tr><td>border-e-stone-900</td><td>border-inline-end-color: oklch(21.6% .006 56.043);</td><td><div style="border-inline-end-color: oklch(21.6% .006 56.043);"></div></td></tr>
    <tr><td>border-e-stone-950</td><td>border-inline-end-color: oklch(14.7% .004 49.25);</td><td><div style="border-inline-end-color: oklch(14.7% .004 49.25);"></div></td></tr>
    <tr><td>border-e-black</td><td>border-inline-end-color: #000;</td><td><div style="border-inline-end-color: #000;"></div></td></tr>
    <tr><td>border-e-white</td><td>border-inline-end-color: #fff;</td><td><div style="border-inline-end-color: #fff;"></div></td></tr>
    <tr><td>border-t-inherit</td><td>border-top-color: inherit;</td><td><div style="border-top-color: inherit;"></div></td></tr>
    <tr><td>border-t-current</td><td>border-top-color: currentColor;</td><td><div style="border-top-color: currentColor;"></div></td></tr>
    <tr><td>border-t-transparent</td><td>border-top-color: transparent;</td><td><div style="border-top-color: transparent;"></div></td></tr>
    <tr><td>border-t-red-50</td><td>border-top-color: oklch(97.1% .013 17.38);</td><td><div style="border-top-color: oklch(97.1% .013 17.38);"></div></td></tr>
    <tr><td>border-t-red-100</td><td>border-top-color: oklch(93.6% .032 17.717);</td><td><div style="border-top-color: oklch(93.6% .032 17.717);"></div></td></tr>
    <tr><td>border-t-red-200</td><td>border-top-color: oklch(88.5% .062 18.334);</td><td><div style="border-top-color: oklch(88.5% .062 18.334);"></div></td></tr>
    <tr><td>border-t-red-300</td><td>border-top-color: oklch(80.8% .114 19.571);</td><td><div style="border-top-color: oklch(80.8% .114 19.571);"></div></td></tr>
    <tr><td>border-t-red-400</td><td>border-top-color: oklch(70.4% .191 22.216);</td><td><div style="border-top-color: oklch(70.4% .191 22.216);"></div></td></tr>
    <tr><td>border-t-red-500</td><td>border-top-color: oklch(63.7% .237 25.331);</td><td><div style="border-top-color: oklch(63.7% .237 25.331);"></div></td></tr>
    <tr><td>border-t-red-600</td><td>border-top-color: oklch(57.7% .245 27.325);</td><td><div style="border-top-color: oklch(57.7% .245 27.325);"></div></td></tr>
    <tr><td>border-t-red-700</td><td>border-top-color: oklch(50.5% .213 27.518);</td><td><div style="border-top-color: oklch(50.5% .213 27.518);"></div></td></tr>
    <tr><td>border-t-red-800</td><td>border-top-color: oklch(44.4% .177 26.899);</td><td><div style="border-top-color: oklch(44.4% .177 26.899);"></div></td></tr>
    <tr><td>border-t-red-900</td><td>border-top-color: oklch(39.6% .141 25.723);</td><td><div style="border-top-color: oklch(39.6% .141 25.723);"></div></td></tr>
    <tr><td>border-t-red-950</td><td>border-top-color: oklch(25.8% .092 26.042);</td><td><div style="border-top-color: oklch(25.8% .092 26.042);"></div></td></tr>
    <tr><td>border-t-orange-50</td><td>border-top-color: oklch(98% .016 73.684);</td><td><div style="border-top-color: oklch(98% .016 73.684);"></div></td></tr>
    <tr><td>border-t-orange-100</td><td>border-top-color: oklch(95.4% .038 75.164);</td><td><div style="border-top-color: oklch(95.4% .038 75.164);"></div></td></tr>
    <tr><td>border-t-orange-200</td><td>border-top-color: oklch(90.1% .076 70.697);</td><td><div style="border-top-color: oklch(90.1% .076 70.697);"></div></td></tr>
    <tr><td>border-t-orange-300</td><td>border-top-color: oklch(83.7% .128 66.29);</td><td><div style="border-top-color: oklch(83.7% .128 66.29);"></div></td></tr>
    <tr><td>border-t-orange-400</td><td>border-top-color: oklch(75% .183 55.934);</td><td><div style="border-top-color: oklch(75% .183 55.934);"></div></td></tr>
    <tr><td>border-t-orange-500</td><td>border-top-color: oklch(70.5% .213 47.604);</td><td><div style="border-top-color: oklch(70.5% .213 47.604);"></div></td></tr>
    <tr><td>border-t-orange-600</td><td>border-top-color: oklch(64.6% .222 41.116);</td><td><div style="border-top-color: oklch(64.6% .222 41.116);"></div></td></tr>
    <tr><td>border-t-orange-700</td><td>border-top-color: oklch(55.3% .195 38.402);</td><td><div style="border-top-color: oklch(55.3% .195 38.402);"></div></td></tr>
    <tr><td>border-t-orange-800</td><td>border-top-color: oklch(47% .157 37.304);</td><td><div style="border-top-color: oklch(47% .157 37.304);"></div></td></tr>
    <tr><td>border-t-orange-900</td><td>border-top-color: oklch(40.8% .123 38.172);</td><td><div style="border-top-color: oklch(40.8% .123 38.172);"></div></td></tr>
    <tr><td>border-t-orange-950</td><td>border-top-color: oklch(26.6% .079 36.259);</td><td><div style="border-top-color: oklch(26.6% .079 36.259);"></div></td></tr>
    <tr><td>border-t-amber-50</td><td>border-top-color: oklch(98.7% .022 95.277);</td><td><div style="border-top-color: oklch(98.7% .022 95.277);"></div></td></tr>
    <tr><td>border-t-amber-100</td><td>border-top-color: oklch(96.2% .059 95.617);</td><td><div style="border-top-color: oklch(96.2% .059 95.617);"></div></td></tr>
    <tr><td>border-t-amber-200</td><td>border-top-color: oklch(92.4% .12 95.746);</td><td><div style="border-top-color: oklch(92.4% .12 95.746);"></div></td></tr>
    <tr><td>border-t-amber-300</td><td>border-top-color: oklch(87.9% .169 91.605);</td><td><div style="border-top-color: oklch(87.9% .169 91.605);"></div></td></tr>
    <tr><td>border-t-amber-400</td><td>border-top-color: oklch(82.8% .189 84.429);</td><td><div style="border-top-color: oklch(82.8% .189 84.429);"></div></td></tr>
    <tr><td>border-t-amber-500</td><td>border-top-color: oklch(76.9% .188 70.08);</td><td><div style="border-top-color: oklch(76.9% .188 70.08);"></div></td></tr>
    <tr><td>border-t-amber-600</td><td>border-top-color: oklch(66.6% .179 58.318);</td><td><div style="border-top-color: oklch(66.6% .179 58.318);"></div></td></tr>
    <tr><td>border-t-amber-700</td><td>border-top-color: oklch(55.5% .163 48.998);</td><td><div style="border-top-color: oklch(55.5% .163 48.998);"></div></td></tr>
    <tr><td>border-t-amber-800</td><td>border-top-color: oklch(47.3% .137 46.201);</td><td><div style="border-top-color: oklch(47.3% .137 46.201);"></div></td></tr>
    <tr><td>border-t-amber-900</td><td>border-top-color: oklch(41.4% .112 45.904);</td><td><div style="border-top-color: oklch(41.4% .112 45.904);"></div></td></tr>
    <tr><td>border-t-amber-950</td><td>border-top-color: oklch(27.9% .077 45.635);</td><td><div style="border-top-color: oklch(27.9% .077 45.635);"></div></td></tr>
    <tr><td>border-t-yellow-50</td><td>border-top-color: oklch(98.7% .026 102.212);</td><td><div style="border-top-color: oklch(98.7% .026 102.212);"></div></td></tr>
    <tr><td>border-t-yellow-100</td><td>border-top-color: oklch(97.3% .071 103.193);</td><td><div style="border-top-color: oklch(97.3% .071 103.193);"></div></td></tr>
    <tr><td>border-t-yellow-200</td><td>border-top-color: oklch(94.5% .129 101.54);</td><td><div style="border-top-color: oklch(94.5% .129 101.54);"></div></td></tr>
    <tr><td>border-t-yellow-300</td><td>border-top-color: oklch(90.5% .182 98.111);</td><td><div style="border-top-color: oklch(90.5% .182 98.111);"></div></td></tr>
    <tr><td>border-t-yellow-400</td><td>border-top-color: oklch(85.2% .199 91.936);</td><td><div style="border-top-color: oklch(85.2% .199 91.936);"></div></td></tr>
    <tr><td>border-t-yellow-500</td><td>border-top-color: oklch(79.5% .184 86.047);</td><td><div style="border-top-color: oklch(79.5% .184 86.047);"></div></td></tr>
    <tr><td>border-t-yellow-600</td><td>border-top-color: oklch(68.1% .162 75.834);</td><td><div style="border-top-color: oklch(68.1% .162 75.834);"></div></td></tr>
    <tr><td>border-t-yellow-700</td><td>border-top-color: oklch(55.4% .135 66.442);</td><td><div style="border-top-color: oklch(55.4% .135 66.442);"></div></td></tr>
    <tr><td>border-t-yellow-800</td><td>border-top-color: oklch(47.6% .114 61.907);</td><td><div style="border-top-color: oklch(47.6% .114 61.907);"></div></td></tr>
    <tr><td>border-t-yellow-900</td><td>border-top-color: oklch(42.1% .095 57.708);</td><td><div style="border-top-color: oklch(42.1% .095 57.708);"></div></td></tr>
    <tr><td>border-t-yellow-950</td><td>border-top-color: oklch(28.6% .066 53.813);</td><td><div style="border-top-color: oklch(28.6% .066 53.813);"></div></td></tr>
    <tr><td>border-t-lime-50</td><td>border-top-color: oklch(98.6% .031 120.757);</td><td><div style="border-top-color: oklch(98.6% .031 120.757);"></div></td></tr>
    <tr><td>border-t-lime-100</td><td>border-top-color: oklch(96.7% .067 122.328);</td><td><div style="border-top-color: oklch(96.7% .067 122.328);"></div></td></tr>
    <tr><td>border-t-lime-200</td><td>border-top-color: oklch(93.8% .127 124.321);</td><td><div style="border-top-color: oklch(93.8% .127 124.321);"></div></td></tr>
    <tr><td>border-t-lime-300</td><td>border-top-color: oklch(89.7% .196 126.665);</td><td><div style="border-top-color: oklch(89.7% .196 126.665);"></div></td></tr>
    <tr><td>border-t-lime-400</td><td>border-top-color: oklch(84.1% .238 128.85);</td><td><div style="border-top-color: oklch(84.1% .238 128.85);"></div></td></tr>
    <tr><td>border-t-lime-500</td><td>border-top-color: oklch(76.8% .233 130.85);</td><td><div style="border-top-color: oklch(76.8% .233 130.85);"></div></td></tr>
    <tr><td>border-t-lime-600</td><td>border-top-color: oklch(64.8% .2 131.684);</td><td><div style="border-top-color: oklch(64.8% .2 131.684);"></div></td></tr>
    <tr><td>border-t-lime-700</td><td>border-top-color: oklch(53.2% .157 131.589);</td><td><div style="border-top-color: oklch(53.2% .157 131.589);"></div></td></tr>
    <tr><td>border-t-lime-800</td><td>border-top-color: oklch(45.3% .124 130.933);</td><td><div style="border-top-color: oklch(45.3% .124 130.933);"></div></td></tr>
    <tr><td>border-t-lime-900</td><td>border-top-color: oklch(40.5% .101 131.063);</td><td><div style="border-top-color: oklch(40.5% .101 131.063);"></div></td></tr>
    <tr><td>border-t-lime-950</td><td>border-top-color: oklch(27.4% .072 132.109);</td><td><div style="border-top-color: oklch(27.4% .072 132.109);"></div></td></tr>
    <tr><td>border-t-green-50</td><td>border-top-color: oklch(98.2% .018 155.826);</td><td><div style="border-top-color: oklch(98.2% .018 155.826);"></div></td></tr>
    <tr><td>border-t-green-100</td><td>border-top-color: oklch(96.2% .044 156.743);</td><td><div style="border-top-color: oklch(96.2% .044 156.743);"></div></td></tr>
    <tr><td>border-t-green-200</td><td>border-top-color: oklch(92.5% .084 155.995);</td><td><div style="border-top-color: oklch(92.5% .084 155.995);"></div></td></tr>
    <tr><td>border-t-green-300</td><td>border-top-color: oklch(87.1% .15 154.449);</td><td><div style="border-top-color: oklch(87.1% .15 154.449);"></div></td></tr>
    <tr><td>border-t-green-400</td><td>border-top-color: oklch(79.2% .209 151.711);</td><td><div style="border-top-color: oklch(79.2% .209 151.711);"></div></td></tr>
    <tr><td>border-t-green-500</td><td>border-top-color: oklch(72.3% .219 149.579);</td><td><div style="border-top-color: oklch(72.3% .219 149.579);"></div></td></tr>
    <tr><td>border-t-green-600</td><td>border-top-color: oklch(62.7% .194 149.214);</td><td><div style="border-top-color: oklch(62.7% .194 149.214);"></div></td></tr>
    <tr><td>border-t-green-700</td><td>border-top-color: oklch(52.7% .154 150.069);</td><td><div style="border-top-color: oklch(52.7% .154 150.069);"></div></td></tr>
    <tr><td>border-t-green-800</td><td>border-top-color: oklch(44.8% .119 151.328);</td><td><div style="border-top-color: oklch(44.8% .119 151.328);"></div></td></tr>
    <tr><td>border-t-green-900</td><td>border-top-color: oklch(39.3% .095 152.535);</td><td><div style="border-top-color: oklch(39.3% .095 152.535);"></div></td></tr>
    <tr><td>border-t-green-950</td><td>border-top-color: oklch(26.6% .065 152.934);</td><td><div style="border-top-color: oklch(26.6% .065 152.934);"></div></td></tr>
    <tr><td>border-t-emerald-50</td><td>border-top-color: oklch(97.9% .021 166.113);</td><td><div style="border-top-color: oklch(97.9% .021 166.113);"></div></td></tr>
    <tr><td>border-t-emerald-100</td><td>border-top-color: oklch(95% .052 163.051);</td><td><div style="border-top-color: oklch(95% .052 163.051);"></div></td></tr>
    <tr><td>border-t-emerald-200</td><td>border-top-color: oklch(90.5% .093 164.15);</td><td><div style="border-top-color: oklch(90.5% .093 164.15);"></div></td></tr>
    <tr><td>border-t-emerald-300</td><td>border-top-color: oklch(84.5% .143 164.978);</td><td><div style="border-top-color: oklch(84.5% .143 164.978);"></div></td></tr>
    <tr><td>border-t-emerald-400</td><td>border-top-color: oklch(76.5% .177 163.223);</td><td><div style="border-top-color: oklch(76.5% .177 163.223);"></div></td></tr>
    <tr><td>border-t-emerald-500</td><td>border-top-color: oklch(69.6% .17 162.48);</td><td><div style="border-top-color: oklch(69.6% .17 162.48);"></div></td></tr>
    <tr><td>border-t-emerald-600</td><td>border-top-color: oklch(59.6% .145 163.225);</td><td><div style="border-top-color: oklch(59.6% .145 163.225);"></div></td></tr>
    <tr><td>border-t-emerald-700</td><td>border-top-color: oklch(50.8% .118 165.612);</td><td><div style="border-top-color: oklch(50.8% .118 165.612);"></div></td></tr>
    <tr><td>border-t-emerald-800</td><td>border-top-color: oklch(43.2% .095 166.913);</td><td><div style="border-top-color: oklch(43.2% .095 166.913);"></div></td></tr>
    <tr><td>border-t-emerald-900</td><td>border-top-color: oklch(37.8% .077 168.94);</td><td><div style="border-top-color: oklch(37.8% .077 168.94);"></div></td></tr>
    <tr><td>border-t-emerald-950</td><td>border-top-color: oklch(26.2% .051 172.552);</td><td><div style="border-top-color: oklch(26.2% .051 172.552);"></div></td></tr>
    <tr><td>border-t-teal-50</td><td>border-top-color: oklch(98.4% .014 180.72);</td><td><div style="border-top-color: oklch(98.4% .014 180.72);"></div></td></tr>
    <tr><td>border-t-teal-100</td><td>border-top-color: oklch(95.3% .051 180.801);</td><td><div style="border-top-color: oklch(95.3% .051 180.801);"></div></td></tr>
    <tr><td>border-t-teal-200</td><td>border-top-color: oklch(91% .096 180.426);</td><td><div style="border-top-color: oklch(91% .096 180.426);"></div></td></tr>
    <tr><td>border-t-teal-300</td><td>border-top-color: oklch(85.5% .138 181.071);</td><td><div style="border-top-color: oklch(85.5% .138 181.071);"></div></td></tr>
    <tr><td>border-t-teal-400</td><td>border-top-color: oklch(77.7% .152 181.912);</td><td><div style="border-top-color: oklch(77.7% .152 181.912);"></div></td></tr>
    <tr><td>border-t-teal-500</td><td>border-top-color: oklch(70.4% .14 182.503);</td><td><div style="border-top-color: oklch(70.4% .14 182.503);"></div></td></tr>
    <tr><td>border-t-teal-600</td><td>border-top-color: oklch(60% .118 184.704);</td><td><div style="border-top-color: oklch(60% .118 184.704);"></div></td></tr>
    <tr><td>border-t-teal-700</td><td>border-top-color: oklch(51.1% .096 186.391);</td><td><div style="border-top-color: oklch(51.1% .096 186.391);"></div></td></tr>
    <tr><td>border-t-teal-800</td><td>border-top-color: oklch(43.7% .078 188.216);</td><td><div style="border-top-color: oklch(43.7% .078 188.216);"></div></td></tr>
    <tr><td>border-t-teal-900</td><td>border-top-color: oklch(38.6% .063 188.416);</td><td><div style="border-top-color: oklch(38.6% .063 188.416);"></div></td></tr>
    <tr><td>border-t-teal-950</td><td>border-top-color: oklch(27.7% .046 192.524);</td><td><div style="border-top-color: oklch(27.7% .046 192.524);"></div></td></tr>
    <tr><td>border-t-cyan-50</td><td>border-top-color: oklch(98.4% .019 200.873);</td><td><div style="border-top-color: oklch(98.4% .019 200.873);"></div></td></tr>
    <tr><td>border-t-cyan-100</td><td>border-top-color: oklch(95.6% .045 203.388);</td><td><div style="border-top-color: oklch(95.6% .045 203.388);"></div></td></tr>
    <tr><td>border-t-cyan-200</td><td>border-top-color: oklch(91.7% .08 205.041);</td><td><div style="border-top-color: oklch(91.7% .08 205.041);"></div></td></tr>
    <tr><td>border-t-cyan-300</td><td>border-top-color: oklch(86.5% .127 207.078);</td><td><div style="border-top-color: oklch(86.5% .127 207.078);"></div></td></tr>
    <tr><td>border-t-cyan-400</td><td>border-top-color: oklch(78.9% .154 211.53);</td><td><div style="border-top-color: oklch(78.9% .154 211.53);"></div></td></tr>
    <tr><td>border-t-cyan-500</td><td>border-top-color: oklch(71.5% .143 215.221);</td><td><div style="border-top-color: oklch(71.5% .143 215.221);"></div></td></tr>
    <tr><td>border-t-cyan-600</td><td>border-top-color: oklch(60.9% .126 221.723);</td><td><div style="border-top-color: oklch(60.9% .126 221.723);"></div></td></tr>
    <tr><td>border-t-cyan-700</td><td>border-top-color: oklch(52% .105 223.128);</td><td><div style="border-top-color: oklch(52% .105 223.128);"></div></td></tr>
    <tr><td>border-t-cyan-800</td><td>border-top-color: oklch(45% .085 224.283);</td><td><div style="border-top-color: oklch(45% .085 224.283);"></div></td></tr>
    <tr><td>border-t-cyan-900</td><td>border-top-color: oklch(39.8% .07 227.392);</td><td><div style="border-top-color: oklch(39.8% .07 227.392);"></div></td></tr>
    <tr><td>border-t-cyan-950</td><td>border-top-color: oklch(30.2% .056 229.695);</td><td><div style="border-top-color: oklch(30.2% .056 229.695);"></div></td></tr>
    <tr><td>border-t-sky-50</td><td>border-top-color: oklch(97.7% .013 236.62);</td><td><div style="border-top-color: oklch(97.7% .013 236.62);"></div></td></tr>
    <tr><td>border-t-sky-100</td><td>border-top-color: oklch(95.1% .026 236.824);</td><td><div style="border-top-color: oklch(95.1% .026 236.824);"></div></td></tr>
    <tr><td>border-t-sky-200</td><td>border-top-color: oklch(90.1% .058 230.902);</td><td><div style="border-top-color: oklch(90.1% .058 230.902);"></div></td></tr>
    <tr><td>border-t-sky-300</td><td>border-top-color: oklch(82.8% .111 230.318);</td><td><div style="border-top-color: oklch(82.8% .111 230.318);"></div></td></tr>
    <tr><td>border-t-sky-400</td><td>border-top-color: oklch(74.6% .16 232.661);</td><td><div style="border-top-color: oklch(74.6% .16 232.661);"></div></td></tr>
    <tr><td>border-t-sky-500</td><td>border-top-color: oklch(68.5% .169 237.323);</td><td><div style="border-top-color: oklch(68.5% .169 237.323);"></div></td></tr>
    <tr><td>border-t-sky-600</td><td>border-top-color: oklch(58.8% .158 241.966);</td><td><div style="border-top-color: oklch(58.8% .158 241.966);"></div></td></tr>
    <tr><td>border-t-sky-700</td><td>border-top-color: oklch(50% .134 242.749);</td><td><div style="border-top-color: oklch(50% .134 242.749);"></div></td></tr>
    <tr><td>border-t-sky-800</td><td>border-top-color: oklch(44.3% .11 240.79);</td><td><div style="border-top-color: oklch(44.3% .11 240.79);"></div></td></tr>
    <tr><td>border-t-sky-900</td><td>border-top-color: oklch(39.1% .09 240.876);</td><td><div style="border-top-color: oklch(39.1% .09 240.876);"></div></td></tr>
    <tr><td>border-t-sky-950</td><td>border-top-color: oklch(29.3% .066 243.157);</td><td><div style="border-top-color: oklch(29.3% .066 243.157);"></div></td></tr>
    <tr><td>border-t-blue-50</td><td>border-top-color: oklch(97% .014 254.604);</td><td><div style="border-top-color: oklch(97% .014 254.604);"></div></td></tr>
    <tr><td>border-t-blue-100</td><td>border-top-color: oklch(93.2% .032 255.585);</td><td><div style="border-top-color: oklch(93.2% .032 255.585);"></div></td></tr>
    <tr><td>border-t-blue-200</td><td>border-top-color: oklch(88.2% .059 254.128);</td><td><div style="border-top-color: oklch(88.2% .059 254.128);"></div></td></tr>
    <tr><td>border-t-blue-300</td><td>border-top-color: oklch(80.9% .105 251.813);</td><td><div style="border-top-color: oklch(80.9% .105 251.813);"></div></td></tr>
    <tr><td>border-t-blue-400</td><td>border-top-color: oklch(70.7% .165 254.624);</td><td><div style="border-top-color: oklch(70.7% .165 254.624);"></div></td></tr>
    <tr><td>border-t-blue-500</td><td>border-top-color: oklch(62.3% .214 259.815);</td><td><div style="border-top-color: oklch(62.3% .214 259.815);"></div></td></tr>
    <tr><td>border-t-blue-600</td><td>border-top-color: oklch(54.6% .245 262.881);</td><td><div style="border-top-color: oklch(54.6% .245 262.881);"></div></td></tr>
    <tr><td>border-t-blue-700</td><td>border-top-color: oklch(48.8% .243 264.376);</td><td><div style="border-top-color: oklch(48.8% .243 264.376);"></div></td></tr>
    <tr><td>border-t-blue-800</td><td>border-top-color: oklch(42.4% .199 265.638);</td><td><div style="border-top-color: oklch(42.4% .199 265.638);"></div></td></tr>
    <tr><td>border-t-blue-900</td><td>border-top-color: oklch(37.9% .146 265.522);</td><td><div style="border-top-color: oklch(37.9% .146 265.522);"></div></td></tr>
    <tr><td>border-t-blue-950</td><td>border-top-color: oklch(28.2% .091 267.935);</td><td><div style="border-top-color: oklch(28.2% .091 267.935);"></div></td></tr>
    <tr><td>border-t-indigo-50</td><td>border-top-color: oklch(96.2% .018 272.314);</td><td><div style="border-top-color: oklch(96.2% .018 272.314);"></div></td></tr>
    <tr><td>border-t-indigo-100</td><td>border-top-color: oklch(93% .034 272.788);</td><td><div style="border-top-color: oklch(93% .034 272.788);"></div></td></tr>
    <tr><td>border-t-indigo-200</td><td>border-top-color: oklch(87% .065 274.039);</td><td><div style="border-top-color: oklch(87% .065 274.039);"></div></td></tr>
    <tr><td>border-t-indigo-300</td><td>border-top-color: oklch(78.5% .115 274.713);</td><td><div style="border-top-color: oklch(78.5% .115 274.713);"></div></td></tr>
    <tr><td>border-t-indigo-400</td><td>border-top-color: oklch(67.3% .182 276.935);</td><td><div style="border-top-color: oklch(67.3% .182 276.935);"></div></td></tr>
    <tr><td>border-t-indigo-500</td><td>border-top-color: oklch(58.5% .233 277.117);</td><td><div style="border-top-color: oklch(58.5% .233 277.117);"></div></td></tr>
    <tr><td>border-t-indigo-600</td><td>border-top-color: oklch(51.1% .262 276.966);</td><td><div style="border-top-color: oklch(51.1% .262 276.966);"></div></td></tr>
    <tr><td>border-t-indigo-700</td><td>border-top-color: oklch(45.7% .24 277.023);</td><td><div style="border-top-color: oklch(45.7% .24 277.023);"></div></td></tr>
    <tr><td>border-t-indigo-800</td><td>border-top-color: oklch(39.8% .195 277.366);</td><td><div style="border-top-color: oklch(39.8% .195 277.366);"></div></td></tr>
    <tr><td>border-t-indigo-900</td><td>border-top-color: oklch(35.9% .144 278.697);</td><td><div style="border-top-color: oklch(35.9% .144 278.697);"></div></td></tr>
    <tr><td>border-t-indigo-950</td><td>border-top-color: oklch(25.7% .09 281.288);</td><td><div style="border-top-color: oklch(25.7% .09 281.288);"></div></td></tr>
    <tr><td>border-t-violet-50</td><td>border-top-color: oklch(96.9% .016 293.756);</td><td><div style="border-top-color: oklch(96.9% .016 293.756);"></div></td></tr>
    <tr><td>border-t-violet-100</td><td>border-top-color: oklch(94.3% .029 294.588);</td><td><div style="border-top-color: oklch(94.3% .029 294.588);"></div></td></tr>
    <tr><td>border-t-violet-200</td><td>border-top-color: oklch(89.4% .057 293.283);</td><td><div style="border-top-color: oklch(89.4% .057 293.283);"></div></td></tr>
    <tr><td>border-t-violet-300</td><td>border-top-color: oklch(81.1% .111 293.571);</td><td><div style="border-top-color: oklch(81.1% .111 293.571);"></div></td></tr>
    <tr><td>border-t-violet-400</td><td>border-top-color: oklch(70.2% .183 293.541);</td><td><div style="border-top-color: oklch(70.2% .183 293.541);"></div></td></tr>
    <tr><td>border-t-violet-500</td><td>border-top-color: oklch(60.6% .25 292.717);</td><td><div style="border-top-color: oklch(60.6% .25 292.717);"></div></td></tr>
    <tr><td>border-t-violet-600</td><td>border-top-color: oklch(54.1% .281 293.009);</td><td><div style="border-top-color: oklch(54.1% .281 293.009);"></div></td></tr>
    <tr><td>border-t-violet-700</td><td>border-top-color: oklch(49.1% .27 292.581);</td><td><div style="border-top-color: oklch(49.1% .27 292.581);"></div></td></tr>
    <tr><td>border-t-violet-800</td><td>border-top-color: oklch(43.2% .232 292.759);</td><td><div style="border-top-color: oklch(43.2% .232 292.759);"></div></td></tr>
    <tr><td>border-t-violet-900</td><td>border-top-color: oklch(38% .189 293.745);</td><td><div style="border-top-color: oklch(38% .189 293.745);"></div></td></tr>
    <tr><td>border-t-violet-950</td><td>border-top-color: oklch(28.3% .141 291.089);</td><td><div style="border-top-color: oklch(28.3% .141 291.089);"></div></td></tr>
    <tr><td>border-t-purple-50</td><td>border-top-color: oklch(97.7% .014 308.299);</td><td><div style="border-top-color: oklch(97.7% .014 308.299);"></div></td></tr>
    <tr><td>border-t-purple-100</td><td>border-top-color: oklch(94.6% .033 307.174);</td><td><div style="border-top-color: oklch(94.6% .033 307.174);"></div></td></tr>
    <tr><td>border-t-purple-200</td><td>border-top-color: oklch(90.2% .063 306.703);</td><td><div style="border-top-color: oklch(90.2% .063 306.703);"></div></td></tr>
    <tr><td>border-t-purple-300</td><td>border-top-color: oklch(82.7% .119 306.383);</td><td><div style="border-top-color: oklch(82.7% .119 306.383);"></div></td></tr>
    <tr><td>border-t-purple-400</td><td>border-top-color: oklch(71.4% .203 305.504);</td><td><div style="border-top-color: oklch(71.4% .203 305.504);"></div></td></tr>
    <tr><td>border-t-purple-500</td><td>border-top-color: oklch(62.7% .265 303.9);</td><td><div style="border-top-color: oklch(62.7% .265 303.9);"></div></td></tr>
    <tr><td>border-t-purple-600</td><td>border-top-color: oklch(55.8% .288 302.321);</td><td><div style="border-top-color: oklch(55.8% .288 302.321);"></div></td></tr>
    <tr><td>border-t-purple-700</td><td>border-top-color: oklch(49.6% .265 301.924);</td><td><div style="border-top-color: oklch(49.6% .265 301.924);"></div></td></tr>
    <tr><td>border-t-purple-800</td><td>border-top-color: oklch(43.8% .218 303.724);</td><td><div style="border-top-color: oklch(43.8% .218 303.724);"></div></td></tr>
    <tr><td>border-t-purple-900</td><td>border-top-color: oklch(38.1% .176 304.987);</td><td><div style="border-top-color: oklch(38.1% .176 304.987);"></div></td></tr>
    <tr><td>border-t-purple-950</td><td>border-top-color: oklch(29.1% .149 302.717);</td><td><div style="border-top-color: oklch(29.1% .149 302.717);"></div></td></tr>
    <tr><td>border-t-fuchsia-50</td><td>border-top-color: oklch(97.7% .017 320.058);</td><td><div style="border-top-color: oklch(97.7% .017 320.058);"></div></td></tr>
    <tr><td>border-t-fuchsia-100</td><td>border-top-color: oklch(95.2% .037 318.852);</td><td><div style="border-top-color: oklch(95.2% .037 318.852);"></div></td></tr>
    <tr><td>border-t-fuchsia-200</td><td>border-top-color: oklch(90.3% .076 319.62);</td><td><div style="border-top-color: oklch(90.3% .076 319.62);"></div></td></tr>
    <tr><td>border-t-fuchsia-300</td><td>border-top-color: oklch(83.3% .145 321.434);</td><td><div style="border-top-color: oklch(83.3% .145 321.434);"></div></td></tr>
    <tr><td>border-t-fuchsia-400</td><td>border-top-color: oklch(74% .238 322.16);</td><td><div style="border-top-color: oklch(74% .238 322.16);"></div></td></tr>
    <tr><td>border-t-fuchsia-500</td><td>border-top-color: oklch(66.7% .295 322.15);</td><td><div style="border-top-color: oklch(66.7% .295 322.15);"></div></td></tr>
    <tr><td>border-t-fuchsia-600</td><td>border-top-color: oklch(59.1% .293 322.896);</td><td><div style="border-top-color: oklch(59.1% .293 322.896);"></div></td></tr>
    <tr><td>border-t-fuchsia-700</td><td>border-top-color: oklch(51.8% .253 323.949);</td><td><div style="border-top-color: oklch(51.8% .253 323.949);"></div></td></tr>
    <tr><td>border-t-fuchsia-800</td><td>border-top-color: oklch(45.2% .211 324.591);</td><td><div style="border-top-color: oklch(45.2% .211 324.591);"></div></td></tr>
    <tr><td>border-t-fuchsia-900</td><td>border-top-color: oklch(40.1% .17 325.612);</td><td><div style="border-top-color: oklch(40.1% .17 325.612);"></div></td></tr>
    <tr><td>border-t-fuchsia-950</td><td>border-top-color: oklch(29.3% .136 325.661);</td><td><div style="border-top-color: oklch(29.3% .136 325.661);"></div></td></tr>
    <tr><td>border-t-pink-50</td><td>border-top-color: oklch(97.1% .014 343.198);</td><td><div style="border-top-color: oklch(97.1% .014 343.198);"></div></td></tr>
    <tr><td>border-t-pink-100</td><td>border-top-color: oklch(94.8% .028 342.258);</td><td><div style="border-top-color: oklch(94.8% .028 342.258);"></div></td></tr>
    <tr><td>border-t-pink-200</td><td>border-top-color: oklch(89.9% .061 343.231);</td><td><div style="border-top-color: oklch(89.9% .061 343.231);"></div></td></tr>
    <tr><td>border-t-pink-300</td><td>border-top-color: oklch(82.3% .12 346.018);</td><td><div style="border-top-color: oklch(82.3% .12 346.018);"></div></td></tr>
    <tr><td>border-t-pink-400</td><td>border-top-color: oklch(71.8% .202 349.761);</td><td><div style="border-top-color: oklch(71.8% .202 349.761);"></div></td></tr>
    <tr><td>border-t-pink-500</td><td>border-top-color: oklch(65.6% .241 354.308);</td><td><div style="border-top-color: oklch(65.6% .241 354.308);"></div></td></tr>
    <tr><td>border-t-pink-600</td><td>border-top-color: oklch(59.2% .249 .584);</td><td><div style="border-top-color: oklch(59.2% .249 .584);"></div></td></tr>
    <tr><td>border-t-pink-700</td><td>border-top-color: oklch(52.5% .223 3.958);</td><td><div style="border-top-color: oklch(52.5% .223 3.958);"></div></td></tr>
    <tr><td>border-t-pink-800</td><td>border-top-color: oklch(45.9% .187 3.815);</td><td><div style="border-top-color: oklch(45.9% .187 3.815);"></div></td></tr>
    <tr><td>border-t-pink-900</td><td>border-top-color: oklch(40.8% .153 2.432);</td><td><div style="border-top-color: oklch(40.8% .153 2.432);"></div></td></tr>
    <tr><td>border-t-pink-950</td><td>border-top-color: oklch(28.4% .109 3.907);</td><td><div style="border-top-color: oklch(28.4% .109 3.907);"></div></td></tr>
    <tr><td>border-t-rose-50</td><td>border-top-color: oklch(96.9% .015 12.422);</td><td><div style="border-top-color: oklch(96.9% .015 12.422);"></div></td></tr>
    <tr><td>border-t-rose-100</td><td>border-top-color: oklch(94.1% .03 12.58);</td><td><div style="border-top-color: oklch(94.1% .03 12.58);"></div></td></tr>
    <tr><td>border-t-rose-200</td><td>border-top-color: oklch(89.2% .058 10.001);</td><td><div style="border-top-color: oklch(89.2% .058 10.001);"></div></td></tr>
    <tr><td>border-t-rose-300</td><td>border-top-color: oklch(81% .117 11.638);</td><td><div style="border-top-color: oklch(81% .117 11.638);"></div></td></tr>
    <tr><td>border-t-rose-400</td><td>border-top-color: oklch(71.2% .194 13.428);</td><td><div style="border-top-color: oklch(71.2% .194 13.428);"></div></td></tr>
    <tr><td>border-t-rose-500</td><td>border-top-color: oklch(64.5% .246 16.439);</td><td><div style="border-top-color: oklch(64.5% .246 16.439);"></div></td></tr>
    <tr><td>border-t-rose-600</td><td>border-top-color: oklch(58.6% .253 17.585);</td><td><div style="border-top-color: oklch(58.6% .253 17.585);"></div></td></tr>
    <tr><td>border-t-rose-700</td><td>border-top-color: oklch(51.4% .222 16.935);</td><td><div style="border-top-color: oklch(51.4% .222 16.935);"></div></td></tr>
    <tr><td>border-t-rose-800</td><td>border-top-color: oklch(45.5% .188 13.697);</td><td><div style="border-top-color: oklch(45.5% .188 13.697);"></div></td></tr>
    <tr><td>border-t-rose-900</td><td>border-top-color: oklch(41% .159 10.272);</td><td><div style="border-top-color: oklch(41% .159 10.272);"></div></td></tr>
    <tr><td>border-t-rose-950</td><td>border-top-color: oklch(27.1% .105 12.094);</td><td><div style="border-top-color: oklch(27.1% .105 12.094);"></div></td></tr>
    <tr><td>border-t-slate-50</td><td>border-top-color: oklch(98.4% .003 247.858);</td><td><div style="border-top-color: oklch(98.4% .003 247.858);"></div></td></tr>
    <tr><td>border-t-slate-100</td><td>border-top-color: oklch(96.8% .007 247.896);</td><td><div style="border-top-color: oklch(96.8% .007 247.896);"></div></td></tr>
    <tr><td>border-t-slate-200</td><td>border-top-color: oklch(92.9% .013 255.508);</td><td><div style="border-top-color: oklch(92.9% .013 255.508);"></div></td></tr>
    <tr><td>border-t-slate-300</td><td>border-top-color: oklch(86.9% .022 252.894);</td><td><div style="border-top-color: oklch(86.9% .022 252.894);"></div></td></tr>
    <tr><td>border-t-slate-400</td><td>border-top-color: oklch(70.4% .04 256.788);</td><td><div style="border-top-color: oklch(70.4% .04 256.788);"></div></td></tr>
    <tr><td>border-t-slate-500</td><td>border-top-color: oklch(55.4% .046 257.417);</td><td><div style="border-top-color: oklch(55.4% .046 257.417);"></div></td></tr>
    <tr><td>border-t-slate-600</td><td>border-top-color: oklch(44.6% .043 257.281);</td><td><div style="border-top-color: oklch(44.6% .043 257.281);"></div></td></tr>
    <tr><td>border-t-slate-700</td><td>border-top-color: oklch(37.2% .044 257.287);</td><td><div style="border-top-color: oklch(37.2% .044 257.287);"></div></td></tr>
    <tr><td>border-t-slate-800</td><td>border-top-color: oklch(27.9% .041 260.031);</td><td><div style="border-top-color: oklch(27.9% .041 260.031);"></div></td></tr>
    <tr><td>border-t-slate-900</td><td>border-top-color: oklch(20.8% .042 265.755);</td><td><div style="border-top-color: oklch(20.8% .042 265.755);"></div></td></tr>
    <tr><td>border-t-slate-950</td><td>border-top-color: oklch(12.9% .042 264.695);</td><td><div style="border-top-color: oklch(12.9% .042 264.695);"></div></td></tr>
    <tr><td>border-t-gray-50</td><td>border-top-color: oklch(98.5% .002 247.839);</td><td><div style="border-top-color: oklch(98.5% .002 247.839);"></div></td></tr>
    <tr><td>border-t-gray-100</td><td>border-top-color: oklch(96.7% .003 264.542);</td><td><div style="border-top-color: oklch(96.7% .003 264.542);"></div></td></tr>
    <tr><td>border-t-gray-200</td><td>border-top-color: oklch(92.8% .006 264.531);</td><td><div style="border-top-color: oklch(92.8% .006 264.531);"></div></td></tr>
    <tr><td>border-t-gray-300</td><td>border-top-color: oklch(87.2% .01 258.338);</td><td><div style="border-top-color: oklch(87.2% .01 258.338);"></div></td></tr>
    <tr><td>border-t-gray-400</td><td>border-top-color: oklch(70.7% .022 261.325);</td><td><div style="border-top-color: oklch(70.7% .022 261.325);"></div></td></tr>
    <tr><td>border-t-gray-500</td><td>border-top-color: oklch(55.1% .027 264.364);</td><td><div style="border-top-color: oklch(55.1% .027 264.364);"></div></td></tr>
    <tr><td>border-t-gray-600</td><td>border-top-color: oklch(44.6% .03 256.802);</td><td><div style="border-top-color: oklch(44.6% .03 256.802);"></div></td></tr>
    <tr><td>border-t-gray-700</td><td>border-top-color: oklch(37.3% .034 259.733);</td><td><div style="border-top-color: oklch(37.3% .034 259.733);"></div></td></tr>
    <tr><td>border-t-gray-800</td><td>border-top-color: oklch(27.8% .033 256.848);</td><td><div style="border-top-color: oklch(27.8% .033 256.848);"></div></td></tr>
    <tr><td>border-t-gray-900</td><td>border-top-color: oklch(21% .034 264.665);</td><td><div style="border-top-color: oklch(21% .034 264.665);"></div></td></tr>
    <tr><td>border-t-gray-950</td><td>border-top-color: oklch(13% .028 261.692);</td><td><div style="border-top-color: oklch(13% .028 261.692);"></div></td></tr>
    <tr><td>border-t-zinc-50</td><td>border-top-color: oklch(98.5% 0 0);</td><td><div style="border-top-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-t-zinc-100</td><td>border-top-color: oklch(96.7% .001 286.375);</td><td><div style="border-top-color: oklch(96.7% .001 286.375);"></div></td></tr>
    <tr><td>border-t-zinc-200</td><td>border-top-color: oklch(92% .004 286.32);</td><td><div style="border-top-color: oklch(92% .004 286.32);"></div></td></tr>
    <tr><td>border-t-zinc-300</td><td>border-top-color: oklch(87.1% .006 286.286);</td><td><div style="border-top-color: oklch(87.1% .006 286.286);"></div></td></tr>
    <tr><td>border-t-zinc-400</td><td>border-top-color: oklch(70.5% .015 286.067);</td><td><div style="border-top-color: oklch(70.5% .015 286.067);"></div></td></tr>
    <tr><td>border-t-zinc-500</td><td>border-top-color: oklch(55.2% .016 285.938);</td><td><div style="border-top-color: oklch(55.2% .016 285.938);"></div></td></tr>
    <tr><td>border-t-zinc-600</td><td>border-top-color: oklch(44.2% .017 285.786);</td><td><div style="border-top-color: oklch(44.2% .017 285.786);"></div></td></tr>
    <tr><td>border-t-zinc-700</td><td>border-top-color: oklch(37% .013 285.805);</td><td><div style="border-top-color: oklch(37% .013 285.805);"></div></td></tr>
    <tr><td>border-t-zinc-800</td><td>border-top-color: oklch(27.4% .006 286.033);</td><td><div style="border-top-color: oklch(27.4% .006 286.033);"></div></td></tr>
    <tr><td>border-t-zinc-900</td><td>border-top-color: oklch(21% .006 285.885);</td><td><div style="border-top-color: oklch(21% .006 285.885);"></div></td></tr>
    <tr><td>border-t-zinc-950</td><td>border-top-color: oklch(14.1% .005 285.823);</td><td><div style="border-top-color: oklch(14.1% .005 285.823);"></div></td></tr>
    <tr><td>border-t-neutral-50</td><td>border-top-color: oklch(98.5% 0 0);</td><td><div style="border-top-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-100</td><td>border-top-color: oklch(97% 0 0);</td><td><div style="border-top-color: oklch(97% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-200</td><td>border-top-color: oklch(92.2% 0 0);</td><td><div style="border-top-color: oklch(92.2% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-300</td><td>border-top-color: oklch(87% 0 0);</td><td><div style="border-top-color: oklch(87% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-400</td><td>border-top-color: oklch(70.8% 0 0);</td><td><div style="border-top-color: oklch(70.8% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-500</td><td>border-top-color: oklch(55.6% 0 0);</td><td><div style="border-top-color: oklch(55.6% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-600</td><td>border-top-color: oklch(43.9% 0 0);</td><td><div style="border-top-color: oklch(43.9% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-700</td><td>border-top-color: oklch(37.1% 0 0);</td><td><div style="border-top-color: oklch(37.1% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-800</td><td>border-top-color: oklch(26.9% 0 0);</td><td><div style="border-top-color: oklch(26.9% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-900</td><td>border-top-color: oklch(20.5% 0 0);</td><td><div style="border-top-color: oklch(20.5% 0 0);"></div></td></tr>
    <tr><td>border-t-neutral-950</td><td>border-top-color: oklch(14.5% 0 0);</td><td><div style="border-top-color: oklch(14.5% 0 0);"></div></td></tr>
    <tr><td>border-t-stone-50</td><td>border-top-color: oklch(98.5% .001 106.423);</td><td><div style="border-top-color: oklch(98.5% .001 106.423);"></div></td></tr>
    <tr><td>border-t-stone-100</td><td>border-top-color: oklch(97% .001 106.424);</td><td><div style="border-top-color: oklch(97% .001 106.424);"></div></td></tr>
    <tr><td>border-t-stone-200</td><td>border-top-color: oklch(92.3% .003 48.717);</td><td><div style="border-top-color: oklch(92.3% .003 48.717);"></div></td></tr>
    <tr><td>border-t-stone-300</td><td>border-top-color: oklch(86.9% .005 56.366);</td><td><div style="border-top-color: oklch(86.9% .005 56.366);"></div></td></tr>
    <tr><td>border-t-stone-400</td><td>border-top-color: oklch(70.9% .01 56.259);</td><td><div style="border-top-color: oklch(70.9% .01 56.259);"></div></td></tr>
    <tr><td>border-t-stone-500</td><td>border-top-color: oklch(55.3% .013 58.071);</td><td><div style="border-top-color: oklch(55.3% .013 58.071);"></div></td></tr>
    <tr><td>border-t-stone-600</td><td>border-top-color: oklch(44.4% .011 73.639);</td><td><div style="border-top-color: oklch(44.4% .011 73.639);"></div></td></tr>
    <tr><td>border-t-stone-700</td><td>border-top-color: oklch(37.4% .01 67.558);</td><td><div style="border-top-color: oklch(37.4% .01 67.558);"></div></td></tr>
    <tr><td>border-t-stone-800</td><td>border-top-color: oklch(26.8% .007 34.298);</td><td><div style="border-top-color: oklch(26.8% .007 34.298);"></div></td></tr>
    <tr><td>border-t-stone-900</td><td>border-top-color: oklch(21.6% .006 56.043);</td><td><div style="border-top-color: oklch(21.6% .006 56.043);"></div></td></tr>
    <tr><td>border-t-stone-950</td><td>border-top-color: oklch(14.7% .004 49.25);</td><td><div style="border-top-color: oklch(14.7% .004 49.25);"></div></td></tr>
    <tr><td>border-t-black</td><td>border-top-color: #000;</td><td><div style="border-top-color: #000;"></div></td></tr>
    <tr><td>border-t-white</td><td>border-top-color: #fff;</td><td><div style="border-top-color: #fff;"></div></td></tr>
    <tr><td>border-r-inherit</td><td>border-right-color: inherit;</td><td><div style="border-right-color: inherit;"></div></td></tr>
    <tr><td>border-r-current</td><td>border-right-color: currentColor;</td><td><div style="border-right-color: currentColor;"></div></td></tr>
    <tr><td>border-r-transparent</td><td>border-right-color: transparent;</td><td><div style="border-right-color: transparent;"></div></td></tr>
    <tr><td>border-r-red-50</td><td>border-right-color: oklch(97.1% .013 17.38);</td><td><div style="border-right-color: oklch(97.1% .013 17.38);"></div></td></tr>
    <tr><td>border-r-red-100</td><td>border-right-color: oklch(93.6% .032 17.717);</td><td><div style="border-right-color: oklch(93.6% .032 17.717);"></div></td></tr>
    <tr><td>border-r-red-200</td><td>border-right-color: oklch(88.5% .062 18.334);</td><td><div style="border-right-color: oklch(88.5% .062 18.334);"></div></td></tr>
    <tr><td>border-r-red-300</td><td>border-right-color: oklch(80.8% .114 19.571);</td><td><div style="border-right-color: oklch(80.8% .114 19.571);"></div></td></tr>
    <tr><td>border-r-red-400</td><td>border-right-color: oklch(70.4% .191 22.216);</td><td><div style="border-right-color: oklch(70.4% .191 22.216);"></div></td></tr>
    <tr><td>border-r-red-500</td><td>border-right-color: oklch(63.7% .237 25.331);</td><td><div style="border-right-color: oklch(63.7% .237 25.331);"></div></td></tr>
    <tr><td>border-r-red-600</td><td>border-right-color: oklch(57.7% .245 27.325);</td><td><div style="border-right-color: oklch(57.7% .245 27.325);"></div></td></tr>
    <tr><td>border-r-red-700</td><td>border-right-color: oklch(50.5% .213 27.518);</td><td><div style="border-right-color: oklch(50.5% .213 27.518);"></div></td></tr>
    <tr><td>border-r-red-800</td><td>border-right-color: oklch(44.4% .177 26.899);</td><td><div style="border-right-color: oklch(44.4% .177 26.899);"></div></td></tr>
    <tr><td>border-r-red-900</td><td>border-right-color: oklch(39.6% .141 25.723);</td><td><div style="border-right-color: oklch(39.6% .141 25.723);"></div></td></tr>
    <tr><td>border-r-red-950</td><td>border-right-color: oklch(25.8% .092 26.042);</td><td><div style="border-right-color: oklch(25.8% .092 26.042);"></div></td></tr>
    <tr><td>border-r-orange-50</td><td>border-right-color: oklch(98% .016 73.684);</td><td><div style="border-right-color: oklch(98% .016 73.684);"></div></td></tr>
    <tr><td>border-r-orange-100</td><td>border-right-color: oklch(95.4% .038 75.164);</td><td><div style="border-right-color: oklch(95.4% .038 75.164);"></div></td></tr>
    <tr><td>border-r-orange-200</td><td>border-right-color: oklch(90.1% .076 70.697);</td><td><div style="border-right-color: oklch(90.1% .076 70.697);"></div></td></tr>
    <tr><td>border-r-orange-300</td><td>border-right-color: oklch(83.7% .128 66.29);</td><td><div style="border-right-color: oklch(83.7% .128 66.29);"></div></td></tr>
    <tr><td>border-r-orange-400</td><td>border-right-color: oklch(75% .183 55.934);</td><td><div style="border-right-color: oklch(75% .183 55.934);"></div></td></tr>
    <tr><td>border-r-orange-500</td><td>border-right-color: oklch(70.5% .213 47.604);</td><td><div style="border-right-color: oklch(70.5% .213 47.604);"></div></td></tr>
    <tr><td>border-r-orange-600</td><td>border-right-color: oklch(64.6% .222 41.116);</td><td><div style="border-right-color: oklch(64.6% .222 41.116);"></div></td></tr>
    <tr><td>border-r-orange-700</td><td>border-right-color: oklch(55.3% .195 38.402);</td><td><div style="border-right-color: oklch(55.3% .195 38.402);"></div></td></tr>
    <tr><td>border-r-orange-800</td><td>border-right-color: oklch(47% .157 37.304);</td><td><div style="border-right-color: oklch(47% .157 37.304);"></div></td></tr>
    <tr><td>border-r-orange-900</td><td>border-right-color: oklch(40.8% .123 38.172);</td><td><div style="border-right-color: oklch(40.8% .123 38.172);"></div></td></tr>
    <tr><td>border-r-orange-950</td><td>border-right-color: oklch(26.6% .079 36.259);</td><td><div style="border-right-color: oklch(26.6% .079 36.259);"></div></td></tr>
    <tr><td>border-r-amber-50</td><td>border-right-color: oklch(98.7% .022 95.277);</td><td><div style="border-right-color: oklch(98.7% .022 95.277);"></div></td></tr>
    <tr><td>border-r-amber-100</td><td>border-right-color: oklch(96.2% .059 95.617);</td><td><div style="border-right-color: oklch(96.2% .059 95.617);"></div></td></tr>
    <tr><td>border-r-amber-200</td><td>border-right-color: oklch(92.4% .12 95.746);</td><td><div style="border-right-color: oklch(92.4% .12 95.746);"></div></td></tr>
    <tr><td>border-r-amber-300</td><td>border-right-color: oklch(87.9% .169 91.605);</td><td><div style="border-right-color: oklch(87.9% .169 91.605);"></div></td></tr>
    <tr><td>border-r-amber-400</td><td>border-right-color: oklch(82.8% .189 84.429);</td><td><div style="border-right-color: oklch(82.8% .189 84.429);"></div></td></tr>
    <tr><td>border-r-amber-500</td><td>border-right-color: oklch(76.9% .188 70.08);</td><td><div style="border-right-color: oklch(76.9% .188 70.08);"></div></td></tr>
    <tr><td>border-r-amber-600</td><td>border-right-color: oklch(66.6% .179 58.318);</td><td><div style="border-right-color: oklch(66.6% .179 58.318);"></div></td></tr>
    <tr><td>border-r-amber-700</td><td>border-right-color: oklch(55.5% .163 48.998);</td><td><div style="border-right-color: oklch(55.5% .163 48.998);"></div></td></tr>
    <tr><td>border-r-amber-800</td><td>border-right-color: oklch(47.3% .137 46.201);</td><td><div style="border-right-color: oklch(47.3% .137 46.201);"></div></td></tr>
    <tr><td>border-r-amber-900</td><td>border-right-color: oklch(41.4% .112 45.904);</td><td><div style="border-right-color: oklch(41.4% .112 45.904);"></div></td></tr>
    <tr><td>border-r-amber-950</td><td>border-right-color: oklch(27.9% .077 45.635);</td><td><div style="border-right-color: oklch(27.9% .077 45.635);"></div></td></tr>
    <tr><td>border-r-yellow-50</td><td>border-right-color: oklch(98.7% .026 102.212);</td><td><div style="border-right-color: oklch(98.7% .026 102.212);"></div></td></tr>
    <tr><td>border-r-yellow-100</td><td>border-right-color: oklch(97.3% .071 103.193);</td><td><div style="border-right-color: oklch(97.3% .071 103.193);"></div></td></tr>
    <tr><td>border-r-yellow-200</td><td>border-right-color: oklch(94.5% .129 101.54);</td><td><div style="border-right-color: oklch(94.5% .129 101.54);"></div></td></tr>
    <tr><td>border-r-yellow-300</td><td>border-right-color: oklch(90.5% .182 98.111);</td><td><div style="border-right-color: oklch(90.5% .182 98.111);"></div></td></tr>
    <tr><td>border-r-yellow-400</td><td>border-right-color: oklch(85.2% .199 91.936);</td><td><div style="border-right-color: oklch(85.2% .199 91.936);"></div></td></tr>
    <tr><td>border-r-yellow-500</td><td>border-right-color: oklch(79.5% .184 86.047);</td><td><div style="border-right-color: oklch(79.5% .184 86.047);"></div></td></tr>
    <tr><td>border-r-yellow-600</td><td>border-right-color: oklch(68.1% .162 75.834);</td><td><div style="border-right-color: oklch(68.1% .162 75.834);"></div></td></tr>
    <tr><td>border-r-yellow-700</td><td>border-right-color: oklch(55.4% .135 66.442);</td><td><div style="border-right-color: oklch(55.4% .135 66.442);"></div></td></tr>
    <tr><td>border-r-yellow-800</td><td>border-right-color: oklch(47.6% .114 61.907);</td><td><div style="border-right-color: oklch(47.6% .114 61.907);"></div></td></tr>
    <tr><td>border-r-yellow-900</td><td>border-right-color: oklch(42.1% .095 57.708);</td><td><div style="border-right-color: oklch(42.1% .095 57.708);"></div></td></tr>
    <tr><td>border-r-yellow-950</td><td>border-right-color: oklch(28.6% .066 53.813);</td><td><div style="border-right-color: oklch(28.6% .066 53.813);"></div></td></tr>
    <tr><td>border-r-lime-50</td><td>border-right-color: oklch(98.6% .031 120.757);</td><td><div style="border-right-color: oklch(98.6% .031 120.757);"></div></td></tr>
    <tr><td>border-r-lime-100</td><td>border-right-color: oklch(96.7% .067 122.328);</td><td><div style="border-right-color: oklch(96.7% .067 122.328);"></div></td></tr>
    <tr><td>border-r-lime-200</td><td>border-right-color: oklch(93.8% .127 124.321);</td><td><div style="border-right-color: oklch(93.8% .127 124.321);"></div></td></tr>
    <tr><td>border-r-lime-300</td><td>border-right-color: oklch(89.7% .196 126.665);</td><td><div style="border-right-color: oklch(89.7% .196 126.665);"></div></td></tr>
    <tr><td>border-r-lime-400</td><td>border-right-color: oklch(84.1% .238 128.85);</td><td><div style="border-right-color: oklch(84.1% .238 128.85);"></div></td></tr>
    <tr><td>border-r-lime-500</td><td>border-right-color: oklch(76.8% .233 130.85);</td><td><div style="border-right-color: oklch(76.8% .233 130.85);"></div></td></tr>
    <tr><td>border-r-lime-600</td><td>border-right-color: oklch(64.8% .2 131.684);</td><td><div style="border-right-color: oklch(64.8% .2 131.684);"></div></td></tr>
    <tr><td>border-r-lime-700</td><td>border-right-color: oklch(53.2% .157 131.589);</td><td><div style="border-right-color: oklch(53.2% .157 131.589);"></div></td></tr>
    <tr><td>border-r-lime-800</td><td>border-right-color: oklch(45.3% .124 130.933);</td><td><div style="border-right-color: oklch(45.3% .124 130.933);"></div></td></tr>
    <tr><td>border-r-lime-900</td><td>border-right-color: oklch(40.5% .101 131.063);</td><td><div style="border-right-color: oklch(40.5% .101 131.063);"></div></td></tr>
    <tr><td>border-r-lime-950</td><td>border-right-color: oklch(27.4% .072 132.109);</td><td><div style="border-right-color: oklch(27.4% .072 132.109);"></div></td></tr>
    <tr><td>border-r-green-50</td><td>border-right-color: oklch(98.2% .018 155.826);</td><td><div style="border-right-color: oklch(98.2% .018 155.826);"></div></td></tr>
    <tr><td>border-r-green-100</td><td>border-right-color: oklch(96.2% .044 156.743);</td><td><div style="border-right-color: oklch(96.2% .044 156.743);"></div></td></tr>
    <tr><td>border-r-green-200</td><td>border-right-color: oklch(92.5% .084 155.995);</td><td><div style="border-right-color: oklch(92.5% .084 155.995);"></div></td></tr>
    <tr><td>border-r-green-300</td><td>border-right-color: oklch(87.1% .15 154.449);</td><td><div style="border-right-color: oklch(87.1% .15 154.449);"></div></td></tr>
    <tr><td>border-r-green-400</td><td>border-right-color: oklch(79.2% .209 151.711);</td><td><div style="border-right-color: oklch(79.2% .209 151.711);"></div></td></tr>
    <tr><td>border-r-green-500</td><td>border-right-color: oklch(72.3% .219 149.579);</td><td><div style="border-right-color: oklch(72.3% .219 149.579);"></div></td></tr>
    <tr><td>border-r-green-600</td><td>border-right-color: oklch(62.7% .194 149.214);</td><td><div style="border-right-color: oklch(62.7% .194 149.214);"></div></td></tr>
    <tr><td>border-r-green-700</td><td>border-right-color: oklch(52.7% .154 150.069);</td><td><div style="border-right-color: oklch(52.7% .154 150.069);"></div></td></tr>
    <tr><td>border-r-green-800</td><td>border-right-color: oklch(44.8% .119 151.328);</td><td><div style="border-right-color: oklch(44.8% .119 151.328);"></div></td></tr>
    <tr><td>border-r-green-900</td><td>border-right-color: oklch(39.3% .095 152.535);</td><td><div style="border-right-color: oklch(39.3% .095 152.535);"></div></td></tr>
    <tr><td>border-r-green-950</td><td>border-right-color: oklch(26.6% .065 152.934);</td><td><div style="border-right-color: oklch(26.6% .065 152.934);"></div></td></tr>
    <tr><td>border-r-emerald-50</td><td>border-right-color: oklch(97.9% .021 166.113);</td><td><div style="border-right-color: oklch(97.9% .021 166.113);"></div></td></tr>
    <tr><td>border-r-emerald-100</td><td>border-right-color: oklch(95% .052 163.051);</td><td><div style="border-right-color: oklch(95% .052 163.051);"></div></td></tr>
    <tr><td>border-r-emerald-200</td><td>border-right-color: oklch(90.5% .093 164.15);</td><td><div style="border-right-color: oklch(90.5% .093 164.15);"></div></td></tr>
    <tr><td>border-r-emerald-300</td><td>border-right-color: oklch(84.5% .143 164.978);</td><td><div style="border-right-color: oklch(84.5% .143 164.978);"></div></td></tr>
    <tr><td>border-r-emerald-400</td><td>border-right-color: oklch(76.5% .177 163.223);</td><td><div style="border-right-color: oklch(76.5% .177 163.223);"></div></td></tr>
    <tr><td>border-r-emerald-500</td><td>border-right-color: oklch(69.6% .17 162.48);</td><td><div style="border-right-color: oklch(69.6% .17 162.48);"></div></td></tr>
    <tr><td>border-r-emerald-600</td><td>border-right-color: oklch(59.6% .145 163.225);</td><td><div style="border-right-color: oklch(59.6% .145 163.225);"></div></td></tr>
    <tr><td>border-r-emerald-700</td><td>border-right-color: oklch(50.8% .118 165.612);</td><td><div style="border-right-color: oklch(50.8% .118 165.612);"></div></td></tr>
    <tr><td>border-r-emerald-800</td><td>border-right-color: oklch(43.2% .095 166.913);</td><td><div style="border-right-color: oklch(43.2% .095 166.913);"></div></td></tr>
    <tr><td>border-r-emerald-900</td><td>border-right-color: oklch(37.8% .077 168.94);</td><td><div style="border-right-color: oklch(37.8% .077 168.94);"></div></td></tr>
    <tr><td>border-r-emerald-950</td><td>border-right-color: oklch(26.2% .051 172.552);</td><td><div style="border-right-color: oklch(26.2% .051 172.552);"></div></td></tr>
    <tr><td>border-r-teal-50</td><td>border-right-color: oklch(98.4% .014 180.72);</td><td><div style="border-right-color: oklch(98.4% .014 180.72);"></div></td></tr>
    <tr><td>border-r-teal-100</td><td>border-right-color: oklch(95.3% .051 180.801);</td><td><div style="border-right-color: oklch(95.3% .051 180.801);"></div></td></tr>
    <tr><td>border-r-teal-200</td><td>border-right-color: oklch(91% .096 180.426);</td><td><div style="border-right-color: oklch(91% .096 180.426);"></div></td></tr>
    <tr><td>border-r-teal-300</td><td>border-right-color: oklch(85.5% .138 181.071);</td><td><div style="border-right-color: oklch(85.5% .138 181.071);"></div></td></tr>
    <tr><td>border-r-teal-400</td><td>border-right-color: oklch(77.7% .152 181.912);</td><td><div style="border-right-color: oklch(77.7% .152 181.912);"></div></td></tr>
    <tr><td>border-r-teal-500</td><td>border-right-color: oklch(70.4% .14 182.503);</td><td><div style="border-right-color: oklch(70.4% .14 182.503);"></div></td></tr>
    <tr><td>border-r-teal-600</td><td>border-right-color: oklch(60% .118 184.704);</td><td><div style="border-right-color: oklch(60% .118 184.704);"></div></td></tr>
    <tr><td>border-r-teal-700</td><td>border-right-color: oklch(51.1% .096 186.391);</td><td><div style="border-right-color: oklch(51.1% .096 186.391);"></div></td></tr>
    <tr><td>border-r-teal-800</td><td>border-right-color: oklch(43.7% .078 188.216);</td><td><div style="border-right-color: oklch(43.7% .078 188.216);"></div></td></tr>
    <tr><td>border-r-teal-900</td><td>border-right-color: oklch(38.6% .063 188.416);</td><td><div style="border-right-color: oklch(38.6% .063 188.416);"></div></td></tr>
    <tr><td>border-r-teal-950</td><td>border-right-color: oklch(27.7% .046 192.524);</td><td><div style="border-right-color: oklch(27.7% .046 192.524);"></div></td></tr>
    <tr><td>border-r-cyan-50</td><td>border-right-color: oklch(98.4% .019 200.873);</td><td><div style="border-right-color: oklch(98.4% .019 200.873);"></div></td></tr>
    <tr><td>border-r-cyan-100</td><td>border-right-color: oklch(95.6% .045 203.388);</td><td><div style="border-right-color: oklch(95.6% .045 203.388);"></div></td></tr>
    <tr><td>border-r-cyan-200</td><td>border-right-color: oklch(91.7% .08 205.041);</td><td><div style="border-right-color: oklch(91.7% .08 205.041);"></div></td></tr>
    <tr><td>border-r-cyan-300</td><td>border-right-color: oklch(86.5% .127 207.078);</td><td><div style="border-right-color: oklch(86.5% .127 207.078);"></div></td></tr>
    <tr><td>border-r-cyan-400</td><td>border-right-color: oklch(78.9% .154 211.53);</td><td><div style="border-right-color: oklch(78.9% .154 211.53);"></div></td></tr>
    <tr><td>border-r-cyan-500</td><td>border-right-color: oklch(71.5% .143 215.221);</td><td><div style="border-right-color: oklch(71.5% .143 215.221);"></div></td></tr>
    <tr><td>border-r-cyan-600</td><td>border-right-color: oklch(60.9% .126 221.723);</td><td><div style="border-right-color: oklch(60.9% .126 221.723);"></div></td></tr>
    <tr><td>border-r-cyan-700</td><td>border-right-color: oklch(52% .105 223.128);</td><td><div style="border-right-color: oklch(52% .105 223.128);"></div></td></tr>
    <tr><td>border-r-cyan-800</td><td>border-right-color: oklch(45% .085 224.283);</td><td><div style="border-right-color: oklch(45% .085 224.283);"></div></td></tr>
    <tr><td>border-r-cyan-900</td><td>border-right-color: oklch(39.8% .07 227.392);</td><td><div style="border-right-color: oklch(39.8% .07 227.392);"></div></td></tr>
    <tr><td>border-r-cyan-950</td><td>border-right-color: oklch(30.2% .056 229.695);</td><td><div style="border-right-color: oklch(30.2% .056 229.695);"></div></td></tr>
    <tr><td>border-r-sky-50</td><td>border-right-color: oklch(97.7% .013 236.62);</td><td><div style="border-right-color: oklch(97.7% .013 236.62);"></div></td></tr>
    <tr><td>border-r-sky-100</td><td>border-right-color: oklch(95.1% .026 236.824);</td><td><div style="border-right-color: oklch(95.1% .026 236.824);"></div></td></tr>
    <tr><td>border-r-sky-200</td><td>border-right-color: oklch(90.1% .058 230.902);</td><td><div style="border-right-color: oklch(90.1% .058 230.902);"></div></td></tr>
    <tr><td>border-r-sky-300</td><td>border-right-color: oklch(82.8% .111 230.318);</td><td><div style="border-right-color: oklch(82.8% .111 230.318);"></div></td></tr>
    <tr><td>border-r-sky-400</td><td>border-right-color: oklch(74.6% .16 232.661);</td><td><div style="border-right-color: oklch(74.6% .16 232.661);"></div></td></tr>
    <tr><td>border-r-sky-500</td><td>border-right-color: oklch(68.5% .169 237.323);</td><td><div style="border-right-color: oklch(68.5% .169 237.323);"></div></td></tr>
    <tr><td>border-r-sky-600</td><td>border-right-color: oklch(58.8% .158 241.966);</td><td><div style="border-right-color: oklch(58.8% .158 241.966);"></div></td></tr>
    <tr><td>border-r-sky-700</td><td>border-right-color: oklch(50% .134 242.749);</td><td><div style="border-right-color: oklch(50% .134 242.749);"></div></td></tr>
    <tr><td>border-r-sky-800</td><td>border-right-color: oklch(44.3% .11 240.79);</td><td><div style="border-right-color: oklch(44.3% .11 240.79);"></div></td></tr>
    <tr><td>border-r-sky-900</td><td>border-right-color: oklch(39.1% .09 240.876);</td><td><div style="border-right-color: oklch(39.1% .09 240.876);"></div></td></tr>
    <tr><td>border-r-sky-950</td><td>border-right-color: oklch(29.3% .066 243.157);</td><td><div style="border-right-color: oklch(29.3% .066 243.157);"></div></td></tr>
    <tr><td>border-r-blue-50</td><td>border-right-color: oklch(97% .014 254.604);</td><td><div style="border-right-color: oklch(97% .014 254.604);"></div></td></tr>
    <tr><td>border-r-blue-100</td><td>border-right-color: oklch(93.2% .032 255.585);</td><td><div style="border-right-color: oklch(93.2% .032 255.585);"></div></td></tr>
    <tr><td>border-r-blue-200</td><td>border-right-color: oklch(88.2% .059 254.128);</td><td><div style="border-right-color: oklch(88.2% .059 254.128);"></div></td></tr>
    <tr><td>border-r-blue-300</td><td>border-right-color: oklch(80.9% .105 251.813);</td><td><div style="border-right-color: oklch(80.9% .105 251.813);"></div></td></tr>
    <tr><td>border-r-blue-400</td><td>border-right-color: oklch(70.7% .165 254.624);</td><td><div style="border-right-color: oklch(70.7% .165 254.624);"></div></td></tr>
    <tr><td>border-r-blue-500</td><td>border-right-color: oklch(62.3% .214 259.815);</td><td><div style="border-right-color: oklch(62.3% .214 259.815);"></div></td></tr>
    <tr><td>border-r-blue-600</td><td>border-right-color: oklch(54.6% .245 262.881);</td><td><div style="border-right-color: oklch(54.6% .245 262.881);"></div></td></tr>
    <tr><td>border-r-blue-700</td><td>border-right-color: oklch(48.8% .243 264.376);</td><td><div style="border-right-color: oklch(48.8% .243 264.376);"></div></td></tr>
    <tr><td>border-r-blue-800</td><td>border-right-color: oklch(42.4% .199 265.638);</td><td><div style="border-right-color: oklch(42.4% .199 265.638);"></div></td></tr>
    <tr><td>border-r-blue-900</td><td>border-right-color: oklch(37.9% .146 265.522);</td><td><div style="border-right-color: oklch(37.9% .146 265.522);"></div></td></tr>
    <tr><td>border-r-blue-950</td><td>border-right-color: oklch(28.2% .091 267.935);</td><td><div style="border-right-color: oklch(28.2% .091 267.935);"></div></td></tr>
    <tr><td>border-r-indigo-50</td><td>border-right-color: oklch(96.2% .018 272.314);</td><td><div style="border-right-color: oklch(96.2% .018 272.314);"></div></td></tr>
    <tr><td>border-r-indigo-100</td><td>border-right-color: oklch(93% .034 272.788);</td><td><div style="border-right-color: oklch(93% .034 272.788);"></div></td></tr>
    <tr><td>border-r-indigo-200</td><td>border-right-color: oklch(87% .065 274.039);</td><td><div style="border-right-color: oklch(87% .065 274.039);"></div></td></tr>
    <tr><td>border-r-indigo-300</td><td>border-right-color: oklch(78.5% .115 274.713);</td><td><div style="border-right-color: oklch(78.5% .115 274.713);"></div></td></tr>
    <tr><td>border-r-indigo-400</td><td>border-right-color: oklch(67.3% .182 276.935);</td><td><div style="border-right-color: oklch(67.3% .182 276.935);"></div></td></tr>
    <tr><td>border-r-indigo-500</td><td>border-right-color: oklch(58.5% .233 277.117);</td><td><div style="border-right-color: oklch(58.5% .233 277.117);"></div></td></tr>
    <tr><td>border-r-indigo-600</td><td>border-right-color: oklch(51.1% .262 276.966);</td><td><div style="border-right-color: oklch(51.1% .262 276.966);"></div></td></tr>
    <tr><td>border-r-indigo-700</td><td>border-right-color: oklch(45.7% .24 277.023);</td><td><div style="border-right-color: oklch(45.7% .24 277.023);"></div></td></tr>
    <tr><td>border-r-indigo-800</td><td>border-right-color: oklch(39.8% .195 277.366);</td><td><div style="border-right-color: oklch(39.8% .195 277.366);"></div></td></tr>
    <tr><td>border-r-indigo-900</td><td>border-right-color: oklch(35.9% .144 278.697);</td><td><div style="border-right-color: oklch(35.9% .144 278.697);"></div></td></tr>
    <tr><td>border-r-indigo-950</td><td>border-right-color: oklch(25.7% .09 281.288);</td><td><div style="border-right-color: oklch(25.7% .09 281.288);"></div></td></tr>
    <tr><td>border-r-violet-50</td><td>border-right-color: oklch(96.9% .016 293.756);</td><td><div style="border-right-color: oklch(96.9% .016 293.756);"></div></td></tr>
    <tr><td>border-r-violet-100</td><td>border-right-color: oklch(94.3% .029 294.588);</td><td><div style="border-right-color: oklch(94.3% .029 294.588);"></div></td></tr>
    <tr><td>border-r-violet-200</td><td>border-right-color: oklch(89.4% .057 293.283);</td><td><div style="border-right-color: oklch(89.4% .057 293.283);"></div></td></tr>
    <tr><td>border-r-violet-300</td><td>border-right-color: oklch(81.1% .111 293.571);</td><td><div style="border-right-color: oklch(81.1% .111 293.571);"></div></td></tr>
    <tr><td>border-r-violet-400</td><td>border-right-color: oklch(70.2% .183 293.541);</td><td><div style="border-right-color: oklch(70.2% .183 293.541);"></div></td></tr>
    <tr><td>border-r-violet-500</td><td>border-right-color: oklch(60.6% .25 292.717);</td><td><div style="border-right-color: oklch(60.6% .25 292.717);"></div></td></tr>
    <tr><td>border-r-violet-600</td><td>border-right-color: oklch(54.1% .281 293.009);</td><td><div style="border-right-color: oklch(54.1% .281 293.009);"></div></td></tr>
    <tr><td>border-r-violet-700</td><td>border-right-color: oklch(49.1% .27 292.581);</td><td><div style="border-right-color: oklch(49.1% .27 292.581);"></div></td></tr>
    <tr><td>border-r-violet-800</td><td>border-right-color: oklch(43.2% .232 292.759);</td><td><div style="border-right-color: oklch(43.2% .232 292.759);"></div></td></tr>
    <tr><td>border-r-violet-900</td><td>border-right-color: oklch(38% .189 293.745);</td><td><div style="border-right-color: oklch(38% .189 293.745);"></div></td></tr>
    <tr><td>border-r-violet-950</td><td>border-right-color: oklch(28.3% .141 291.089);</td><td><div style="border-right-color: oklch(28.3% .141 291.089);"></div></td></tr>
    <tr><td>border-r-purple-50</td><td>border-right-color: oklch(97.7% .014 308.299);</td><td><div style="border-right-color: oklch(97.7% .014 308.299);"></div></td></tr>
    <tr><td>border-r-purple-100</td><td>border-right-color: oklch(94.6% .033 307.174);</td><td><div style="border-right-color: oklch(94.6% .033 307.174);"></div></td></tr>
    <tr><td>border-r-purple-200</td><td>border-right-color: oklch(90.2% .063 306.703);</td><td><div style="border-right-color: oklch(90.2% .063 306.703);"></div></td></tr>
    <tr><td>border-r-purple-300</td><td>border-right-color: oklch(82.7% .119 306.383);</td><td><div style="border-right-color: oklch(82.7% .119 306.383);"></div></td></tr>
    <tr><td>border-r-purple-400</td><td>border-right-color: oklch(71.4% .203 305.504);</td><td><div style="border-right-color: oklch(71.4% .203 305.504);"></div></td></tr>
    <tr><td>border-r-purple-500</td><td>border-right-color: oklch(62.7% .265 303.9);</td><td><div style="border-right-color: oklch(62.7% .265 303.9);"></div></td></tr>
    <tr><td>border-r-purple-600</td><td>border-right-color: oklch(55.8% .288 302.321);</td><td><div style="border-right-color: oklch(55.8% .288 302.321);"></div></td></tr>
    <tr><td>border-r-purple-700</td><td>border-right-color: oklch(49.6% .265 301.924);</td><td><div style="border-right-color: oklch(49.6% .265 301.924);"></div></td></tr>
    <tr><td>border-r-purple-800</td><td>border-right-color: oklch(43.8% .218 303.724);</td><td><div style="border-right-color: oklch(43.8% .218 303.724);"></div></td></tr>
    <tr><td>border-r-purple-900</td><td>border-right-color: oklch(38.1% .176 304.987);</td><td><div style="border-right-color: oklch(38.1% .176 304.987);"></div></td></tr>
    <tr><td>border-r-purple-950</td><td>border-right-color: oklch(29.1% .149 302.717);</td><td><div style="border-right-color: oklch(29.1% .149 302.717);"></div></td></tr>
    <tr><td>border-r-fuchsia-50</td><td>border-right-color: oklch(97.7% .017 320.058);</td><td><div style="border-right-color: oklch(97.7% .017 320.058);"></div></td></tr>
    <tr><td>border-r-fuchsia-100</td><td>border-right-color: oklch(95.2% .037 318.852);</td><td><div style="border-right-color: oklch(95.2% .037 318.852);"></div></td></tr>
    <tr><td>border-r-fuchsia-200</td><td>border-right-color: oklch(90.3% .076 319.62);</td><td><div style="border-right-color: oklch(90.3% .076 319.62);"></div></td></tr>
    <tr><td>border-r-fuchsia-300</td><td>border-right-color: oklch(83.3% .145 321.434);</td><td><div style="border-right-color: oklch(83.3% .145 321.434);"></div></td></tr>
    <tr><td>border-r-fuchsia-400</td><td>border-right-color: oklch(74% .238 322.16);</td><td><div style="border-right-color: oklch(74% .238 322.16);"></div></td></tr>
    <tr><td>border-r-fuchsia-500</td><td>border-right-color: oklch(66.7% .295 322.15);</td><td><div style="border-right-color: oklch(66.7% .295 322.15);"></div></td></tr>
    <tr><td>border-r-fuchsia-600</td><td>border-right-color: oklch(59.1% .293 322.896);</td><td><div style="border-right-color: oklch(59.1% .293 322.896);"></div></td></tr>
    <tr><td>border-r-fuchsia-700</td><td>border-right-color: oklch(51.8% .253 323.949);</td><td><div style="border-right-color: oklch(51.8% .253 323.949);"></div></td></tr>
    <tr><td>border-r-fuchsia-800</td><td>border-right-color: oklch(45.2% .211 324.591);</td><td><div style="border-right-color: oklch(45.2% .211 324.591);"></div></td></tr>
    <tr><td>border-r-fuchsia-900</td><td>border-right-color: oklch(40.1% .17 325.612);</td><td><div style="border-right-color: oklch(40.1% .17 325.612);"></div></td></tr>
    <tr><td>border-r-fuchsia-950</td><td>border-right-color: oklch(29.3% .136 325.661);</td><td><div style="border-right-color: oklch(29.3% .136 325.661);"></div></td></tr>
    <tr><td>border-r-pink-50</td><td>border-right-color: oklch(97.1% .014 343.198);</td><td><div style="border-right-color: oklch(97.1% .014 343.198);"></div></td></tr>
    <tr><td>border-r-pink-100</td><td>border-right-color: oklch(94.8% .028 342.258);</td><td><div style="border-right-color: oklch(94.8% .028 342.258);"></div></td></tr>
    <tr><td>border-r-pink-200</td><td>border-right-color: oklch(89.9% .061 343.231);</td><td><div style="border-right-color: oklch(89.9% .061 343.231);"></div></td></tr>
    <tr><td>border-r-pink-300</td><td>border-right-color: oklch(82.3% .12 346.018);</td><td><div style="border-right-color: oklch(82.3% .12 346.018);"></div></td></tr>
    <tr><td>border-r-pink-400</td><td>border-right-color: oklch(71.8% .202 349.761);</td><td><div style="border-right-color: oklch(71.8% .202 349.761);"></div></td></tr>
    <tr><td>border-r-pink-500</td><td>border-right-color: oklch(65.6% .241 354.308);</td><td><div style="border-right-color: oklch(65.6% .241 354.308);"></div></td></tr>
    <tr><td>border-r-pink-600</td><td>border-right-color: oklch(59.2% .249 .584);</td><td><div style="border-right-color: oklch(59.2% .249 .584);"></div></td></tr>
    <tr><td>border-r-pink-700</td><td>border-right-color: oklch(52.5% .223 3.958);</td><td><div style="border-right-color: oklch(52.5% .223 3.958);"></div></td></tr>
    <tr><td>border-r-pink-800</td><td>border-right-color: oklch(45.9% .187 3.815);</td><td><div style="border-right-color: oklch(45.9% .187 3.815);"></div></td></tr>
    <tr><td>border-r-pink-900</td><td>border-right-color: oklch(40.8% .153 2.432);</td><td><div style="border-right-color: oklch(40.8% .153 2.432);"></div></td></tr>
    <tr><td>border-r-pink-950</td><td>border-right-color: oklch(28.4% .109 3.907);</td><td><div style="border-right-color: oklch(28.4% .109 3.907);"></div></td></tr>
    <tr><td>border-r-rose-50</td><td>border-right-color: oklch(96.9% .015 12.422);</td><td><div style="border-right-color: oklch(96.9% .015 12.422);"></div></td></tr>
    <tr><td>border-r-rose-100</td><td>border-right-color: oklch(94.1% .03 12.58);</td><td><div style="border-right-color: oklch(94.1% .03 12.58);"></div></td></tr>
    <tr><td>border-r-rose-200</td><td>border-right-color: oklch(89.2% .058 10.001);</td><td><div style="border-right-color: oklch(89.2% .058 10.001);"></div></td></tr>
    <tr><td>border-r-rose-300</td><td>border-right-color: oklch(81% .117 11.638);</td><td><div style="border-right-color: oklch(81% .117 11.638);"></div></td></tr>
    <tr><td>border-r-rose-400</td><td>border-right-color: oklch(71.2% .194 13.428);</td><td><div style="border-right-color: oklch(71.2% .194 13.428);"></div></td></tr>
    <tr><td>border-r-rose-500</td><td>border-right-color: oklch(64.5% .246 16.439);</td><td><div style="border-right-color: oklch(64.5% .246 16.439);"></div></td></tr>
    <tr><td>border-r-rose-600</td><td>border-right-color: oklch(58.6% .253 17.585);</td><td><div style="border-right-color: oklch(58.6% .253 17.585);"></div></td></tr>
    <tr><td>border-r-rose-700</td><td>border-right-color: oklch(51.4% .222 16.935);</td><td><div style="border-right-color: oklch(51.4% .222 16.935);"></div></td></tr>
    <tr><td>border-r-rose-800</td><td>border-right-color: oklch(45.5% .188 13.697);</td><td><div style="border-right-color: oklch(45.5% .188 13.697);"></div></td></tr>
    <tr><td>border-r-rose-900</td><td>border-right-color: oklch(41% .159 10.272);</td><td><div style="border-right-color: oklch(41% .159 10.272);"></div></td></tr>
    <tr><td>border-r-rose-950</td><td>border-right-color: oklch(27.1% .105 12.094);</td><td><div style="border-right-color: oklch(27.1% .105 12.094);"></div></td></tr>
    <tr><td>border-r-slate-50</td><td>border-right-color: oklch(98.4% .003 247.858);</td><td><div style="border-right-color: oklch(98.4% .003 247.858);"></div></td></tr>
    <tr><td>border-r-slate-100</td><td>border-right-color: oklch(96.8% .007 247.896);</td><td><div style="border-right-color: oklch(96.8% .007 247.896);"></div></td></tr>
    <tr><td>border-r-slate-200</td><td>border-right-color: oklch(92.9% .013 255.508);</td><td><div style="border-right-color: oklch(92.9% .013 255.508);"></div></td></tr>
    <tr><td>border-r-slate-300</td><td>border-right-color: oklch(86.9% .022 252.894);</td><td><div style="border-right-color: oklch(86.9% .022 252.894);"></div></td></tr>
    <tr><td>border-r-slate-400</td><td>border-right-color: oklch(70.4% .04 256.788);</td><td><div style="border-right-color: oklch(70.4% .04 256.788);"></div></td></tr>
    <tr><td>border-r-slate-500</td><td>border-right-color: oklch(55.4% .046 257.417);</td><td><div style="border-right-color: oklch(55.4% .046 257.417);"></div></td></tr>
    <tr><td>border-r-slate-600</td><td>border-right-color: oklch(44.6% .043 257.281);</td><td><div style="border-right-color: oklch(44.6% .043 257.281);"></div></td></tr>
    <tr><td>border-r-slate-700</td><td>border-right-color: oklch(37.2% .044 257.287);</td><td><div style="border-right-color: oklch(37.2% .044 257.287);"></div></td></tr>
    <tr><td>border-r-slate-800</td><td>border-right-color: oklch(27.9% .041 260.031);</td><td><div style="border-right-color: oklch(27.9% .041 260.031);"></div></td></tr>
    <tr><td>border-r-slate-900</td><td>border-right-color: oklch(20.8% .042 265.755);</td><td><div style="border-right-color: oklch(20.8% .042 265.755);"></div></td></tr>
    <tr><td>border-r-slate-950</td><td>border-right-color: oklch(12.9% .042 264.695);</td><td><div style="border-right-color: oklch(12.9% .042 264.695);"></div></td></tr>
    <tr><td>border-r-gray-50</td><td>border-right-color: oklch(98.5% .002 247.839);</td><td><div style="border-right-color: oklch(98.5% .002 247.839);"></div></td></tr>
    <tr><td>border-r-gray-100</td><td>border-right-color: oklch(96.7% .003 264.542);</td><td><div style="border-right-color: oklch(96.7% .003 264.542);"></div></td></tr>
    <tr><td>border-r-gray-200</td><td>border-right-color: oklch(92.8% .006 264.531);</td><td><div style="border-right-color: oklch(92.8% .006 264.531);"></div></td></tr>
    <tr><td>border-r-gray-300</td><td>border-right-color: oklch(87.2% .01 258.338);</td><td><div style="border-right-color: oklch(87.2% .01 258.338);"></div></td></tr>
    <tr><td>border-r-gray-400</td><td>border-right-color: oklch(70.7% .022 261.325);</td><td><div style="border-right-color: oklch(70.7% .022 261.325);"></div></td></tr>
    <tr><td>border-r-gray-500</td><td>border-right-color: oklch(55.1% .027 264.364);</td><td><div style="border-right-color: oklch(55.1% .027 264.364);"></div></td></tr>
    <tr><td>border-r-gray-600</td><td>border-right-color: oklch(44.6% .03 256.802);</td><td><div style="border-right-color: oklch(44.6% .03 256.802);"></div></td></tr>
    <tr><td>border-r-gray-700</td><td>border-right-color: oklch(37.3% .034 259.733);</td><td><div style="border-right-color: oklch(37.3% .034 259.733);"></div></td></tr>
    <tr><td>border-r-gray-800</td><td>border-right-color: oklch(27.8% .033 256.848);</td><td><div style="border-right-color: oklch(27.8% .033 256.848);"></div></td></tr>
    <tr><td>border-r-gray-900</td><td>border-right-color: oklch(21% .034 264.665);</td><td><div style="border-right-color: oklch(21% .034 264.665);"></div></td></tr>
    <tr><td>border-r-gray-950</td><td>border-right-color: oklch(13% .028 261.692);</td><td><div style="border-right-color: oklch(13% .028 261.692);"></div></td></tr>
    <tr><td>border-r-zinc-50</td><td>border-right-color: oklch(98.5% 0 0);</td><td><div style="border-right-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-r-zinc-100</td><td>border-right-color: oklch(96.7% .001 286.375);</td><td><div style="border-right-color: oklch(96.7% .001 286.375);"></div></td></tr>
    <tr><td>border-r-zinc-200</td><td>border-right-color: oklch(92% .004 286.32);</td><td><div style="border-right-color: oklch(92% .004 286.32);"></div></td></tr>
    <tr><td>border-r-zinc-300</td><td>border-right-color: oklch(87.1% .006 286.286);</td><td><div style="border-right-color: oklch(87.1% .006 286.286);"></div></td></tr>
    <tr><td>border-r-zinc-400</td><td>border-right-color: oklch(70.5% .015 286.067);</td><td><div style="border-right-color: oklch(70.5% .015 286.067);"></div></td></tr>
    <tr><td>border-r-zinc-500</td><td>border-right-color: oklch(55.2% .016 285.938);</td><td><div style="border-right-color: oklch(55.2% .016 285.938);"></div></td></tr>
    <tr><td>border-r-zinc-600</td><td>border-right-color: oklch(44.2% .017 285.786);</td><td><div style="border-right-color: oklch(44.2% .017 285.786);"></div></td></tr>
    <tr><td>border-r-zinc-700</td><td>border-right-color: oklch(37% .013 285.805);</td><td><div style="border-right-color: oklch(37% .013 285.805);"></div></td></tr>
    <tr><td>border-r-zinc-800</td><td>border-right-color: oklch(27.4% .006 286.033);</td><td><div style="border-right-color: oklch(27.4% .006 286.033);"></div></td></tr>
    <tr><td>border-r-zinc-900</td><td>border-right-color: oklch(21% .006 285.885);</td><td><div style="border-right-color: oklch(21% .006 285.885);"></div></td></tr>
    <tr><td>border-r-zinc-950</td><td>border-right-color: oklch(14.1% .005 285.823);</td><td><div style="border-right-color: oklch(14.1% .005 285.823);"></div></td></tr>
    <tr><td>border-r-neutral-50</td><td>border-right-color: oklch(98.5% 0 0);</td><td><div style="border-right-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-100</td><td>border-right-color: oklch(97% 0 0);</td><td><div style="border-right-color: oklch(97% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-200</td><td>border-right-color: oklch(92.2% 0 0);</td><td><div style="border-right-color: oklch(92.2% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-300</td><td>border-right-color: oklch(87% 0 0);</td><td><div style="border-right-color: oklch(87% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-400</td><td>border-right-color: oklch(70.8% 0 0);</td><td><div style="border-right-color: oklch(70.8% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-500</td><td>border-right-color: oklch(55.6% 0 0);</td><td><div style="border-right-color: oklch(55.6% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-600</td><td>border-right-color: oklch(43.9% 0 0);</td><td><div style="border-right-color: oklch(43.9% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-700</td><td>border-right-color: oklch(37.1% 0 0);</td><td><div style="border-right-color: oklch(37.1% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-800</td><td>border-right-color: oklch(26.9% 0 0);</td><td><div style="border-right-color: oklch(26.9% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-900</td><td>border-right-color: oklch(20.5% 0 0);</td><td><div style="border-right-color: oklch(20.5% 0 0);"></div></td></tr>
    <tr><td>border-r-neutral-950</td><td>border-right-color: oklch(14.5% 0 0);</td><td><div style="border-right-color: oklch(14.5% 0 0);"></div></td></tr>
    <tr><td>border-r-stone-50</td><td>border-right-color: oklch(98.5% .001 106.423);</td><td><div style="border-right-color: oklch(98.5% .001 106.423);"></div></td></tr>
    <tr><td>border-r-stone-100</td><td>border-right-color: oklch(97% .001 106.424);</td><td><div style="border-right-color: oklch(97% .001 106.424);"></div></td></tr>
    <tr><td>border-r-stone-200</td><td>border-right-color: oklch(92.3% .003 48.717);</td><td><div style="border-right-color: oklch(92.3% .003 48.717);"></div></td></tr>
    <tr><td>border-r-stone-300</td><td>border-right-color: oklch(86.9% .005 56.366);</td><td><div style="border-right-color: oklch(86.9% .005 56.366);"></div></td></tr>
    <tr><td>border-r-stone-400</td><td>border-right-color: oklch(70.9% .01 56.259);</td><td><div style="border-right-color: oklch(70.9% .01 56.259);"></div></td></tr>
    <tr><td>border-r-stone-500</td><td>border-right-color: oklch(55.3% .013 58.071);</td><td><div style="border-right-color: oklch(55.3% .013 58.071);"></div></td></tr>
    <tr><td>border-r-stone-600</td><td>border-right-color: oklch(44.4% .011 73.639);</td><td><div style="border-right-color: oklch(44.4% .011 73.639);"></div></td></tr>
    <tr><td>border-r-stone-700</td><td>border-right-color: oklch(37.4% .01 67.558);</td><td><div style="border-right-color: oklch(37.4% .01 67.558);"></div></td></tr>
    <tr><td>border-r-stone-800</td><td>border-right-color: oklch(26.8% .007 34.298);</td><td><div style="border-right-color: oklch(26.8% .007 34.298);"></div></td></tr>
    <tr><td>border-r-stone-900</td><td>border-right-color: oklch(21.6% .006 56.043);</td><td><div style="border-right-color: oklch(21.6% .006 56.043);"></div></td></tr>
    <tr><td>border-r-stone-950</td><td>border-right-color: oklch(14.7% .004 49.25);</td><td><div style="border-right-color: oklch(14.7% .004 49.25);"></div></td></tr>
    <tr><td>border-r-black</td><td>border-right-color: #000;</td><td><div style="border-right-color: #000;"></div></td></tr>
    <tr><td>border-r-white</td><td>border-right-color: #fff;</td><td><div style="border-right-color: #fff;"></div></td></tr>
    <tr><td>border-b-inherit</td><td>border-bottom-color: inherit;</td><td><div style="border-bottom-color: inherit;"></div></td></tr>
    <tr><td>border-b-current</td><td>border-bottom-color: currentColor;</td><td><div style="border-bottom-color: currentColor;"></div></td></tr>
    <tr><td>border-b-transparent</td><td>border-bottom-color: transparent;</td><td><div style="border-bottom-color: transparent;"></div></td></tr>
    <tr><td>border-b-red-50</td><td>border-bottom-color: oklch(97.1% .013 17.38);</td><td><div style="border-bottom-color: oklch(97.1% .013 17.38);"></div></td></tr>
    <tr><td>border-b-red-100</td><td>border-bottom-color: oklch(93.6% .032 17.717);</td><td><div style="border-bottom-color: oklch(93.6% .032 17.717);"></div></td></tr>
    <tr><td>border-b-red-200</td><td>border-bottom-color: oklch(88.5% .062 18.334);</td><td><div style="border-bottom-color: oklch(88.5% .062 18.334);"></div></td></tr>
    <tr><td>border-b-red-300</td><td>border-bottom-color: oklch(80.8% .114 19.571);</td><td><div style="border-bottom-color: oklch(80.8% .114 19.571);"></div></td></tr>
    <tr><td>border-b-red-400</td><td>border-bottom-color: oklch(70.4% .191 22.216);</td><td><div style="border-bottom-color: oklch(70.4% .191 22.216);"></div></td></tr>
    <tr><td>border-b-red-500</td><td>border-bottom-color: oklch(63.7% .237 25.331);</td><td><div style="border-bottom-color: oklch(63.7% .237 25.331);"></div></td></tr>
    <tr><td>border-b-red-600</td><td>border-bottom-color: oklch(57.7% .245 27.325);</td><td><div style="border-bottom-color: oklch(57.7% .245 27.325);"></div></td></tr>
    <tr><td>border-b-red-700</td><td>border-bottom-color: oklch(50.5% .213 27.518);</td><td><div style="border-bottom-color: oklch(50.5% .213 27.518);"></div></td></tr>
    <tr><td>border-b-red-800</td><td>border-bottom-color: oklch(44.4% .177 26.899);</td><td><div style="border-bottom-color: oklch(44.4% .177 26.899);"></div></td></tr>
    <tr><td>border-b-red-900</td><td>border-bottom-color: oklch(39.6% .141 25.723);</td><td><div style="border-bottom-color: oklch(39.6% .141 25.723);"></div></td></tr>
    <tr><td>border-b-red-950</td><td>border-bottom-color: oklch(25.8% .092 26.042);</td><td><div style="border-bottom-color: oklch(25.8% .092 26.042);"></div></td></tr>
    <tr><td>border-b-orange-50</td><td>border-bottom-color: oklch(98% .016 73.684);</td><td><div style="border-bottom-color: oklch(98% .016 73.684);"></div></td></tr>
    <tr><td>border-b-orange-100</td><td>border-bottom-color: oklch(95.4% .038 75.164);</td><td><div style="border-bottom-color: oklch(95.4% .038 75.164);"></div></td></tr>
    <tr><td>border-b-orange-200</td><td>border-bottom-color: oklch(90.1% .076 70.697);</td><td><div style="border-bottom-color: oklch(90.1% .076 70.697);"></div></td></tr>
    <tr><td>border-b-orange-300</td><td>border-bottom-color: oklch(83.7% .128 66.29);</td><td><div style="border-bottom-color: oklch(83.7% .128 66.29);"></div></td></tr>
    <tr><td>border-b-orange-400</td><td>border-bottom-color: oklch(75% .183 55.934);</td><td><div style="border-bottom-color: oklch(75% .183 55.934);"></div></td></tr>
    <tr><td>border-b-orange-500</td><td>border-bottom-color: oklch(70.5% .213 47.604);</td><td><div style="border-bottom-color: oklch(70.5% .213 47.604);"></div></td></tr>
    <tr><td>border-b-orange-600</td><td>border-bottom-color: oklch(64.6% .222 41.116);</td><td><div style="border-bottom-color: oklch(64.6% .222 41.116);"></div></td></tr>
    <tr><td>border-b-orange-700</td><td>border-bottom-color: oklch(55.3% .195 38.402);</td><td><div style="border-bottom-color: oklch(55.3% .195 38.402);"></div></td></tr>
    <tr><td>border-b-orange-800</td><td>border-bottom-color: oklch(47% .157 37.304);</td><td><div style="border-bottom-color: oklch(47% .157 37.304);"></div></td></tr>
    <tr><td>border-b-orange-900</td><td>border-bottom-color: oklch(40.8% .123 38.172);</td><td><div style="border-bottom-color: oklch(40.8% .123 38.172);"></div></td></tr>
    <tr><td>border-b-orange-950</td><td>border-bottom-color: oklch(26.6% .079 36.259);</td><td><div style="border-bottom-color: oklch(26.6% .079 36.259);"></div></td></tr>
    <tr><td>border-b-amber-50</td><td>border-bottom-color: oklch(98.7% .022 95.277);</td><td><div style="border-bottom-color: oklch(98.7% .022 95.277);"></div></td></tr>
    <tr><td>border-b-amber-100</td><td>border-bottom-color: oklch(96.2% .059 95.617);</td><td><div style="border-bottom-color: oklch(96.2% .059 95.617);"></div></td></tr>
    <tr><td>border-b-amber-200</td><td>border-bottom-color: oklch(92.4% .12 95.746);</td><td><div style="border-bottom-color: oklch(92.4% .12 95.746);"></div></td></tr>
    <tr><td>border-b-amber-300</td><td>border-bottom-color: oklch(87.9% .169 91.605);</td><td><div style="border-bottom-color: oklch(87.9% .169 91.605);"></div></td></tr>
    <tr><td>border-b-amber-400</td><td>border-bottom-color: oklch(82.8% .189 84.429);</td><td><div style="border-bottom-color: oklch(82.8% .189 84.429);"></div></td></tr>
    <tr><td>border-b-amber-500</td><td>border-bottom-color: oklch(76.9% .188 70.08);</td><td><div style="border-bottom-color: oklch(76.9% .188 70.08);"></div></td></tr>
    <tr><td>border-b-amber-600</td><td>border-bottom-color: oklch(66.6% .179 58.318);</td><td><div style="border-bottom-color: oklch(66.6% .179 58.318);"></div></td></tr>
    <tr><td>border-b-amber-700</td><td>border-bottom-color: oklch(55.5% .163 48.998);</td><td><div style="border-bottom-color: oklch(55.5% .163 48.998);"></div></td></tr>
    <tr><td>border-b-amber-800</td><td>border-bottom-color: oklch(47.3% .137 46.201);</td><td><div style="border-bottom-color: oklch(47.3% .137 46.201);"></div></td></tr>
    <tr><td>border-b-amber-900</td><td>border-bottom-color: oklch(41.4% .112 45.904);</td><td><div style="border-bottom-color: oklch(41.4% .112 45.904);"></div></td></tr>
    <tr><td>border-b-amber-950</td><td>border-bottom-color: oklch(27.9% .077 45.635);</td><td><div style="border-bottom-color: oklch(27.9% .077 45.635);"></div></td></tr>
    <tr><td>border-b-yellow-50</td><td>border-bottom-color: oklch(98.7% .026 102.212);</td><td><div style="border-bottom-color: oklch(98.7% .026 102.212);"></div></td></tr>
    <tr><td>border-b-yellow-100</td><td>border-bottom-color: oklch(97.3% .071 103.193);</td><td><div style="border-bottom-color: oklch(97.3% .071 103.193);"></div></td></tr>
    <tr><td>border-b-yellow-200</td><td>border-bottom-color: oklch(94.5% .129 101.54);</td><td><div style="border-bottom-color: oklch(94.5% .129 101.54);"></div></td></tr>
    <tr><td>border-b-yellow-300</td><td>border-bottom-color: oklch(90.5% .182 98.111);</td><td><div style="border-bottom-color: oklch(90.5% .182 98.111);"></div></td></tr>
    <tr><td>border-b-yellow-400</td><td>border-bottom-color: oklch(85.2% .199 91.936);</td><td><div style="border-bottom-color: oklch(85.2% .199 91.936);"></div></td></tr>
    <tr><td>border-b-yellow-500</td><td>border-bottom-color: oklch(79.5% .184 86.047);</td><td><div style="border-bottom-color: oklch(79.5% .184 86.047);"></div></td></tr>
    <tr><td>border-b-yellow-600</td><td>border-bottom-color: oklch(68.1% .162 75.834);</td><td><div style="border-bottom-color: oklch(68.1% .162 75.834);"></div></td></tr>
    <tr><td>border-b-yellow-700</td><td>border-bottom-color: oklch(55.4% .135 66.442);</td><td><div style="border-bottom-color: oklch(55.4% .135 66.442);"></div></td></tr>
    <tr><td>border-b-yellow-800</td><td>border-bottom-color: oklch(47.6% .114 61.907);</td><td><div style="border-bottom-color: oklch(47.6% .114 61.907);"></div></td></tr>
    <tr><td>border-b-yellow-900</td><td>border-bottom-color: oklch(42.1% .095 57.708);</td><td><div style="border-bottom-color: oklch(42.1% .095 57.708);"></div></td></tr>
    <tr><td>border-b-yellow-950</td><td>border-bottom-color: oklch(28.6% .066 53.813);</td><td><div style="border-bottom-color: oklch(28.6% .066 53.813);"></div></td></tr>
    <tr><td>border-b-lime-50</td><td>border-bottom-color: oklch(98.6% .031 120.757);</td><td><div style="border-bottom-color: oklch(98.6% .031 120.757);"></div></td></tr>
    <tr><td>border-b-lime-100</td><td>border-bottom-color: oklch(96.7% .067 122.328);</td><td><div style="border-bottom-color: oklch(96.7% .067 122.328);"></div></td></tr>
    <tr><td>border-b-lime-200</td><td>border-bottom-color: oklch(93.8% .127 124.321);</td><td><div style="border-bottom-color: oklch(93.8% .127 124.321);"></div></td></tr>
    <tr><td>border-b-lime-300</td><td>border-bottom-color: oklch(89.7% .196 126.665);</td><td><div style="border-bottom-color: oklch(89.7% .196 126.665);"></div></td></tr>
    <tr><td>border-b-lime-400</td><td>border-bottom-color: oklch(84.1% .238 128.85);</td><td><div style="border-bottom-color: oklch(84.1% .238 128.85);"></div></td></tr>
    <tr><td>border-b-lime-500</td><td>border-bottom-color: oklch(76.8% .233 130.85);</td><td><div style="border-bottom-color: oklch(76.8% .233 130.85);"></div></td></tr>
    <tr><td>border-b-lime-600</td><td>border-bottom-color: oklch(64.8% .2 131.684);</td><td><div style="border-bottom-color: oklch(64.8% .2 131.684);"></div></td></tr>
    <tr><td>border-b-lime-700</td><td>border-bottom-color: oklch(53.2% .157 131.589);</td><td><div style="border-bottom-color: oklch(53.2% .157 131.589);"></div></td></tr>
    <tr><td>border-b-lime-800</td><td>border-bottom-color: oklch(45.3% .124 130.933);</td><td><div style="border-bottom-color: oklch(45.3% .124 130.933);"></div></td></tr>
    <tr><td>border-b-lime-900</td><td>border-bottom-color: oklch(40.5% .101 131.063);</td><td><div style="border-bottom-color: oklch(40.5% .101 131.063);"></div></td></tr>
    <tr><td>border-b-lime-950</td><td>border-bottom-color: oklch(27.4% .072 132.109);</td><td><div style="border-bottom-color: oklch(27.4% .072 132.109);"></div></td></tr>
    <tr><td>border-b-green-50</td><td>border-bottom-color: oklch(98.2% .018 155.826);</td><td><div style="border-bottom-color: oklch(98.2% .018 155.826);"></div></td></tr>
    <tr><td>border-b-green-100</td><td>border-bottom-color: oklch(96.2% .044 156.743);</td><td><div style="border-bottom-color: oklch(96.2% .044 156.743);"></div></td></tr>
    <tr><td>border-b-green-200</td><td>border-bottom-color: oklch(92.5% .084 155.995);</td><td><div style="border-bottom-color: oklch(92.5% .084 155.995);"></div></td></tr>
    <tr><td>border-b-green-300</td><td>border-bottom-color: oklch(87.1% .15 154.449);</td><td><div style="border-bottom-color: oklch(87.1% .15 154.449);"></div></td></tr>
    <tr><td>border-b-green-400</td><td>border-bottom-color: oklch(79.2% .209 151.711);</td><td><div style="border-bottom-color: oklch(79.2% .209 151.711);"></div></td></tr>
    <tr><td>border-b-green-500</td><td>border-bottom-color: oklch(72.3% .219 149.579);</td><td><div style="border-bottom-color: oklch(72.3% .219 149.579);"></div></td></tr>
    <tr><td>border-b-green-600</td><td>border-bottom-color: oklch(62.7% .194 149.214);</td><td><div style="border-bottom-color: oklch(62.7% .194 149.214);"></div></td></tr>
    <tr><td>border-b-green-700</td><td>border-bottom-color: oklch(52.7% .154 150.069);</td><td><div style="border-bottom-color: oklch(52.7% .154 150.069);"></div></td></tr>
    <tr><td>border-b-green-800</td><td>border-bottom-color: oklch(44.8% .119 151.328);</td><td><div style="border-bottom-color: oklch(44.8% .119 151.328);"></div></td></tr>
    <tr><td>border-b-green-900</td><td>border-bottom-color: oklch(39.3% .095 152.535);</td><td><div style="border-bottom-color: oklch(39.3% .095 152.535);"></div></td></tr>
    <tr><td>border-b-green-950</td><td>border-bottom-color: oklch(26.6% .065 152.934);</td><td><div style="border-bottom-color: oklch(26.6% .065 152.934);"></div></td></tr>
    <tr><td>border-b-emerald-50</td><td>border-bottom-color: oklch(97.9% .021 166.113);</td><td><div style="border-bottom-color: oklch(97.9% .021 166.113);"></div></td></tr>
    <tr><td>border-b-emerald-100</td><td>border-bottom-color: oklch(95% .052 163.051);</td><td><div style="border-bottom-color: oklch(95% .052 163.051);"></div></td></tr>
    <tr><td>border-b-emerald-200</td><td>border-bottom-color: oklch(90.5% .093 164.15);</td><td><div style="border-bottom-color: oklch(90.5% .093 164.15);"></div></td></tr>
    <tr><td>border-b-emerald-300</td><td>border-bottom-color: oklch(84.5% .143 164.978);</td><td><div style="border-bottom-color: oklch(84.5% .143 164.978);"></div></td></tr>
    <tr><td>border-b-emerald-400</td><td>border-bottom-color: oklch(76.5% .177 163.223);</td><td><div style="border-bottom-color: oklch(76.5% .177 163.223);"></div></td></tr>
    <tr><td>border-b-emerald-500</td><td>border-bottom-color: oklch(69.6% .17 162.48);</td><td><div style="border-bottom-color: oklch(69.6% .17 162.48);"></div></td></tr>
    <tr><td>border-b-emerald-600</td><td>border-bottom-color: oklch(59.6% .145 163.225);</td><td><div style="border-bottom-color: oklch(59.6% .145 163.225);"></div></td></tr>
    <tr><td>border-b-emerald-700</td><td>border-bottom-color: oklch(50.8% .118 165.612);</td><td><div style="border-bottom-color: oklch(50.8% .118 165.612);"></div></td></tr>
    <tr><td>border-b-emerald-800</td><td>border-bottom-color: oklch(43.2% .095 166.913);</td><td><div style="border-bottom-color: oklch(43.2% .095 166.913);"></div></td></tr>
    <tr><td>border-b-emerald-900</td><td>border-bottom-color: oklch(37.8% .077 168.94);</td><td><div style="border-bottom-color: oklch(37.8% .077 168.94);"></div></td></tr>
    <tr><td>border-b-emerald-950</td><td>border-bottom-color: oklch(26.2% .051 172.552);</td><td><div style="border-bottom-color: oklch(26.2% .051 172.552);"></div></td></tr>
    <tr><td>border-b-teal-50</td><td>border-bottom-color: oklch(98.4% .014 180.72);</td><td><div style="border-bottom-color: oklch(98.4% .014 180.72);"></div></td></tr>
    <tr><td>border-b-teal-100</td><td>border-bottom-color: oklch(95.3% .051 180.801);</td><td><div style="border-bottom-color: oklch(95.3% .051 180.801);"></div></td></tr>
    <tr><td>border-b-teal-200</td><td>border-bottom-color: oklch(91% .096 180.426);</td><td><div style="border-bottom-color: oklch(91% .096 180.426);"></div></td></tr>
    <tr><td>border-b-teal-300</td><td>border-bottom-color: oklch(85.5% .138 181.071);</td><td><div style="border-bottom-color: oklch(85.5% .138 181.071);"></div></td></tr>
    <tr><td>border-b-teal-400</td><td>border-bottom-color: oklch(77.7% .152 181.912);</td><td><div style="border-bottom-color: oklch(77.7% .152 181.912);"></div></td></tr>
    <tr><td>border-b-teal-500</td><td>border-bottom-color: oklch(70.4% .14 182.503);</td><td><div style="border-bottom-color: oklch(70.4% .14 182.503);"></div></td></tr>
    <tr><td>border-b-teal-600</td><td>border-bottom-color: oklch(60% .118 184.704);</td><td><div style="border-bottom-color: oklch(60% .118 184.704);"></div></td></tr>
    <tr><td>border-b-teal-700</td><td>border-bottom-color: oklch(51.1% .096 186.391);</td><td><div style="border-bottom-color: oklch(51.1% .096 186.391);"></div></td></tr>
    <tr><td>border-b-teal-800</td><td>border-bottom-color: oklch(43.7% .078 188.216);</td><td><div style="border-bottom-color: oklch(43.7% .078 188.216);"></div></td></tr>
    <tr><td>border-b-teal-900</td><td>border-bottom-color: oklch(38.6% .063 188.416);</td><td><div style="border-bottom-color: oklch(38.6% .063 188.416);"></div></td></tr>
    <tr><td>border-b-teal-950</td><td>border-bottom-color: oklch(27.7% .046 192.524);</td><td><div style="border-bottom-color: oklch(27.7% .046 192.524);"></div></td></tr>
    <tr><td>border-b-cyan-50</td><td>border-bottom-color: oklch(98.4% .019 200.873);</td><td><div style="border-bottom-color: oklch(98.4% .019 200.873);"></div></td></tr>
    <tr><td>border-b-cyan-100</td><td>border-bottom-color: oklch(95.6% .045 203.388);</td><td><div style="border-bottom-color: oklch(95.6% .045 203.388);"></div></td></tr>
    <tr><td>border-b-cyan-200</td><td>border-bottom-color: oklch(91.7% .08 205.041);</td><td><div style="border-bottom-color: oklch(91.7% .08 205.041);"></div></td></tr>
    <tr><td>border-b-cyan-300</td><td>border-bottom-color: oklch(86.5% .127 207.078);</td><td><div style="border-bottom-color: oklch(86.5% .127 207.078);"></div></td></tr>
    <tr><td>border-b-cyan-400</td><td>border-bottom-color: oklch(78.9% .154 211.53);</td><td><div style="border-bottom-color: oklch(78.9% .154 211.53);"></div></td></tr>
    <tr><td>border-b-cyan-500</td><td>border-bottom-color: oklch(71.5% .143 215.221);</td><td><div style="border-bottom-color: oklch(71.5% .143 215.221);"></div></td></tr>
    <tr><td>border-b-cyan-600</td><td>border-bottom-color: oklch(60.9% .126 221.723);</td><td><div style="border-bottom-color: oklch(60.9% .126 221.723);"></div></td></tr>
    <tr><td>border-b-cyan-700</td><td>border-bottom-color: oklch(52% .105 223.128);</td><td><div style="border-bottom-color: oklch(52% .105 223.128);"></div></td></tr>
    <tr><td>border-b-cyan-800</td><td>border-bottom-color: oklch(45% .085 224.283);</td><td><div style="border-bottom-color: oklch(45% .085 224.283);"></div></td></tr>
    <tr><td>border-b-cyan-900</td><td>border-bottom-color: oklch(39.8% .07 227.392);</td><td><div style="border-bottom-color: oklch(39.8% .07 227.392);"></div></td></tr>
    <tr><td>border-b-cyan-950</td><td>border-bottom-color: oklch(30.2% .056 229.695);</td><td><div style="border-bottom-color: oklch(30.2% .056 229.695);"></div></td></tr>
    <tr><td>border-b-sky-50</td><td>border-bottom-color: oklch(97.7% .013 236.62);</td><td><div style="border-bottom-color: oklch(97.7% .013 236.62);"></div></td></tr>
    <tr><td>border-b-sky-100</td><td>border-bottom-color: oklch(95.1% .026 236.824);</td><td><div style="border-bottom-color: oklch(95.1% .026 236.824);"></div></td></tr>
    <tr><td>border-b-sky-200</td><td>border-bottom-color: oklch(90.1% .058 230.902);</td><td><div style="border-bottom-color: oklch(90.1% .058 230.902);"></div></td></tr>
    <tr><td>border-b-sky-300</td><td>border-bottom-color: oklch(82.8% .111 230.318);</td><td><div style="border-bottom-color: oklch(82.8% .111 230.318);"></div></td></tr>
    <tr><td>border-b-sky-400</td><td>border-bottom-color: oklch(74.6% .16 232.661);</td><td><div style="border-bottom-color: oklch(74.6% .16 232.661);"></div></td></tr>
    <tr><td>border-b-sky-500</td><td>border-bottom-color: oklch(68.5% .169 237.323);</td><td><div style="border-bottom-color: oklch(68.5% .169 237.323);"></div></td></tr>
    <tr><td>border-b-sky-600</td><td>border-bottom-color: oklch(58.8% .158 241.966);</td><td><div style="border-bottom-color: oklch(58.8% .158 241.966);"></div></td></tr>
    <tr><td>border-b-sky-700</td><td>border-bottom-color: oklch(50% .134 242.749);</td><td><div style="border-bottom-color: oklch(50% .134 242.749);"></div></td></tr>
    <tr><td>border-b-sky-800</td><td>border-bottom-color: oklch(44.3% .11 240.79);</td><td><div style="border-bottom-color: oklch(44.3% .11 240.79);"></div></td></tr>
    <tr><td>border-b-sky-900</td><td>border-bottom-color: oklch(39.1% .09 240.876);</td><td><div style="border-bottom-color: oklch(39.1% .09 240.876);"></div></td></tr>
    <tr><td>border-b-sky-950</td><td>border-bottom-color: oklch(29.3% .066 243.157);</td><td><div style="border-bottom-color: oklch(29.3% .066 243.157);"></div></td></tr>
    <tr><td>border-b-blue-50</td><td>border-bottom-color: oklch(97% .014 254.604);</td><td><div style="border-bottom-color: oklch(97% .014 254.604);"></div></td></tr>
    <tr><td>border-b-blue-100</td><td>border-bottom-color: oklch(93.2% .032 255.585);</td><td><div style="border-bottom-color: oklch(93.2% .032 255.585);"></div></td></tr>
    <tr><td>border-b-blue-200</td><td>border-bottom-color: oklch(88.2% .059 254.128);</td><td><div style="border-bottom-color: oklch(88.2% .059 254.128);"></div></td></tr>
    <tr><td>border-b-blue-300</td><td>border-bottom-color: oklch(80.9% .105 251.813);</td><td><div style="border-bottom-color: oklch(80.9% .105 251.813);"></div></td></tr>
    <tr><td>border-b-blue-400</td><td>border-bottom-color: oklch(70.7% .165 254.624);</td><td><div style="border-bottom-color: oklch(70.7% .165 254.624);"></div></td></tr>
    <tr><td>border-b-blue-500</td><td>border-bottom-color: oklch(62.3% .214 259.815);</td><td><div style="border-bottom-color: oklch(62.3% .214 259.815);"></div></td></tr>
    <tr><td>border-b-blue-600</td><td>border-bottom-color: oklch(54.6% .245 262.881);</td><td><div style="border-bottom-color: oklch(54.6% .245 262.881);"></div></td></tr>
    <tr><td>border-b-blue-700</td><td>border-bottom-color: oklch(48.8% .243 264.376);</td><td><div style="border-bottom-color: oklch(48.8% .243 264.376);"></div></td></tr>
    <tr><td>border-b-blue-800</td><td>border-bottom-color: oklch(42.4% .199 265.638);</td><td><div style="border-bottom-color: oklch(42.4% .199 265.638);"></div></td></tr>
    <tr><td>border-b-blue-900</td><td>border-bottom-color: oklch(37.9% .146 265.522);</td><td><div style="border-bottom-color: oklch(37.9% .146 265.522);"></div></td></tr>
    <tr><td>border-b-blue-950</td><td>border-bottom-color: oklch(28.2% .091 267.935);</td><td><div style="border-bottom-color: oklch(28.2% .091 267.935);"></div></td></tr>
    <tr><td>border-b-indigo-50</td><td>border-bottom-color: oklch(96.2% .018 272.314);</td><td><div style="border-bottom-color: oklch(96.2% .018 272.314);"></div></td></tr>
    <tr><td>border-b-indigo-100</td><td>border-bottom-color: oklch(93% .034 272.788);</td><td><div style="border-bottom-color: oklch(93% .034 272.788);"></div></td></tr>
    <tr><td>border-b-indigo-200</td><td>border-bottom-color: oklch(87% .065 274.039);</td><td><div style="border-bottom-color: oklch(87% .065 274.039);"></div></td></tr>
    <tr><td>border-b-indigo-300</td><td>border-bottom-color: oklch(78.5% .115 274.713);</td><td><div style="border-bottom-color: oklch(78.5% .115 274.713);"></div></td></tr>
    <tr><td>border-b-indigo-400</td><td>border-bottom-color: oklch(67.3% .182 276.935);</td><td><div style="border-bottom-color: oklch(67.3% .182 276.935);"></div></td></tr>
    <tr><td>border-b-indigo-500</td><td>border-bottom-color: oklch(58.5% .233 277.117);</td><td><div style="border-bottom-color: oklch(58.5% .233 277.117);"></div></td></tr>
    <tr><td>border-b-indigo-600</td><td>border-bottom-color: oklch(51.1% .262 276.966);</td><td><div style="border-bottom-color: oklch(51.1% .262 276.966);"></div></td></tr>
    <tr><td>border-b-indigo-700</td><td>border-bottom-color: oklch(45.7% .24 277.023);</td><td><div style="border-bottom-color: oklch(45.7% .24 277.023);"></div></td></tr>
    <tr><td>border-b-indigo-800</td><td>border-bottom-color: oklch(39.8% .195 277.366);</td><td><div style="border-bottom-color: oklch(39.8% .195 277.366);"></div></td></tr>
    <tr><td>border-b-indigo-900</td><td>border-bottom-color: oklch(35.9% .144 278.697);</td><td><div style="border-bottom-color: oklch(35.9% .144 278.697);"></div></td></tr>
    <tr><td>border-b-indigo-950</td><td>border-bottom-color: oklch(25.7% .09 281.288);</td><td><div style="border-bottom-color: oklch(25.7% .09 281.288);"></div></td></tr>
    <tr><td>border-b-violet-50</td><td>border-bottom-color: oklch(96.9% .016 293.756);</td><td><div style="border-bottom-color: oklch(96.9% .016 293.756);"></div></td></tr>
    <tr><td>border-b-violet-100</td><td>border-bottom-color: oklch(94.3% .029 294.588);</td><td><div style="border-bottom-color: oklch(94.3% .029 294.588);"></div></td></tr>
    <tr><td>border-b-violet-200</td><td>border-bottom-color: oklch(89.4% .057 293.283);</td><td><div style="border-bottom-color: oklch(89.4% .057 293.283);"></div></td></tr>
    <tr><td>border-b-violet-300</td><td>border-bottom-color: oklch(81.1% .111 293.571);</td><td><div style="border-bottom-color: oklch(81.1% .111 293.571);"></div></td></tr>
    <tr><td>border-b-violet-400</td><td>border-bottom-color: oklch(70.2% .183 293.541);</td><td><div style="border-bottom-color: oklch(70.2% .183 293.541);"></div></td></tr>
    <tr><td>border-b-violet-500</td><td>border-bottom-color: oklch(60.6% .25 292.717);</td><td><div style="border-bottom-color: oklch(60.6% .25 292.717);"></div></td></tr>
    <tr><td>border-b-violet-600</td><td>border-bottom-color: oklch(54.1% .281 293.009);</td><td><div style="border-bottom-color: oklch(54.1% .281 293.009);"></div></td></tr>
    <tr><td>border-b-violet-700</td><td>border-bottom-color: oklch(49.1% .27 292.581);</td><td><div style="border-bottom-color: oklch(49.1% .27 292.581);"></div></td></tr>
    <tr><td>border-b-violet-800</td><td>border-bottom-color: oklch(43.2% .232 292.759);</td><td><div style="border-bottom-color: oklch(43.2% .232 292.759);"></div></td></tr>
    <tr><td>border-b-violet-900</td><td>border-bottom-color: oklch(38% .189 293.745);</td><td><div style="border-bottom-color: oklch(38% .189 293.745);"></div></td></tr>
    <tr><td>border-b-violet-950</td><td>border-bottom-color: oklch(28.3% .141 291.089);</td><td><div style="border-bottom-color: oklch(28.3% .141 291.089);"></div></td></tr>
    <tr><td>border-b-purple-50</td><td>border-bottom-color: oklch(97.7% .014 308.299);</td><td><div style="border-bottom-color: oklch(97.7% .014 308.299);"></div></td></tr>
    <tr><td>border-b-purple-100</td><td>border-bottom-color: oklch(94.6% .033 307.174);</td><td><div style="border-bottom-color: oklch(94.6% .033 307.174);"></div></td></tr>
    <tr><td>border-b-purple-200</td><td>border-bottom-color: oklch(90.2% .063 306.703);</td><td><div style="border-bottom-color: oklch(90.2% .063 306.703);"></div></td></tr>
    <tr><td>border-b-purple-300</td><td>border-bottom-color: oklch(82.7% .119 306.383);</td><td><div style="border-bottom-color: oklch(82.7% .119 306.383);"></div></td></tr>
    <tr><td>border-b-purple-400</td><td>border-bottom-color: oklch(71.4% .203 305.504);</td><td><div style="border-bottom-color: oklch(71.4% .203 305.504);"></div></td></tr>
    <tr><td>border-b-purple-500</td><td>border-bottom-color: oklch(62.7% .265 303.9);</td><td><div style="border-bottom-color: oklch(62.7% .265 303.9);"></div></td></tr>
    <tr><td>border-b-purple-600</td><td>border-bottom-color: oklch(55.8% .288 302.321);</td><td><div style="border-bottom-color: oklch(55.8% .288 302.321);"></div></td></tr>
    <tr><td>border-b-purple-700</td><td>border-bottom-color: oklch(49.6% .265 301.924);</td><td><div style="border-bottom-color: oklch(49.6% .265 301.924);"></div></td></tr>
    <tr><td>border-b-purple-800</td><td>border-bottom-color: oklch(43.8% .218 303.724);</td><td><div style="border-bottom-color: oklch(43.8% .218 303.724);"></div></td></tr>
    <tr><td>border-b-purple-900</td><td>border-bottom-color: oklch(38.1% .176 304.987);</td><td><div style="border-bottom-color: oklch(38.1% .176 304.987);"></div></td></tr>
    <tr><td>border-b-purple-950</td><td>border-bottom-color: oklch(29.1% .149 302.717);</td><td><div style="border-bottom-color: oklch(29.1% .149 302.717);"></div></td></tr>
    <tr><td>border-b-fuchsia-50</td><td>border-bottom-color: oklch(97.7% .017 320.058);</td><td><div style="border-bottom-color: oklch(97.7% .017 320.058);"></div></td></tr>
    <tr><td>border-b-fuchsia-100</td><td>border-bottom-color: oklch(95.2% .037 318.852);</td><td><div style="border-bottom-color: oklch(95.2% .037 318.852);"></div></td></tr>
    <tr><td>border-b-fuchsia-200</td><td>border-bottom-color: oklch(90.3% .076 319.62);</td><td><div style="border-bottom-color: oklch(90.3% .076 319.62);"></div></td></tr>
    <tr><td>border-b-fuchsia-300</td><td>border-bottom-color: oklch(83.3% .145 321.434);</td><td><div style="border-bottom-color: oklch(83.3% .145 321.434);"></div></td></tr>
    <tr><td>border-b-fuchsia-400</td><td>border-bottom-color: oklch(74% .238 322.16);</td><td><div style="border-bottom-color: oklch(74% .238 322.16);"></div></td></tr>
    <tr><td>border-b-fuchsia-500</td><td>border-bottom-color: oklch(66.7% .295 322.15);</td><td><div style="border-bottom-color: oklch(66.7% .295 322.15);"></div></td></tr>
    <tr><td>border-b-fuchsia-600</td><td>border-bottom-color: oklch(59.1% .293 322.896);</td><td><div style="border-bottom-color: oklch(59.1% .293 322.896);"></div></td></tr>
    <tr><td>border-b-fuchsia-700</td><td>border-bottom-color: oklch(51.8% .253 323.949);</td><td><div style="border-bottom-color: oklch(51.8% .253 323.949);"></div></td></tr>
    <tr><td>border-b-fuchsia-800</td><td>border-bottom-color: oklch(45.2% .211 324.591);</td><td><div style="border-bottom-color: oklch(45.2% .211 324.591);"></div></td></tr>
    <tr><td>border-b-fuchsia-900</td><td>border-bottom-color: oklch(40.1% .17 325.612);</td><td><div style="border-bottom-color: oklch(40.1% .17 325.612);"></div></td></tr>
    <tr><td>border-b-fuchsia-950</td><td>border-bottom-color: oklch(29.3% .136 325.661);</td><td><div style="border-bottom-color: oklch(29.3% .136 325.661);"></div></td></tr>
    <tr><td>border-b-pink-50</td><td>border-bottom-color: oklch(97.1% .014 343.198);</td><td><div style="border-bottom-color: oklch(97.1% .014 343.198);"></div></td></tr>
    <tr><td>border-b-pink-100</td><td>border-bottom-color: oklch(94.8% .028 342.258);</td><td><div style="border-bottom-color: oklch(94.8% .028 342.258);"></div></td></tr>
    <tr><td>border-b-pink-200</td><td>border-bottom-color: oklch(89.9% .061 343.231);</td><td><div style="border-bottom-color: oklch(89.9% .061 343.231);"></div></td></tr>
    <tr><td>border-b-pink-300</td><td>border-bottom-color: oklch(82.3% .12 346.018);</td><td><div style="border-bottom-color: oklch(82.3% .12 346.018);"></div></td></tr>
    <tr><td>border-b-pink-400</td><td>border-bottom-color: oklch(71.8% .202 349.761);</td><td><div style="border-bottom-color: oklch(71.8% .202 349.761);"></div></td></tr>
    <tr><td>border-b-pink-500</td><td>border-bottom-color: oklch(65.6% .241 354.308);</td><td><div style="border-bottom-color: oklch(65.6% .241 354.308);"></div></td></tr>
    <tr><td>border-b-pink-600</td><td>border-bottom-color: oklch(59.2% .249 .584);</td><td><div style="border-bottom-color: oklch(59.2% .249 .584);"></div></td></tr>
    <tr><td>border-b-pink-700</td><td>border-bottom-color: oklch(52.5% .223 3.958);</td><td><div style="border-bottom-color: oklch(52.5% .223 3.958);"></div></td></tr>
    <tr><td>border-b-pink-800</td><td>border-bottom-color: oklch(45.9% .187 3.815);</td><td><div style="border-bottom-color: oklch(45.9% .187 3.815);"></div></td></tr>
    <tr><td>border-b-pink-900</td><td>border-bottom-color: oklch(40.8% .153 2.432);</td><td><div style="border-bottom-color: oklch(40.8% .153 2.432);"></div></td></tr>
    <tr><td>border-b-pink-950</td><td>border-bottom-color: oklch(28.4% .109 3.907);</td><td><div style="border-bottom-color: oklch(28.4% .109 3.907);"></div></td></tr>
    <tr><td>border-b-rose-50</td><td>border-bottom-color: oklch(96.9% .015 12.422);</td><td><div style="border-bottom-color: oklch(96.9% .015 12.422);"></div></td></tr>
    <tr><td>border-b-rose-100</td><td>border-bottom-color: oklch(94.1% .03 12.58);</td><td><div style="border-bottom-color: oklch(94.1% .03 12.58);"></div></td></tr>
    <tr><td>border-b-rose-200</td><td>border-bottom-color: oklch(89.2% .058 10.001);</td><td><div style="border-bottom-color: oklch(89.2% .058 10.001);"></div></td></tr>
    <tr><td>border-b-rose-300</td><td>border-bottom-color: oklch(81% .117 11.638);</td><td><div style="border-bottom-color: oklch(81% .117 11.638);"></div></td></tr>
    <tr><td>border-b-rose-400</td><td>border-bottom-color: oklch(71.2% .194 13.428);</td><td><div style="border-bottom-color: oklch(71.2% .194 13.428);"></div></td></tr>
    <tr><td>border-b-rose-500</td><td>border-bottom-color: oklch(64.5% .246 16.439);</td><td><div style="border-bottom-color: oklch(64.5% .246 16.439);"></div></td></tr>
    <tr><td>border-b-rose-600</td><td>border-bottom-color: oklch(58.6% .253 17.585);</td><td><div style="border-bottom-color: oklch(58.6% .253 17.585);"></div></td></tr>
    <tr><td>border-b-rose-700</td><td>border-bottom-color: oklch(51.4% .222 16.935);</td><td><div style="border-bottom-color: oklch(51.4% .222 16.935);"></div></td></tr>
    <tr><td>border-b-rose-800</td><td>border-bottom-color: oklch(45.5% .188 13.697);</td><td><div style="border-bottom-color: oklch(45.5% .188 13.697);"></div></td></tr>
    <tr><td>border-b-rose-900</td><td>border-bottom-color: oklch(41% .159 10.272);</td><td><div style="border-bottom-color: oklch(41% .159 10.272);"></div></td></tr>
    <tr><td>border-b-rose-950</td><td>border-bottom-color: oklch(27.1% .105 12.094);</td><td><div style="border-bottom-color: oklch(27.1% .105 12.094);"></div></td></tr>
    <tr><td>border-b-slate-50</td><td>border-bottom-color: oklch(98.4% .003 247.858);</td><td><div style="border-bottom-color: oklch(98.4% .003 247.858);"></div></td></tr>
    <tr><td>border-b-slate-100</td><td>border-bottom-color: oklch(96.8% .007 247.896);</td><td><div style="border-bottom-color: oklch(96.8% .007 247.896);"></div></td></tr>
    <tr><td>border-b-slate-200</td><td>border-bottom-color: oklch(92.9% .013 255.508);</td><td><div style="border-bottom-color: oklch(92.9% .013 255.508);"></div></td></tr>
    <tr><td>border-b-slate-300</td><td>border-bottom-color: oklch(86.9% .022 252.894);</td><td><div style="border-bottom-color: oklch(86.9% .022 252.894);"></div></td></tr>
    <tr><td>border-b-slate-400</td><td>border-bottom-color: oklch(70.4% .04 256.788);</td><td><div style="border-bottom-color: oklch(70.4% .04 256.788);"></div></td></tr>
    <tr><td>border-b-slate-500</td><td>border-bottom-color: oklch(55.4% .046 257.417);</td><td><div style="border-bottom-color: oklch(55.4% .046 257.417);"></div></td></tr>
    <tr><td>border-b-slate-600</td><td>border-bottom-color: oklch(44.6% .043 257.281);</td><td><div style="border-bottom-color: oklch(44.6% .043 257.281);"></div></td></tr>
    <tr><td>border-b-slate-700</td><td>border-bottom-color: oklch(37.2% .044 257.287);</td><td><div style="border-bottom-color: oklch(37.2% .044 257.287);"></div></td></tr>
    <tr><td>border-b-slate-800</td><td>border-bottom-color: oklch(27.9% .041 260.031);</td><td><div style="border-bottom-color: oklch(27.9% .041 260.031);"></div></td></tr>
    <tr><td>border-b-slate-900</td><td>border-bottom-color: oklch(20.8% .042 265.755);</td><td><div style="border-bottom-color: oklch(20.8% .042 265.755);"></div></td></tr>
    <tr><td>border-b-slate-950</td><td>border-bottom-color: oklch(12.9% .042 264.695);</td><td><div style="border-bottom-color: oklch(12.9% .042 264.695);"></div></td></tr>
    <tr><td>border-b-gray-50</td><td>border-bottom-color: oklch(98.5% .002 247.839);</td><td><div style="border-bottom-color: oklch(98.5% .002 247.839);"></div></td></tr>
    <tr><td>border-b-gray-100</td><td>border-bottom-color: oklch(96.7% .003 264.542);</td><td><div style="border-bottom-color: oklch(96.7% .003 264.542);"></div></td></tr>
    <tr><td>border-b-gray-200</td><td>border-bottom-color: oklch(92.8% .006 264.531);</td><td><div style="border-bottom-color: oklch(92.8% .006 264.531);"></div></td></tr>
    <tr><td>border-b-gray-300</td><td>border-bottom-color: oklch(87.2% .01 258.338);</td><td><div style="border-bottom-color: oklch(87.2% .01 258.338);"></div></td></tr>
    <tr><td>border-b-gray-400</td><td>border-bottom-color: oklch(70.7% .022 261.325);</td><td><div style="border-bottom-color: oklch(70.7% .022 261.325);"></div></td></tr>
    <tr><td>border-b-gray-500</td><td>border-bottom-color: oklch(55.1% .027 264.364);</td><td><div style="border-bottom-color: oklch(55.1% .027 264.364);"></div></td></tr>
    <tr><td>border-b-gray-600</td><td>border-bottom-color: oklch(44.6% .03 256.802);</td><td><div style="border-bottom-color: oklch(44.6% .03 256.802);"></div></td></tr>
    <tr><td>border-b-gray-700</td><td>border-bottom-color: oklch(37.3% .034 259.733);</td><td><div style="border-bottom-color: oklch(37.3% .034 259.733);"></div></td></tr>
    <tr><td>border-b-gray-800</td><td>border-bottom-color: oklch(27.8% .033 256.848);</td><td><div style="border-bottom-color: oklch(27.8% .033 256.848);"></div></td></tr>
    <tr><td>border-b-gray-900</td><td>border-bottom-color: oklch(21% .034 264.665);</td><td><div style="border-bottom-color: oklch(21% .034 264.665);"></div></td></tr>
    <tr><td>border-b-gray-950</td><td>border-bottom-color: oklch(13% .028 261.692);</td><td><div style="border-bottom-color: oklch(13% .028 261.692);"></div></td></tr>
    <tr><td>border-b-zinc-50</td><td>border-bottom-color: oklch(98.5% 0 0);</td><td><div style="border-bottom-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-b-zinc-100</td><td>border-bottom-color: oklch(96.7% .001 286.375);</td><td><div style="border-bottom-color: oklch(96.7% .001 286.375);"></div></td></tr>
    <tr><td>border-b-zinc-200</td><td>border-bottom-color: oklch(92% .004 286.32);</td><td><div style="border-bottom-color: oklch(92% .004 286.32);"></div></td></tr>
    <tr><td>border-b-zinc-300</td><td>border-bottom-color: oklch(87.1% .006 286.286);</td><td><div style="border-bottom-color: oklch(87.1% .006 286.286);"></div></td></tr>
    <tr><td>border-b-zinc-400</td><td>border-bottom-color: oklch(70.5% .015 286.067);</td><td><div style="border-bottom-color: oklch(70.5% .015 286.067);"></div></td></tr>
    <tr><td>border-b-zinc-500</td><td>border-bottom-color: oklch(55.2% .016 285.938);</td><td><div style="border-bottom-color: oklch(55.2% .016 285.938);"></div></td></tr>
    <tr><td>border-b-zinc-600</td><td>border-bottom-color: oklch(44.2% .017 285.786);</td><td><div style="border-bottom-color: oklch(44.2% .017 285.786);"></div></td></tr>
    <tr><td>border-b-zinc-700</td><td>border-bottom-color: oklch(37% .013 285.805);</td><td><div style="border-bottom-color: oklch(37% .013 285.805);"></div></td></tr>
    <tr><td>border-b-zinc-800</td><td>border-bottom-color: oklch(27.4% .006 286.033);</td><td><div style="border-bottom-color: oklch(27.4% .006 286.033);"></div></td></tr>
    <tr><td>border-b-zinc-900</td><td>border-bottom-color: oklch(21% .006 285.885);</td><td><div style="border-bottom-color: oklch(21% .006 285.885);"></div></td></tr>
    <tr><td>border-b-zinc-950</td><td>border-bottom-color: oklch(14.1% .005 285.823);</td><td><div style="border-bottom-color: oklch(14.1% .005 285.823);"></div></td></tr>
    <tr><td>border-b-neutral-50</td><td>border-bottom-color: oklch(98.5% 0 0);</td><td><div style="border-bottom-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-100</td><td>border-bottom-color: oklch(97% 0 0);</td><td><div style="border-bottom-color: oklch(97% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-200</td><td>border-bottom-color: oklch(92.2% 0 0);</td><td><div style="border-bottom-color: oklch(92.2% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-300</td><td>border-bottom-color: oklch(87% 0 0);</td><td><div style="border-bottom-color: oklch(87% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-400</td><td>border-bottom-color: oklch(70.8% 0 0);</td><td><div style="border-bottom-color: oklch(70.8% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-500</td><td>border-bottom-color: oklch(55.6% 0 0);</td><td><div style="border-bottom-color: oklch(55.6% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-600</td><td>border-bottom-color: oklch(43.9% 0 0);</td><td><div style="border-bottom-color: oklch(43.9% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-700</td><td>border-bottom-color: oklch(37.1% 0 0);</td><td><div style="border-bottom-color: oklch(37.1% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-800</td><td>border-bottom-color: oklch(26.9% 0 0);</td><td><div style="border-bottom-color: oklch(26.9% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-900</td><td>border-bottom-color: oklch(20.5% 0 0);</td><td><div style="border-bottom-color: oklch(20.5% 0 0);"></div></td></tr>
    <tr><td>border-b-neutral-950</td><td>border-bottom-color: oklch(14.5% 0 0);</td><td><div style="border-bottom-color: oklch(14.5% 0 0);"></div></td></tr>
    <tr><td>border-b-stone-50</td><td>border-bottom-color: oklch(98.5% .001 106.423);</td><td><div style="border-bottom-color: oklch(98.5% .001 106.423);"></div></td></tr>
    <tr><td>border-b-stone-100</td><td>border-bottom-color: oklch(97% .001 106.424);</td><td><div style="border-bottom-color: oklch(97% .001 106.424);"></div></td></tr>
    <tr><td>border-b-stone-200</td><td>border-bottom-color: oklch(92.3% .003 48.717);</td><td><div style="border-bottom-color: oklch(92.3% .003 48.717);"></div></td></tr>
    <tr><td>border-b-stone-300</td><td>border-bottom-color: oklch(86.9% .005 56.366);</td><td><div style="border-bottom-color: oklch(86.9% .005 56.366);"></div></td></tr>
    <tr><td>border-b-stone-400</td><td>border-bottom-color: oklch(70.9% .01 56.259);</td><td><div style="border-bottom-color: oklch(70.9% .01 56.259);"></div></td></tr>
    <tr><td>border-b-stone-500</td><td>border-bottom-color: oklch(55.3% .013 58.071);</td><td><div style="border-bottom-color: oklch(55.3% .013 58.071);"></div></td></tr>
    <tr><td>border-b-stone-600</td><td>border-bottom-color: oklch(44.4% .011 73.639);</td><td><div style="border-bottom-color: oklch(44.4% .011 73.639);"></div></td></tr>
    <tr><td>border-b-stone-700</td><td>border-bottom-color: oklch(37.4% .01 67.558);</td><td><div style="border-bottom-color: oklch(37.4% .01 67.558);"></div></td></tr>
    <tr><td>border-b-stone-800</td><td>border-bottom-color: oklch(26.8% .007 34.298);</td><td><div style="border-bottom-color: oklch(26.8% .007 34.298);"></div></td></tr>
    <tr><td>border-b-stone-900</td><td>border-bottom-color: oklch(21.6% .006 56.043);</td><td><div style="border-bottom-color: oklch(21.6% .006 56.043);"></div></td></tr>
    <tr><td>border-b-stone-950</td><td>border-bottom-color: oklch(14.7% .004 49.25);</td><td><div style="border-bottom-color: oklch(14.7% .004 49.25);"></div></td></tr>
    <tr><td>border-b-black</td><td>border-bottom-color: #000;</td><td><div style="border-bottom-color: #000;"></div></td></tr>
    <tr><td>border-b-white</td><td>border-bottom-color: #fff;</td><td><div style="border-bottom-color: #fff;"></div></td></tr>
    <tr><td>border-l-inherit</td><td>border-left-color: inherit;</td><td><div style="border-left-color: inherit;"></div></td></tr>
    <tr><td>border-l-current</td><td>border-left-color: currentColor;</td><td><div style="border-left-color: currentColor;"></div></td></tr>
    <tr><td>border-l-transparent</td><td>border-left-color: transparent;</td><td><div style="border-left-color: transparent;"></div></td></tr>
    <tr><td>border-l-red-50</td><td>border-left-color: oklch(97.1% .013 17.38);</td><td><div style="border-left-color: oklch(97.1% .013 17.38);"></div></td></tr>
    <tr><td>border-l-red-100</td><td>border-left-color: oklch(93.6% .032 17.717);</td><td><div style="border-left-color: oklch(93.6% .032 17.717);"></div></td></tr>
    <tr><td>border-l-red-200</td><td>border-left-color: oklch(88.5% .062 18.334);</td><td><div style="border-left-color: oklch(88.5% .062 18.334);"></div></td></tr>
    <tr><td>border-l-red-300</td><td>border-left-color: oklch(80.8% .114 19.571);</td><td><div style="border-left-color: oklch(80.8% .114 19.571);"></div></td></tr>
    <tr><td>border-l-red-400</td><td>border-left-color: oklch(70.4% .191 22.216);</td><td><div style="border-left-color: oklch(70.4% .191 22.216);"></div></td></tr>
    <tr><td>border-l-red-500</td><td>border-left-color: oklch(63.7% .237 25.331);</td><td><div style="border-left-color: oklch(63.7% .237 25.331);"></div></td></tr>
    <tr><td>border-l-red-600</td><td>border-left-color: oklch(57.7% .245 27.325);</td><td><div style="border-left-color: oklch(57.7% .245 27.325);"></div></td></tr>
    <tr><td>border-l-red-700</td><td>border-left-color: oklch(50.5% .213 27.518);</td><td><div style="border-left-color: oklch(50.5% .213 27.518);"></div></td></tr>
    <tr><td>border-l-red-800</td><td>border-left-color: oklch(44.4% .177 26.899);</td><td><div style="border-left-color: oklch(44.4% .177 26.899);"></div></td></tr>
    <tr><td>border-l-red-900</td><td>border-left-color: oklch(39.6% .141 25.723);</td><td><div style="border-left-color: oklch(39.6% .141 25.723);"></div></td></tr>
    <tr><td>border-l-red-950</td><td>border-left-color: oklch(25.8% .092 26.042);</td><td><div style="border-left-color: oklch(25.8% .092 26.042);"></div></td></tr>
    <tr><td>border-l-orange-50</td><td>border-left-color: oklch(98% .016 73.684);</td><td><div style="border-left-color: oklch(98% .016 73.684);"></div></td></tr>
    <tr><td>border-l-orange-100</td><td>border-left-color: oklch(95.4% .038 75.164);</td><td><div style="border-left-color: oklch(95.4% .038 75.164);"></div></td></tr>
    <tr><td>border-l-orange-200</td><td>border-left-color: oklch(90.1% .076 70.697);</td><td><div style="border-left-color: oklch(90.1% .076 70.697);"></div></td></tr>
    <tr><td>border-l-orange-300</td><td>border-left-color: oklch(83.7% .128 66.29);</td><td><div style="border-left-color: oklch(83.7% .128 66.29);"></div></td></tr>
    <tr><td>border-l-orange-400</td><td>border-left-color: oklch(75% .183 55.934);</td><td><div style="border-left-color: oklch(75% .183 55.934);"></div></td></tr>
    <tr><td>border-l-orange-500</td><td>border-left-color: oklch(70.5% .213 47.604);</td><td><div style="border-left-color: oklch(70.5% .213 47.604);"></div></td></tr>
    <tr><td>border-l-orange-600</td><td>border-left-color: oklch(64.6% .222 41.116);</td><td><div style="border-left-color: oklch(64.6% .222 41.116);"></div></td></tr>
    <tr><td>border-l-orange-700</td><td>border-left-color: oklch(55.3% .195 38.402);</td><td><div style="border-left-color: oklch(55.3% .195 38.402);"></div></td></tr>
    <tr><td>border-l-orange-800</td><td>border-left-color: oklch(47% .157 37.304);</td><td><div style="border-left-color: oklch(47% .157 37.304);"></div></td></tr>
    <tr><td>border-l-orange-900</td><td>border-left-color: oklch(40.8% .123 38.172);</td><td><div style="border-left-color: oklch(40.8% .123 38.172);"></div></td></tr>
    <tr><td>border-l-orange-950</td><td>border-left-color: oklch(26.6% .079 36.259);</td><td><div style="border-left-color: oklch(26.6% .079 36.259);"></div></td></tr>
    <tr><td>border-l-amber-50</td><td>border-left-color: oklch(98.7% .022 95.277);</td><td><div style="border-left-color: oklch(98.7% .022 95.277);"></div></td></tr>
    <tr><td>border-l-amber-100</td><td>border-left-color: oklch(96.2% .059 95.617);</td><td><div style="border-left-color: oklch(96.2% .059 95.617);"></div></td></tr>
    <tr><td>border-l-amber-200</td><td>border-left-color: oklch(92.4% .12 95.746);</td><td><div style="border-left-color: oklch(92.4% .12 95.746);"></div></td></tr>
    <tr><td>border-l-amber-300</td><td>border-left-color: oklch(87.9% .169 91.605);</td><td><div style="border-left-color: oklch(87.9% .169 91.605);"></div></td></tr>
    <tr><td>border-l-amber-400</td><td>border-left-color: oklch(82.8% .189 84.429);</td><td><div style="border-left-color: oklch(82.8% .189 84.429);"></div></td></tr>
    <tr><td>border-l-amber-500</td><td>border-left-color: oklch(76.9% .188 70.08);</td><td><div style="border-left-color: oklch(76.9% .188 70.08);"></div></td></tr>
    <tr><td>border-l-amber-600</td><td>border-left-color: oklch(66.6% .179 58.318);</td><td><div style="border-left-color: oklch(66.6% .179 58.318);"></div></td></tr>
    <tr><td>border-l-amber-700</td><td>border-left-color: oklch(55.5% .163 48.998);</td><td><div style="border-left-color: oklch(55.5% .163 48.998);"></div></td></tr>
    <tr><td>border-l-amber-800</td><td>border-left-color: oklch(47.3% .137 46.201);</td><td><div style="border-left-color: oklch(47.3% .137 46.201);"></div></td></tr>
    <tr><td>border-l-amber-900</td><td>border-left-color: oklch(41.4% .112 45.904);</td><td><div style="border-left-color: oklch(41.4% .112 45.904);"></div></td></tr>
    <tr><td>border-l-amber-950</td><td>border-left-color: oklch(27.9% .077 45.635);</td><td><div style="border-left-color: oklch(27.9% .077 45.635);"></div></td></tr>
    <tr><td>border-l-yellow-50</td><td>border-left-color: oklch(98.7% .026 102.212);</td><td><div style="border-left-color: oklch(98.7% .026 102.212);"></div></td></tr>
    <tr><td>border-l-yellow-100</td><td>border-left-color: oklch(97.3% .071 103.193);</td><td><div style="border-left-color: oklch(97.3% .071 103.193);"></div></td></tr>
    <tr><td>border-l-yellow-200</td><td>border-left-color: oklch(94.5% .129 101.54);</td><td><div style="border-left-color: oklch(94.5% .129 101.54);"></div></td></tr>
    <tr><td>border-l-yellow-300</td><td>border-left-color: oklch(90.5% .182 98.111);</td><td><div style="border-left-color: oklch(90.5% .182 98.111);"></div></td></tr>
    <tr><td>border-l-yellow-400</td><td>border-left-color: oklch(85.2% .199 91.936);</td><td><div style="border-left-color: oklch(85.2% .199 91.936);"></div></td></tr>
    <tr><td>border-l-yellow-500</td><td>border-left-color: oklch(79.5% .184 86.047);</td><td><div style="border-left-color: oklch(79.5% .184 86.047);"></div></td></tr>
    <tr><td>border-l-yellow-600</td><td>border-left-color: oklch(68.1% .162 75.834);</td><td><div style="border-left-color: oklch(68.1% .162 75.834);"></div></td></tr>
    <tr><td>border-l-yellow-700</td><td>border-left-color: oklch(55.4% .135 66.442);</td><td><div style="border-left-color: oklch(55.4% .135 66.442);"></div></td></tr>
    <tr><td>border-l-yellow-800</td><td>border-left-color: oklch(47.6% .114 61.907);</td><td><div style="border-left-color: oklch(47.6% .114 61.907);"></div></td></tr>
    <tr><td>border-l-yellow-900</td><td>border-left-color: oklch(42.1% .095 57.708);</td><td><div style="border-left-color: oklch(42.1% .095 57.708);"></div></td></tr>
    <tr><td>border-l-yellow-950</td><td>border-left-color: oklch(28.6% .066 53.813);</td><td><div style="border-left-color: oklch(28.6% .066 53.813);"></div></td></tr>
    <tr><td>border-l-lime-50</td><td>border-left-color: oklch(98.6% .031 120.757);</td><td><div style="border-left-color: oklch(98.6% .031 120.757);"></div></td></tr>
    <tr><td>border-l-lime-100</td><td>border-left-color: oklch(96.7% .067 122.328);</td><td><div style="border-left-color: oklch(96.7% .067 122.328);"></div></td></tr>
    <tr><td>border-l-lime-200</td><td>border-left-color: oklch(93.8% .127 124.321);</td><td><div style="border-left-color: oklch(93.8% .127 124.321);"></div></td></tr>
    <tr><td>border-l-lime-300</td><td>border-left-color: oklch(89.7% .196 126.665);</td><td><div style="border-left-color: oklch(89.7% .196 126.665);"></div></td></tr>
    <tr><td>border-l-lime-400</td><td>border-left-color: oklch(84.1% .238 128.85);</td><td><div style="border-left-color: oklch(84.1% .238 128.85);"></div></td></tr>
    <tr><td>border-l-lime-500</td><td>border-left-color: oklch(76.8% .233 130.85);</td><td><div style="border-left-color: oklch(76.8% .233 130.85);"></div></td></tr>
    <tr><td>border-l-lime-600</td><td>border-left-color: oklch(64.8% .2 131.684);</td><td><div style="border-left-color: oklch(64.8% .2 131.684);"></div></td></tr>
    <tr><td>border-l-lime-700</td><td>border-left-color: oklch(53.2% .157 131.589);</td><td><div style="border-left-color: oklch(53.2% .157 131.589);"></div></td></tr>
    <tr><td>border-l-lime-800</td><td>border-left-color: oklch(45.3% .124 130.933);</td><td><div style="border-left-color: oklch(45.3% .124 130.933);"></div></td></tr>
    <tr><td>border-l-lime-900</td><td>border-left-color: oklch(40.5% .101 131.063);</td><td><div style="border-left-color: oklch(40.5% .101 131.063);"></div></td></tr>
    <tr><td>border-l-lime-950</td><td>border-left-color: oklch(27.4% .072 132.109);</td><td><div style="border-left-color: oklch(27.4% .072 132.109);"></div></td></tr>
    <tr><td>border-l-green-50</td><td>border-left-color: oklch(98.2% .018 155.826);</td><td><div style="border-left-color: oklch(98.2% .018 155.826);"></div></td></tr>
    <tr><td>border-l-green-100</td><td>border-left-color: oklch(96.2% .044 156.743);</td><td><div style="border-left-color: oklch(96.2% .044 156.743);"></div></td></tr>
    <tr><td>border-l-green-200</td><td>border-left-color: oklch(92.5% .084 155.995);</td><td><div style="border-left-color: oklch(92.5% .084 155.995);"></div></td></tr>
    <tr><td>border-l-green-300</td><td>border-left-color: oklch(87.1% .15 154.449);</td><td><div style="border-left-color: oklch(87.1% .15 154.449);"></div></td></tr>
    <tr><td>border-l-green-400</td><td>border-left-color: oklch(79.2% .209 151.711);</td><td><div style="border-left-color: oklch(79.2% .209 151.711);"></div></td></tr>
    <tr><td>border-l-green-500</td><td>border-left-color: oklch(72.3% .219 149.579);</td><td><div style="border-left-color: oklch(72.3% .219 149.579);"></div></td></tr>
    <tr><td>border-l-green-600</td><td>border-left-color: oklch(62.7% .194 149.214);</td><td><div style="border-left-color: oklch(62.7% .194 149.214);"></div></td></tr>
    <tr><td>border-l-green-700</td><td>border-left-color: oklch(52.7% .154 150.069);</td><td><div style="border-left-color: oklch(52.7% .154 150.069);"></div></td></tr>
    <tr><td>border-l-green-800</td><td>border-left-color: oklch(44.8% .119 151.328);</td><td><div style="border-left-color: oklch(44.8% .119 151.328);"></div></td></tr>
    <tr><td>border-l-green-900</td><td>border-left-color: oklch(39.3% .095 152.535);</td><td><div style="border-left-color: oklch(39.3% .095 152.535);"></div></td></tr>
    <tr><td>border-l-green-950</td><td>border-left-color: oklch(26.6% .065 152.934);</td><td><div style="border-left-color: oklch(26.6% .065 152.934);"></div></td></tr>
    <tr><td>border-l-emerald-50</td><td>border-left-color: oklch(97.9% .021 166.113);</td><td><div style="border-left-color: oklch(97.9% .021 166.113);"></div></td></tr>
    <tr><td>border-l-emerald-100</td><td>border-left-color: oklch(95% .052 163.051);</td><td><div style="border-left-color: oklch(95% .052 163.051);"></div></td></tr>
    <tr><td>border-l-emerald-200</td><td>border-left-color: oklch(90.5% .093 164.15);</td><td><div style="border-left-color: oklch(90.5% .093 164.15);"></div></td></tr>
    <tr><td>border-l-emerald-300</td><td>border-left-color: oklch(84.5% .143 164.978);</td><td><div style="border-left-color: oklch(84.5% .143 164.978);"></div></td></tr>
    <tr><td>border-l-emerald-400</td><td>border-left-color: oklch(76.5% .177 163.223);</td><td><div style="border-left-color: oklch(76.5% .177 163.223);"></div></td></tr>
    <tr><td>border-l-emerald-500</td><td>border-left-color: oklch(69.6% .17 162.48);</td><td><div style="border-left-color: oklch(69.6% .17 162.48);"></div></td></tr>
    <tr><td>border-l-emerald-600</td><td>border-left-color: oklch(59.6% .145 163.225);</td><td><div style="border-left-color: oklch(59.6% .145 163.225);"></div></td></tr>
    <tr><td>border-l-emerald-700</td><td>border-left-color: oklch(50.8% .118 165.612);</td><td><div style="border-left-color: oklch(50.8% .118 165.612);"></div></td></tr>
    <tr><td>border-l-emerald-800</td><td>border-left-color: oklch(43.2% .095 166.913);</td><td><div style="border-left-color: oklch(43.2% .095 166.913);"></div></td></tr>
    <tr><td>border-l-emerald-900</td><td>border-left-color: oklch(37.8% .077 168.94);</td><td><div style="border-left-color: oklch(37.8% .077 168.94);"></div></td></tr>
    <tr><td>border-l-emerald-950</td><td>border-left-color: oklch(26.2% .051 172.552);</td><td><div style="border-left-color: oklch(26.2% .051 172.552);"></div></td></tr>
    <tr><td>border-l-teal-50</td><td>border-left-color: oklch(98.4% .014 180.72);</td><td><div style="border-left-color: oklch(98.4% .014 180.72);"></div></td></tr>
    <tr><td>border-l-teal-100</td><td>border-left-color: oklch(95.3% .051 180.801);</td><td><div style="border-left-color: oklch(95.3% .051 180.801);"></div></td></tr>
    <tr><td>border-l-teal-200</td><td>border-left-color: oklch(91% .096 180.426);</td><td><div style="border-left-color: oklch(91% .096 180.426);"></div></td></tr>
    <tr><td>border-l-teal-300</td><td>border-left-color: oklch(85.5% .138 181.071);</td><td><div style="border-left-color: oklch(85.5% .138 181.071);"></div></td></tr>
    <tr><td>border-l-teal-400</td><td>border-left-color: oklch(77.7% .152 181.912);</td><td><div style="border-left-color: oklch(77.7% .152 181.912);"></div></td></tr>
    <tr><td>border-l-teal-500</td><td>border-left-color: oklch(70.4% .14 182.503);</td><td><div style="border-left-color: oklch(70.4% .14 182.503);"></div></td></tr>
    <tr><td>border-l-teal-600</td><td>border-left-color: oklch(60% .118 184.704);</td><td><div style="border-left-color: oklch(60% .118 184.704);"></div></td></tr>
    <tr><td>border-l-teal-700</td><td>border-left-color: oklch(51.1% .096 186.391);</td><td><div style="border-left-color: oklch(51.1% .096 186.391);"></div></td></tr>
    <tr><td>border-l-teal-800</td><td>border-left-color: oklch(43.7% .078 188.216);</td><td><div style="border-left-color: oklch(43.7% .078 188.216);"></div></td></tr>
    <tr><td>border-l-teal-900</td><td>border-left-color: oklch(38.6% .063 188.416);</td><td><div style="border-left-color: oklch(38.6% .063 188.416);"></div></td></tr>
    <tr><td>border-l-teal-950</td><td>border-left-color: oklch(27.7% .046 192.524);</td><td><div style="border-left-color: oklch(27.7% .046 192.524);"></div></td></tr>
    <tr><td>border-l-cyan-50</td><td>border-left-color: oklch(98.4% .019 200.873);</td><td><div style="border-left-color: oklch(98.4% .019 200.873);"></div></td></tr>
    <tr><td>border-l-cyan-100</td><td>border-left-color: oklch(95.6% .045 203.388);</td><td><div style="border-left-color: oklch(95.6% .045 203.388);"></div></td></tr>
    <tr><td>border-l-cyan-200</td><td>border-left-color: oklch(91.7% .08 205.041);</td><td><div style="border-left-color: oklch(91.7% .08 205.041);"></div></td></tr>
    <tr><td>border-l-cyan-300</td><td>border-left-color: oklch(86.5% .127 207.078);</td><td><div style="border-left-color: oklch(86.5% .127 207.078);"></div></td></tr>
    <tr><td>border-l-cyan-400</td><td>border-left-color: oklch(78.9% .154 211.53);</td><td><div style="border-left-color: oklch(78.9% .154 211.53);"></div></td></tr>
    <tr><td>border-l-cyan-500</td><td>border-left-color: oklch(71.5% .143 215.221);</td><td><div style="border-left-color: oklch(71.5% .143 215.221);"></div></td></tr>
    <tr><td>border-l-cyan-600</td><td>border-left-color: oklch(60.9% .126 221.723);</td><td><div style="border-left-color: oklch(60.9% .126 221.723);"></div></td></tr>
    <tr><td>border-l-cyan-700</td><td>border-left-color: oklch(52% .105 223.128);</td><td><div style="border-left-color: oklch(52% .105 223.128);"></div></td></tr>
    <tr><td>border-l-cyan-800</td><td>border-left-color: oklch(45% .085 224.283);</td><td><div style="border-left-color: oklch(45% .085 224.283);"></div></td></tr>
    <tr><td>border-l-cyan-900</td><td>border-left-color: oklch(39.8% .07 227.392);</td><td><div style="border-left-color: oklch(39.8% .07 227.392);"></div></td></tr>
    <tr><td>border-l-cyan-950</td><td>border-left-color: oklch(30.2% .056 229.695);</td><td><div style="border-left-color: oklch(30.2% .056 229.695);"></div></td></tr>
    <tr><td>border-l-sky-50</td><td>border-left-color: oklch(97.7% .013 236.62);</td><td><div style="border-left-color: oklch(97.7% .013 236.62);"></div></td></tr>
    <tr><td>border-l-sky-100</td><td>border-left-color: oklch(95.1% .026 236.824);</td><td><div style="border-left-color: oklch(95.1% .026 236.824);"></div></td></tr>
    <tr><td>border-l-sky-200</td><td>border-left-color: oklch(90.1% .058 230.902);</td><td><div style="border-left-color: oklch(90.1% .058 230.902);"></div></td></tr>
    <tr><td>border-l-sky-300</td><td>border-left-color: oklch(82.8% .111 230.318);</td><td><div style="border-left-color: oklch(82.8% .111 230.318);"></div></td></tr>
    <tr><td>border-l-sky-400</td><td>border-left-color: oklch(74.6% .16 232.661);</td><td><div style="border-left-color: oklch(74.6% .16 232.661);"></div></td></tr>
    <tr><td>border-l-sky-500</td><td>border-left-color: oklch(68.5% .169 237.323);</td><td><div style="border-left-color: oklch(68.5% .169 237.323);"></div></td></tr>
    <tr><td>border-l-sky-600</td><td>border-left-color: oklch(58.8% .158 241.966);</td><td><div style="border-left-color: oklch(58.8% .158 241.966);"></div></td></tr>
    <tr><td>border-l-sky-700</td><td>border-left-color: oklch(50% .134 242.749);</td><td><div style="border-left-color: oklch(50% .134 242.749);"></div></td></tr>
    <tr><td>border-l-sky-800</td><td>border-left-color: oklch(44.3% .11 240.79);</td><td><div style="border-left-color: oklch(44.3% .11 240.79);"></div></td></tr>
    <tr><td>border-l-sky-900</td><td>border-left-color: oklch(39.1% .09 240.876);</td><td><div style="border-left-color: oklch(39.1% .09 240.876);"></div></td></tr>
    <tr><td>border-l-sky-950</td><td>border-left-color: oklch(29.3% .066 243.157);</td><td><div style="border-left-color: oklch(29.3% .066 243.157);"></div></td></tr>
    <tr><td>border-l-blue-50</td><td>border-left-color: oklch(97% .014 254.604);</td><td><div style="border-left-color: oklch(97% .014 254.604);"></div></td></tr>
    <tr><td>border-l-blue-100</td><td>border-left-color: oklch(93.2% .032 255.585);</td><td><div style="border-left-color: oklch(93.2% .032 255.585);"></div></td></tr>
    <tr><td>border-l-blue-200</td><td>border-left-color: oklch(88.2% .059 254.128);</td><td><div style="border-left-color: oklch(88.2% .059 254.128);"></div></td></tr>
    <tr><td>border-l-blue-300</td><td>border-left-color: oklch(80.9% .105 251.813);</td><td><div style="border-left-color: oklch(80.9% .105 251.813);"></div></td></tr>
    <tr><td>border-l-blue-400</td><td>border-left-color: oklch(70.7% .165 254.624);</td><td><div style="border-left-color: oklch(70.7% .165 254.624);"></div></td></tr>
    <tr><td>border-l-blue-500</td><td>border-left-color: oklch(62.3% .214 259.815);</td><td><div style="border-left-color: oklch(62.3% .214 259.815);"></div></td></tr>
    <tr><td>border-l-blue-600</td><td>border-left-color: oklch(54.6% .245 262.881);</td><td><div style="border-left-color: oklch(54.6% .245 262.881);"></div></td></tr>
    <tr><td>border-l-blue-700</td><td>border-left-color: oklch(48.8% .243 264.376);</td><td><div style="border-left-color: oklch(48.8% .243 264.376);"></div></td></tr>
    <tr><td>border-l-blue-800</td><td>border-left-color: oklch(42.4% .199 265.638);</td><td><div style="border-left-color: oklch(42.4% .199 265.638);"></div></td></tr>
    <tr><td>border-l-blue-900</td><td>border-left-color: oklch(37.9% .146 265.522);</td><td><div style="border-left-color: oklch(37.9% .146 265.522);"></div></td></tr>
    <tr><td>border-l-blue-950</td><td>border-left-color: oklch(28.2% .091 267.935);</td><td><div style="border-left-color: oklch(28.2% .091 267.935);"></div></td></tr>
    <tr><td>border-l-indigo-50</td><td>border-left-color: oklch(96.2% .018 272.314);</td><td><div style="border-left-color: oklch(96.2% .018 272.314);"></div></td></tr>
    <tr><td>border-l-indigo-100</td><td>border-left-color: oklch(93% .034 272.788);</td><td><div style="border-left-color: oklch(93% .034 272.788);"></div></td></tr>
    <tr><td>border-l-indigo-200</td><td>border-left-color: oklch(87% .065 274.039);</td><td><div style="border-left-color: oklch(87% .065 274.039);"></div></td></tr>
    <tr><td>border-l-indigo-300</td><td>border-left-color: oklch(78.5% .115 274.713);</td><td><div style="border-left-color: oklch(78.5% .115 274.713);"></div></td></tr>
    <tr><td>border-l-indigo-400</td><td>border-left-color: oklch(67.3% .182 276.935);</td><td><div style="border-left-color: oklch(67.3% .182 276.935);"></div></td></tr>
    <tr><td>border-l-indigo-500</td><td>border-left-color: oklch(58.5% .233 277.117);</td><td><div style="border-left-color: oklch(58.5% .233 277.117);"></div></td></tr>
    <tr><td>border-l-indigo-600</td><td>border-left-color: oklch(51.1% .262 276.966);</td><td><div style="border-left-color: oklch(51.1% .262 276.966);"></div></td></tr>
    <tr><td>border-l-indigo-700</td><td>border-left-color: oklch(45.7% .24 277.023);</td><td><div style="border-left-color: oklch(45.7% .24 277.023);"></div></td></tr>
    <tr><td>border-l-indigo-800</td><td>border-left-color: oklch(39.8% .195 277.366);</td><td><div style="border-left-color: oklch(39.8% .195 277.366);"></div></td></tr>
    <tr><td>border-l-indigo-900</td><td>border-left-color: oklch(35.9% .144 278.697);</td><td><div style="border-left-color: oklch(35.9% .144 278.697);"></div></td></tr>
    <tr><td>border-l-indigo-950</td><td>border-left-color: oklch(25.7% .09 281.288);</td><td><div style="border-left-color: oklch(25.7% .09 281.288);"></div></td></tr>
    <tr><td>border-l-violet-50</td><td>border-left-color: oklch(96.9% .016 293.756);</td><td><div style="border-left-color: oklch(96.9% .016 293.756);"></div></td></tr>
    <tr><td>border-l-violet-100</td><td>border-left-color: oklch(94.3% .029 294.588);</td><td><div style="border-left-color: oklch(94.3% .029 294.588);"></div></td></tr>
    <tr><td>border-l-violet-200</td><td>border-left-color: oklch(89.4% .057 293.283);</td><td><div style="border-left-color: oklch(89.4% .057 293.283);"></div></td></tr>
    <tr><td>border-l-violet-300</td><td>border-left-color: oklch(81.1% .111 293.571);</td><td><div style="border-left-color: oklch(81.1% .111 293.571);"></div></td></tr>
    <tr><td>border-l-violet-400</td><td>border-left-color: oklch(70.2% .183 293.541);</td><td><div style="border-left-color: oklch(70.2% .183 293.541);"></div></td></tr>
    <tr><td>border-l-violet-500</td><td>border-left-color: oklch(60.6% .25 292.717);</td><td><div style="border-left-color: oklch(60.6% .25 292.717);"></div></td></tr>
    <tr><td>border-l-violet-600</td><td>border-left-color: oklch(54.1% .281 293.009);</td><td><div style="border-left-color: oklch(54.1% .281 293.009);"></div></td></tr>
    <tr><td>border-l-violet-700</td><td>border-left-color: oklch(49.1% .27 292.581);</td><td><div style="border-left-color: oklch(49.1% .27 292.581);"></div></td></tr>
    <tr><td>border-l-violet-800</td><td>border-left-color: oklch(43.2% .232 292.759);</td><td><div style="border-left-color: oklch(43.2% .232 292.759);"></div></td></tr>
    <tr><td>border-l-violet-900</td><td>border-left-color: oklch(38% .189 293.745);</td><td><div style="border-left-color: oklch(38% .189 293.745);"></div></td></tr>
    <tr><td>border-l-violet-950</td><td>border-left-color: oklch(28.3% .141 291.089);</td><td><div style="border-left-color: oklch(28.3% .141 291.089);"></div></td></tr>
    <tr><td>border-l-purple-50</td><td>border-left-color: oklch(97.7% .014 308.299);</td><td><div style="border-left-color: oklch(97.7% .014 308.299);"></div></td></tr>
    <tr><td>border-l-purple-100</td><td>border-left-color: oklch(94.6% .033 307.174);</td><td><div style="border-left-color: oklch(94.6% .033 307.174);"></div></td></tr>
    <tr><td>border-l-purple-200</td><td>border-left-color: oklch(90.2% .063 306.703);</td><td><div style="border-left-color: oklch(90.2% .063 306.703);"></div></td></tr>
    <tr><td>border-l-purple-300</td><td>border-left-color: oklch(82.7% .119 306.383);</td><td><div style="border-left-color: oklch(82.7% .119 306.383);"></div></td></tr>
    <tr><td>border-l-purple-400</td><td>border-left-color: oklch(71.4% .203 305.504);</td><td><div style="border-left-color: oklch(71.4% .203 305.504);"></div></td></tr>
    <tr><td>border-l-purple-500</td><td>border-left-color: oklch(62.7% .265 303.9);</td><td><div style="border-left-color: oklch(62.7% .265 303.9);"></div></td></tr>
    <tr><td>border-l-purple-600</td><td>border-left-color: oklch(55.8% .288 302.321);</td><td><div style="border-left-color: oklch(55.8% .288 302.321);"></div></td></tr>
    <tr><td>border-l-purple-700</td><td>border-left-color: oklch(49.6% .265 301.924);</td><td><div style="border-left-color: oklch(49.6% .265 301.924);"></div></td></tr>
    <tr><td>border-l-purple-800</td><td>border-left-color: oklch(43.8% .218 303.724);</td><td><div style="border-left-color: oklch(43.8% .218 303.724);"></div></td></tr>
    <tr><td>border-l-purple-900</td><td>border-left-color: oklch(38.1% .176 304.987);</td><td><div style="border-left-color: oklch(38.1% .176 304.987);"></div></td></tr>
    <tr><td>border-l-purple-950</td><td>border-left-color: oklch(29.1% .149 302.717);</td><td><div style="border-left-color: oklch(29.1% .149 302.717);"></div></td></tr>
    <tr><td>border-l-fuchsia-50</td><td>border-left-color: oklch(97.7% .017 320.058);</td><td><div style="border-left-color: oklch(97.7% .017 320.058);"></div></td></tr>
    <tr><td>border-l-fuchsia-100</td><td>border-left-color: oklch(95.2% .037 318.852);</td><td><div style="border-left-color: oklch(95.2% .037 318.852);"></div></td></tr>
    <tr><td>border-l-fuchsia-200</td><td>border-left-color: oklch(90.3% .076 319.62);</td><td><div style="border-left-color: oklch(90.3% .076 319.62);"></div></td></tr>
    <tr><td>border-l-fuchsia-300</td><td>border-left-color: oklch(83.3% .145 321.434);</td><td><div style="border-left-color: oklch(83.3% .145 321.434);"></div></td></tr>
    <tr><td>border-l-fuchsia-400</td><td>border-left-color: oklch(74% .238 322.16);</td><td><div style="border-left-color: oklch(74% .238 322.16);"></div></td></tr>
    <tr><td>border-l-fuchsia-500</td><td>border-left-color: oklch(66.7% .295 322.15);</td><td><div style="border-left-color: oklch(66.7% .295 322.15);"></div></td></tr>
    <tr><td>border-l-fuchsia-600</td><td>border-left-color: oklch(59.1% .293 322.896);</td><td><div style="border-left-color: oklch(59.1% .293 322.896);"></div></td></tr>
    <tr><td>border-l-fuchsia-700</td><td>border-left-color: oklch(51.8% .253 323.949);</td><td><div style="border-left-color: oklch(51.8% .253 323.949);"></div></td></tr>
    <tr><td>border-l-fuchsia-800</td><td>border-left-color: oklch(45.2% .211 324.591);</td><td><div style="border-left-color: oklch(45.2% .211 324.591);"></div></td></tr>
    <tr><td>border-l-fuchsia-900</td><td>border-left-color: oklch(40.1% .17 325.612);</td><td><div style="border-left-color: oklch(40.1% .17 325.612);"></div></td></tr>
    <tr><td>border-l-fuchsia-950</td><td>border-left-color: oklch(29.3% .136 325.661);</td><td><div style="border-left-color: oklch(29.3% .136 325.661);"></div></td></tr>
    <tr><td>border-l-pink-50</td><td>border-left-color: oklch(97.1% .014 343.198);</td><td><div style="border-left-color: oklch(97.1% .014 343.198);"></div></td></tr>
    <tr><td>border-l-pink-100</td><td>border-left-color: oklch(94.8% .028 342.258);</td><td><div style="border-left-color: oklch(94.8% .028 342.258);"></div></td></tr>
    <tr><td>border-l-pink-200</td><td>border-left-color: oklch(89.9% .061 343.231);</td><td><div style="border-left-color: oklch(89.9% .061 343.231);"></div></td></tr>
    <tr><td>border-l-pink-300</td><td>border-left-color: oklch(82.3% .12 346.018);</td><td><div style="border-left-color: oklch(82.3% .12 346.018);"></div></td></tr>
    <tr><td>border-l-pink-400</td><td>border-left-color: oklch(71.8% .202 349.761);</td><td><div style="border-left-color: oklch(71.8% .202 349.761);"></div></td></tr>
    <tr><td>border-l-pink-500</td><td>border-left-color: oklch(65.6% .241 354.308);</td><td><div style="border-left-color: oklch(65.6% .241 354.308);"></div></td></tr>
    <tr><td>border-l-pink-600</td><td>border-left-color: oklch(59.2% .249 .584);</td><td><div style="border-left-color: oklch(59.2% .249 .584);"></div></td></tr>
    <tr><td>border-l-pink-700</td><td>border-left-color: oklch(52.5% .223 3.958);</td><td><div style="border-left-color: oklch(52.5% .223 3.958);"></div></td></tr>
    <tr><td>border-l-pink-800</td><td>border-left-color: oklch(45.9% .187 3.815);</td><td><div style="border-left-color: oklch(45.9% .187 3.815);"></div></td></tr>
    <tr><td>border-l-pink-900</td><td>border-left-color: oklch(40.8% .153 2.432);</td><td><div style="border-left-color: oklch(40.8% .153 2.432);"></div></td></tr>
    <tr><td>border-l-pink-950</td><td>border-left-color: oklch(28.4% .109 3.907);</td><td><div style="border-left-color: oklch(28.4% .109 3.907);"></div></td></tr>
    <tr><td>border-l-rose-50</td><td>border-left-color: oklch(96.9% .015 12.422);</td><td><div style="border-left-color: oklch(96.9% .015 12.422);"></div></td></tr>
    <tr><td>border-l-rose-100</td><td>border-left-color: oklch(94.1% .03 12.58);</td><td><div style="border-left-color: oklch(94.1% .03 12.58);"></div></td></tr>
    <tr><td>border-l-rose-200</td><td>border-left-color: oklch(89.2% .058 10.001);</td><td><div style="border-left-color: oklch(89.2% .058 10.001);"></div></td></tr>
    <tr><td>border-l-rose-300</td><td>border-left-color: oklch(81% .117 11.638);</td><td><div style="border-left-color: oklch(81% .117 11.638);"></div></td></tr>
    <tr><td>border-l-rose-400</td><td>border-left-color: oklch(71.2% .194 13.428);</td><td><div style="border-left-color: oklch(71.2% .194 13.428);"></div></td></tr>
    <tr><td>border-l-rose-500</td><td>border-left-color: oklch(64.5% .246 16.439);</td><td><div style="border-left-color: oklch(64.5% .246 16.439);"></div></td></tr>
    <tr><td>border-l-rose-600</td><td>border-left-color: oklch(58.6% .253 17.585);</td><td><div style="border-left-color: oklch(58.6% .253 17.585);"></div></td></tr>
    <tr><td>border-l-rose-700</td><td>border-left-color: oklch(51.4% .222 16.935);</td><td><div style="border-left-color: oklch(51.4% .222 16.935);"></div></td></tr>
    <tr><td>border-l-rose-800</td><td>border-left-color: oklch(45.5% .188 13.697);</td><td><div style="border-left-color: oklch(45.5% .188 13.697);"></div></td></tr>
    <tr><td>border-l-rose-900</td><td>border-left-color: oklch(41% .159 10.272);</td><td><div style="border-left-color: oklch(41% .159 10.272);"></div></td></tr>
    <tr><td>border-l-rose-950</td><td>border-left-color: oklch(27.1% .105 12.094);</td><td><div style="border-left-color: oklch(27.1% .105 12.094);"></div></td></tr>
    <tr><td>border-l-slate-50</td><td>border-left-color: oklch(98.4% .003 247.858);</td><td><div style="border-left-color: oklch(98.4% .003 247.858);"></div></td></tr>
    <tr><td>border-l-slate-100</td><td>border-left-color: oklch(96.8% .007 247.896);</td><td><div style="border-left-color: oklch(96.8% .007 247.896);"></div></td></tr>
    <tr><td>border-l-slate-200</td><td>border-left-color: oklch(92.9% .013 255.508);</td><td><div style="border-left-color: oklch(92.9% .013 255.508);"></div></td></tr>
    <tr><td>border-l-slate-300</td><td>border-left-color: oklch(86.9% .022 252.894);</td><td><div style="border-left-color: oklch(86.9% .022 252.894);"></div></td></tr>
    <tr><td>border-l-slate-400</td><td>border-left-color: oklch(70.4% .04 256.788);</td><td><div style="border-left-color: oklch(70.4% .04 256.788);"></div></td></tr>
    <tr><td>border-l-slate-500</td><td>border-left-color: oklch(55.4% .046 257.417);</td><td><div style="border-left-color: oklch(55.4% .046 257.417);"></div></td></tr>
    <tr><td>border-l-slate-600</td><td>border-left-color: oklch(44.6% .043 257.281);</td><td><div style="border-left-color: oklch(44.6% .043 257.281);"></div></td></tr>
    <tr><td>border-l-slate-700</td><td>border-left-color: oklch(37.2% .044 257.287);</td><td><div style="border-left-color: oklch(37.2% .044 257.287);"></div></td></tr>
    <tr><td>border-l-slate-800</td><td>border-left-color: oklch(27.9% .041 260.031);</td><td><div style="border-left-color: oklch(27.9% .041 260.031);"></div></td></tr>
    <tr><td>border-l-slate-900</td><td>border-left-color: oklch(20.8% .042 265.755);</td><td><div style="border-left-color: oklch(20.8% .042 265.755);"></div></td></tr>
    <tr><td>border-l-slate-950</td><td>border-left-color: oklch(12.9% .042 264.695);</td><td><div style="border-left-color: oklch(12.9% .042 264.695);"></div></td></tr>
    <tr><td>border-l-gray-50</td><td>border-left-color: oklch(98.5% .002 247.839);</td><td><div style="border-left-color: oklch(98.5% .002 247.839);"></div></td></tr>
    <tr><td>border-l-gray-100</td><td>border-left-color: oklch(96.7% .003 264.542);</td><td><div style="border-left-color: oklch(96.7% .003 264.542);"></div></td></tr>
    <tr><td>border-l-gray-200</td><td>border-left-color: oklch(92.8% .006 264.531);</td><td><div style="border-left-color: oklch(92.8% .006 264.531);"></div></td></tr>
    <tr><td>border-l-gray-300</td><td>border-left-color: oklch(87.2% .01 258.338);</td><td><div style="border-left-color: oklch(87.2% .01 258.338);"></div></td></tr>
    <tr><td>border-l-gray-400</td><td>border-left-color: oklch(70.7% .022 261.325);</td><td><div style="border-left-color: oklch(70.7% .022 261.325);"></div></td></tr>
    <tr><td>border-l-gray-500</td><td>border-left-color: oklch(55.1% .027 264.364);</td><td><div style="border-left-color: oklch(55.1% .027 264.364);"></div></td></tr>
    <tr><td>border-l-gray-600</td><td>border-left-color: oklch(44.6% .03 256.802);</td><td><div style="border-left-color: oklch(44.6% .03 256.802);"></div></td></tr>
    <tr><td>border-l-gray-700</td><td>border-left-color: oklch(37.3% .034 259.733);</td><td><div style="border-left-color: oklch(37.3% .034 259.733);"></div></td></tr>
    <tr><td>border-l-gray-800</td><td>border-left-color: oklch(27.8% .033 256.848);</td><td><div style="border-left-color: oklch(27.8% .033 256.848);"></div></td></tr>
    <tr><td>border-l-gray-900</td><td>border-left-color: oklch(21% .034 264.665);</td><td><div style="border-left-color: oklch(21% .034 264.665);"></div></td></tr>
    <tr><td>border-l-gray-950</td><td>border-left-color: oklch(13% .028 261.692);</td><td><div style="border-left-color: oklch(13% .028 261.692);"></div></td></tr>
    <tr><td>border-l-zinc-50</td><td>border-left-color: oklch(98.5% 0 0);</td><td><div style="border-left-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-l-zinc-100</td><td>border-left-color: oklch(96.7% .001 286.375);</td><td><div style="border-left-color: oklch(96.7% .001 286.375);"></div></td></tr>
    <tr><td>border-l-zinc-200</td><td>border-left-color: oklch(92% .004 286.32);</td><td><div style="border-left-color: oklch(92% .004 286.32);"></div></td></tr>
    <tr><td>border-l-zinc-300</td><td>border-left-color: oklch(87.1% .006 286.286);</td><td><div style="border-left-color: oklch(87.1% .006 286.286);"></div></td></tr>
    <tr><td>border-l-zinc-400</td><td>border-left-color: oklch(70.5% .015 286.067);</td><td><div style="border-left-color: oklch(70.5% .015 286.067);"></div></td></tr>
    <tr><td>border-l-zinc-500</td><td>border-left-color: oklch(55.2% .016 285.938);</td><td><div style="border-left-color: oklch(55.2% .016 285.938);"></div></td></tr>
    <tr><td>border-l-zinc-600</td><td>border-left-color: oklch(44.2% .017 285.786);</td><td><div style="border-left-color: oklch(44.2% .017 285.786);"></div></td></tr>
    <tr><td>border-l-zinc-700</td><td>border-left-color: oklch(37% .013 285.805);</td><td><div style="border-left-color: oklch(37% .013 285.805);"></div></td></tr>
    <tr><td>border-l-zinc-800</td><td>border-left-color: oklch(27.4% .006 286.033);</td><td><div style="border-left-color: oklch(27.4% .006 286.033);"></div></td></tr>
    <tr><td>border-l-zinc-900</td><td>border-left-color: oklch(21% .006 285.885);</td><td><div style="border-left-color: oklch(21% .006 285.885);"></div></td></tr>
    <tr><td>border-l-zinc-950</td><td>border-left-color: oklch(14.1% .005 285.823);</td><td><div style="border-left-color: oklch(14.1% .005 285.823);"></div></td></tr>
    <tr><td>border-l-neutral-50</td><td>border-left-color: oklch(98.5% 0 0);</td><td><div style="border-left-color: oklch(98.5% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-100</td><td>border-left-color: oklch(97% 0 0);</td><td><div style="border-left-color: oklch(97% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-200</td><td>border-left-color: oklch(92.2% 0 0);</td><td><div style="border-left-color: oklch(92.2% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-300</td><td>border-left-color: oklch(87% 0 0);</td><td><div style="border-left-color: oklch(87% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-400</td><td>border-left-color: oklch(70.8% 0 0);</td><td><div style="border-left-color: oklch(70.8% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-500</td><td>border-left-color: oklch(55.6% 0 0);</td><td><div style="border-left-color: oklch(55.6% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-600</td><td>border-left-color: oklch(43.9% 0 0);</td><td><div style="border-left-color: oklch(43.9% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-700</td><td>border-left-color: oklch(37.1% 0 0);</td><td><div style="border-left-color: oklch(37.1% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-800</td><td>border-left-color: oklch(26.9% 0 0);</td><td><div style="border-left-color: oklch(26.9% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-900</td><td>border-left-color: oklch(20.5% 0 0);</td><td><div style="border-left-color: oklch(20.5% 0 0);"></div></td></tr>
    <tr><td>border-l-neutral-950</td><td>border-left-color: oklch(14.5% 0 0);</td><td><div style="border-left-color: oklch(14.5% 0 0);"></div></td></tr>
    <tr><td>border-l-stone-50</td><td>border-left-color: oklch(98.5% .001 106.423);</td><td><div style="border-left-color: oklch(98.5% .001 106.423);"></div></td></tr>
    <tr><td>border-l-stone-100</td><td>border-left-color: oklch(97% .001 106.424);</td><td><div style="border-left-color: oklch(97% .001 106.424);"></div></td></tr>
    <tr><td>border-l-stone-200</td><td>border-left-color: oklch(92.3% .003 48.717);</td><td><div style="border-left-color: oklch(92.3% .003 48.717);"></div></td></tr>
    <tr><td>border-l-stone-300</td><td>border-left-color: oklch(86.9% .005 56.366);</td><td><div style="border-left-color: oklch(86.9% .005 56.366);"></div></td></tr>
    <tr><td>border-l-stone-400</td><td>border-left-color: oklch(70.9% .01 56.259);</td><td><div style="border-left-color: oklch(70.9% .01 56.259);"></div></td></tr>
    <tr><td>border-l-stone-500</td><td>border-left-color: oklch(55.3% .013 58.071);</td><td><div style="border-left-color: oklch(55.3% .013 58.071);"></div></td></tr>
    <tr><td>border-l-stone-600</td><td>border-left-color: oklch(44.4% .011 73.639);</td><td><div style="border-left-color: oklch(44.4% .011 73.639);"></div></td></tr>
    <tr><td>border-l-stone-700</td><td>border-left-color: oklch(37.4% .01 67.558);</td><td><div style="border-left-color: oklch(37.4% .01 67.558);"></div></td></tr>
    <tr><td>border-l-stone-800</td><td>border-left-color: oklch(26.8% .007 34.298);</td><td><div style="border-left-color: oklch(26.8% .007 34.298);"></div></td></tr>
    <tr><td>border-l-stone-900</td><td>border-left-color: oklch(21.6% .006 56.043);</td><td><div style="border-left-color: oklch(21.6% .006 56.043);"></div></td></tr>
    <tr><td>border-l-stone-950</td><td>border-left-color: oklch(14.7% .004 49.25);</td><td><div style="border-left-color: oklch(14.7% .004 49.25);"></div></td></tr>
    <tr><td>border-l-black</td><td>border-left-color: #000;</td><td><div style="border-left-color: #000;"></div></td></tr>
    <tr><td>border-l-white</td><td>border-left-color: #fff;</td><td><div style="border-left-color: #fff;"></div></td></tr>
  </tbody>
</table>

### Note about the opacity syntax

The color opacity can be changed using the new syntax: e.g. `border-red-500/25` will generate
`border-color: rgb(239 68 68 / 0.25);`.

### Arbitrary values

Any [`<color>`](crate::utils::value_matchers::is_matching_color) property is allowed as arbitrary value.
For example, `border-[hsla(100,100%,50%,1)]`.

[Tailwind reference](https://tailwindcss.com/docs/border-color)
