Utilities for controlling an element's background color.

<table style="display: table;">
  <thead>
    <tr>
      <th style="text-align: center;">Class</th>
      <th style="text-align: center;">Properties</th>
      <th style="text-align: center;">Color</th>
    </tr>
  </thead>
  <tbody>
    <tr><td>bg-inherit</td><td>background-color: inherit;</td><td style="background-color: inherit;"></td></tr>
    <tr><td>bg-current</td><td>background-color: currentColor;</td><td style="background-color: currentColor;"></td></tr>
    <tr><td>bg-transparent</td><td>background-color: transparent;</td><td style="background-color: transparent;"></td></tr>
    <tr><td>bg-red-50</td><td>background-color: oklch(97.1% .013 17.38);</td><td style="background-color: oklch(97.1% .013 17.38);"></td></tr>
    <tr><td>bg-red-100</td><td>background-color: oklch(93.6% .032 17.717);</td><td style="background-color: oklch(93.6% .032 17.717);"></td></tr>
    <tr><td>bg-red-200</td><td>background-color: oklch(88.5% .062 18.334);</td><td style="background-color: oklch(88.5% .062 18.334);"></td></tr>
    <tr><td>bg-red-300</td><td>background-color: oklch(80.8% .114 19.571);</td><td style="background-color: oklch(80.8% .114 19.571);"></td></tr>
    <tr><td>bg-red-400</td><td>background-color: oklch(70.4% .191 22.216);</td><td style="background-color: oklch(70.4% .191 22.216);"></td></tr>
    <tr><td>bg-red-500</td><td>background-color: oklch(63.7% .237 25.331);</td><td style="background-color: oklch(63.7% .237 25.331);"></td></tr>
    <tr><td>bg-red-600</td><td>background-color: oklch(57.7% .245 27.325);</td><td style="background-color: oklch(57.7% .245 27.325);"></td></tr>
    <tr><td>bg-red-700</td><td>background-color: oklch(50.5% .213 27.518);</td><td style="background-color: oklch(50.5% .213 27.518);"></td></tr>
    <tr><td>bg-red-800</td><td>background-color: oklch(44.4% .177 26.899);</td><td style="background-color: oklch(44.4% .177 26.899);"></td></tr>
    <tr><td>bg-red-900</td><td>background-color: oklch(39.6% .141 25.723);</td><td style="background-color: oklch(39.6% .141 25.723);"></td></tr>
    <tr><td>bg-red-950</td><td>background-color: oklch(25.8% .092 26.042);</td><td style="background-color: oklch(25.8% .092 26.042);"></td></tr>
    <tr><td>bg-orange-50</td><td>background-color: oklch(98% .016 73.684);</td><td style="background-color: oklch(98% .016 73.684);"></td></tr>
    <tr><td>bg-orange-100</td><td>background-color: oklch(95.4% .038 75.164);</td><td style="background-color: oklch(95.4% .038 75.164);"></td></tr>
    <tr><td>bg-orange-200</td><td>background-color: oklch(90.1% .076 70.697);</td><td style="background-color: oklch(90.1% .076 70.697);"></td></tr>
    <tr><td>bg-orange-300</td><td>background-color: oklch(83.7% .128 66.29);</td><td style="background-color: oklch(83.7% .128 66.29);"></td></tr>
    <tr><td>bg-orange-400</td><td>background-color: oklch(75% .183 55.934);</td><td style="background-color: oklch(75% .183 55.934);"></td></tr>
    <tr><td>bg-orange-500</td><td>background-color: oklch(70.5% .213 47.604);</td><td style="background-color: oklch(70.5% .213 47.604);"></td></tr>
    <tr><td>bg-orange-600</td><td>background-color: oklch(64.6% .222 41.116);</td><td style="background-color: oklch(64.6% .222 41.116);"></td></tr>
    <tr><td>bg-orange-700</td><td>background-color: oklch(55.3% .195 38.402);</td><td style="background-color: oklch(55.3% .195 38.402);"></td></tr>
    <tr><td>bg-orange-800</td><td>background-color: oklch(47% .157 37.304);</td><td style="background-color: oklch(47% .157 37.304);"></td></tr>
    <tr><td>bg-orange-900</td><td>background-color: oklch(40.8% .123 38.172);</td><td style="background-color: oklch(40.8% .123 38.172);"></td></tr>
    <tr><td>bg-orange-950</td><td>background-color: oklch(26.6% .079 36.259);</td><td style="background-color: oklch(26.6% .079 36.259);"></td></tr>
    <tr><td>bg-amber-50</td><td>background-color: oklch(98.7% .022 95.277);</td><td style="background-color: oklch(98.7% .022 95.277);"></td></tr>
    <tr><td>bg-amber-100</td><td>background-color: oklch(96.2% .059 95.617);</td><td style="background-color: oklch(96.2% .059 95.617);"></td></tr>
    <tr><td>bg-amber-200</td><td>background-color: oklch(92.4% .12 95.746);</td><td style="background-color: oklch(92.4% .12 95.746);"></td></tr>
    <tr><td>bg-amber-300</td><td>background-color: oklch(87.9% .169 91.605);</td><td style="background-color: oklch(87.9% .169 91.605);"></td></tr>
    <tr><td>bg-amber-400</td><td>background-color: oklch(82.8% .189 84.429);</td><td style="background-color: oklch(82.8% .189 84.429);"></td></tr>
    <tr><td>bg-amber-500</td><td>background-color: oklch(76.9% .188 70.08);</td><td style="background-color: oklch(76.9% .188 70.08);"></td></tr>
    <tr><td>bg-amber-600</td><td>background-color: oklch(66.6% .179 58.318);</td><td style="background-color: oklch(66.6% .179 58.318);"></td></tr>
    <tr><td>bg-amber-700</td><td>background-color: oklch(55.5% .163 48.998);</td><td style="background-color: oklch(55.5% .163 48.998);"></td></tr>
    <tr><td>bg-amber-800</td><td>background-color: oklch(47.3% .137 46.201);</td><td style="background-color: oklch(47.3% .137 46.201);"></td></tr>
    <tr><td>bg-amber-900</td><td>background-color: oklch(41.4% .112 45.904);</td><td style="background-color: oklch(41.4% .112 45.904);"></td></tr>
    <tr><td>bg-amber-950</td><td>background-color: oklch(27.9% .077 45.635);</td><td style="background-color: oklch(27.9% .077 45.635);"></td></tr>
    <tr><td>bg-yellow-50</td><td>background-color: oklch(98.7% .026 102.212);</td><td style="background-color: oklch(98.7% .026 102.212);"></td></tr>
    <tr><td>bg-yellow-100</td><td>background-color: oklch(97.3% .071 103.193);</td><td style="background-color: oklch(97.3% .071 103.193);"></td></tr>
    <tr><td>bg-yellow-200</td><td>background-color: oklch(94.5% .129 101.54);</td><td style="background-color: oklch(94.5% .129 101.54);"></td></tr>
    <tr><td>bg-yellow-300</td><td>background-color: oklch(90.5% .182 98.111);</td><td style="background-color: oklch(90.5% .182 98.111);"></td></tr>
    <tr><td>bg-yellow-400</td><td>background-color: oklch(85.2% .199 91.936);</td><td style="background-color: oklch(85.2% .199 91.936);"></td></tr>
    <tr><td>bg-yellow-500</td><td>background-color: oklch(79.5% .184 86.047);</td><td style="background-color: oklch(79.5% .184 86.047);"></td></tr>
    <tr><td>bg-yellow-600</td><td>background-color: oklch(68.1% .162 75.834);</td><td style="background-color: oklch(68.1% .162 75.834);"></td></tr>
    <tr><td>bg-yellow-700</td><td>background-color: oklch(55.4% .135 66.442);</td><td style="background-color: oklch(55.4% .135 66.442);"></td></tr>
    <tr><td>bg-yellow-800</td><td>background-color: oklch(47.6% .114 61.907);</td><td style="background-color: oklch(47.6% .114 61.907);"></td></tr>
    <tr><td>bg-yellow-900</td><td>background-color: oklch(42.1% .095 57.708);</td><td style="background-color: oklch(42.1% .095 57.708);"></td></tr>
    <tr><td>bg-yellow-950</td><td>background-color: oklch(28.6% .066 53.813);</td><td style="background-color: oklch(28.6% .066 53.813);"></td></tr>
    <tr><td>bg-lime-50</td><td>background-color: oklch(98.6% .031 120.757);</td><td style="background-color: oklch(98.6% .031 120.757);"></td></tr>
    <tr><td>bg-lime-100</td><td>background-color: oklch(96.7% .067 122.328);</td><td style="background-color: oklch(96.7% .067 122.328);"></td></tr>
    <tr><td>bg-lime-200</td><td>background-color: oklch(93.8% .127 124.321);</td><td style="background-color: oklch(93.8% .127 124.321);"></td></tr>
    <tr><td>bg-lime-300</td><td>background-color: oklch(89.7% .196 126.665);</td><td style="background-color: oklch(89.7% .196 126.665);"></td></tr>
    <tr><td>bg-lime-400</td><td>background-color: oklch(84.1% .238 128.85);</td><td style="background-color: oklch(84.1% .238 128.85);"></td></tr>
    <tr><td>bg-lime-500</td><td>background-color: oklch(76.8% .233 130.85);</td><td style="background-color: oklch(76.8% .233 130.85);"></td></tr>
    <tr><td>bg-lime-600</td><td>background-color: oklch(64.8% .2 131.684);</td><td style="background-color: oklch(64.8% .2 131.684);"></td></tr>
    <tr><td>bg-lime-700</td><td>background-color: oklch(53.2% .157 131.589);</td><td style="background-color: oklch(53.2% .157 131.589);"></td></tr>
    <tr><td>bg-lime-800</td><td>background-color: oklch(45.3% .124 130.933);</td><td style="background-color: oklch(45.3% .124 130.933);"></td></tr>
    <tr><td>bg-lime-900</td><td>background-color: oklch(40.5% .101 131.063);</td><td style="background-color: oklch(40.5% .101 131.063);"></td></tr>
    <tr><td>bg-lime-950</td><td>background-color: oklch(27.4% .072 132.109);</td><td style="background-color: oklch(27.4% .072 132.109);"></td></tr>
    <tr><td>bg-green-50</td><td>background-color: oklch(98.2% .018 155.826);</td><td style="background-color: oklch(98.2% .018 155.826);"></td></tr>
    <tr><td>bg-green-100</td><td>background-color: oklch(96.2% .044 156.743);</td><td style="background-color: oklch(96.2% .044 156.743);"></td></tr>
    <tr><td>bg-green-200</td><td>background-color: oklch(92.5% .084 155.995);</td><td style="background-color: oklch(92.5% .084 155.995);"></td></tr>
    <tr><td>bg-green-300</td><td>background-color: oklch(87.1% .15 154.449);</td><td style="background-color: oklch(87.1% .15 154.449);"></td></tr>
    <tr><td>bg-green-400</td><td>background-color: oklch(79.2% .209 151.711);</td><td style="background-color: oklch(79.2% .209 151.711);"></td></tr>
    <tr><td>bg-green-500</td><td>background-color: oklch(72.3% .219 149.579);</td><td style="background-color: oklch(72.3% .219 149.579);"></td></tr>
    <tr><td>bg-green-600</td><td>background-color: oklch(62.7% .194 149.214);</td><td style="background-color: oklch(62.7% .194 149.214);"></td></tr>
    <tr><td>bg-green-700</td><td>background-color: oklch(52.7% .154 150.069);</td><td style="background-color: oklch(52.7% .154 150.069);"></td></tr>
    <tr><td>bg-green-800</td><td>background-color: oklch(44.8% .119 151.328);</td><td style="background-color: oklch(44.8% .119 151.328);"></td></tr>
    <tr><td>bg-green-900</td><td>background-color: oklch(39.3% .095 152.535);</td><td style="background-color: oklch(39.3% .095 152.535);"></td></tr>
    <tr><td>bg-green-950</td><td>background-color: oklch(26.6% .065 152.934);</td><td style="background-color: oklch(26.6% .065 152.934);"></td></tr>
    <tr><td>bg-emerald-50</td><td>background-color: oklch(97.9% .021 166.113);</td><td style="background-color: oklch(97.9% .021 166.113);"></td></tr>
    <tr><td>bg-emerald-100</td><td>background-color: oklch(95% .052 163.051);</td><td style="background-color: oklch(95% .052 163.051);"></td></tr>
    <tr><td>bg-emerald-200</td><td>background-color: oklch(90.5% .093 164.15);</td><td style="background-color: oklch(90.5% .093 164.15);"></td></tr>
    <tr><td>bg-emerald-300</td><td>background-color: oklch(84.5% .143 164.978);</td><td style="background-color: oklch(84.5% .143 164.978);"></td></tr>
    <tr><td>bg-emerald-400</td><td>background-color: oklch(76.5% .177 163.223);</td><td style="background-color: oklch(76.5% .177 163.223);"></td></tr>
    <tr><td>bg-emerald-500</td><td>background-color: oklch(69.6% .17 162.48);</td><td style="background-color: oklch(69.6% .17 162.48);"></td></tr>
    <tr><td>bg-emerald-600</td><td>background-color: oklch(59.6% .145 163.225);</td><td style="background-color: oklch(59.6% .145 163.225);"></td></tr>
    <tr><td>bg-emerald-700</td><td>background-color: oklch(50.8% .118 165.612);</td><td style="background-color: oklch(50.8% .118 165.612);"></td></tr>
    <tr><td>bg-emerald-800</td><td>background-color: oklch(43.2% .095 166.913);</td><td style="background-color: oklch(43.2% .095 166.913);"></td></tr>
    <tr><td>bg-emerald-900</td><td>background-color: oklch(37.8% .077 168.94);</td><td style="background-color: oklch(37.8% .077 168.94);"></td></tr>
    <tr><td>bg-emerald-950</td><td>background-color: oklch(26.2% .051 172.552);</td><td style="background-color: oklch(26.2% .051 172.552);"></td></tr>
    <tr><td>bg-teal-50</td><td>background-color: oklch(98.4% .014 180.72);</td><td style="background-color: oklch(98.4% .014 180.72);"></td></tr>
    <tr><td>bg-teal-100</td><td>background-color: oklch(95.3% .051 180.801);</td><td style="background-color: oklch(95.3% .051 180.801);"></td></tr>
    <tr><td>bg-teal-200</td><td>background-color: oklch(91% .096 180.426);</td><td style="background-color: oklch(91% .096 180.426);"></td></tr>
    <tr><td>bg-teal-300</td><td>background-color: oklch(85.5% .138 181.071);</td><td style="background-color: oklch(85.5% .138 181.071);"></td></tr>
    <tr><td>bg-teal-400</td><td>background-color: oklch(77.7% .152 181.912);</td><td style="background-color: oklch(77.7% .152 181.912);"></td></tr>
    <tr><td>bg-teal-500</td><td>background-color: oklch(70.4% .14 182.503);</td><td style="background-color: oklch(70.4% .14 182.503);"></td></tr>
    <tr><td>bg-teal-600</td><td>background-color: oklch(60% .118 184.704);</td><td style="background-color: oklch(60% .118 184.704);"></td></tr>
    <tr><td>bg-teal-700</td><td>background-color: oklch(51.1% .096 186.391);</td><td style="background-color: oklch(51.1% .096 186.391);"></td></tr>
    <tr><td>bg-teal-800</td><td>background-color: oklch(43.7% .078 188.216);</td><td style="background-color: oklch(43.7% .078 188.216);"></td></tr>
    <tr><td>bg-teal-900</td><td>background-color: oklch(38.6% .063 188.416);</td><td style="background-color: oklch(38.6% .063 188.416);"></td></tr>
    <tr><td>bg-teal-950</td><td>background-color: oklch(27.7% .046 192.524);</td><td style="background-color: oklch(27.7% .046 192.524);"></td></tr>
    <tr><td>bg-cyan-50</td><td>background-color: oklch(98.4% .019 200.873);</td><td style="background-color: oklch(98.4% .019 200.873);"></td></tr>
    <tr><td>bg-cyan-100</td><td>background-color: oklch(95.6% .045 203.388);</td><td style="background-color: oklch(95.6% .045 203.388);"></td></tr>
    <tr><td>bg-cyan-200</td><td>background-color: oklch(91.7% .08 205.041);</td><td style="background-color: oklch(91.7% .08 205.041);"></td></tr>
    <tr><td>bg-cyan-300</td><td>background-color: oklch(86.5% .127 207.078);</td><td style="background-color: oklch(86.5% .127 207.078);"></td></tr>
    <tr><td>bg-cyan-400</td><td>background-color: oklch(78.9% .154 211.53);</td><td style="background-color: oklch(78.9% .154 211.53);"></td></tr>
    <tr><td>bg-cyan-500</td><td>background-color: oklch(71.5% .143 215.221);</td><td style="background-color: oklch(71.5% .143 215.221);"></td></tr>
    <tr><td>bg-cyan-600</td><td>background-color: oklch(60.9% .126 221.723);</td><td style="background-color: oklch(60.9% .126 221.723);"></td></tr>
    <tr><td>bg-cyan-700</td><td>background-color: oklch(52% .105 223.128);</td><td style="background-color: oklch(52% .105 223.128);"></td></tr>
    <tr><td>bg-cyan-800</td><td>background-color: oklch(45% .085 224.283);</td><td style="background-color: oklch(45% .085 224.283);"></td></tr>
    <tr><td>bg-cyan-900</td><td>background-color: oklch(39.8% .07 227.392);</td><td style="background-color: oklch(39.8% .07 227.392);"></td></tr>
    <tr><td>bg-cyan-950</td><td>background-color: oklch(30.2% .056 229.695);</td><td style="background-color: oklch(30.2% .056 229.695);"></td></tr>
    <tr><td>bg-sky-50</td><td>background-color: oklch(97.7% .013 236.62);</td><td style="background-color: oklch(97.7% .013 236.62);"></td></tr>
    <tr><td>bg-sky-100</td><td>background-color: oklch(95.1% .026 236.824);</td><td style="background-color: oklch(95.1% .026 236.824);"></td></tr>
    <tr><td>bg-sky-200</td><td>background-color: oklch(90.1% .058 230.902);</td><td style="background-color: oklch(90.1% .058 230.902);"></td></tr>
    <tr><td>bg-sky-300</td><td>background-color: oklch(82.8% .111 230.318);</td><td style="background-color: oklch(82.8% .111 230.318);"></td></tr>
    <tr><td>bg-sky-400</td><td>background-color: oklch(74.6% .16 232.661);</td><td style="background-color: oklch(74.6% .16 232.661);"></td></tr>
    <tr><td>bg-sky-500</td><td>background-color: oklch(68.5% .169 237.323);</td><td style="background-color: oklch(68.5% .169 237.323);"></td></tr>
    <tr><td>bg-sky-600</td><td>background-color: oklch(58.8% .158 241.966);</td><td style="background-color: oklch(58.8% .158 241.966);"></td></tr>
    <tr><td>bg-sky-700</td><td>background-color: oklch(50% .134 242.749);</td><td style="background-color: oklch(50% .134 242.749);"></td></tr>
    <tr><td>bg-sky-800</td><td>background-color: oklch(44.3% .11 240.79);</td><td style="background-color: oklch(44.3% .11 240.79);"></td></tr>
    <tr><td>bg-sky-900</td><td>background-color: oklch(39.1% .09 240.876);</td><td style="background-color: oklch(39.1% .09 240.876);"></td></tr>
    <tr><td>bg-sky-950</td><td>background-color: oklch(29.3% .066 243.157);</td><td style="background-color: oklch(29.3% .066 243.157);"></td></tr>
    <tr><td>bg-blue-50</td><td>background-color: oklch(97% .014 254.604);</td><td style="background-color: oklch(97% .014 254.604);"></td></tr>
    <tr><td>bg-blue-100</td><td>background-color: oklch(93.2% .032 255.585);</td><td style="background-color: oklch(93.2% .032 255.585);"></td></tr>
    <tr><td>bg-blue-200</td><td>background-color: oklch(88.2% .059 254.128);</td><td style="background-color: oklch(88.2% .059 254.128);"></td></tr>
    <tr><td>bg-blue-300</td><td>background-color: oklch(80.9% .105 251.813);</td><td style="background-color: oklch(80.9% .105 251.813);"></td></tr>
    <tr><td>bg-blue-400</td><td>background-color: oklch(70.7% .165 254.624);</td><td style="background-color: oklch(70.7% .165 254.624);"></td></tr>
    <tr><td>bg-blue-500</td><td>background-color: oklch(62.3% .214 259.815);</td><td style="background-color: oklch(62.3% .214 259.815);"></td></tr>
    <tr><td>bg-blue-600</td><td>background-color: oklch(54.6% .245 262.881);</td><td style="background-color: oklch(54.6% .245 262.881);"></td></tr>
    <tr><td>bg-blue-700</td><td>background-color: oklch(48.8% .243 264.376);</td><td style="background-color: oklch(48.8% .243 264.376);"></td></tr>
    <tr><td>bg-blue-800</td><td>background-color: oklch(42.4% .199 265.638);</td><td style="background-color: oklch(42.4% .199 265.638);"></td></tr>
    <tr><td>bg-blue-900</td><td>background-color: oklch(37.9% .146 265.522);</td><td style="background-color: oklch(37.9% .146 265.522);"></td></tr>
    <tr><td>bg-blue-950</td><td>background-color: oklch(28.2% .091 267.935);</td><td style="background-color: oklch(28.2% .091 267.935);"></td></tr>
    <tr><td>bg-indigo-50</td><td>background-color: oklch(96.2% .018 272.314);</td><td style="background-color: oklch(96.2% .018 272.314);"></td></tr>
    <tr><td>bg-indigo-100</td><td>background-color: oklch(93% .034 272.788);</td><td style="background-color: oklch(93% .034 272.788);"></td></tr>
    <tr><td>bg-indigo-200</td><td>background-color: oklch(87% .065 274.039);</td><td style="background-color: oklch(87% .065 274.039);"></td></tr>
    <tr><td>bg-indigo-300</td><td>background-color: oklch(78.5% .115 274.713);</td><td style="background-color: oklch(78.5% .115 274.713);"></td></tr>
    <tr><td>bg-indigo-400</td><td>background-color: oklch(67.3% .182 276.935);</td><td style="background-color: oklch(67.3% .182 276.935);"></td></tr>
    <tr><td>bg-indigo-500</td><td>background-color: oklch(58.5% .233 277.117);</td><td style="background-color: oklch(58.5% .233 277.117);"></td></tr>
    <tr><td>bg-indigo-600</td><td>background-color: oklch(51.1% .262 276.966);</td><td style="background-color: oklch(51.1% .262 276.966);"></td></tr>
    <tr><td>bg-indigo-700</td><td>background-color: oklch(45.7% .24 277.023);</td><td style="background-color: oklch(45.7% .24 277.023);"></td></tr>
    <tr><td>bg-indigo-800</td><td>background-color: oklch(39.8% .195 277.366);</td><td style="background-color: oklch(39.8% .195 277.366);"></td></tr>
    <tr><td>bg-indigo-900</td><td>background-color: oklch(35.9% .144 278.697);</td><td style="background-color: oklch(35.9% .144 278.697);"></td></tr>
    <tr><td>bg-indigo-950</td><td>background-color: oklch(25.7% .09 281.288);</td><td style="background-color: oklch(25.7% .09 281.288);"></td></tr>
    <tr><td>bg-violet-50</td><td>background-color: oklch(96.9% .016 293.756);</td><td style="background-color: oklch(96.9% .016 293.756);"></td></tr>
    <tr><td>bg-violet-100</td><td>background-color: oklch(94.3% .029 294.588);</td><td style="background-color: oklch(94.3% .029 294.588);"></td></tr>
    <tr><td>bg-violet-200</td><td>background-color: oklch(89.4% .057 293.283);</td><td style="background-color: oklch(89.4% .057 293.283);"></td></tr>
    <tr><td>bg-violet-300</td><td>background-color: oklch(81.1% .111 293.571);</td><td style="background-color: oklch(81.1% .111 293.571);"></td></tr>
    <tr><td>bg-violet-400</td><td>background-color: oklch(70.2% .183 293.541);</td><td style="background-color: oklch(70.2% .183 293.541);"></td></tr>
    <tr><td>bg-violet-500</td><td>background-color: oklch(60.6% .25 292.717);</td><td style="background-color: oklch(60.6% .25 292.717);"></td></tr>
    <tr><td>bg-violet-600</td><td>background-color: oklch(54.1% .281 293.009);</td><td style="background-color: oklch(54.1% .281 293.009);"></td></tr>
    <tr><td>bg-violet-700</td><td>background-color: oklch(49.1% .27 292.581);</td><td style="background-color: oklch(49.1% .27 292.581);"></td></tr>
    <tr><td>bg-violet-800</td><td>background-color: oklch(43.2% .232 292.759);</td><td style="background-color: oklch(43.2% .232 292.759);"></td></tr>
    <tr><td>bg-violet-900</td><td>background-color: oklch(38% .189 293.745);</td><td style="background-color: oklch(38% .189 293.745);"></td></tr>
    <tr><td>bg-violet-950</td><td>background-color: oklch(28.3% .141 291.089);</td><td style="background-color: oklch(28.3% .141 291.089);"></td></tr>
    <tr><td>bg-purple-50</td><td>background-color: oklch(97.7% .014 308.299);</td><td style="background-color: oklch(97.7% .014 308.299);"></td></tr>
    <tr><td>bg-purple-100</td><td>background-color: oklch(94.6% .033 307.174);</td><td style="background-color: oklch(94.6% .033 307.174);"></td></tr>
    <tr><td>bg-purple-200</td><td>background-color: oklch(90.2% .063 306.703);</td><td style="background-color: oklch(90.2% .063 306.703);"></td></tr>
    <tr><td>bg-purple-300</td><td>background-color: oklch(82.7% .119 306.383);</td><td style="background-color: oklch(82.7% .119 306.383);"></td></tr>
    <tr><td>bg-purple-400</td><td>background-color: oklch(71.4% .203 305.504);</td><td style="background-color: oklch(71.4% .203 305.504);"></td></tr>
    <tr><td>bg-purple-500</td><td>background-color: oklch(62.7% .265 303.9);</td><td style="background-color: oklch(62.7% .265 303.9);"></td></tr>
    <tr><td>bg-purple-600</td><td>background-color: oklch(55.8% .288 302.321);</td><td style="background-color: oklch(55.8% .288 302.321);"></td></tr>
    <tr><td>bg-purple-700</td><td>background-color: oklch(49.6% .265 301.924);</td><td style="background-color: oklch(49.6% .265 301.924);"></td></tr>
    <tr><td>bg-purple-800</td><td>background-color: oklch(43.8% .218 303.724);</td><td style="background-color: oklch(43.8% .218 303.724);"></td></tr>
    <tr><td>bg-purple-900</td><td>background-color: oklch(38.1% .176 304.987);</td><td style="background-color: oklch(38.1% .176 304.987);"></td></tr>
    <tr><td>bg-purple-950</td><td>background-color: oklch(29.1% .149 302.717);</td><td style="background-color: oklch(29.1% .149 302.717);"></td></tr>
    <tr><td>bg-fuchsia-50</td><td>background-color: oklch(97.7% .017 320.058);</td><td style="background-color: oklch(97.7% .017 320.058);"></td></tr>
    <tr><td>bg-fuchsia-100</td><td>background-color: oklch(95.2% .037 318.852);</td><td style="background-color: oklch(95.2% .037 318.852);"></td></tr>
    <tr><td>bg-fuchsia-200</td><td>background-color: oklch(90.3% .076 319.62);</td><td style="background-color: oklch(90.3% .076 319.62);"></td></tr>
    <tr><td>bg-fuchsia-300</td><td>background-color: oklch(83.3% .145 321.434);</td><td style="background-color: oklch(83.3% .145 321.434);"></td></tr>
    <tr><td>bg-fuchsia-400</td><td>background-color: oklch(74% .238 322.16);</td><td style="background-color: oklch(74% .238 322.16);"></td></tr>
    <tr><td>bg-fuchsia-500</td><td>background-color: oklch(66.7% .295 322.15);</td><td style="background-color: oklch(66.7% .295 322.15);"></td></tr>
    <tr><td>bg-fuchsia-600</td><td>background-color: oklch(59.1% .293 322.896);</td><td style="background-color: oklch(59.1% .293 322.896);"></td></tr>
    <tr><td>bg-fuchsia-700</td><td>background-color: oklch(51.8% .253 323.949);</td><td style="background-color: oklch(51.8% .253 323.949);"></td></tr>
    <tr><td>bg-fuchsia-800</td><td>background-color: oklch(45.2% .211 324.591);</td><td style="background-color: oklch(45.2% .211 324.591);"></td></tr>
    <tr><td>bg-fuchsia-900</td><td>background-color: oklch(40.1% .17 325.612);</td><td style="background-color: oklch(40.1% .17 325.612);"></td></tr>
    <tr><td>bg-fuchsia-950</td><td>background-color: oklch(29.3% .136 325.661);</td><td style="background-color: oklch(29.3% .136 325.661);"></td></tr>
    <tr><td>bg-pink-50</td><td>background-color: oklch(97.1% .014 343.198);</td><td style="background-color: oklch(97.1% .014 343.198);"></td></tr>
    <tr><td>bg-pink-100</td><td>background-color: oklch(94.8% .028 342.258);</td><td style="background-color: oklch(94.8% .028 342.258);"></td></tr>
    <tr><td>bg-pink-200</td><td>background-color: oklch(89.9% .061 343.231);</td><td style="background-color: oklch(89.9% .061 343.231);"></td></tr>
    <tr><td>bg-pink-300</td><td>background-color: oklch(82.3% .12 346.018);</td><td style="background-color: oklch(82.3% .12 346.018);"></td></tr>
    <tr><td>bg-pink-400</td><td>background-color: oklch(71.8% .202 349.761);</td><td style="background-color: oklch(71.8% .202 349.761);"></td></tr>
    <tr><td>bg-pink-500</td><td>background-color: oklch(65.6% .241 354.308);</td><td style="background-color: oklch(65.6% .241 354.308);"></td></tr>
    <tr><td>bg-pink-600</td><td>background-color: oklch(59.2% .249 .584);</td><td style="background-color: oklch(59.2% .249 .584);"></td></tr>
    <tr><td>bg-pink-700</td><td>background-color: oklch(52.5% .223 3.958);</td><td style="background-color: oklch(52.5% .223 3.958);"></td></tr>
    <tr><td>bg-pink-800</td><td>background-color: oklch(45.9% .187 3.815);</td><td style="background-color: oklch(45.9% .187 3.815);"></td></tr>
    <tr><td>bg-pink-900</td><td>background-color: oklch(40.8% .153 2.432);</td><td style="background-color: oklch(40.8% .153 2.432);"></td></tr>
    <tr><td>bg-pink-950</td><td>background-color: oklch(28.4% .109 3.907);</td><td style="background-color: oklch(28.4% .109 3.907);"></td></tr>
    <tr><td>bg-rose-50</td><td>background-color: oklch(96.9% .015 12.422);</td><td style="background-color: oklch(96.9% .015 12.422);"></td></tr>
    <tr><td>bg-rose-100</td><td>background-color: oklch(94.1% .03 12.58);</td><td style="background-color: oklch(94.1% .03 12.58);"></td></tr>
    <tr><td>bg-rose-200</td><td>background-color: oklch(89.2% .058 10.001);</td><td style="background-color: oklch(89.2% .058 10.001);"></td></tr>
    <tr><td>bg-rose-300</td><td>background-color: oklch(81% .117 11.638);</td><td style="background-color: oklch(81% .117 11.638);"></td></tr>
    <tr><td>bg-rose-400</td><td>background-color: oklch(71.2% .194 13.428);</td><td style="background-color: oklch(71.2% .194 13.428);"></td></tr>
    <tr><td>bg-rose-500</td><td>background-color: oklch(64.5% .246 16.439);</td><td style="background-color: oklch(64.5% .246 16.439);"></td></tr>
    <tr><td>bg-rose-600</td><td>background-color: oklch(58.6% .253 17.585);</td><td style="background-color: oklch(58.6% .253 17.585);"></td></tr>
    <tr><td>bg-rose-700</td><td>background-color: oklch(51.4% .222 16.935);</td><td style="background-color: oklch(51.4% .222 16.935);"></td></tr>
    <tr><td>bg-rose-800</td><td>background-color: oklch(45.5% .188 13.697);</td><td style="background-color: oklch(45.5% .188 13.697);"></td></tr>
    <tr><td>bg-rose-900</td><td>background-color: oklch(41% .159 10.272);</td><td style="background-color: oklch(41% .159 10.272);"></td></tr>
    <tr><td>bg-rose-950</td><td>background-color: oklch(27.1% .105 12.094);</td><td style="background-color: oklch(27.1% .105 12.094);"></td></tr>
    <tr><td>bg-slate-50</td><td>background-color: oklch(98.4% .003 247.858);</td><td style="background-color: oklch(98.4% .003 247.858);"></td></tr>
    <tr><td>bg-slate-100</td><td>background-color: oklch(96.8% .007 247.896);</td><td style="background-color: oklch(96.8% .007 247.896);"></td></tr>
    <tr><td>bg-slate-200</td><td>background-color: oklch(92.9% .013 255.508);</td><td style="background-color: oklch(92.9% .013 255.508);"></td></tr>
    <tr><td>bg-slate-300</td><td>background-color: oklch(86.9% .022 252.894);</td><td style="background-color: oklch(86.9% .022 252.894);"></td></tr>
    <tr><td>bg-slate-400</td><td>background-color: oklch(70.4% .04 256.788);</td><td style="background-color: oklch(70.4% .04 256.788);"></td></tr>
    <tr><td>bg-slate-500</td><td>background-color: oklch(55.4% .046 257.417);</td><td style="background-color: oklch(55.4% .046 257.417);"></td></tr>
    <tr><td>bg-slate-600</td><td>background-color: oklch(44.6% .043 257.281);</td><td style="background-color: oklch(44.6% .043 257.281);"></td></tr>
    <tr><td>bg-slate-700</td><td>background-color: oklch(37.2% .044 257.287);</td><td style="background-color: oklch(37.2% .044 257.287);"></td></tr>
    <tr><td>bg-slate-800</td><td>background-color: oklch(27.9% .041 260.031);</td><td style="background-color: oklch(27.9% .041 260.031);"></td></tr>
    <tr><td>bg-slate-900</td><td>background-color: oklch(20.8% .042 265.755);</td><td style="background-color: oklch(20.8% .042 265.755);"></td></tr>
    <tr><td>bg-slate-950</td><td>background-color: oklch(12.9% .042 264.695);</td><td style="background-color: oklch(12.9% .042 264.695);"></td></tr>
    <tr><td>bg-gray-50</td><td>background-color: oklch(98.5% .002 247.839);</td><td style="background-color: oklch(98.5% .002 247.839);"></td></tr>
    <tr><td>bg-gray-100</td><td>background-color: oklch(96.7% .003 264.542);</td><td style="background-color: oklch(96.7% .003 264.542);"></td></tr>
    <tr><td>bg-gray-200</td><td>background-color: oklch(92.8% .006 264.531);</td><td style="background-color: oklch(92.8% .006 264.531);"></td></tr>
    <tr><td>bg-gray-300</td><td>background-color: oklch(87.2% .01 258.338);</td><td style="background-color: oklch(87.2% .01 258.338);"></td></tr>
    <tr><td>bg-gray-400</td><td>background-color: oklch(70.7% .022 261.325);</td><td style="background-color: oklch(70.7% .022 261.325);"></td></tr>
    <tr><td>bg-gray-500</td><td>background-color: oklch(55.1% .027 264.364);</td><td style="background-color: oklch(55.1% .027 264.364);"></td></tr>
    <tr><td>bg-gray-600</td><td>background-color: oklch(44.6% .03 256.802);</td><td style="background-color: oklch(44.6% .03 256.802);"></td></tr>
    <tr><td>bg-gray-700</td><td>background-color: oklch(37.3% .034 259.733);</td><td style="background-color: oklch(37.3% .034 259.733);"></td></tr>
    <tr><td>bg-gray-800</td><td>background-color: oklch(27.8% .033 256.848);</td><td style="background-color: oklch(27.8% .033 256.848);"></td></tr>
    <tr><td>bg-gray-900</td><td>background-color: oklch(21% .034 264.665);</td><td style="background-color: oklch(21% .034 264.665);"></td></tr>
    <tr><td>bg-gray-950</td><td>background-color: oklch(13% .028 261.692);</td><td style="background-color: oklch(13% .028 261.692);"></td></tr>
    <tr><td>bg-zinc-50</td><td>background-color: oklch(98.5% 0 0);</td><td style="background-color: oklch(98.5% 0 0);"></td></tr>
    <tr><td>bg-zinc-100</td><td>background-color: oklch(96.7% .001 286.375);</td><td style="background-color: oklch(96.7% .001 286.375);"></td></tr>
    <tr><td>bg-zinc-200</td><td>background-color: oklch(92% .004 286.32);</td><td style="background-color: oklch(92% .004 286.32);"></td></tr>
    <tr><td>bg-zinc-300</td><td>background-color: oklch(87.1% .006 286.286);</td><td style="background-color: oklch(87.1% .006 286.286);"></td></tr>
    <tr><td>bg-zinc-400</td><td>background-color: oklch(70.5% .015 286.067);</td><td style="background-color: oklch(70.5% .015 286.067);"></td></tr>
    <tr><td>bg-zinc-500</td><td>background-color: oklch(55.2% .016 285.938);</td><td style="background-color: oklch(55.2% .016 285.938);"></td></tr>
    <tr><td>bg-zinc-600</td><td>background-color: oklch(44.2% .017 285.786);</td><td style="background-color: oklch(44.2% .017 285.786);"></td></tr>
    <tr><td>bg-zinc-700</td><td>background-color: oklch(37% .013 285.805);</td><td style="background-color: oklch(37% .013 285.805);"></td></tr>
    <tr><td>bg-zinc-800</td><td>background-color: oklch(27.4% .006 286.033);</td><td style="background-color: oklch(27.4% .006 286.033);"></td></tr>
    <tr><td>bg-zinc-900</td><td>background-color: oklch(21% .006 285.885);</td><td style="background-color: oklch(21% .006 285.885);"></td></tr>
    <tr><td>bg-zinc-950</td><td>background-color: oklch(14.1% .005 285.823);</td><td style="background-color: oklch(14.1% .005 285.823);"></td></tr>
    <tr><td>bg-neutral-50</td><td>background-color: oklch(98.5% 0 0);</td><td style="background-color: oklch(98.5% 0 0);"></td></tr>
    <tr><td>bg-neutral-100</td><td>background-color: oklch(97% 0 0);</td><td style="background-color: oklch(97% 0 0);"></td></tr>
    <tr><td>bg-neutral-200</td><td>background-color: oklch(92.2% 0 0);</td><td style="background-color: oklch(92.2% 0 0);"></td></tr>
    <tr><td>bg-neutral-300</td><td>background-color: oklch(87% 0 0);</td><td style="background-color: oklch(87% 0 0);"></td></tr>
    <tr><td>bg-neutral-400</td><td>background-color: oklch(70.8% 0 0);</td><td style="background-color: oklch(70.8% 0 0);"></td></tr>
    <tr><td>bg-neutral-500</td><td>background-color: oklch(55.6% 0 0);</td><td style="background-color: oklch(55.6% 0 0);"></td></tr>
    <tr><td>bg-neutral-600</td><td>background-color: oklch(43.9% 0 0);</td><td style="background-color: oklch(43.9% 0 0);"></td></tr>
    <tr><td>bg-neutral-700</td><td>background-color: oklch(37.1% 0 0);</td><td style="background-color: oklch(37.1% 0 0);"></td></tr>
    <tr><td>bg-neutral-800</td><td>background-color: oklch(26.9% 0 0);</td><td style="background-color: oklch(26.9% 0 0);"></td></tr>
    <tr><td>bg-neutral-900</td><td>background-color: oklch(20.5% 0 0);</td><td style="background-color: oklch(20.5% 0 0);"></td></tr>
    <tr><td>bg-neutral-950</td><td>background-color: oklch(14.5% 0 0);</td><td style="background-color: oklch(14.5% 0 0);"></td></tr>
    <tr><td>bg-stone-50</td><td>background-color: oklch(98.5% .001 106.423);</td><td style="background-color: oklch(98.5% .001 106.423);"></td></tr>
    <tr><td>bg-stone-100</td><td>background-color: oklch(97% .001 106.424);</td><td style="background-color: oklch(97% .001 106.424);"></td></tr>
    <tr><td>bg-stone-200</td><td>background-color: oklch(92.3% .003 48.717);</td><td style="background-color: oklch(92.3% .003 48.717);"></td></tr>
    <tr><td>bg-stone-300</td><td>background-color: oklch(86.9% .005 56.366);</td><td style="background-color: oklch(86.9% .005 56.366);"></td></tr>
    <tr><td>bg-stone-400</td><td>background-color: oklch(70.9% .01 56.259);</td><td style="background-color: oklch(70.9% .01 56.259);"></td></tr>
    <tr><td>bg-stone-500</td><td>background-color: oklch(55.3% .013 58.071);</td><td style="background-color: oklch(55.3% .013 58.071);"></td></tr>
    <tr><td>bg-stone-600</td><td>background-color: oklch(44.4% .011 73.639);</td><td style="background-color: oklch(44.4% .011 73.639);"></td></tr>
    <tr><td>bg-stone-700</td><td>background-color: oklch(37.4% .01 67.558);</td><td style="background-color: oklch(37.4% .01 67.558);"></td></tr>
    <tr><td>bg-stone-800</td><td>background-color: oklch(26.8% .007 34.298);</td><td style="background-color: oklch(26.8% .007 34.298);"></td></tr>
    <tr><td>bg-stone-900</td><td>background-color: oklch(21.6% .006 56.043);</td><td style="background-color: oklch(21.6% .006 56.043);"></td></tr>
    <tr><td>bg-stone-950</td><td>background-color: oklch(14.7% .004 49.25);</td><td style="background-color: oklch(14.7% .004 49.25);"></td></tr>
    <tr><td>bg-black</td><td>background-color: #000;</td><td style="background-color: #000;"></td></tr>
    <tr><td>bg-white</td><td>background-color: #fff;</td><td style="background-color: #fff;"></td></tr>
  </tbody>
</table>

### Note about the opacity syntax

The color opacity can be changed using the new syntax: e.g. `bg-red-500/25` will generate
`background-color: rgb(239 68 68 / 0.25);`.

### Arbitrary values

Any [`<color>`](crate::utils::value_matchers::is_matching_color) property is allowed as arbitrary value.
For example, `bg-[hsla(100,100%,50%,1)]`.

[Tailwind reference](https://tailwindcss.com/docs/background-color)
